/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.event.*;
import javax.swing.event.*;
import ij.*;
import javax.swing.border.*;
import javax.swing.tree.*;
import javax.swing.JTree;

import mrcp.control.*;
import mrcp.ddd.*;


/**
 * Die Klasse beschreibt die graphsiche Oberflche der Karteikarte Quellenselektion.
 * Zur Ereignisbehandlung wird eine eigene Klasse vom Typ "Source_control" verwendet.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class JPanel_Source extends JPanel implements ScrollPaneConstants {

	// member


	/**
	 * Verweis auf die zugehrige Kontrollklasse
	 */
	public Source_control		source_control;


	/**
	 * Verweis auf die gui der Pluginklasse
	 */
	gui											Document;


	/**
	 * Layout
	 */
	GridBagLayout						gridBagLayout1 = new GridBagLayout();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton									Eval = new JButton();


	/**
	 * grafische Oberflche zur Darstellung der schiefen Projektion
	 */
	public JPanel_DicomCube jPanelDicomCube;


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JToggleButton		jButton_P_Cor = new JToggleButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton									jButtonAddFiles = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton									jButtonDelete = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton									jButtonSelectAll = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton									jButtonBorders = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JToggleButton		jButton_P_3D = new JToggleButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JToggleButton		jButton_P_Tra = new JToggleButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JToggleButton		jButton_P_Sag = new JToggleButton();


	/**
	 * Schieberegler, der die Vergrerung steuert
	 */
	public JSlider					jSlider1 = new JSlider(JSlider.VERTICAL, 0, 100, 12);


	/**
	 * Layout
	 */
	BorderLayout						borderLayout1 = new BorderLayout();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	TitledBorder						titledBorder1;


	/**
	 * Verweis auf das Hauptfenster
	 */
	public gui							g;


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JSplitPane				jSplitPane1 = new JSplitPane();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	public JTextArea				htmlPane = new JTextArea();


	/**
	 * grafische Darstellung des Schichtbaumes
	 */

	public Slice_Tree				tree;


	/**
	 * Icon zur zur grafischen Darstellung von Schaltflchen
	 */
	ImageIcon								icon = new ImageIcon("Resource/left.gif");


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JScrollPane							htmlView, treeview;



	// Konstruktor


	/**
	 * Konstruiert ein neues Exemplar mit zugehrigem Hauptfenster.
	 * Die gui der Kontrollklasse wird zugeordnet und die Initialiserungsmethode aufgerufen.
	 * 
	 * @param g Hauptfenster
	 * 
	 */
	public JPanel_Source(gui Document, gui g) {
		try {
			this.Document = Document;
			this.g = g;

			// steuert das Event-Handling fr Source
			source_control = new Source_control(Document, this);

			// listModel.addElement ("D:\\DATEN\\Diplom Arbeit\\images\\mr\\DE701118\\ST990819\\SE000015\\IM000167.dcm") ;
			// listModel.addElement ("D:\\DATEN\\Diplom Arbeit\\images\\mr\\DE701118\\ST990819\\SE000015\\IM000168.dcm") ;
			jbInit();

			// validate () ;
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fr die
	 * grafischen Elemente.
	 * 
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	private void jbInit() throws Exception {
		titledBorder1 = new TitledBorder("");
		titledBorder2 = new TitledBorder("");
		titledBorder3 = new TitledBorder("Zoom");
		this.setLayout(gridBagLayout1);

		// jScrollPane2.getViewport().setLayout(null);
		// jScrollPane3.getViewport().setLayout(null);


		jPanelDicomCube = new JPanel_DicomCube(Document, source_control, this);




		tree = Document.slicetree;




		// Zoom Slider
		jSlider1.setOrientation(JSlider.HORIZONTAL);
		jSlider1.setMajorTickSpacing(10);
		jSlider1.setMinorTickSpacing(1);
		jSlider1.setBorder(titledBorder3);
		jSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
		treeview = new JScrollPane(tree);
		htmlView = new JScrollPane(htmlPane);
		jSplitPane1.setTopComponent(treeview);
		jSplitPane1.setBottomComponent(htmlView);
		Dimension MinimumSize = new Dimension(100, 100);

		htmlView.setMinimumSize(new Dimension(50, 50));
		treeview.setMinimumSize(new Dimension(50, 50));
		treeview.setPreferredSize(new Dimension(200, 200));

		// jSplitPane1.setDividerLocation(200);




		// jButton_Help.setText("Help");
		jButton_P_3D.setSelected(true);
		jPanelDicomCube.setPreferredSize(new Dimension(500, 300));
		jButtonBB.setPreferredSize(new Dimension(55, 27));
		jButtonBB.setMinimumSize(new Dimension(55, 27));
		jButton_IB.setPreferredSize(new Dimension(55, 27));
		jButton_IB.setMinimumSize(new Dimension(55, 27));
		jButton_P_3D.setMaximumSize(new Dimension(55, 27));
		jButton_P_3D.setPreferredSize(new Dimension(55, 27));
		jButton_P_Tra.setMaximumSize(new Dimension(55, 27));
		jButton_P_Tra.setPreferredSize(new Dimension(55, 27));
		this.add(jPanelDicomCube, new GridBagConstraints(1, 1, 2, 1, 0.2, 0.6, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));



		// this.add(jPanelDicomCube, new GridBagConstraints(5, 1, 1, 2, 0.3, 0.3
		// ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 250, 0));

		this.add(jSlider1, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jSplitPane1, new GridBagConstraints(0, 1, 1, 4, 0.8, 0.4, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		this.add(jPanel1, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanel1.add(jButton_P_3D, null);
		jPanel1.add(jButton_P_Sag, null);
		jPanel1.add(jButton_P_Tra, null);
		jPanel1.add(jButton_P_Cor, null);
		jPanel1.add(jButtonBB, null);
		jPanel1.add(jButton_IB, null);
		this.add(jPanel2, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		jPanel2.add(jButtonAddFiles, null);
		jPanel2.add(jButtonDelete, null);
		jPanel2.add(jButtonBorders, null);
		jPanel2.add(jButtonSelectAll, null);
		jPanel2.add(Eval, null);

		// Buttons
		jButtonAddFiles.setText("Hinzufgen");
		jButtonAddFiles.setActionCommand("Add Files");
		jButtonAddFiles.addActionListener(source_control);

		jButtonDelete.setText("Lschen");
		jButtonDelete.setActionCommand("Delete File");
		jButtonDelete.addActionListener(source_control);



		jButtonSelectAll.setText("Alle Auswhlen");
		jButtonSelectAll.setActionCommand("SelectAll");
		jButtonSelectAll.addActionListener(source_control);

		jButtonBorders.setText("Begrenzungen");
		jButtonBorders.setActionCommand("Borders");
		jButtonBorders.addActionListener(source_control);

		jButton_P_Cor.setText("Cor");
		jButton_P_Cor.setActionCommand("P_Cor");
		jButton_P_Cor.addActionListener(source_control);

		jButton_P_3D.setText("3D");
		jButton_P_3D.setActionCommand("P_3D");
		jButton_P_3D.addActionListener(source_control);

		jButton_P_Tra.setText("Tra");
		jButton_P_Tra.setActionCommand("P_Tra");
		jButton_P_Tra.addActionListener(source_control);

		jButton_P_Sag.setText("Sag");
		jButton_P_Sag.setActionCommand("P_Sag");
		jButton_P_Sag.addActionListener(source_control);

		jButton_IB.setText("SQ");
		jButton_IB.setActionCommand("IB");
		jButton_IB.addActionListener(source_control);

		Eval.setText("Auswerten");
		Eval.setActionCommand("Eval");
		Eval.addActionListener(source_control);

		jButtonBB.setText("UQ");
		jButtonBB.setActionCommand("BB");
		jButtonBB.addActionListener(source_control);

		// JtextArea
		htmlPane.setFont(new Font("Serif", Font.ITALIC, 16));

		// htmlPane.setLineWrap(true);
		// htmlPane.setWrapStyleWord(true);
		// ZoomSLider
		jSlider1.addChangeListener(source_control);
		jPanelDicomCube.addMouseMotionListener(source_control);
		jPanelDicomCube.addMouseListener(source_control);

		// test
		jSlider1.addMouseListener(source_control);
		jPanelDicomCube.setCursor(new Cursor(Cursor.HAND_CURSOR));
		tree.addTreeSelectionListener(source_control);

	} 


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JToggleButton jButton_IB = new JToggleButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JToggleButton jButtonBB = new JToggleButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel				jPanel1 = new JPanel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel				jPanel2 = new JPanel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	TitledBorder	titledBorder2;


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	TitledBorder	titledBorder3;



	// ImageIcon icon = new ImageIcon ("Resource/Transversal_Ser.gif") ;

}










/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

