/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import ij.*;

import mrcp.graphics.*;
import mrcp.tools.*;


/**
 * Die Klasse beschreibt die grafische Oberflche des Optionenmens (Dialog).
 * An dieser Stelle wird nur der Container und zwei Schaltflchen verwaltet.
 * Beim Besttigen des Dialogfensters werden alle Einstellungen eingelesen,
 * geprft und eventuell zurck geschrieben.
 * Die globalen Einstellungen sind allesamt in "Global_Options" als statische Variablen gespeichert.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Optionen_Dialog extends JDialog {


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel							panel1 = new JPanel();


	/**
	 * Karteicontainer, fr die Karten des Optionenmens
	 */
	TabbedPages_Options panel2 = new TabbedPages_Options();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton							button1 = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton							button2 = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	Border							border1;


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel							jPanel1 = new JPanel();


	/**
	 * Layout
	 */
	GridBagLayout				gridBagLayout1 = new GridBagLayout();


	/**
	 * Layout
	 */
	GridLayout					gridLayout1 = new GridLayout();


	/**
	 * Der Konstruktur erzeugt ein neues Dialogfenster.
	 * 
	 * 
	 * @param frame Basis-Fenster
	 * @param title Titel des Dialogs
	 * @param modal Modalitt des Dialogs
	 * 
	 */
	public Optionen_Dialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		} 

		pack();
	}


	/**
	 * Der Konstruktur erzeugt ein neues nicht modales Dialogfenster.
	 * 
	 * 
	 * @param frame Basis-Fenster
	 * @param title Titel des Dialogs
	 * 
	 */
	public Optionen_Dialog(Frame frame, String title) {
		this(frame, title, false);
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fr die
	 * grafischen Elemente.
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	private void jbInit() throws Exception {
		border1 = BorderFactory.createRaisedBevelBorder();
		jPanel1.setLayout(gridLayout1);
		panel2.setBorder(border1);
		button1.setText("OK");
		button1.addActionListener(new OptionenDialog1_button1_actionAdapter(this));
		button2.setText("Abbrechen");
		gridLayout1.setHgap(4);
		button2.addActionListener(new OptionenDialog1_button2_actionAdapter(this));
		this.addWindowListener(new OptionenDialog1_this_windowAdapter(this));
		panel1.setLayout(gridBagLayout1);
		panel1.add(panel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 8, 4, 8), 0, 0));
		jPanel1.add(button1, null);
		jPanel1.add(button2, null);
		getContentPane().add(panel1);
	} 

	// OK
	// Einlesen der neuen Werte


	/**
	 * Die Methode steuert das Einlesen und Prfen der Einstellungen.
	 * Falls die Prfung einen Fehler ergeben hat, wird der neue Wert nicht
	 * bernommen und eine Medung in ImageJ ausgegeben.
	 * Diese Methode wurde von JBuilder generiert.
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	void button1_actionPerformed(ActionEvent e) {

		float		tmp;
		String	temp;



		// Reiter Interpolation
		temp = panel2.jTextField_lagrange.getText();
		try {
			tmp = new Integer(temp).intValue();
			if (tmp < 3 || tmp > 5) {
				IJ.beep();
				IJ.error("Ungltiger Wert {3,4,5}");
			} else {
				Global_Options.NumberOfPoints = (int) tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Anzahl der Punkte Lagrange fehlerhaft");
		} 

		temp = panel2.jTextField_kubic.getText();
		try {
			tmp = new Integer(temp).intValue();
			if (tmp < 4 || tmp > 7) {
				IJ.beep();
				IJ.error("Ungltiger Wert Kubische Interpolation [4-7]");
			} else {
				Global_Options.NumberOfPoints_Kubic = (int) tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Anzahl der Punkte Kubische Interpolation fehlerhaft");
		} 

		temp = panel2.jTextField4.getText();
		try {
			tmp = new Integer(temp).intValue();
			if (tmp < 2 || tmp > 3) {
				IJ.beep();
				IJ.error("Ungltiger Wert {2;3}");
			} else {
				Global_Options.Matrix_Resolution = (int) tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrixauflsung falsch angegeben");
		} 

		temp = panel2.jTextField_Integrationnumber.getText();
		try {
			tmp = new Integer(temp).intValue();
			if (tmp < 1 || tmp > 9) {
				IJ.beep();
				IJ.error("Ungltiger Wert Integrationsintervalle {1-9}");
			} else {
				Global_Options.Integration_Number = (int) tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Anzahl Integrationsintervalle ungltig");
		} 

		temp = panel2.jTextField_Rot.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 0.0 || tmp > 10.0) {
				IJ.beep();
				IJ.error("Ungltiger Wert [0-10]");
			} else {
				Global_Options.RotateStep = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.error(ec.getMessage() + "  Rotationsschrittweite ungltig");
		} 

		temp = panel2.jTextField5.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Max_X = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT MAX X ungltig");
		} 

		temp = panel2.jTextField6.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Max_Y = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT MAX y ungltig");
		} 

		temp = panel2.jTextField7.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Max_Z = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT MAX z ungltig");
		} 

		temp = panel2.jTextField8.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Min_X = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT Min X ungltig");
		} 

		temp = panel2.jTextField9.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Min_Y = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT Min Y ungltig");
		} 

		temp = panel2.jTextField10.getText();
		try {
			tmp = new Float(temp).floatValue();
			Global_Options.MRT_Min_Z = tmp;
		} catch (Exception ec) {
			IJ.error(ec.getMessage() + "  MRT Min Z ungltig");
		} 

		Global_Options.Directorytest = panel2.jCheckBox1.isSelected();
		Global_Options.showHiddenLines = panel2.jCheckBox2.isSelected();
		Global_Options.drawNumbers = panel2.jCheckBox3.isSelected();

		temp = panel2.jTextField2.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 120 || tmp > 150) {
				IJ.beep();
				IJ.error("Ungltiger Alphawert Wert [120-150]");
			} else {
				Global_Options.Alpha = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Alpha Wert ist ungltig");
		} 
		temp = panel2.jTextField3.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 50 || tmp > 70) {
				IJ.beep();
				IJ.error("Ungltiger Beta Wert [50-70]");
			} else {
				Global_Options.Beta = tmp;
			}
		} catch (Exception ec) {
			IJ.write(ec.getMessage() + "  Beta Wert ist ungltig");
		} 

		temp = panel2.jTextField_eq_mult.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Multiplikator Wert [1-10]");
			} else {
				Global_Options.Factor_impRows = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Multiplikator");
		} 

		temp = panel2.jTextField_eq_CS.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Factor_eq_CS Wert [1-10]");
			} else {
				Global_Options.Factor_eq_CS = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Factor_eq_CS");
		} 

		temp = panel2.jTextField_eq_TS.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Factor_eq_TS Wert [1-10]");
			} else {
				Global_Options.Factor_eq_TS = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Factor_eq_TS");
		} 

		temp = panel2.jTextField_eq_TC.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Factor_eq_TC Wert [1-10]");
			} else {
				Global_Options.Factor_eq_TC = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Factor_eq_TC");
		} 
		if (panel2.jRadioButton1.isSelected()) {
			Global_Options.Interpolationmodel = 0;
		} else if (panel2.jRadioButton2.isSelected()) {
			Global_Options.Interpolationmodel = 1;
		} else if (panel2.jRadioButton3.isSelected()) {
			Global_Options.Interpolationmodel = 2;
		} else if (panel2.jRadioButton4.isSelected()) {
			Global_Options.Interpolationmodel = 3;
		} else if (panel2.jRadioButton5.isSelected()) {
			Global_Options.Interpolationmodel = 4;
		} else if (panel2.jRadioButton6.isSelected()) {
			Global_Options.Interpolationmodel = 5;
		} else if (panel2.jRadioButton7.isSelected()) {
			Global_Options.Interpolationmodel = 6;
		} else if (panel2.jRadioButton8.isSelected()) {
			Global_Options.Interpolationmodel = 7;



		} 
		if (panel2.jCheckBox_SC_T.isSelected()) {
			Global_Options.SC_T = true;
		} else {
			Global_Options.SC_T = false;
		} 
		if (panel2.jCheckBox_TC_S.isSelected()) {
			Global_Options.TC_S = true;
		} else {
			Global_Options.TC_S = false;
		} 
		if (panel2.jCheckBox_TS_C.isSelected()) {
			Global_Options.TS_C = true;
		} else {
			Global_Options.TS_C = false;
		} 

		// Reiter Funktionen
		if (panel2.jRadioButton_Comb.isSelected()) {
			Global_Options.ApproxMethod = 0;
		} else if (panel2.jRadioButton_Comb2.isSelected()) {
			Global_Options.ApproxMethod = 1;
		} else if (panel2.jRadioButton_Comb3.isSelected()) {
			Global_Options.ApproxMethod = 2;
		} else {
			Global_Options.ApproxMethod = 3;
		} 


		temp = panel2.jTextField_mftc.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 0 || tmp > 1) {
				IJ.beep();
				IJ.error("Ungltiger Matrix Factor TC Wert [0-1]");
			} else {
				Global_Options.Matrix_Factor_TC = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrix Factor TC");
		} 

		temp = panel2.jTextField_mfts.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 0 || tmp > 1) {
				IJ.beep();
				IJ.error("Ungltiger Matrix Factor TS Wert [0-1]");
			} else {
				Global_Options.Matrix_Factor_TS = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrix Factor TS");
		} 

		temp = panel2.jTextField_mfcs.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 0 || tmp > 1) {
				IJ.beep();
				IJ.error("Ungltiger Matrix Factor CS Wert [0-1]");
			} else {
				Global_Options.Matrix_Factor_CS = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrix Factor CS");
		} 

		temp = panel2.jTextField_mtc.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Matrix TC Wert [1-10]");
			} else {
				Global_Options.Matrix_TC = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrix  TC");
		} 

		temp = panel2.jTextField_mts.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Matrix TX Wert [1-10]");
			} else {
				Global_Options.Matrix_TS = tmp;
			}
		} catch (Exception ec) {
			IJ.write(ec.getMessage() + "  Matrix  TS");
		} 

		temp = panel2.jTextField_mcs.getText();
		try {
			tmp = new Float(temp).floatValue();
			if (tmp < 1 || tmp > 10) {
				IJ.beep();
				IJ.error("Ungltiger Matrix CS Wert [1-10]");
			} else {
				Global_Options.Matrix_CS = tmp;
			}
		} catch (Exception ec) {
			IJ.beep();
			IJ.write(ec.getMessage() + "  Matrix  CS");
		} 


		/*
		 * Integrationen
		 * temp = panel2.jTextField_Integrationnumber.getText();
		 * try {
		 * tmp = new Integer(temp).intValue();
		 * Global_Options.Integration_Number = (int) tmp;
		 * } catch (Exception ec) {
		 * IJ.write(ec.getMessage() + "  Integrationsnummer");
		 * }
		 */
		if (panel2.jRadioButton_Mittel.isSelected()) {
			Global_Options.IntegrationMethod = 0;
		} else if (panel2.jRadioButton_Riemann.isSelected()) {
			Global_Options.IntegrationMethod = 1;
		} else if (panel2.jRadioButton_Simpson.isSelected()) {
			Global_Options.IntegrationMethod = 2;
		} else if (panel2.jRadioButton_Trapez.isSelected()) {
			Global_Options.IntegrationMethod = 3;



			// Einstellen der neuen Werte
		} 
		Global_Options.setFactors();
		Global_Options.setMatrixFactors();



		dispose();
	} 

	// Abbrechen


	/**
	 * Die Methode steuert das Einlesen und Prfen der Einstellungen.
	 * Diese Methode wurde von JBuilder generiert.
	 * 
	 * @param e Das Aktionsereignis
	 */
	void button2_actionPerformed(ActionEvent e) {
		dispose();
	} 


	/**
	 * Von JBuilder automatisch generierte Methode fr die
	 * Beendigung des Dialogs.
	 * 
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	void this_windowClosing(WindowEvent e) {
		dispose();
	} 

}


/**
 * Von JBuilder generierte Unterklasse zur Ereignisbehandlung.
 * 
 * 
 * 
 */
class OptionenDialog1_button1_actionAdapter implements ActionListener {
	Optionen_Dialog adaptee;


	/**
	 * Von JBuilder generierter Konstruktor zur Ereignisbehandlung
	 * 
	 * 
	 * @param adaptee Optionen-Dialog
	 * 
	 */
	OptionenDialog1_button1_actionAdapter(Optionen_Dialog adaptee) {
		this.adaptee = adaptee;
	}


	/**
	 * Von JBuilder generierte Methode zur Ereignisbehandlung
	 * 
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	public void actionPerformed(ActionEvent e) {
		adaptee.button1_actionPerformed(e);
	} 

}


/**
 * Von JBuilder generierte Unterklasse zur Ereignisbehandlung.
 * 
 * 
 * 
 */
class OptionenDialog1_button2_actionAdapter implements ActionListener {
	Optionen_Dialog adaptee;


	/**
	 * Von JBuilder generierte Methode zur Ereignisbehandlung
	 * 
	 * 
	 * @param adaptee Optionen-Dialog
	 * 
	 */
	OptionenDialog1_button2_actionAdapter(Optionen_Dialog adaptee) {
		this.adaptee = adaptee;
	}


	/**
	 * Von JBuilder generierte Methode zur Ereignisbehandlung
	 * 
	 * 
	 * @param e Aktionsereignis
	 * 
	 * 
	 */
	public void actionPerformed(ActionEvent e) {
		adaptee.button2_actionPerformed(e);
	} 

}


/**
 * Von JBuilder generierte Unterklasse zur Ereignisbehandlung.
 * 
 * 
 * 
 */
class OptionenDialog1_this_windowAdapter extends WindowAdapter {
	Optionen_Dialog adaptee;


	/**
	 * Von JBuilder generierte Methode zur Ereignisbehandlung
	 * 
	 * 
	 * @param adaptee Optionen-Dialog
	 * 
	 */
	OptionenDialog1_this_windowAdapter(Optionen_Dialog adaptee) {
		this.adaptee = adaptee;
	}


	/**
	 * Von JBuilder generierte Methode zur Ereignisbehandlung
	 * 
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	public void windowClosing(WindowEvent e) {
		adaptee.this_windowClosing(e);
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

