/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import ij.*;

import mrcp.tools.*;
import mrcp.graphics.*;


/**
 * Die Klasse beschreibt die grafische Oberflche des Schichtparametermens (Dialog).
 * Beim Besttigen des Dialogfensters werden alle Einstellungen eingelesen,
 * geprft und eventuell zurck geschrieben.
 * Die Einstellungen sind allesamt in "Update_control" als statische Variablen gespeichert.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Slice_Dialog extends JDialog {


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JPanel					panel1 = new JPanel();


	/**
	 * Layout
	 */
	GridBagLayout		gridBagLayout1 = new GridBagLayout();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton					jButton_ok = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JButton					jButton_cancel = new JButton();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel1 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_numslc = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_sl_dst = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel2 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel3 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel4 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel5 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel6 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_curr = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_cols = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_rows = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel7 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_origin = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel8 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel9 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel10 = new JLabel();


	/**
	 * Auswahlliste zur Selektion der Orientierung
	 */
	final String[]	List = {
		"Transversal", "Sagittal", "Coronar"
	};


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JComboBox				jComboBox1 = new JComboBox(List);


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JLabel					jLabel11 = new JLabel();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_width = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jText_heigth = new JTextField();


	/**
	 * Allgemeines Feld zur grafischen Darstellung
	 */
	JTextField			jTextField_depth = new JTextField();


	/**
	 * Boolesche Variable, die angibt, ob der Dialog unterbrochen wurde.
	 */
	public boolean	isCanceld = false;


	/**
	 * Der Konstruktor erzeugt einen neuen Schichtparameterdialog.
	 * 
	 * 
	 * @param frame Basis Fenster
	 * @param title Titel des Dialogs
	 * @param modal Modalitt
	 * 
	 */
	public Slice_Dialog(Frame frame, String title, boolean modal) {
		super(frame, title, modal);
		try {
			jbInit();
			pack();

		} catch (Exception ex) {
			ex.printStackTrace();
		} 
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 * 
	 * 
	 * @throws Exception
	 * 
	 * 
	 */
	void jbInit() throws Exception {
		panel1.setLayout(gridBagLayout1);
		jButton_ok.setText("bernehmen");
		jButton_ok.addActionListener(new java.awt.event.ActionListener() {


			/**
			 * Method declaration
			 *
			 *
			 * @param e
			 *
			 */
			public void actionPerformed(ActionEvent e) {
				jButton_ok_actionPerformed(e);
			} 

		});
		jButton_cancel.setText("Abbrechen");
		jButton_cancel.addActionListener(new java.awt.event.ActionListener() {


			/**
			 * Method declaration
			 *
			 *
			 * @param e
			 *
			 */
			public void actionPerformed(ActionEvent e) {
				jButton_cancel_actionPerformed(e);
			} 

		});
		jLabel1.setFont(new java.awt.Font("SansSerif", 3, 14));
		jLabel1.setText("Schicht Konfiguration");
		jTextField_numslc.setMinimumSize(new Dimension(40, 21));
		jTextField_numslc.setPreferredSize(new Dimension(40, 21));
		jTextField_numslc.setText(new Integer(Update_control.numslices).toString());
		jTextField_numslc.setHorizontalAlignment(SwingConstants.CENTER);
		jTextField_sl_dst.setMinimumSize(new Dimension(40, 21));
		jTextField_sl_dst.setPreferredSize(new Dimension(40, 21));
		jTextField_sl_dst.setText(new Float(Update_control.slicedist).toString());
		jTextField_sl_dst.setHorizontalAlignment(SwingConstants.CENTER);
		jLabel2.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel2.setText("Anzahl der Schichten");
		jLabel3.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel3.setText("Schichtabstand");
		jLabel4.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel4.setText("Aktuelle Schichtnummer");
		jLabel5.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel5.setText("Anzahl der Matrixspalten");
		jLabel6.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel6.setText("Anzahl der Matrixreihen");
		jTextField_curr.setMinimumSize(new Dimension(40, 21));
		jTextField_curr.setPreferredSize(new Dimension(40, 21));
		jTextField_curr.setText(new Integer(Update_control.currentSlice).toString());
		jTextField_curr.setHorizontalAlignment(SwingConstants.CENTER);
		jTextField_cols.setMinimumSize(new Dimension(40, 21));
		jTextField_cols.setPreferredSize(new Dimension(40, 21));
		jTextField_cols.setText(new Integer(Update_control.Cols).toString());
		jTextField_cols.setHorizontalAlignment(SwingConstants.CENTER);
		jTextField_rows.setMinimumSize(new Dimension(40, 21));
		jTextField_rows.setPreferredSize(new Dimension(40, 21));
		jTextField_rows.setText(new Integer(Update_control.Rows).toString());
		jTextField_rows.setHorizontalAlignment(SwingConstants.CENTER);
		jLabel7.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel7.setText("Ursprungskoordinaten");


		String	org = "";
		Point3D p = Update_control.getOrigin();

		if (p == null) {
			org = "0.0;0.0;0.0";
		} else {
			org = p.toString();
		} 
		jTextField_origin.setText(org);
		jTextField_origin.setHorizontalAlignment(SwingConstants.CENTER);


		panel1.setPreferredSize(new Dimension(400, 300));
		jLabel8.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel8.setText("Schichtbreite");
		jLabel9.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel9.setText("Schichthhe");
		jLabel10.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel10.setText("Schichtdicke");
		jLabel11.setHorizontalTextPosition(SwingConstants.LEFT);
		jLabel11.setText("Schichtorientierung");
		jTextField_width.setMinimumSize(new Dimension(40, 21));
		jTextField_width.setPreferredSize(new Dimension(40, 21));
		jTextField_width.setText(new Float(Update_control.width).toString());
		jTextField_width.setHorizontalAlignment(SwingConstants.CENTER);
		jText_heigth.setMinimumSize(new Dimension(40, 21));
		jText_heigth.setPreferredSize(new Dimension(40, 21));
		jText_heigth.setText(new Float(Update_control.heigth).toString());
		jText_heigth.setHorizontalAlignment(SwingConstants.CENTER);
		jTextField_depth.setMinimumSize(new Dimension(40, 21));
		jTextField_depth.setPreferredSize(new Dimension(40, 21));
		jTextField_depth.setText(new Float(Update_control.depth).toString());
		jTextField_depth.setHorizontalAlignment(SwingConstants.CENTER);
		getContentPane().add(panel1);
		panel1.add(jButton_ok, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jButton_cancel, new GridBagConstraints(1, 11, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(10, 0, 20, 0), 0, 0));
		panel1.add(jTextField_numslc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_sl_dst, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_curr, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_cols, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_rows, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel7, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_origin, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel9, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel10, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jComboBox1, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jLabel11, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_width, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jText_heigth, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
		panel1.add(jTextField_depth, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

		jComboBox1.setSelectedItem(Update_control.Orientation);
	} 


	/**
	 * Die Methode steuert das Einlesen und Schreiben der gewhlten Parameterwerte.
	 * Falls die Prfung einen Fehler ergeben hat, wird der neue Wert nicht
	 * bernommen und eine Medung in ImageJ ausgegeben.
	 * 
	 * @param e Das Aktionereignis
	 * 
	 * 
	 */
	void jButton_ok_actionPerformed(ActionEvent e) {

		// Daten einlesen und Fehler Koorektur !
		isCanceld = false;

		final String	tmp = ",.";

		String				temp = jText_heigth.getText();

		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 999) {
				return;
			} 
			Update_control.heigth = new Float(temp).floatValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Hhe");
		} 


		temp = jTextField_cols.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 999) {
				return;
			} 
			Update_control.Cols = new Integer(temp).intValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Spalten");
		} 


		temp = jTextField_curr.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 99) {
				return;
			} 
			Update_control.currentSlice = new Integer(temp).intValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der aktuellen Schicht");
		} 

		temp = jTextField_depth.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 999) {
				return;
			} 
			Update_control.depth = new Float(temp).floatValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Tiefe");
		} 


		temp = jTextField_numslc.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 99) {
				return;
			} 
			Update_control.numslices = new Integer(temp).intValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Anzahl der Schichten");
		} 


		temp = jTextField_rows.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 999) {
				return;
			} 
			Update_control.Rows = new Integer(temp).intValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Anzahl der Reihen");
		} 


		temp = jTextField_sl_dst.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < -99 || tempo > 99) {
				return;
			} 
			Update_control.slicedist = new Float(temp).floatValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe des Schichtabstands");
		} 

		temp = jTextField_width.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));
		try {
			float tempo = new Float(temp).floatValue();

			if (tempo < 0 || tempo > 999) {
				return;
			} 
			Update_control.width = new Float(temp).floatValue();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Breite");
		} 


		temp = jTextField_origin.getText();
		temp = temp.replace(tmp.charAt(0), tmp.charAt(1));

		// Trennzeichen ist das Semikolon !

		try {
			int			index = temp.indexOf(";", 0);
			String	tp = temp.substring(0, index);

			tp = tp.trim();
			float x = new Float(tp).floatValue();

			int		index2 = temp.indexOf(";", index + 1);

			tp = temp.substring(index + 1, index2);
			tp = tp.trim();
			float y = new Float(tp).floatValue();

			tp = temp.substring(index2 + 1);
			tp = tp.trim();
			float z = new Float(tp).floatValue();

			Update_control.Origin = new Point3D(x, y, z);

		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe des Ursprungs");
		} 

		try {
			Update_control.Orientation = (String) jComboBox1.getSelectedItem();
		} catch (Exception ep) {
			IJ.write("Fehler bei der Angabe der Orientierung");
		} 

		Update_control.ColSpacing = (float) Update_control.width / (float) Update_control.Cols;
		Update_control.RowSpacing = (float) Update_control.heigth / (float) Update_control.Rows;
		Update_control.setSlices();

		this.dispose();
	} 


	/**
	 * Die Methode steuert das Verhalten nach Abbruch des Dialogs.
	 * Die boolesche Varibale "isCanceld" wird auf wahr gesetzt.
	 * 
	 * @param e Das Aktionsereignis
	 * 
	 * 
	 */
	void jButton_cancel_actionPerformed(ActionEvent e) {
		isCanceld = true;
		this.dispose();
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

