/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import mrcp.control.*;
import javax.swing.tree.*;
import mrcp.ddd.*;
import mrcp.tools.*;


/**
 * Diese Klasse stellt das Hauptfenster der Anwendung dar.
 * Dazu werden im wesentlichen drei Karteireiter verwaltet, die die Funktionalitt des Programmes steuern.
 * Zustzlich wird an dieser Stelle die grafische Oberflche der Karteikarte Schichtselektion kontrolliert.
 * Fr die Ereignisverarbeitung wird speziel ein Kontrollmodul (Adjsutment_control) in einer neuen Klasse angelegt.
 * Die Layoutsteuerung wird durch entsprechende Layout-Manager geregelt (vorwiegend Gridbag-Layout)
 *
 *
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class gui extends JFrame {
    
    // member
    
    
    /**
     * Verweis auf die gui der Pluginklasse (this)
     */
    gui														Document;
    
    
    /**
     * Kontrollklasse zur Steuerung der Ereignisbehandlung in Schichtselektion
     */
    public Adjustment_control			adjustmentcontrol;
    
    
    /**
     * Kontrollklasse zur Steuerung der Ereignisbehandlung in Bildberlagerung
     */
    
    public Composite_control			compcontrol;
    
    
    /**
     * grafische Darstellung der schiefen Projektion
     */
    
    public JPanel_Cube						jPanel_cube;
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    
    JButton												jButton_yl = new JButton();
    
    
    /**
     * Karteikarten Container fr die Programmodule (Quellenselektion, Schichtselektion, Bildberlagerung)
     */
    JTabbedPane										jTabbedPane_MRCP = new JTabbedPane();
    
    
    /**
     * grafische Oberflche von Schichtselektion
     */
    public JPanel									Adjustments3D = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout1 = new GridBagLayout();
    
    
    /**
     * grafische Oberflche von Quellenselektion
     */
    public JPanel_Source					Sourceselection;
    
    
    /**
     * grafische Oberflche von Bildberlagerung
     */
    public JPanel_Composite				Composite;
    
    
    /**
     * Men im Hauptfenster
     */
    JMenuBar											jMenuBar1 = new JMenuBar();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout1 = new BorderLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_yr = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButtonRotZL = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButtonRotZR = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButtonRotXL = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButtonRotXR = new JButton();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout2 = new BorderLayout();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout2 = new GridBagLayout();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout3 = new GridBagLayout();
    
    
    /**
     * grafische Oberflche des Vorschaubildes
     */
    public JPanel_Preview					jPanel_Preview;
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_sl_prev = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_sl_next = new JButton();
    
    
    /**
     * Zoom Schieberegler
     */
    JSlider												jSlider_3D = new JSlider();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_set = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_3D_BG = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout4 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Pre_BG = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout5 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_IJ = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_Export = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Tra_BG = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Sag_BG = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Cor_BG = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout6 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JLabel												jLabel2 = new JLabel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JLabel												jLabel3 = new JLabel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG__z = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG_z = new JButton();
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
   
    ImageIcon											icon_left = new ImageIcon(getClass().getResource("resources/left.gif")) ;
    // ImageIcon										
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rigth = new ImageIcon(getClass().getResource("resources/right.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_z_r = new ImageIcon(getClass().getResource("resources/rot_z_l.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_z_l = new ImageIcon(getClass().getResource("resources/rot_z_r.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_y_l = new ImageIcon(getClass().getResource("resources/rot_y_l.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_y_r = new ImageIcon(getClass().getResource("resources/rot_y_r.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_x_l = new ImageIcon(getClass().getResource("resources/rot_x_l.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rot_x_r = new ImageIcon(getClass().getResource("resources/rot_x_r.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rr = new ImageIcon(getClass().getResource("resources/rotrigth.gif"));
    
    
    /**
     * Icon zur zur grafischen Darstellung von Schaltflchen
     */
    ImageIcon											icon_rl = new ImageIcon(getClass().getResource("resources/rotleft.gif"));
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JLabel												jLabelDist = new JLabel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel1_BG = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout7 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG__x = new JButton();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout5 = new BorderLayout();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout8 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG_x = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JLabel												jLabel4 = new JLabel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel2_BG = new JPanel();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout3 = new BorderLayout();
    
    
    /**
     * grafische Oberflche des Seitenri
     */
    public JPanel_Ortho_S					jPanel_Sag;
    
    
    /**
     * grafische Oberflche des Aufri
     */
    public JPanel_Ortho_T					jPanel_Tra;
    
    
    /**
     * grafische Oberflche des Grundri
     */
    public JPanel_Ortho_C					jPanel_Cor;
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout4 = new BorderLayout();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout9 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG__y = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_BG_y = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JLabel												jLabel5 = new JLabel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel3_BG = new JPanel();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout6 = new BorderLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_w = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    
    JButton												jButton__w = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel_Ortho_All							jpanel_Ortho;
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_y = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_z = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton__z = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton__h = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel1 = new JPanel();
    
    
    /**
     * Layout
     */
    BorderLayout									borderLayout8 = new BorderLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel2 = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton2 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton4 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton_Update = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JCheckBox											jCheckBox_showall = new JCheckBox();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel3 = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel4 = new JPanel();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout10 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel5 = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton1 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton3 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel6 = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton5 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JButton												jButton6 = new JButton();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Buttons = new JPanel();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    JPanel												jPanel_Buttons2 = new JPanel();
    
    
    /**
     * Fortschrittsanzeige
     */
    JProgressBar									jProgressBar_Adjustment = new JProgressBar(0, 256);
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout11 = new GridBagLayout();
    
    
    /**
     * Layout
     */
    GridBagLayout									gridBagLayout12 = new GridBagLayout();
    
    
    /**
     * Allgemeines Feld zur grafischen Darstellung
     */
    TitledBorder									titledBorder1;
    
    
    /**
     * Der Wurzelelement des Baumes der gewhlten 2D-Datenstze
     */
    
    public DefaultMutableTreeNode top = new DefaultMutableTreeNode("3D Datensatz");
    
    
    /**
     * Das Baummodell
     */
    public DefaultTreeModel	treeModel = new DefaultTreeModel(top);
    
    
    /**
     * Der Baum der gewhlten 2D-Datenstze
     */
    public Slice_Tree slicetree = new Slice_Tree(treeModel);
    
    
    /**
     * Der Konstruktur erzeugt das Hauptfenster und die grafische Oberflche der Karteikarte Schichtselektion.
     * Zur Anordnung und Initialisierung wird die von JBuilder generierte Methode "jbInit" aufgerufen.
     *
     *
     */
    public gui() {
        
        slicetree.initTree(top, treeModel);
        Global_Options.setMatrixFactors();
        Global_Options.setFactors();
        
        this.Document = this;
        
        // steuert das Event-Handling fr Adjustments
        adjustmentcontrol = new Adjustment_control(this);
        jPanel_Preview = new JPanel_Preview(this);
        jPanel_Tra = new JPanel_Ortho_T(this);
        jPanel_Sag = new JPanel_Ortho_S(this);
        jPanel_Cor = new JPanel_Ortho_C(this);
        jpanel_Ortho = new JPanel_Ortho_All(this);
        
        // Aufbau
        try {
            jbInit();
            
            // pack();
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        // neuzeichnen
        validate();
    }
    
    // Gui aufbauen
    
    
    /**
     *
     * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
     * grafischen Elemente.
     *
     * @throws Exception
     *
     *
     */
    private void jbInit() throws Exception {
        
        titledBorder1 = new TitledBorder("Zoom");
        this.setSize(800, 690);
        this.setVisible(true);
        this.getContentPane().setLayout(borderLayout1);
        
        jButtonRotXL.setMaximumSize(new Dimension(50, 25));
        jButtonRotXL.setIcon(icon_rot_x_l);
        jButtonRotXR.setMaximumSize(new Dimension(50, 25));
        jButtonRotXR.setIcon(icon_rot_x_r);
        jButton_sl_prev.setIcon(icon_left);
        jButton_set.setText("Neu");
        jPanel_3D_BG.setLayout(gridBagLayout4);
        jPanel_Pre_BG.setLayout(gridBagLayout5);
        jPanel_3D_BG.setBorder(BorderFactory.createLineBorder(Color.black));
        jButton_IJ.setFont(new java.awt.Font("Dialog", 0, 10));
        jButton_IJ.setPreferredSize(new Dimension(69, 25));
        jButton_IJ.setText("ImageJ");
        jButton_Export.setFont(new java.awt.Font("Dialog", 0, 10));
        jButton_Export.setText("Dicom");
        jPanel_Pre_BG.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel_Tra_BG.setLayout(gridBagLayout6);
        jPanel_Cor_BG.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel_Cor_BG.setLayout(gridBagLayout9);
        jLabel2.setFont(new java.awt.Font("SansSerif", 1, 14));
        jLabel2.setText("3D-Ansicht");
        jLabel3.setFont(new java.awt.Font("SansSerif", 2, 12));
        jLabel3.setText("Transversal");
        
        jButton_sl_next.setIcon(icon_rigth);
        jButtonRotZL.setIcon(icon_rot_z_r);
        jButton_BG__x.setIcon(icon_left);
        jPanel_Sag.setPreferredSize(new Dimension(170, 170));
        jPanel_Sag_BG.setLayout(gridBagLayout8);
        jButton_BG_x.setIcon(icon_rigth);
        jLabel4.setFont(new java.awt.Font("SansSerif", 2, 12));
        jLabel4.setText("Sagittal");
        jPanel2_BG.setLayout(borderLayout3);
        jPanel_Sag.setPreferredSize(new Dimension(192, 192));
        jPanel3_BG.setLayout(borderLayout4);
        jPanel_Tra.setPreferredSize(new Dimension(192, 192));
        jButton_BG__z.setIcon(icon_left);
        jButton_BG_z.setIcon(icon_rigth);
        jButton_BG__y.setIcon(icon_left);
        jButton_BG_y.setIcon(icon_rigth);
        jLabel5.setText("Coronar");
        jPanel3_BG.setLayout(borderLayout6);
        jPanel_Cor.setPreferredSize(new Dimension(192, 192));
        jSlider_3D.setValue(20);
        jSlider_3D.setMajorTickSpacing(20);
        jSlider_3D.setPaintTicks(true);
        jSlider_3D.setMinorTickSpacing(10);
        jSlider_3D.setBorder(titledBorder1);
        jButton_yl.setIcon(icon_rot_y_l);
        jButton_yr.setIcon(icon_rot_y_r);
        jButtonRotZR.setIcon(icon_rot_z_l);
        jButton_w.setText("x+");
        jButton__w.setMaximumSize(new Dimension(47, 27));
        jButton__w.setPreferredSize(new Dimension(47, 27));
        jButton__w.setText("x-");
        jButton_y.setText("y+");
        jButton_z.setText("z+");
        jButton__z.setMaximumSize(new Dimension(47, 27));
        jButton__z.setMinimumSize(new Dimension(47, 27));
        jButton__z.setPreferredSize(new Dimension(47, 27));
        jButton__z.setText("z-");
        jButton__h.setMaximumSize(new Dimension(47, 27));
        jButton__h.setMinimumSize(new Dimension(47, 27));
        jButton__h.setPreferredSize(new Dimension(47, 27));
        jButton__h.setText("y-");
        jPanel1.setLayout(gridBagLayout11);
        jPanel_Preview.setMinimumSize(new Dimension(192, 192));
        jPanel_Preview.setPreferredSize(new Dimension(256, 256));
        
        // jPanel_Preview.setPreferredSize(new Dimension(192, 192));
        jPanel1_BG.setLayout(borderLayout8);
        jPanel_Tra_BG.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel_Sag_BG.setBorder(BorderFactory.createLineBorder(Color.black));
        jButton2.setIcon(icon_rl);
        jButton4.setIcon(icon_rr);
        jButton_Update.setFont(new java.awt.Font("Dialog", 0, 10));
        jButton_Update.setText("Neuzeichnen");
        jCheckBox_showall.setText("Alle Schichten");
        jPanel1_BG.setBackground(Color.black);
        jPanel2_BG.setBackground(Color.black);
        jPanel3_BG.setBackground(Color.black);
        jPanel4.setLayout(gridBagLayout10);
        
        jLabel2.setForeground(Color.black);
        jLabel3.setForeground(Color.black);
        jLabel4.setForeground(Color.black);
        jLabel5.setFont(new java.awt.Font("SansSerif", 2, 12));
        jLabel5.setForeground(Color.black);
        
        jButton1.setIcon(icon_rl);
        jButton3.setIcon(icon_rr);
        jButton5.setIcon(icon_rr);
        jPanel_Buttons.setMaximumSize(new Dimension(130, 1000));
        jPanel_Buttons.setMinimumSize(new Dimension(130, 21));
        jPanel_Buttons.setPreferredSize(new Dimension(90, 21));
        jPanel_Buttons.setLayout(gridBagLayout12);
        jPanel_Buttons2.setPreferredSize(new Dimension(90, 37));
        jProgressBar_Adjustment.setPreferredSize(new Dimension(90, 16));
        jButton6.setIcon(icon_rl);
        this.getContentPane().add(jTabbedPane_MRCP, BorderLayout.CENTER);
        
        Adjustments3D.setLayout(gridBagLayout1);
        
        // jTabbedPane_MRCP.addTab("3D-Adjustments", jPanel1_Adjustments);
        
        
        Sourceselection = new JPanel_Source(this, this);
        jPanel_cube = new JPanel_Cube(Document);
        
        
        compcontrol = new Composite_control(Document);
        jPanel_cube.setLayout(null);
        Composite = new JPanel_Composite(Document, compcontrol);
        compcontrol.source = Composite;
        
        jPanel1_BG.setName("Tra");
        jPanel1_BG.setCursor(new Cursor(Cursor.HAND_CURSOR));
        jPanel1_BG.addMouseListener(adjustmentcontrol);
        jPanel1_BG.addMouseMotionListener(adjustmentcontrol);
        
        jPanel2_BG.setName("Sag");
        jPanel2_BG.setCursor(new Cursor(Cursor.HAND_CURSOR));
        jPanel2_BG.addMouseListener(adjustmentcontrol);
        jPanel2_BG.addMouseMotionListener(adjustmentcontrol);
        
        jPanel3_BG.setName("Cor");
        jPanel3_BG.setCursor(new Cursor(Cursor.HAND_CURSOR));
        jPanel3_BG.addMouseListener(adjustmentcontrol);
        jPanel3_BG.addMouseMotionListener(adjustmentcontrol);
        
        jSlider_3D.addChangeListener(adjustmentcontrol);
        
        Adjustments3D.add(jPanel_3D_BG, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.6, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jPanel_cube, new GridBagConstraints(0, 1, 3, 3, 0.2, 0.3, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jButton_set, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jSlider_3D, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 20, 0, 0), 0, 0));
        jPanel_3D_BG.add(jLabelDist, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jPanel_Buttons, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.5, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButtonRotZR, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButtonRotZL, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButton_yl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButton_yr, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButtonRotXR, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButtonRotXL, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButton_sl_prev, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons.add(jButton_sl_next, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jPanel_Buttons2, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.3, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Buttons2.add(jButton__z, null);
        jPanel_Buttons2.add(jButton_z, null);
        jPanel_Buttons2.add(jButton__h, null);
        jPanel_Buttons2.add(jButton_y, null);
        jPanel_Buttons2.add(jButton__w, null);
        jPanel_Buttons2.add(jButton_w, null);
        jPanel_3D_BG.add(jCheckBox_showall, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_3D_BG.add(jProgressBar_Adjustment, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        Adjustments3D.add(jPanel_Pre_BG, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.6, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Pre_BG.add(jPanel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add(jPanel_Preview, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Pre_BG.add(jPanel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add(jButton_Update, null);
        jPanel3.add(jButton_Export, null);
        jPanel3.add(jButton_IJ, null);
        Adjustments3D.add(jPanel4, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.4, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add(jPanel_Tra_BG, new GridBagConstraints(0, 0, 1, 1, 0.33, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Tra_BG.add(jPanel1_BG, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1_BG.add(jPanel_Tra, BorderLayout.CENTER);
        jPanel_Tra_BG.add(jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Tra_BG.add(jPanel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(jButton_BG__z, null);
        jPanel2.add(jButton2, null);
        jPanel2.add(jButton4, null);
        jPanel2.add(jButton_BG_z, null);
        jPanel4.add(jPanel_Cor_BG, new GridBagConstraints(2, 0, 1, 1, 0.33, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Cor_BG.add(jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Cor_BG.add(jPanel3_BG, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3_BG.add(jPanel_Cor, BorderLayout.CENTER);
        jPanel_Cor_BG.add(jPanel6, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add(jButton_BG__y, null);
        jPanel6.add(jButton6, null);
        jPanel6.add(jButton5, null);
        jPanel6.add(jButton_BG_y, null);
        jPanel4.add(jPanel_Sag_BG, new GridBagConstraints(1, 0, 1, 1, 0.33, 1.0, GridBagConstraints.SOUTH, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
        jPanel_Sag_BG.add(jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 10, 0));
        jPanel_Sag_BG.add(jPanel2_BG, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2_BG.add(jPanel_Sag, BorderLayout.CENTER);
        jPanel_Sag_BG.add(jPanel5, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(jButton_BG__x, null);
        jPanel5.add(jButton1, null);
        jPanel5.add(jButton3, null);
        jPanel5.add(jButton_BG_x, null);
        
        // Achtung Reihenfolge ist wichtig
        jTabbedPane_MRCP.addTab("Quellenselektion", Sourceselection);
        jTabbedPane_MRCP.addTab("Schichtselektion", Adjustments3D);
        jTabbedPane_MRCP.addTab("Bildberlagerung", Composite);
        
        
        
        
        // Buttons
        jButton_yl.addActionListener(adjustmentcontrol);
        jButton_yl.setActionCommand("Rotate Y Left");
        
        jButton_yr.addActionListener(adjustmentcontrol);
        jButton_yr.setActionCommand("Rotate Y Right");
        
        jButton5.addActionListener(adjustmentcontrol);
        jButton5.setActionCommand("Rotate Y Left");
        
        jButton6.addActionListener(adjustmentcontrol);
        jButton6.setActionCommand("Rotate Y Right");
        
        jButtonRotZL.addActionListener(adjustmentcontrol);
        jButtonRotZL.setActionCommand("Rotate Z Left");
        
        jButtonRotZR.addActionListener(adjustmentcontrol);
        jButtonRotZR.setActionCommand("Rotate Z Right");
        
        jButton2.setActionCommand("Rotate Z Right");
        jButton4.setActionCommand("Rotate Z Left");
        jButton2.addActionListener(adjustmentcontrol);
        jButton4.addActionListener(adjustmentcontrol);
        
        
        jButtonRotXR.addActionListener(adjustmentcontrol);
        jButtonRotXR.setActionCommand("Rotate X Right");
        
        jButtonRotXL.addActionListener(adjustmentcontrol);
        jButtonRotXL.setActionCommand("Rotate X Left");
        
        jButton1.addActionListener(adjustmentcontrol);
        jButton1.setActionCommand("Rotate X Right");
        
        jButton3.addActionListener(adjustmentcontrol);
        jButton3.setActionCommand("Rotate X Left");
        
        jButton_BG__z.setActionCommand("BG -z");
        jButton_BG__z.addActionListener(adjustmentcontrol);
        
        jButton_BG_z.setActionCommand("BG +z");
        jButton_BG_z.addActionListener(adjustmentcontrol);
        
        jButton_BG__x.setActionCommand("BG -x");
        jButton_BG__x.addActionListener(adjustmentcontrol);
        
        jButton_BG_x.setActionCommand("BG +x");
        jButton_BG_x.addActionListener(adjustmentcontrol);
        
        jButton_BG__y.setActionCommand("BG -y");
        jButton_BG__y.addActionListener(adjustmentcontrol);
        
        jButton_BG_y.setActionCommand("BG +y");
        jButton_BG_y.addActionListener(adjustmentcontrol);
        
        
        jButton__w.setActionCommand("width-");
        jButton__w.addActionListener(adjustmentcontrol);
        jButton_w.setActionCommand("width+");
        jButton_w.addActionListener(adjustmentcontrol);
        
        jButton__h.setActionCommand("heigth-");
        jButton__h.addActionListener(adjustmentcontrol);
        jButton_y.setActionCommand("heigth+");
        jButton_y.addActionListener(adjustmentcontrol);
        
        jButton__z.setActionCommand("depth-");
        jButton__z.addActionListener(adjustmentcontrol);
        jButton_z.setActionCommand("depth+");
        jButton_z.addActionListener(adjustmentcontrol);
        
        jButton_set.setActionCommand("set");
        jButton_set.addActionListener(adjustmentcontrol);
        
        jButton_Update.setActionCommand("Update");
        jButton_Update.addActionListener(adjustmentcontrol);
        
        jButton_sl_prev.setActionCommand("prev");
        jButton_sl_prev.addActionListener(adjustmentcontrol);
        
        
        jButton_sl_next.setActionCommand("next");
        jButton_sl_next.addActionListener(adjustmentcontrol);
        
        jButton_IJ.setActionCommand("ImageJ");
        jButton_IJ.addActionListener(adjustmentcontrol);
        
        jButton_Export.setActionCommand("Export");
        jButton_Export.addActionListener(adjustmentcontrol);
        
        // Mousemoton Listener // MouseListener
        jPanel_cube.addMouseMotionListener(adjustmentcontrol);
        jPanel_cube.addMouseListener(adjustmentcontrol);
        
        jCheckBox_showall.addItemListener(adjustmentcontrol);
        
        
        // Menbar aufbauen
        JMenu			datei = new JMenu("Datei");
        JMenuItem dat = new JMenuItem("Schlieen");
        
        
        JMenu			Optionen = new JMenu("Optionen");
        JMenuItem opt = new JMenuItem("Optionen einstellen");
        
        opt.addActionListener(adjustmentcontrol);
        Optionen.addActionListener(adjustmentcontrol);
        
        dat.addActionListener(adjustmentcontrol);
        datei.addActionListener(adjustmentcontrol);
        
        Optionen.add(opt);
        datei.add(dat);
        
        jMenuBar1.add(datei);
        jMenuBar1.add(Optionen);
        
        // test Button
        this.setJMenuBar(jMenuBar1);
        this.setTitle("MRCP-Analysis");
        
        
    }
    
    
    
}






/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

