/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.tools;
import java.awt.*;
import mrcp.dd.*;


/**
 * Die Klasse verwaltet die globalen Einstellungen als statische Variablen.
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Global_Options {


	/**
	 * Boolesche Variable, die angibt, ob der Verzeichnisname beim Vergleich zwei Schichtbilder zur Hilfe genommen werden soll.
	 */
	public static boolean			Directorytest = true;


	/**
	 * Boolesche Variable, die angibt, ob die Eckpunkte des Umgebungs- und Schnittquader gezeichnet werden sollen.
	 */
	public static boolean			drawNumbers = false;


	/**
	 * Konstante fr die Umrechnung von Grad in Bogenma.
	 * Wird eigentlich in JAVA 1.2 nicht mehr bentugt.
	 */
	public static final float RAD = 0.01745333f;

	// Projektionstypen


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Kabinett = 0;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Sag = 2;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Tra = 1;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Cor = 3;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Tra2 = 4;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Sag2 = 5;


	/**
	 * Konstante zur Kennzeichnung des Projektionstyp
	 */
	public static final byte	P_Parallel_Cor2 = 6;



	/**
	 * Mastab zur Darstellung der Projektionen
	 */
	public static float				scale = 0.6f;



	/**
	 * Schrittweite in Grad fr alle Rotationen
	 */
	public static float				RotateStep = 5.0f;


	/**
	 * Farbe des globalen Quader
	 */
	public static Color				GlobalCubeColor = Color.black;


	/**
	 * Farbe des Umgebungsquader
	 */
	public static Color				BoundingColor = Color.green;


	/**
	 * Farbe des Schnittquader
	 */
	public static Color				IntersectionColor = Color.cyan;


	/**
	 * Farbe des Auswahlquaders
	 */
	public static Color				SelectionColor = Color.magenta;


	/**
	 * Farbe des ersten Kompositionskanal
	 */
	public static Color				Channel_one = Color.gray;


	/**
	 * Farbe des zweiten Kompositionskanal
	 */
	public static Color				Channel_two = Color.yellow;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */

	public static float				MRT_Max_X = 250.0f;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */
	public static float				MRT_Max_Y = 250.0f;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */
	public static float				MRT_Max_Z = 250.0f;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */
	public static float				MRT_Min_X = -250.0f;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */
	public static float				MRT_Min_Y = -250.0f;


	/**
	 * Ausdehnungen des MRT-Aufnahmebereich
	 */
	public static float				MRT_Min_Z = -250.0f;


	/**
	 * Projektionsparameter der schiefen Projektion
	 */
	public static float				Alpha = 135.0f;


	/**
	 * Projektionsparameter der schiefen Projektion
	 */
	public static float				Beta = 63.43f;


	/**
	 * x-Komponente des Projektionszentrum
	 */
	public static float				BPX = (float) (1 / Math.tan(Beta * RAD) * Math.cos(Alpha * RAD));


	/**
	 * y-Komponente des Projektionszentrum
	 */
	public static float				BPY = (float) (1 / Math.tan(Beta * RAD) * Math.sin(Alpha * RAD));


	/**
	 * z-Komponente des Projektionszentrum
	 */
	public static float				BPZ = (float) (Math.sqrt(1 - (BPX * BPX + BPY * BPY)));


	/**
	 * Projektionszentrum
	 */
	public static Point3D			BP = new Point3D(-5000 * BPX, -5000 * BPY, -5000 * BPZ);


	/**
	 * Boolesche Variable, die angibt, ob die verdeckten Linien gezeichnet werden sollen.
	 */
	public static boolean			showHiddenLines = true;


	/**
	 * Interpolations-Art
	 * 0 = Nchster Nachbar
	 * 1 = Bi-Linear interpoliert
	 * 2 = Tri-Linear interpolier
	 * 3 = Bi-Lagrange interpoliert
	 * 4 = Tri-Lagrange interpoliert
	 * 5 = Bi-Kubisch
	 * 7 = Tri-Kubisch
	 * 8 = Multi-Kubisch
	 */
	public static int					Interpolationmodel = 2;


	/**
	 * Auswahlzeichenkette fr den Auswertdialog in Quellenselktion
	 */
	public static String[]		IString = {
		"Nearest Neighbour", "Bi-Linear", "Tri-Linear", "Bi-Lagrange", "Tri-Langrange", "Bi-Kubic", "Tri-Kubic", "Multi_Kubic"
	};


	/**
	 * Grad des Polynoms bei Lagrangr-Interpolation
	 */
	public static int					NumberOfPoints = 3;		// mu grer gleich 3 sein !


	/**
	 * Anzahl der Sttzpunkte bei multi-kubischer Interpolation (>=4)
	 */
	public static int					NumberOfPoints_Kubic = 4;




	/**
	 * Farbe der Transversaldrahtmodelle
	 */
	public static Color				TransversalColor = Color.blue;


	/**
	 * Farbe der Sagittaldrahtmodelle
	 */
	public static Color				SagittalColor = Color.black;


	/**
	 * Farbe der Coronardrahtmodelle
	 */
	public static Color				CoronarColor = Color.magenta;


	/**
	 * Farbe des Drahtmodells der aktuellen Schicht
	 */
	public static Color				CurrentSliceColor = Color.orange;


	/**
	 * Anzahl der Integrationsintervalle bei numerishcer Integration
	 */
	public static int					Integration_Number = 1;


	/**
	 * Maximale Anzahl von untersttzten Serien
	 */
	public static int					MaxNumberOfSeries = 10;


	/**
	 * Methode zur Berechnung der Funktionswerte
	 * 0 = Addition
	 * 1 = Mittelwert
	 * 2 = Gewichtete Summen
	 * 3 = Lineare Gleichungen
	 */

	public static int					ApproxMethod = 0;


	/**
	 * Auswahlzeichenkette
	 */
	public static String[]		ApproxString = {
		"add", "average", "sums", "linear equtations"
	};



	/**
	 * Integrationsmethode
	 * 0 = Mittelpunktregel
	 * 1 = Riemannsumme
	 * 2 = Trapezregel
	 * 3 = Simpson Regel
	 */
	public static int					IntegrationMethod = 0;


	/**
	 * Auswahlzeichenkette
	 */
	public static String[]		IntegrationString = {
		"add", "average", "sums", "linear equtations"
	};


	/**
	 * Anzahl der Unterteilungen pro Matrix (2,3)
	 * Diese wird verwendet um die Auflsung bei den
	 * Methoden "Gewichtete Summen" und "Lineare Gleichungen" zu erhhen.
	 */
	public static int					Matrix_Resolution = 3;


	/**
	 * Epsilon Umgebung fr relativen Vergelich
	 */
	public static float				eps = 0.005f;


	/**
	 * Zahl maximaler paarweiserer Vergleiche bei den Methoden "Gewichtete Summen" und "Lineare Gleichungen".
	 */
	public static int					NumberOfPairs = 45;




	/**
	 * Hilfsfeld zur Verwaltung der Einstellungen fr die Methode der "gewichteten Summe".
	 */
	public static float[][]		Factors = new float[3][3];


	/**
	 * Hilfsfeld zur Verwaltung der Einstellungen fr die Methode der "gewichteten Summe".
	 */
	public static float[][]		PairFactors = new float[3][3];


	/**
	 * Verhltnis der Zeilensummen zu den Spaltensummen fr das Paar (Transversal / Coronar).
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_Factor_TC = 0.5f;


	/**
	 * Verhltnis der Zeilensummen zu den Spaltensummen fr das Paar (Transversal / Sagittal).
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_Factor_TS = 0.5f;


	/**
	 * Verhltnis der Zeilensummen zu den Spaltensummen fr das Paar (Coronar / Sagittal)
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_Factor_CS = 0.5f;


	/**
	 * Gewichtung des Paares (Transversal / Coronar) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_TC = 1.0f;


	/**
	 * Gewichtung des Paares (Transversal / Sagittal) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_TS = 1.0f;


	/**
	 * Gewichtung des Paares (Coronar / Sagittal) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 */
	public static float				Matrix_CS = 1.0f;


	/**
	 * Die Methode speichert die Einstellung des (Zeilensummen-Spaltemnsummen-Verhltnisses)
	 * in einem Hilfsfeld.
	 * Wird bei der Methode der "gewichteten Summe" verwendet.
	 * 
	 */
	public static void setMatrixFactors() {
		Factors[0][1] = Matrix_Factor_TS;
		Factors[1][0] = 1.0f - Matrix_Factor_TS;

		Factors[0][2] = Matrix_Factor_TC;
		Factors[2][0] = 1.0f - Matrix_Factor_TC;

		Factors[2][1] = Matrix_Factor_CS;
		Factors[1][2] = 1.0f - Matrix_Factor_CS;
	} 


	/**
	 * Die Methode speichert die Einstellung der Gewichtung
	 * in einem Hilfsfeld.
	 * Wird bei der Methode "Gewichtete Summe" verwendet.
	 */
	public static void setFactors() {
		PairFactors[0][1] = Matrix_TS;
		PairFactors[1][0] = Matrix_TS;

		PairFactors[0][2] = Matrix_TC;
		PairFactors[2][0] = Matrix_TC;

		PairFactors[2][1] = Matrix_CS;
		PairFactors[1][2] = Matrix_CS;
	} 


	/**
	 * Die Methode liefert die aktuellen Einstellungen der Methode "Gewichtete Summen" fr das Schichtpaar (ds1, ds2).
	 * Dazu werden die Orientierungen der Schichten umgesetzt.
	 * Hier wird das Zeilensummen-Spaltemnsummen-Verhltnis abgefragt.
	 * @param ds1 1.Schicht
	 * @param ds2 2.Schicht
	 * 
	 * @return Einstellung bezglich der angegeben Schichten
	 * 
	 */
	public static float getMatrixFactors(Dicom_Slice ds1, Dicom_Slice ds2) {
		int a = (ds1.getOrientation() - 1) / 3;
		int b = (ds2.getOrientation() - 1) / 3;

		return Factors[a][b];
	} 


	/**
	 * Die Methode liefert die aktuellen Einstellungen der Methode "Gewichtete Summen" fr das Schichtpaar (ds1, ds2).
	 * Dazu werden die Orientierungen der Schichten umgesetzt.
	 * Hier wird die Gewichtung abgefragt.
	 * @param ds1 1.Schicht
	 * @param ds2 2.Schicht
	 * 
	 * @return Einstellung bezglich der angegeben Schichten
	 * 
	 * 
	 */
	public static float getFactors(Dicom_Slice ds1, Dicom_Slice ds2) {
		int a = (ds1.getOrientation() - 1) / 3;
		int b = (ds2.getOrientation() - 1) / 3;

		return PairFactors[a][b];
	} 



	/**
	 * Faktor fr die wichtigeren Zeilen des linearen Gleichungsystems.
	 * Wird bei der Methode "Lineare Gleichungen" verwendet.
	 */
	public static float		Factor_impRows = 1;


	/**
	 * Gewichtung des Paares (Transversal / Coronar ) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static float		Factor_eq_TC = 1.0f;


	/**
	 * Gewichtung des Paares (Transversal / Sagittal) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static float		Factor_eq_TS = 1.0f;


	/**
	 * Gewichtung des Paares (Coronar / Sagittal) bei Berechnung des Gesamtfunktionswertes.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static float		Factor_eq_CS = 1.0f;


	/**
	 * Boolesche Variable, die angibt, ob das Trippel Transversal/Coronar/Sagittal verwendet wird.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static boolean TC_S = false;


	/**
	 * Boolesche Variable, die angibt, ob das Trippel Transversal/Sagittal/Coronar verwendet wird.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static boolean TS_C = true;


	/**
	 * Boolesche Variable, die angibt, ob das Trippel Sagittal/Coronar/Transversal verwendet wird.
	 * Wird bei der Methode der "Lineare Gleichungen" verwendet.
	 */
	public static boolean SC_T = false;


}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

