/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/


package mrcp.tools;
import java.util.Vector;
import mrcp.LineareAlgebra.*;
import ij.*;


/**
 * Die Klasse stellt weitere mathematische Methoden als statische Prozeduren zur Verfgung
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public final class MathTools {


	/**
	 * Nullvektor
	 */
	public static Point3D			Nullvector = new Point3D(0, 0, 0);


	/**
	 * Standardmatrix bei der Methode "Linerare Gleichungen" mit drei Intervallen.
	 */
	public static double[][]	Matrix3_3 = {
		 {
			1, 1, 1, 0, 0, 0, 0, 0, 0
		}, {
			0, 0, 0, 1, 1, 1, 0, 0, 0
		}, {
			0, 0, 0, 0, 0, 0, 1, 1, 1
		}, {
			1, 0, 0, 1, 0, 0, 1, 0, 0
		}, {
			0, 1, 0, 0, 1, 0, 0, 1, 0
		}, {
			0, 0, 1, 0, 0, 1, 0, 0, 1
		}, {
			1, 0, 0, 0, 0, 0, 0, 0, 0
		}, {
			0, 1, 0, 0, 0, 0, 0, 0, 0
		}, {
			0, 0, 1, 0, 0, 0, 0, 0, 0
		}, {
			0, 0, 0, 1, 0, 0, 0, 0, 0
		}, {
			0, 0, 0, 0, 1, 0, 0, 0, 0
		}, {
			0, 0, 0, 0, 0, 1, 0, 0, 0
		}, {
			0, 0, 0, 0, 0, 0, 1, 0, 0
		}, {
			0, 0, 0, 0, 0, 0, 0, 1, 0
		}, {
			0, 0, 0, 0, 0, 0, 0, 0, 1
		}
	};


	/**
	 * Standardmatrix bei der Methode "Linerare Gleichungen" mit zwei Intervallen
	 */
	public static double[][]	Matrix2_2 = {
		 {
			1, 1, 0, 0
		}, {
			0, 0, 1, 1
		}, {
			1, 0, 1, 0
		}, {
			0, 1, 0, 1
		}, {
			1, 0, 0, 0
		}, {
			0, 1, 0, 0
		}, {
			0, 0, 1, 0
		}, {
			0, 0, 0, 1
		}
	};


	/**
	 * Standardkonstruktor
	 * 
	 */
	public MathTools() {}


	/**
	 * Die Methode rundet das bergebende Argument.
	 * Im Gegensatz zur Java-Methode wird ein Float-Wert zurckgegeben.
	 * 
	 * @param x zu rundendes Argument
	 * 
	 * @return gerundeter Wert
	 * 
	 * 
	 */
	public static float round_db(float x) {
		return (float) Math.round(x);
	} 


	/**
	 * Floor Methode aus dem Java-Paket math.
	 * Im Gegensatz zur Java-Methode wird ein Ganzzahlwert zurckgegeben.
	 * 
	 * 
	 * @param x Fliekommawert
	 * 
	 * @return floor (x) als Ganzzahl
	 * 
	 * 
	 */
	public static int floor(float x) {
		return (int) Math.floor(x);
	} 


	/**
	 * Ceil Methode aus dem Java-Paket math.
	 * Im Gegensatz zur Java-Methode wird ein Ganzzahlwert zurckgegeben.
	 * 
	 * 
	 * @param x Fliekommawert
	 * 
	 * @return Ceil (x) als Ganzzahl
	 * 
	 * 
	 */
	public static int ceil(float x) {
		return (int) Math.ceil(x);
	} 

	// round mit cast


	/**
	 * Die Methode rundet das bergebende Argument.
	 * Im Gegensatz zur Java-Methode wird ein Integer-Wert zurckgegeben.
	 * 
	 * @param x zu rundendes Argument
	 * 
	 * @return gerundeter Wert
	 * 
	 */
	public static int round(float x) {
		return (int) Math.round(x);
	} 

	// Vergleich mit Epsilon Umgebung


	/**
	 * Die Methode vergleicht zwei Argumente hinsichtlich eine Epsilonumgebung.
	 * 
	 * 
	 * @param x Argument 1
	 * @param y Argument 2
	 * @param eps Epsilonumgebung
	 * 
	 * @return wahr, x und y innerhalb der Epsilonumgebung
	 * 
	 * 
	 */
	public static boolean equal(float x, float y, float eps) {
		return Math.abs(x - y) < eps;
	} 


	/**
	 * Die Methode berechnet eine lineare Interpolation zwischen zwei Sttzwerten.
	 * Die Sttzstellen haben den Abstand eins.
	 * 
	 * @param val1 1.Sttzwert
	 * @param val2 2.Sttzwert
	 * @param XFactor Interpolationsstelle
	 * 
	 * @return linear interpolierter Wert
	 * 
	 */
	public static float LI2(float val1, float val2, float XFactor) {
		return val1 + (val2 - val1) * XFactor;
	} 


	/**
	 * Die Methode berechnet einen Interpolationswert mit Hilfe der Lagrange-Interpolation.
	 * Alle Sttz-Punkte werden als quidistant angenommen.
	 * Je nach Anzahl der Sttzwerte wird ein entsprechen Grad des Polynoms benutzt.
	 * @param values Sttzwerte
	 * @param XVal Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 * 
	 * 
	 */
	public static float Lagrange(int[] values, float XVal) {

		// XVal = XVal - floor (XVal) ;
		int		n = values.length;

		// XVal += n / 2 - 1 ;
		float val = 0;

		for (int j = 0; j < n; j++) {
			float Beta = 1.0f;

			for (int i = 0; i < n; i++) {
				if (i != j) {
					Beta *= (XVal - i) / (j - i);
				} 
			} 
			val += Beta * values[j];
		} 

		return val;

	} 


	/**
	 * Die Methode berechnet einen Interpolationswert mit Hilfe der Lagrange-Interpolation.
	 * Alle Sttz-Punkte werden als quidistant angenommen.
	 * Je nach Anzahl der Sttzwerte wird ein entsprechen Grad des Polynoms benutzt.
	 * @param values Sttzwerte
	 * @param XVal Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 * 
	 * 
	 */
	public static float Lagrange(float[] values, float XVal) {

		// XVal = XVal - floor (XVal) ;
		int		n = values.length;

		// XVal += n / 2 - 1 ;
		float val = 0;

		for (int j = 0; j < n; j++) {
			float Beta = 1.0f;

			for (int i = 0; i < n; i++) {
				if (i != j) {
					Beta *= (XVal - i) / (j - i);
				} 
			} 
			val += Beta * values[j];
		} 

		return val;

	} 



	/**
	 * Die Methode berechnet eine Interpolationswert mit Hilfe der Kubischen-Spline-Interpolation.
	 * Die Anzahl der Sttzwerte betrgt genau vier.
	 * 
	 * @param values Sttzwerte
	 * @param dist Distanz der Sttzpunkte
	 * @param XVal Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 * 
	 */
	public static float KubicSpline(int[] values, float dist, float XVal) {

		float y1 = 3 / dist * (values[2] - 2 * values[1] + values[0]);
		float y2 = 3 / dist * (values[3] - 2 * values[2] + values[1]);

		float c2 = (y2 - 0.25f * y1) / (3.75f * dist);
		float c1 = (y1 - dist * c2) / (4 * dist);

		float d1 = (1 / (3 * dist)) * (c2 - c1);
		float b1 = (1 / dist) * (values[2] - values[1]) - (dist / 3) * (c2 + 2 * c1);


		return values[1] + b1 * (XVal) + c1 * (XVal * XVal) + d1 * (XVal * XVal * XVal);
	} 


	/**
	 * Die Methode berechnet eine Interpolationswert mit Hilfe der Kubischen-Spline-Interpolation.
	 * Die Anzahl der Sttzwerte betrgt genau vier.
	 * 
	 * @param values Sttzwerte
	 * @param dist Distanz der Sttzpunkte
	 * @param XVal Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 */
	public static float KubicSpline(float[] values, float dist, float XVal) {

		float y1 = 3 / dist * (values[2] - 2 * values[1] + values[0]);
		float y2 = 3 / dist * (values[3] - 2 * values[2] + values[1]);

		float c2 = (y2 - 0.25f * y1) / (3.75f * dist);
		float c1 = (y1 - dist * c2) / (4 * dist);

		float d1 = (1 / (3 * dist)) * (c2 - c1);
		float b1 = (1 / dist) * (values[2] - values[1]) - (dist / 3) * (c2 + 2 * c1);


		return values[1] + b1 * (XVal) + c1 * (XVal * XVal) + d1 * (XVal * XVal * XVal);
	} 


	/**
	 * Die Methode berechnet eine Interpolationswert mit Hilfe der Kubischen-Spline-Interpolation.
	 * 
	 * 
	 * @param n Anzahl der Sttzpunkte
	 * @param dist Sttzpunktdistanz
	 * @param y Sttzwerte
	 * @param x0 Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 * 
	 * 
	 */
	public static float KubicSpline2(int n, float dist, float[] y, float x0) {
		--n;
		float[] a = new float[n + 1];
		float[] b = new float[n + 1];
		float[] c = new float[n + 1];
		float[] d = new float[n + 1];
		float[] h = new float[n + 1];

		for (int i = 0; i <= n - 1; i++) {
			h[i] = dist;
		} 

		// Aufstellung des Gleichungssystem

		for (int i = 0; i <= n - 2; i++) {
			a[i] = 3 * ((y[i + 2] - y[i + 1]) / h[i + 1] - (y[i + 1] - y[i]) / h[i]);
			b[i] = h[i];
			c[i] = h[i + 1];
			d[i] = 2 * (h[i] + h[i + 1]);

		} 

		// Berechnen der Koeffizienten !

		trdiag(n - 1, b, d, c, a, 0);

		// Lsungsvektor in c !

		for (int i = 0; i <= n - 2; i++) {
			c[i + 1] = a[i];
		} 

		c[0] = 0;
		c[n] = 0;

		for (int i = 0; i <= n - 1; i++) {
			b[i] = (y[i + 1] - y[i]) / h[i] - h[i] * (c[i + 1] + 2 * c[i]) / 3;
			d[i] = (c[i + 1] - c[i]) / (3 * h[i]);

		} 

		int i = (int) x0;

		x0 = x0 - i;

		return (((d[i] * x0 + c[i]) * x0 + b[i]) * x0 + y[i]);

	} 


	/**
	 * Die Methode berechnet eine Interpolationswert mit Hilfe der Kubischen-Spline-Interpolation.
	 * 
	 * 
	 * @param n Anzahl der Sttzpunkte
	 * @param dist Sttzpunktdistanz
	 * @param y Sttzwerte
	 * @param x0 Interpolationsstelle
	 * 
	 * @return interpolierter Wert
	 */
	public static float KubicSpline2(int n, float dist, int[] y, float x0) {
		--n;
		float[] a = new float[n + 1];
		float[] b = new float[n + 1];
		float[] c = new float[n + 1];
		float[] d = new float[n + 1];
		float[] h = new float[n + 1];

		for (int i = 0; i <= n - 1; i++) {
			h[i] = dist;
		} 

		// Aufstellung des Gleichungssystem

		for (int i = 0; i <= n - 2; i++) {
			a[i] = 3 * ((y[i + 2] - y[i + 1]) / h[i + 1] - (y[i + 1] - y[i]) / h[i]);
			b[i] = h[i];
			c[i] = h[i + 1];
			d[i] = 2 * (h[i] + h[i + 1]);

		} 

		// Berechnen der Koeffizienten !

		trdiag(n - 1, b, d, c, a, 0);

		// Lsungsvektor in c !

		for (int i = 0; i <= n - 2; i++) {
			c[i + 1] = a[i];
		} 

		c[0] = 0;
		c[n] = 0;

		for (int i = 0; i <= n - 1; i++) {
			b[i] = (y[i + 1] - y[i]) / h[i] - h[i] * (c[i + 1] + 2 * c[i]) / 3;
			d[i] = (c[i + 1] - c[i]) / (3 * h[i]);

		} 

		int i = (int) x0;

		x0 = x0 - i;

		return (((d[i] * x0 + c[i]) * x0 + b[i]) * x0 + y[i]);

	} 


	/**
	 * Die Methode berechnet den Lsungsvektor einer tri-diagonalen Matrix.
	 * 
	 * 
	 * @param n Anzahl der Gleichungen
	 * @param lower untere Nebendiagonale
	 * @param diag Hauptdiagonale
	 * @param upper obere Nebendiagonale
	 * @param b Lsungsvektor
	 * @param rep Parameter zur Methodensteuerung
	 * 
	 * 
	 */
	public static void trdiag(int n, float[] lower, float[] diag, float[] upper, float[] b, int rep) {
		for (int i = 1; i < n; i++) {
			lower[i] /= diag[i - 1];
			diag[i] -= lower[i] * upper[i - 1];

		} 

		// Vorwrtselimination

		for (int i = 1; i < n; i++) {
			b[i] -= lower[i] * b[i - 1];
		} 

		// Rckwertelimination

		b[n - 1] /= diag[n - 1];

		for (int i = n - 2; i >= 0; i--) {
			b[i] = (b[i] - upper[i] * b[i + 1]) / diag[i];
		} 

	} 


	/**
	 * Die Methode berechnet die Gewichte der Funktionswerte zur Bestimmung eines
	 * Integrals mit Hilfe der Simpson-Regel.
	 * 
	 * 
	 * @param n Index des aktuell bearbeiteten Intervalls
	 * @param Anzahl der Integrationsintervalle
	 * 
	 * @return Simpsongewicht
	 * 
	 * 
	 */
	public static int getWeigth(int n, int global_n) {

		// berechnet Gewichte fr Simspon Rule

		if (n == 0 || n == 2 * global_n) {
			return 1;
		} 
		if ((n % 2) == 0) {
			return 2;
		} else {
			return 4;
		} 
	} 


	/**
	 * Die Methode lst ein berbestimmtes Gleichungssystem durch linearen Ausgleich.
	 * Falls die Matrix positiv definit ist, kommt eine Cholskeyzerlegung zum Einsatz.
	 * Sonst wird versucht das Gausche Prinzip anzuwenden.
	 * @param a Gleichungssystem als Matrix
	 * @param b Ergebnisvektor
	 * @param n Anzahl der Zeilen
	 * @param p Anzahl der Spalten
	 * 
	 * @return Lsungsvektor
	 * 
	 * 
	 */
	public static double[] solveLinEqu(double[][] a, double[] b, int n, int p) {

		// Linearer Ausgleich des berbestimmten Gleichungssystem
		// n Anzahl Zeilen
		// p Anzahl Spalten
		// a zu berechne Matrix
		// b Vektor b


		// transponierte Matrix
		double[][]	at = new double[p][n];

		Blas_j.mattran_j(a, at, n, p);

		// c = a * at
		double[][]	c = new double[p][p];

		Blas_j.matmat_j(at, a, c, p, n, p);

		// d = at * b
		double[]	d = new double[p];

		Blas_j.matvec_j(at, b, d, p, n);

		// Blas_j.matmat_j(at,b,d,n,p,n);


		// cx = d
		Cholesky	chol = new Cholesky();

		try {
			chol.solvePosDef(c, d, new double[p], p, false);
		} catch (Exception e) {
			IJ.write(" Not pos definet error ");

			int[] ipvt = new int[p];

			try {
				LU_j.dgefa_j(c, p, ipvt);
				LU_j.dgesl_j(c, p, ipvt, b, 0);
			} catch (Exception ep) {
				IJ.write(" Not Gauslsbar ");
				return null;
			} 
			return b;
		} 
		return d;
	} 


	/**
	 * Die Methode berechnet eine Potenz.
	 * 
	 * 
	 * @param Basis Basis
	 * @param Exponent Exponent
	 * 
	 * @return Die Potenz "basis hoch Exponent"
	 * 
	 */
	public static float Exp(float Basis, int Exponent) {
		if (Exponent == 0) {
			return 1;
		} 
		float val = Basis;

		for (int i = 0; i < Exponent - 1; i++) {
			val *= val;
		} 
		return val;
	} 


	/**
	 * Die Methode berechnet den Schnittpunkt von einer Ebene und einer Geraden.
	 * Dazu wird die Normalengleichung der Ebene und die Punktrichtungsgleichung der Geraden benutzt.
	 * 
	 * @param go Positionsvektor
	 * @param gm Richtungsvektor
	 * @param eo Positionsvektor der Ebene
	 * @param em Normalenvektor der Ebene
	 * 
	 * @return Schnittpunkt
	 * 
	 * 
	 */
	public static Point3D calcIntersection_GP(Point3D go, Point3D gm, Point3D eo, Point3D em) {

		// Test auf Parallelitt
		if (gm.VC_SK_Mult(em) == 0) {
			return null;

			// Berechnung des Schnittpunktes
		} 
		Point3D tmp = go.VC_Min(eo);
		float		r0 = gm.VC_SK_Mult(em);
		float		r1 = tmp.VC_SK_Mult(em);
		float		r = -r1 / r0;

		return go.VC_Add(gm.Sk_Mult(r));
	} 


	/**
	 * Die Methode berechnet die Schnittgerade zweier Ebenen.
	 * Dazu mu eine Ebene in Punktrichtungsform und die andere Normalenform vorliegen.
	 * Das Ergebnis wird in "go" und "gm" gespeichert.
	 * @param eo Positionsvektor der ersten Ebene
	 * @param em Normalenvektor der ersten Ebene
	 * @param o  Positionsvektor der zweiten Ebenee
	 * @param v1 1. Richtungsvektor
	 * @param v2 2. Richtungsvektor
	 * @param go Geradenpositionsvektor
	 * @param gm Geradenrichtungsvektor
	 * 
	 * 
	 */
	public static void calcIntersection_PP(Point3D eo, Point3D em, Point3D o, Point3D v1, Point3D v2, Point3D go, Point3D gm) {

		// Test auf Parallelitt

		if (em.VC_SK_Mult(v1) == 0 && em.VC_SK_Mult(v2) == 0) {
			go = gm = null;
			return;
		} 

		// Berechnung des Schnittpunktes
		Point3D tmp = o.VC_Min(eo);
		float		a = tmp.VC_SK_Mult(em);
		float		r = v1.VC_SK_Mult(em);
		float		s = v2.VC_SK_Mult(em);

		if (s != 0)		// nach s auflsen
		 {
			a /= s;
			r /= s;
			go.set(o.VC_Add(v2.Sk_Mult(-a)));
			gm.set(v1.VC_Add(v2.Sk_Mult(-r)));
		} else {
			a /= r;
			s /= r;
			go.set(o.VC_Add(v1.Sk_Mult(-a)));
			gm.set(v2.VC_Add(v1.Sk_Mult(-s)));
		} 

	} 


	/**
	 * Die Methodw kopiert eine Matrix "tief".
	 * 
	 * 
	 * @param a Quellmatrix
	 * @param b Zielmatrix
	 * 
	 * 
	 */
	public static void copyMatrix(double[][] a, double[][] b) {
		int rows = a.length;
		int cols = a[0].length;

		for (int i = 0; i < rows; i++) {
			for (int n = 0; n < cols; n++) {

				b[i][n] = a[i][n];
			} 
		} 

	} 


}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

