/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.tools;
import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;
import mrcp.dd.*;
import mrcp.ddd.*;


/**
 * Die Klasse verwaltet das grafische Erscheinungsbild der Baumansicht in Quellenselektion.
 * Insbesondere wird hier jedem Knoten in Abhngigkeit seinen Darstellung ein Icon zugewiesen.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class MyRenderer extends DefaultTreeCellRenderer {
	ImageIcon Tra_Icon, Tra_Ser_Icon, DDD_Icon, Sag_Icon, Sagital_Ser_Icon, Cor_Icon, Cor_Ser_Icon;


	/**
	 * Der Konstruktur initialisert die neuen Knotenbilder als Icons.
	 * 
	 * 
	 */
	public MyRenderer() {

		String	path = System.getProperty("user.dir");

		path += System.getProperty("file.separator");
		DDD_Icon = new ImageIcon(path + "Resource/ddd.gif");

		Tra_Icon = new ImageIcon(path + "Resource/Transversal_Icon.gif");
		Tra_Ser_Icon = new ImageIcon(path + "Resource/Transversal_Ser_Icon.gif");

		Sag_Icon = new ImageIcon(path + "Resource/Sagital.gif");
		Sagital_Ser_Icon = new ImageIcon(path + "Resource/Sagital_Ser.gif");

		Cor_Icon = new ImageIcon(path + "Resource/Coronar_Icon.gif");
		Cor_Ser_Icon = new ImageIcon(path + "Resource/Coronar_Ser_Icon.gif");
	}


	/**
	 * Die Methode mu berschrieben werden, um bei Zeichnung des Baumes
	 * die neuen Icon zuordnen zu knnen.
	 * Je nach Darstellung des jeweiligen Knoten, wird ein Icon zugeordnet.
	 * 
	 * @param tree Baumobjekt
	 * @param value Knotenobjekt
	 * @param sel Markierung
	 * @param expanded Expansion
	 * @param leaf Blatt
	 * @param row Nummer der Reihe
	 * @param hasFocus Fokus
	 * 
	 * @return Komponente
	 * 
	 */
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {

		super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

		DefaultMutableTreeNode	node = (DefaultMutableTreeNode) value;
		Object									object = node.getUserObject();

		String									classname = object.getClass().getName();

		if (classname.compareTo("java.lang.String") == 0) 

		// 3D Wurzelobject
		{
			setIcon(DDD_Icon);
			return this;
		} 

		if (classname.indexOf("Series_Node") > 0) {
			DefaultMutableTreeNode	child = (DefaultMutableTreeNode) node.getFirstChild();
			Slice_Leaf							sl = (Slice_Leaf) child.getUserObject();
			Dicom_Slice							ds = sl.cube.ds;

			if (ds.isSagittal()) {
				setIcon(Sagital_Ser_Icon);
			} else if (ds.isCoronar()) {
				setIcon(Cor_Ser_Icon);
			} else if (ds.isTransversal()) {
				setIcon(Tra_Ser_Icon);
			} 
			return this;
		} 

		if (leaf) {
			Slice_Leaf	Sleaf = (Slice_Leaf) object;

			if (Sleaf.cube.ds.isSagittal()) {
				setIcon(Sag_Icon);
			} else if (Sleaf.cube.ds.isCoronar()) {
				setIcon(Cor_Icon);
			} else if (Sleaf.cube.ds.isTransversal()) {
				setIcon(Tra_Icon);
			} 
			return this;
		} 
		return this;
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

