/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.tools;


/**
 * Die Klasse stellt eine zweidimensionalen Vektor mit einigen Operatoren zur Verfgung.
 * Im Gegensatz zur Klasse "java.awt.Point" werden Fliekommakomponenten untersttzt.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Point2D {


	/**
	 * x-Komponente des Vektors
	 */
	float x;


	/**
	 * y-Komponente des Vektors
	 */
	float y;


	/**
	 * Der Konstruktur erzeugt einen neuen Vektor mit den angegebene Komponenten.
	 * 
	 * 
	 * @param x x-Komponente des Vektors
	 * @param y y-Komponente des Vektors
	 * 
	 */
	public Point2D(float x, float y) {
		this.x = x;
		this.y = y;
	}


	/**
	 * Die Methode liefert die x-Komponente des Vektorszurck.
	 * 
	 * 
	 * @return x-Komponente des Vektors
	 * 
	 * 
	 */
	public float getX() {
		return this.x;
	} 


	/**
	 * Die Methode liefert die y-Komponente des Vektorszurck.
	 * 
	 * 
	 * @return y-Komponente des Vektors
	 * 
	 * 
	 */
	public float getY() {
		return this.y;
	} 


	// vektorielle Subtraktiion


	/**
	 * Die Methode berechnet eine vektorielle Subtraktion mit "p".
	 * 
	 * 
	 * @param p Subtrahend
	 * 
	 * @return Differenz der Vektoren
	 * 
	 * 
	 */
	public Point2D VC_Min(Point2D p) {
		return new Point2D(getX() - p.getX(), getY() - p.getY());
	} 

	// Vektor Skalare Multiplikation


	/**
	 * Die Methode berechnet eine vektorielle skalare Multiplikation
	 * 
	 * 
	 * @param Faktor
	 * 
	 * @return skalares Vektorprodukt
	 * 
	 * 
	 */
	public float VC_SK_Mult(Point2D p) {
		return (getX() * p.getX() + getY() * p.getY());
	} 


	/**
	 * Die Methode quadriert den Vektor
	 * 
	 * 
	 * @return Das Qudrat des Vektors
	 * 
	 * 
	 */
	public float square() {
		return getX() * getX() + getY() * getY();
	} 



	/**
	 * Die Methode berechnet die Lnge des Vektors.
	 * 
	 * 
	 * @return Lnge des Vektors
	 * 
	 * 
	 */
	public float Length() {
		return (float) Math.sqrt(getX() * getX() + getY() * getY());
	} 

	// normalisieren


	/**
	 * Die Methode normalisiert den Vektor.
	 * Dann gilt Betrag = 1.
	 * 
	 * 
	 */
	public void norm() {
		float fac = (getX() * getX()) + (getY() * getY());

		fac = (float) Math.sqrt(1 / fac);

		this.x = getX() * fac;
		this.y = getY() * fac;
	} 


	/**
	 * Die Methode berechnet eine skalare Multiplikation.
	 * 
	 * 
	 * @param fac Skalar
	 * 
	 * 
	 */
	public void Sk_Mult(float fac) {
		x = x * fac;
		y = y * fac;
	} 


	/**
	 * Die Methode berechnet eine Translation des Vektors.
	 * 
	 * 
	 * @param a x-Komponente des Translationsvektors
	 * @param b y-Komponente des Translationsvektors
	 * 
	 */
	public void translate(float a, float b) {
		x += a;
		y += b;
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

