/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.tools;
import java.awt.*;
import java.lang.Math;


/**
 * Die Klasse stellt eine dreidimensionalen Vektor mit einigen Operatoren zur Verfgung.
 * 
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */


public class Point3D {


	/**
	 * x-Komponente des Vektors
	 */
	float x;


	/**
	 * y-Komponente des Vektors
	 */
	float y;


	/**
	 * z-Komponente des Vektors
	 */
	float z;


	/**
	 * 
	 * 
	 * Diese Methode konstruiert einen 3-dimensionalen Vector
	 * @param  x  X-Komponente
	 * @param  y  Y-Komponente
	 * @param  z  Z-Komponente
	 * 
	 */

	// Konstruktor
	public Point3D(float x, float y, float z) {

		this.x = x;
		this.y = y;
		this.z = z;
	}


	/**
	 * 
	 * <p>
	 * Diese Methode transliert einen Vektor relativ zu den als
	 * Parameter angegebenen Koordinaten.
	 * @param  x  x-Increment
	 * @param  y  y-Increment
	 * @param  z  z-Increment
	 * 
	 */
	public void translate(float x, float y, float z) {
		this.x += x;
		this.y += y;
		this.z += z;
	} 


	/**
	 * Die Methode setzt die Komponenten des Vektors neu.
	 * 
	 * 
	 * @param x x-Komponente
	 * @param y y-Komponente
	 * @param z z-Komponente
	 * 
	 * 
	 */
	public void set(float x, float y, float z) {
		this.x = x;
		this.y = y;
		this.z = z;
	} 


	/**
	 * Die Methode setzt die Komponenten des Vektors neu.
	 * 
	 * 
	 * @param p neuer Vektor
	 * 
	 * 
	 */
	public void set(Point3D p) {
		this.x = p.x;
		this.y = p.y;
		this.z = p.z;
	} 


	/**
	 * Die Methode verschiebt den Vektor um den angegebenen Translationsvektor.
	 * 
	 * 
	 * @param p Translationsvektor
	 * 
	 * 
	 */
	public void translate(Point3D p) {
		this.x += p.x;
		this.y += p.y;
		this.z += p.z;
	} 


	/**
	 * Die Methode erzeugt ein neues Exemplar, das um den angegebenen Translationsvektor verschoben ist.
	 * 
	 * 
	 * 
	 * @param p Translationsvektor
	 * 
	 * @return Kopie des verschobenen Ursprungsvektor
	 * 
	 * 
	 */
	public Point3D translate_copy(Point3D p) {

		return new Point3D(this.x + p.x, this.y + p.y, this.z + p.z);
	} 




	/**
	 * Die Methode rotiert den Vektor um die y-Achse
	 * 
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateY(float Grad) {
		float xnew = (float) (z * Math.sin(Grad * Global_Options.RAD) + x * Math.cos(Grad * Global_Options.RAD));

		float znew = (float) (z * Math.cos(Grad * Global_Options.RAD) - x * Math.sin(Grad * Global_Options.RAD));

		x = xnew;
		z = znew;

	} 



	/**
	 * Die Methode rotiert den Vektor um die x-Achse
	 * 
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateX(float Grad) {
		float ynew = (float) (y * Math.cos(Grad * Global_Options.RAD) - z * Math.sin(Grad * Global_Options.RAD));

		float znew = (float) (y * Math.sin(Grad * Global_Options.RAD) + z * Math.cos(Grad * Global_Options.RAD));

		y = ynew;
		z = znew;

	} 



	/**
	 * Die Methode rotiert den Vektor um die z-Achse
	 * 
	 * 
	 * @param Grad Drehwinkel
	 * 
	 * 
	 */
	public void rotateZ(float Grad) {
		float xnew = (float) (x * Math.cos(Grad * Global_Options.RAD) - y * Math.sin(Grad * Global_Options.RAD));

		float ynew = (float) (x * Math.sin(Grad * Global_Options.RAD) + y * Math.cos(Grad * Global_Options.RAD));

		x = xnew;
		y = ynew;
	} 



	/**
	 * Die Methode liefert die x-Komponente zurck.
	 * 
	 * 
	 * @return x-Komponente
	 * 
	 * 
	 */
	public float getX() {
		return this.x;
	} 



	/**
	 * Die Methode liefert die y-Komponente zurck.
	 * 
	 * 
	 * @return y-Komponente
	 * 
	 * 
	 */
	public float getY() {
		return this.y;
	} 




	/**
	 * Die Methode liefert die z-Komponente zurck.
	 * 
	 * 
	 * @return z-Komponente
	 * 
	 * 
	 */
	public float getZ() {
		return this.z;
	} 

	// Skalare Multiplikation


	/**
	 * Method declaration
	 * 
	 * 
	 * @param fac
	 * 
	 * @return
	 * 
	 * 
	 */
	public Point3D Sk_Mult(float fac) {
		return new Point3D(getX() * fac, getY() * fac, getZ() * fac);
	} 

	// Vektor Skalare Multiplikation


	/**
	 * Method declaration
	 * 
	 * 
	 * @param p2
	 * 
	 * @return
	 * 
	 * 
	 */
	public float VC_SK_Mult(Point3D p2) {
		return (getX() * p2.getX() + getY() * p2.getY() + getZ() * p2.getZ());
	} 


	/**
	 * Die Methode addiert zwei Vektoren und liefert das Ergebnis zurck.
	 * 
	 * 
	 * @param Vec Summandenvektor
	 * 
	 * @return Summe der Vektoren
	 * 
	 * 
	 */
	public Point3D VC_Add(Point3D Vec) {
		return new Point3D(getX() + Vec.getX(), getY() + Vec.getY(), getZ() + Vec.getZ());
	} 


	/**
	 * Die Methode addiert zwei Vektoren.
	 * 
	 * 
	 * @param Vec Summandenvektor
	 * 
	 * 
	 */
	public void VC_Add2(Point3D Vec) {
		x += Vec.getX();
		y += Vec.getY();
		z += Vec.getZ();
	} 


	/**
	 * Die Methode subtrahiert zwei Vektoren und liefert das Ergebnis zurck..
	 * 
	 * 
	 * @param Vec Subtrahendenvektor
	 * 
	 * @return Differnzvektor
	 * 
	 * 
	 */
	public Point3D VC_Min(Point3D Vec) {
		return new Point3D(getX() - Vec.getX(), getY() - Vec.getY(), getZ() - Vec.getZ());
	} 




	/**
	 * Die Methode multipliziert zwei Vektoren und liefert das Ergebnis zurck.
	 * 
	 * 
	 * @param Vec Faktorvektor
	 * 
	 * @return Produktvektor
	 * 
	 * 
	 */
	public Point3D VC_Mult(Point3D Vec) {
		return new Point3D(getY() * Vec.getZ() - getZ() * Vec.getY(), getZ() * Vec.getX() - getX() * Vec.getZ(), getX() * Vec.getY() - getY() * Vec.getX());
	} 



	/**
	 * Die Methode normalisiert den Vektor.
	 * Das bedeute die Lnge ist eins.
	 * 
	 * 
	 */
	public void norm() {
		float fac = (getX() * getX()) + (getY() * getY()) + (getZ() * getZ());

		fac = (float) Math.sqrt(1 / fac);

		x = getX() * fac;
		y = getY() * fac;
		z = getZ() * fac;
	} 

	// Quadrat


	/**
	 * Die Methode quadriert den Vektor.
	 * 
	 * 
	 * @return Vektorquadrat
	 * 
	 * 
	 */
	public float square() {
		return getX() * getX() + getY() * getY() + getZ() * getZ();
	} 


	/**
	 * Die Methode berechnet den Betrag des Vektors.
	 * 
	 * 
	 * @return Betrag des Vektors (Lnge)
	 * 
	 * 
	 */
	public float Length() {
		return (float) Math.sqrt(getX() * getX() + getY() * getY() + getZ() * getZ());
	} 


	/**
	 * Die Methode vergleicht zwei Vektoren.
	 * 
	 * 
	 * @param p zu vergleichender Vektor
	 * 
	 * @return wahr, falls Vektoren gleich.
	 * 
	 * 
	 */
	public boolean equal(Point3D p) {

		// Vergleich ber Epsilon Umgebung
		float		eps = Global_Options.eps;

		boolean result = (MathTools.equal(Math.abs(getX()), Math.abs(p.getX()), eps) && MathTools.equal(Math.abs(getY()), Math.abs(p.getY()), eps) && MathTools.equal(Math.abs(getZ()), Math.abs(p.getZ()), eps));

		return result;

	} 


	/**
	 * Die Methode liefert einen Zeichenkette der Komponenten zurck.
	 * 
	 * 
	 * @return Zeichenkette mit Komponenten
	 * 
	 * 
	 */
	public String toString() {
		String	temp = "";

		temp += Double.toString(x);
		temp += "; ";
		temp += Double.toString(y);
		temp += "; ";
		temp += Double.toString(z);

		return temp;
	} 

}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

