/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

package mrcp.tools;
import java.lang.Math;
import ij.*;


/**
 * Klasse zur Darstellung eines Quaders, der durch seine Eckpunkte gegeben ist.
 * Zustzlich werden einige Hilfsoperationen definiert.
 * 
 * @author Thomas Demuth
 * @version 2000.08.11
 */
public class Vektor3DPoint {


	/**
	 * Vektor der Eckpunkte
	 */

	public Point3D[]	Quader = new Point3D[8];


	// Konstruktor


	/**
	 * Erzeugt einen Quader mit den angegebenen Eckpunkten.
	 * 
	 * 
	 * @param p1 Punkt1
	 * @param p2 Punkt2
	 * @param p3 Punkt3
	 * @param p4 Punkt4
	 * @param p5 Punkt5
	 * @param p6 Punkt6
	 * @param p7 Punkt7
	 * @param p8 Punkt8
	 * 
	 */
	public Vektor3DPoint(Point3D p1, Point3D p2, Point3D p3, Point3D p4, Point3D p5, Point3D p6, Point3D p7, Point3D p8) {
		setPoint(1, p1);
		setPoint(2, p2);
		setPoint(3, p3);
		setPoint(4, p4);
		setPoint(5, p5);
		setPoint(6, p6);
		setPoint(7, p7);
		setPoint(8, p8);
	}

	// 


	/**
	 * Standardkonstruktur, der einen leeren Quader erzeugt.
	 * 
	 * 
	 */
	public Vektor3DPoint() {
		setPoint(1, new Point3D(0, 0, 0));
		setPoint(2, new Point3D(0, 0, 0));
		setPoint(3, new Point3D(0, 0, 0));
		setPoint(4, new Point3D(0, 0, 0));
		setPoint(5, new Point3D(0, 0, 0));
		setPoint(6, new Point3D(0, 0, 0));
		setPoint(7, new Point3D(0, 0, 0));
		setPoint(8, new Point3D(0, 0, 0));
	}



	/**
	 * Die Methode liefert den Punkt mit dem bergebenden Index zurck.
	 * 
	 * 
	 * @param number Index des Punktes
	 * 
	 * @return Eckpunkt
	 * 
	 * 
	 */
	public Point3D getPoint(int number) {
		try {

			return Quader[number - 1];
		} catch (IndexOutOfBoundsException e) {
			return null;
		} 
	} 


	/**
	 * Die Methode setzt den bergebenden Punkt an die entsprechende Indexposition.
	 * 
	 * 
	 * @param number Indexposition
	 * @param p neuer Punkt
	 * 
	 * 
	 */
	public void setPoint(int number, Point3D p) {
		try {
			Quader[number - 1] = p;
		} catch (Exception e) {
			IJ.error("IndexOutOfBoundsException in getPoint");
			return;
		} 
	} 



	/**
	 * Die Methode addiert 4 Punkte.
	 * Dies wird bentigt um den Mittelpunkt des Quaders zu berechnen.
	 * 
	 * @param p1 Punkt1
	 * @param p2 Punkt1
	 * @param p3 Punkt1
	 * @param p4 Punkt1
	 * 
	 * @return Summe der Punkte
	 * 
	 * 
	 */
	public Point3D add(Point3D p1, Point3D p2, Point3D p3, Point3D p4) {
		return (p1.VC_Add(p2)).VC_Add(p3).VC_Add(p4);

	} 



	/**
	 * Die Methode subtrahiert zwei dreidimensionale Punkte (Vektoren)
	 * 
	 * 
	 * @param p1 Punkt 1
	 * @param p2 Punkt 2
	 * 
	 * @return Differenzvektor
	 * 
	 * 
	 */
	public Point3D sub(Point3D p1, Point3D p2) {
		return (Point3D) p1.VC_Add(p2.Sk_Mult(-1));
	} 






	/**
	 * Die Methode berechnet den Euklidischen-Abstand zweier Punkte im Raum.
	 * 
	 * 
	 * @param p1 Punkt 1
	 * @param p2 Punkt 2
	 * 
	 * @return Euklidischer Abstand
	 * 
	 * 
	 */
	public float getDistance(Point3D p1, Point3D p2) {
		return (float) Math.sqrt(((p1.getX() - p2.getX()) * (p1.getX() - p2.getX())) + ((p1.getY() - p2.getY()) * (p1.getY() - p2.getY())) + ((p1.getZ() - p2.getZ()) * (p1.getZ() - p2.getZ())));

	} 


	/**
	 * Die Methode verschiebt den Quader, um den angegebenen Translationsvektor.
	 * 
	 * 
	 * @param x x-Komponente des Translationsvektors
	 * @param y y-Komponente des Translationsvektors
	 * @param z z-Komponente des Translationsvektors
	 * 
	 * 
	 */
	public void translate(float x, float y, float z) {
		for (int i = 0; i < 8; i++) {
			Quader[i].translate(x, y, z);
		} 

	} 


	/**
	 * Die Methode berechnet den Mittelpunkt des Quaders.
	 * 
	 * 
	 * @return Mittelpunkt
	 * 
	 * 
	 */
	public Point3D getMid() {
		Point3D mid;
		float		x, y, z;

		x = y = z = 0;

		for (int i = 0; i < 8; i++) {

			x += Quader[i].getX();
			y += Quader[i].getY();
			z += Quader[i].getZ();

		} 

		mid = new Point3D(x / 8, y / 8, z / 8);
		return mid;
	} 


}




/*--- formatting done in "My Own Convention" style on 08-28-2000 ---*/

