/*--- formatted by Jindent 2.1, (www.c-lab.de/~jindent) ---*/

/*
 * Copyright (C) 2000 Thomas Hacklaender, e-mail: reply@thomas-hacklaender.de
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * http://www.gnu.org/copyleft/copyleft.html
 */
package rad.dicom.ima;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import rad.dicom.dcm.*;


/**
 * Diese Klasse erweitert die Funktionalitaet von ImagePanel um zwei Buttons
 * zur Einstellung der Center und Window Werte.
 * <ul>
 * <li> D = Das Wertepaar, das fuer das Bild als Defaultwert festgelegt wurde.
 * Normalerweise werden das die Werte aus der DICOM "VOI LUT Module" sein. </li>
 * <li> A = Die Werte werden automatisch so berechnet, dass alle Pixelwerte zwischen
 * der 10ten und 90ten Perzentiele dargestellt werden. </li></ul>
 * Obwohl ImageBtnPanel die Funktionalitaet von ImagePanel erweitert, kann
 * sie nicht von dieser abgeleitet werden: ImagePanel sieht nicht vor, dass
 * auf der Darstellungsflaeche (JPanel) zusaetzlich JComponenten angeordnet
 * werden. <br>
 * Deshalb wird hier ein eigenes JPanel erzeugt, das das ImagePanel als
 * JComponente enthaelt. ImageBtnPanel ruft beim Druck auf einen Button die
 * <code>setCW (int type)</code> Methode von ImagePanel auf.
 * @author  Thomas Hacklaender
 * @version 2000.05.04
 */
public class ImageBtnPanel extends JPanel {


	/*
	 * Property "preferredSize"
	 * Die preferredSize des ImagePanel ist 262*262. Hinzu kommt:
	 * - ein 4 Pixel breiter Rand
	 * - eine Zeile mit 17 Pixel hohen Buttons und 4 Pixel Abstand zum ImagePanel.
	 */
	private Dimension preferredSize = new Dimension(262 + 2 * 4, 262 + 2 * 4 + 4 + 17);

	/*
	 * Property "minimumSize"
	 * Die minimumSize des ImagePanel ist 38*38.
	 */
	private Dimension minimumSize = new Dimension(38 + 2 * 4, 38 + 2 * 4 + 4 + 17);

	/* Allgemeine globale Felder der Instanz */
	ImagePanel				dcmImageP = new ImagePanel();
	JButton						autoB = new JButton();
	JButton						defaultB = new JButton();
	GridBagLayout			gridBagLayout1 = new GridBagLayout();
	JLabel						sizeL = new JLabel();


	/**
	 * Erzeugt ein ImageBtnPanel ohne Bildinformation.
	 * Hier wird die darzustellende Pixelmatrix noch nicht angegeben, da sie
	 * moeglicherweise noch nicht bekannt ist und das Panel die Moeglichkeit
	 * bieten muss, nacheinander verschiede Pixelmatrizen anzuzeigen.
	 */
	public ImageBtnPanel() {
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		} 
	}


	/**
	 * Es wird eine neue Pixelmatrix zur Darstellung uebergeben. Das neue Bild
	 * wird dargestellt.
	 * @param theDI	Die neue Pixelmatrix des Bildes.
	 */
	public void setImage(GeneralImageIOD theDI) {
		dcmImageP.setImage(theDI);
		sizeL.setText(theDI.rows + " R / " + theDI.columns + " C");
	} 


	/**
	 * Eventhandler fuer Button Pressed Events (Name von JBuielder generiert).
	 * A = Die Werte werden automatisch so berechnet, dass alle Pixelwerte zwischen
	 * der 10ten und 90ten Perzentiele dargestellt werden.
	 * @param	e		Das Event.
	 */
	void autoB_actionPerformed(ActionEvent e) {
		dcmImageP.setCW(ImagePanel.CW_AUTO);
	} 


	/**
	 * Eventhandler fuer Button Pressed Events (Name von JBuielder generiert).
	 * D = Das Wertepaar, das fuer das Bild als Defaultwert festgelegt wurde.
	 * Normalerweise werden das die Werte aus der DICOM "VOI LUT Module" sein.
	 * @param	e		Das Event.
	 */
	void defaultB_actionPerformed(ActionEvent e) {
		dcmImageP.setCW(ImagePanel.CW_DEFAULT);
	}


	/**
	 * Von JBuilder automatisch generierte Initialisierungsmethode fuer die
	 * grafischen Elemente.
	 */
	private void jbInit() throws Exception {
		this.setBackground(SystemColor.control);	// Von Hand eingetragen
		this.setPreferredSize(preferredSize);			// Von Hand eingetragen
		this.setMinimumSize(minimumSize);					// Von Hand eingetragen

		this.setLayout(gridBagLayout1);
		autoB.setText("A");
		autoB.setHorizontalTextPosition(SwingConstants.CENTER);
		autoB.setMargin(new Insets(2, 2, 2, 2));
		autoB.setBackground(SystemColor.control);
		autoB.setMinimumSize(new Dimension(20, 17));
		autoB.setBounds(new Rectangle(173, 152, 68, 35));
		autoB.addActionListener(new java.awt.event.ActionListener() {

			/**
			 */
			public void actionPerformed(ActionEvent e) {
				autoB_actionPerformed(e);
			} 

		});
		defaultB.setText("D");
		defaultB.setHorizontalTextPosition(SwingConstants.CENTER);
		defaultB.setMargin(new Insets(2, 2, 2, 2));
		defaultB.setBackground(SystemColor.control);
		defaultB.setMinimumSize(new Dimension(20, 17));
		defaultB.addActionListener(new java.awt.event.ActionListener() {

			/**
			 */
			public void actionPerformed(ActionEvent e) {
				defaultB_actionPerformed(e);
			} 

		});
		sizeL.setHorizontalAlignment(SwingConstants.CENTER);
		sizeL.setHorizontalTextPosition(SwingConstants.CENTER);
		sizeL.setText("R / C");

		this.add(dcmImageP, new GridBagConstraints2(0, 0, 3, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 4, 4), 0, 0));
		this.add(autoB, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(0, 0, 4, 0), 0, 0));
		this.add(sizeL, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
		this.add(defaultB, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(0, 0, 4, 0), 0, 0));
	} 

}


/*--- formatting done in "My Own Convention" style on 04-30-2000 ---*/

