/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ImageStatistics;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected ImageStatistics stats;
    protected float[] cTable;
    protected int[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Image img;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    public static int nBins = 256;

    public HistogramWindow(ImagePlus imp) {
        super(new ImagePlus("Histogram of " + imp.getShortTitle(), GUI.createBlankImage(300, 240)));
        this.showHistogram(imp, nBins);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins) {
        super(new ImagePlus(title, GUI.createBlankImage(300, 240)));
        this.showHistogram(imp, bins);
    }

    public void showHistogram(ImagePlus imp, int bins) {
        this.setup();
        this.stats = imp.getStatistics(27, bins);
        this.histogram = this.stats.histogram;
        this.lut = imp.createLut();
        this.img = this.imp.getImage();
        int type = imp.getType();
        this.cTable = imp.getCalibration().getCTable();
        boolean fixedRange = type == 0 || type == 3 || type == 4;
        Graphics g = this.img.getGraphics();
        if (g != null) {
            this.drawHistogram(g, fixedRange);
            g.dispose();
        }
        this.imp.setImage(this.img);
    }

    public void setup() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.log = new Button("Log");
        this.log.addActionListener(this);
        buttons.add(this.log);
        Panel valueAndCount = new Panel();
        valueAndCount.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.count);
        buttons.add(valueAndCount);
        this.add(buttons);
        this.pack();
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            if ((x -= this.frame.x) > 255) {
                x = 255;
            }
            int index = (int)((double)x * (double)this.histogram.length / 256.0);
            double v = 0.0;
            if (this.cTable != null && this.cTable.length == 256) {
                v = this.cTable[index];
            } else if (this.cTable != null && this.cTable.length == 65536) {
                int index2 = (int)(this.stats.histMin + (double)index * this.stats.binSize + this.stats.binSize / 2.0);
                if (index2 >= 0 && index < 65536) {
                    v = this.cTable[index2];
                }
            } else {
                v = this.stats.histMin + (double)index * this.stats.binSize;
                if (this.stats.binSize != 1.0) {
                    v += this.stats.binSize / 2.0;
                }
            }
            if (v == (double)((int)v)) {
                this.value.setText("  Value: " + (int)v);
            } else {
                this.value.setText("  Value: " + IJ.d2s(v, this.decimalPlaces));
            }
            this.count.setText("  Count: " + this.histogram[index]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(Graphics g, boolean fixedRange) {
        int maxCount2 = 0;
        int mode2 = 0;
        g.setColor(Color.black);
        this.decimalPlaces = Analyzer.getPrecision();
        int saveModalCount = this.histogram[this.stats.mode];
        int i = 0;
        while (i < this.histogram.length) {
            if (this.histogram[i] > maxCount2 && i != this.stats.mode) {
                maxCount2 = this.histogram[i];
                mode2 = i;
            }
            ++i;
        }
        this.newMaxCount = this.stats.maxCount;
        if (this.newMaxCount > maxCount2 * 2 && maxCount2 != 0) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        this.drawPlot(this.newMaxCount, g);
        this.histogram[this.stats.mode] = saveModalCount;
        int x = 21;
        int y = 140;
        this.lut.drawUnscaledColorBar(g, x, y, 256, 12);
        this.drawText(g, x, y += 27, fixedRange);
    }

    void drawPlot(int maxCount, Graphics g) {
        this.frame = new Rectangle(20, 10, 256, 128);
        g.drawRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        int i = 0;
        while (i < 256) {
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int y = 128 * this.histogram[index] / maxCount;
            if (y > 128) {
                y = 128;
            }
            g.drawLine(i + 20, 138, i + 20, 138 - y);
            ++i;
        }
    }

    void drawLogPlot(int maxCount, Graphics g) {
        this.frame = new Rectangle(20, 10, 256, 128);
        g.drawRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        double max = Math.log(maxCount);
        g.setColor(Color.gray);
        int i = 0;
        while (i < 256) {
            int y;
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int n = y = this.histogram[index] == 0 ? 0 : (int)(128.0 * Math.log(this.histogram[index]) / max);
            if (y > 128) {
                y = 128;
            }
            g.drawLine(i + 20, 138, i + 20, 138 - y);
            ++i;
        }
        g.setColor(Color.black);
    }

    void drawText(Graphics g, int x, int y, boolean fixedRange) {
        double hmin = this.stats.histMin;
        double hmax = this.stats.histMax;
        if (this.cTable != null && (int)hmin >= 0 && (int)hmax < this.cTable.length) {
            hmin = this.cTable[(int)hmin];
            hmax = this.cTable[(int)hmax];
        }
        g.drawString(this.d2s(hmin), x - 4, y);
        g.drawString(this.d2s(hmax), x + 256 - this.getWidth(hmax, g) + 10, y);
        boolean showBins = this.stats.nBins != 256 || !fixedRange;
        int col1 = 25;
        int col2 = 148;
        int row1 = y + 25;
        if (showBins) {
            row1 -= 8;
        }
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        g.drawString("Count: " + this.stats.pixelCount, col1, row1);
        g.drawString("Mean: " + this.d2s(this.stats.mean), col1, row2);
        g.drawString("StdDev: " + this.d2s(this.stats.stdDev), col1, row3);
        g.drawString("Mode: " + this.d2s(this.stats.dmode) + " (" + this.stats.maxCount + ")", col2, row3);
        g.drawString("Min: " + this.d2s(this.stats.min), col2, row1);
        g.drawString("Max: " + this.d2s(this.stats.max), col2, row2);
        if (showBins) {
            g.drawString("Bins: " + this.d2s(this.stats.nBins), col1, row4);
            g.drawString("Bin Width: " + this.d2s(this.stats.binSize), col2, row4);
        }
    }

    String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, this.decimalPlaces);
    }

    int getWidth(double d, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        return fm.stringWidth(this.d2s(d));
    }

    void showList() {
        StringBuffer sb = new StringBuffer();
        if (this.stats.binSize == 1.0 && this.stats.nBins == 256) {
            int i = 0;
            while (i < this.stats.nBins) {
                sb.append(String.valueOf(i) + "\t" + this.histogram[i] + "\n");
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.stats.nBins) {
                double v = this.stats.histMin + (double)i * this.stats.binSize;
                if (this.stats.binSize != 1.0) {
                    v += this.stats.binSize / 2.0;
                }
                sb.append(String.valueOf(IJ.d2s(v, this.decimalPlaces)) + "\t" + this.histogram[i] + "\n");
                ++i;
            }
        }
        TextWindow tw = new TextWindow(this.getTitle(), "value\tcount", sb.toString(), 200, 400);
    }

    void copyToClipboard() {
        int i;
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter pw = new PrintWriter(aw);
        if (this.stats.binSize == 1.0) {
            i = 0;
            while (i < this.stats.nBins) {
                pw.print(String.valueOf(i) + "\t" + this.histogram[i] + "\n");
                ++i;
            }
        } else {
            i = 0;
            while (i < this.stats.nBins) {
                pw.print(String.valueOf(IJ.d2s(this.stats.histMin + (double)i * this.stats.binSize + this.stats.binSize / 2.0, this.decimalPlaces)) + "\t" + this.histogram[i] + "\n");
                ++i;
            }
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(String.valueOf(text.length()) + " characters copied to Clipboard");
    }

    void replot() {
        this.logScale ^= true;
        Graphics g = this.img.getGraphics();
        this.frame = new Rectangle(20, 10, 256, 128);
        g.setColor(Color.white);
        g.fillRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        g.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.newMaxCount, g);
            this.drawPlot(this.newMaxCount, g);
        } else {
            this.drawPlot(this.newMaxCount, g);
        }
        this.imp.setImage(this.img);
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        } else if (b == this.log) {
            this.replot();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

