/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.Wand;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.getBoolean("pcursor", false);
    protected ImagePlus imp;
    protected boolean imageUpdated;
    private ImageJ ij;
    private int imageWidth;
    private int imageHeight;
    private double magnification;
    private Rectangle srcRect;
    private int dstWidth;
    private int dstHeight;
    private int xMouseStart = 0;
    private int yMouseStart = 0;
    private int xSrcStart = 0;
    private int ySrcStart = 0;
    private int xMouse = -1;
    private int yMouse = -1;
    int count;
    private static final double[] zoomLevels = new double[]{0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};

    public ImageCanvas(ImagePlus imp) {
        this.imp = imp;
        this.ij = IJ.getInstance();
        int width = imp.getWidth();
        int height = imp.getHeight();
        this.imageWidth = width;
        this.imageHeight = height;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(width, height);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
    }

    public void setDrawingSize(int width, int height) {
        this.dstWidth = width;
        this.dstHeight = height;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void print(Graphics g, double scale) {
        g.drawImage(this.imp.getImage(), 0, 0, (int)((double)this.imageWidth * scale), (int)((double)this.imageHeight * scale), 0, 0, this.imageWidth, this.imageHeight, null);
    }

    public void paint(Graphics g) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            roi.updatePaste();
        }
        try {
            Image img;
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            if ((img = this.imp.getImage()) != null) {
                g.drawImage(img, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (roi != null) {
                roi.draw(g);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Paint");
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public void setCursor(int x, int y) {
        if (x != -1) {
            this.xMouse = x;
        }
        if (y != -1) {
            this.yMouse = y;
        }
        Roi roi = this.imp.getRoi();
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return;
        }
        if (IJ.spaceBarDown()) {
            this.setCursor(handCursor);
            return;
        }
        switch (Toolbar.getToolId()) {
            case 11: {
                if (IJ.isMacintosh()) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(moveCursor);
                break;
            }
            case 12: {
                this.setCursor(handCursor);
                break;
            }
            default: {
                if (usePointer || roi != null && roi.getState() != 0 && roi.contains(x, y)) {
                    this.setCursor(defaultCursor);
                    break;
                }
                this.setCursor(crosshairCursor);
            }
        }
    }

    public int offScreenX(int x) {
        return this.srcRect.x + (int)((double)x / this.magnification);
    }

    public int offScreenY(int y) {
        return this.srcRect.y + (int)((double)y / this.magnification);
    }

    public int screenX(int x) {
        return (int)((double)(x - this.srcRect.x) * this.magnification);
    }

    public int screenY(int y) {
        return (int)((double)(y - this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
        ImageWindow win = this.imp.getWindow();
        String scale = "";
        if (magnification != 1.0) {
            double percent = magnification * 100.0;
            scale = percent == (double)((int)percent) ? " (" + IJ.d2s(percent, 0) + "%)" : " (" + IJ.d2s(percent, 1) + "%)";
        }
        win.setTitle(String.valueOf(this.imp.getTitle()) + scale);
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void resizeCanvas(int width, int height) {
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)width > (double)this.imageWidth * this.magnification) {
                width = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)height > (double)this.imageHeight * this.magnification) {
                height = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(width, height);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    static double getLowerZoomLevel(double currentMag) {
        double newMag = zoomLevels[0];
        int i = 0;
        while (i < zoomLevels.length) {
            if (!(zoomLevels[i] < currentMag)) break;
            newMag = zoomLevels[i];
            ++i;
        }
        return newMag;
    }

    static double getHigherZoomLevel(double currentMag) {
        double newMag = 32.0;
        int i = zoomLevels.length - 1;
        while (i >= 0) {
            if (!(zoomLevels[i] > currentMag)) break;
            newMag = zoomLevels[i];
            --i;
        }
        return newMag;
    }

    public void zoomIn(int x, int y) {
        if (this.magnification >= 32.0) {
            return;
        }
        double newMag = ImageCanvas.getHigherZoomLevel(this.magnification);
        if (newMag == this.imp.getWindow().getInitialMagnification()) {
            this.unzoom();
            return;
        }
        int newWidth = (int)((double)this.dstWidth * newMag / this.magnification);
        int newHeight = (int)((double)this.dstHeight * newMag / this.magnification);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ImageWindow win = this.imp.getWindow();
        Point loc = win.getLocationOnScreen();
        if (loc.x + 50 + newWidth < screen.width && loc.y + 50 + newHeight < screen.height) {
            this.setDrawingSize(newWidth, newHeight);
            win.pack();
        } else {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        }
        this.setMagnification(newMag);
        this.repaint();
    }

    public void zoomOut(int x, int y) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double newMag = ImageCanvas.getLowerZoomLevel(this.magnification);
        if (newMag == this.imp.getWindow().getInitialMagnification()) {
            this.unzoom();
            return;
        }
        if (this.srcRect.width <= this.imageWidth / 2) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * newMag), (int)((double)this.imageHeight * newMag));
            this.imp.getWindow().pack();
        }
        this.setMagnification(newMag);
        this.repaint();
    }

    void unzoom() {
        double imag = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == imag) {
            return;
        }
        this.setMagnification(imag);
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow win = this.imp.getWindow();
        this.setDrawingSize((int)((double)this.imageWidth * imag), (int)((double)this.imageHeight * imag));
        win.pack();
        this.repaint();
    }

    void scroll(int sx, int sy) {
        int x = this.xSrcStart + (int)((double)sx / this.magnification);
        int y = this.ySrcStart + (int)((double)sy / this.magnification);
        int newx = this.xSrcStart + (this.xMouseStart - x);
        int newy = this.ySrcStart + (this.yMouseStart - y);
        if (newx < 0) {
            newx = 0;
        }
        if (newy < 0) {
            newy = 0;
        }
        if (newx + this.srcRect.width > this.imageWidth) {
            newx = this.imageWidth - this.srcRect.width;
        }
        if (newy + this.srcRect.height > this.imageHeight) {
            newy = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = newx;
        this.srcRect.y = newy;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int index) {
        IndexColorModel cm = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(cm.getRGB(index));
    }

    protected void setDrawingColor(int ox, int oy, boolean setBackground) {
        Color c;
        int type = this.imp.getType();
        int[] v = this.imp.getPixel(ox, oy);
        switch (type) {
            case 0: {
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(v[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(v[0]));
                break;
            }
            case 1: 
            case 2: {
                double min = this.imp.getProcessor().getMin();
                double max = this.imp.getProcessor().getMax();
                double value = type == 2 ? Float.intBitsToFloat(v[0]) : (float)v[0];
                int index = (int)(255.0 * ((value - min) / (max - min)));
                if (index < 0) {
                    index = 0;
                }
                if (index > 255) {
                    index = 255;
                }
                if (setBackground) {
                    this.setBackgroundColor(this.getColor(index));
                    break;
                }
                this.setForegroundColor(this.getColor(index));
                break;
            }
            case 3: 
            case 4: {
                Color c2 = new Color(v[0], v[1], v[2]);
                if (setBackground) {
                    this.setBackgroundColor(c2);
                    break;
                }
                this.setForegroundColor(c2);
                break;
            }
        }
        if (setBackground) {
            c = Toolbar.getBackgroundColor();
        } else {
            c = Toolbar.getForegroundColor();
            this.imp.setColor(c);
        }
        IJ.showStatus("(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + ")");
    }

    private void setForegroundColor(Color c) {
        Toolbar.setForegroundColor(c);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    private void setBackgroundColor(Color c) {
        Toolbar.setBackgroundColor(c);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.ij == null) {
            return;
        }
        int toolID = Toolbar.getToolId();
        ImageWindow win = this.imp.getWindow();
        if (win != null && win.running && toolID != 11) {
            win.running = false;
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int flags = e.getModifiers();
        if (IJ.debugMode) {
            IJ.write("Mouse pressed: (" + x + "," + y + ")" + ImageJ.modifiers(flags));
        }
        if (toolID != 11 && (e.isPopupTrigger() || (flags & 4) != 0)) {
            PopupMenu popup;
            if (IJ.debugMode) {
                IJ.write("show popup: " + (e.isPopupTrigger() ? "true" : "false"));
            }
            if ((popup = Menus.getPopupMenu()) != null) {
                this.add(popup);
                popup.show(this, x, y);
            }
            return;
        }
        int ox = this.offScreenX(x);
        int oy = this.offScreenY(y);
        if (IJ.spaceBarDown()) {
            this.xMouseStart = ox;
            this.yMouseStart = oy;
            this.xSrcStart = this.srcRect.x;
            this.ySrcStart = this.srcRect.y;
            return;
        }
        if ((flags & 8) != 0 && toolID != 11 && toolID != 13) {
            this.setDrawingColor(ox, oy, false);
            return;
        }
        switch (toolID) {
            case 11: {
                if ((flags & 0xE) != 0) {
                    this.zoomOut(x, y);
                    break;
                }
                this.zoomIn(x, y);
                break;
            }
            case 12: {
                this.xMouseStart = ox;
                this.yMouseStart = oy;
                this.xSrcStart = this.srcRect.x;
                this.ySrcStart = this.srcRect.y;
                break;
            }
            case 13: {
                this.setDrawingColor(ox, oy, IJ.altKeyDown());
                break;
            }
            case 7: {
                this.xMouse = ox;
                this.yMouse = oy;
                IJ.doCommand("Measure");
                break;
            }
            case 8: {
                Roi roi = this.imp.getRoi();
                if (roi != null && roi.contains(ox, oy)) {
                    Rectangle r = roi.getBoundingRect();
                    if (r.width == this.imageWidth && r.height == this.imageHeight) {
                        this.imp.killRoi();
                    } else {
                        this.handleRoiMouseDown(x, y);
                        return;
                    }
                }
                if (this.imp.getType() == 1 || this.imp.getType() == 2) {
                    IJ.error("The wand tool does not work with 16 and 32-bit grayscale images.");
                    return;
                }
                ImageProcessor ip = this.imp.getProcessor();
                Wand w = new Wand(ip);
                double t1 = ip.getMinThreshold();
                if (t1 == -808080.0) {
                    w.autoOutline(ox, oy);
                } else {
                    w.autoOutline(ox, oy, (int)t1, (int)ip.getMaxThreshold());
                }
                if (w.npoints <= 0) break;
                roi = new PolygonRoi(w.xpoints, w.ypoints, w.npoints, this.imp, 4);
                this.imp.setRoi(roi);
                break;
            }
            default: {
                this.handleRoiMouseDown(x, y);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        ImageWindow win = this.imp.getWindow();
        if (win != null) {
            this.setCursor(defaultCursor);
        }
        this.xMouse = -1;
        this.yMouse = -1;
        IJ.showStatus("");
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(x, y);
        } else {
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(x, y, (e.getModifiers() & 1) != 0);
            }
        }
    }

    void handleRoiMouseDown(int sx, int sy) {
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            int type = roi.getType();
            if (type == 0 && r.width == this.imp.getWidth() && r.height == this.imp.getHeight()) {
                this.imp.killRoi();
                return;
            }
            if (roi.contains(ox, oy)) {
                roi.handleMouseDown(sx, sy);
                return;
            }
            if ((roi.getType() == 2 || roi.getType() == 6) && roi.getState() == 0) {
                return;
            }
        }
        this.imp.createNewRoi(ox, oy);
    }

    public void mouseReleased(MouseEvent e) {
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            Rectangle r = roi.getBoundingRect();
            if (!(r.width != 0 && r.height != 0 || roi.getType() == 2 || roi.getType() == 6 || roi instanceof TextRoi || roi.getState() != 0)) {
                this.imp.killRoi();
            } else {
                roi.handleMouseUp(e.getX(), e.getY());
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.ij == null) {
            return;
        }
        int ox = this.offScreenX(e.getX());
        int oy = this.offScreenY(e.getY());
        this.setCursor(ox, oy);
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6) && roi.getState() == 0) {
            PolygonRoi pRoi = (PolygonRoi)roi;
            pRoi.handleMouseMove(ox, oy);
        } else if (ox < this.imageWidth && oy < this.imageHeight) {
            ImageWindow win = this.imp.getWindow();
            if (win != null) {
                win.mouseMoved(ox, oy);
            }
        } else {
            IJ.showStatus("");
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

