/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Menus;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import ij.util.StringSorter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CommandLister
implements PlugIn {
    public void run(String string) {
        if (string.equals("shortcuts")) {
            this.listShortcuts();
        } else {
            this.listCommands();
        }
    }

    public void listCommands() {
        Hashtable hashtable = Menus.getCommands();
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(String.valueOf(string) + "\t" + (String)hashtable.get(string));
        }
        this.showList("Commands", "Command\tPlugin", vector);
    }

    public void listShortcuts() {
        Hashtable hashtable = Menus.getShortcuts();
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            int n2 = n;
            boolean bl = false;
            if (n2 > 200) {
                bl = true;
                n2 -= 200;
            }
            String string = KeyEvent.getKeyText(n2);
            if (!bl && string.length() == 1) {
                char c = string.charAt(0);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                char[] cArray = new char[]{c};
                string = new String(cArray);
            }
            if (string.length() > 1) {
                string = " " + string;
            }
            vector.addElement(String.valueOf(string) + "\t" + (String)hashtable.get(n));
        }
        this.showList("Keyboard Shortcuts", "Hot Key\tCommand", vector);
    }

    void showList(String string, String string2, Vector vector) {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append((String)objectArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        new TextWindow(string, string2, stringBuffer.toString(), 300, 400);
    }
}

