/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static boolean grayscale;
    private static boolean halfSize;
    static /* synthetic */ Class class$ij$plugin$FolderOpener;

    public void run(String arg) {
        OpenDialog od = new OpenDialog("Image Sequence...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String[] list = new File(directory).list();
        if (list == null) {
            return;
        }
        IJ.register(class$ij$plugin$FolderOpener != null ? class$ij$plugin$FolderOpener : (class$ij$plugin$FolderOpener = FolderOpener.class$("ij.plugin.FolderOpener")));
        StringSorter.sort(list);
        if (IJ.debugMode) {
            IJ.write("FolderOpener: " + directory + " (" + list.length + " files)");
        }
        int width = 0;
        int height = 0;
        int type = 0;
        ImageStack stack = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int n = 0;
        try {
            int i = 0;
            while (i < list.length) {
                if (!list[i].endsWith(".txt")) {
                    ImagePlus imp = new Opener().openImage(directory, list[i]);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        type = imp.getType();
                        if (!this.showDialog(imp, list.length)) {
                            return;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = halfSize ? new ImageStack(width / 2, height / 2, cm) : new ImageStack(width, height, cm);
                    }
                    if (stack != null) {
                        n = stack.getSize() + 1;
                    }
                    IJ.showStatus(String.valueOf(n) + "/" + list.length);
                    IJ.showProgress((double)n / (double)list.length);
                    if (imp == null) {
                        IJ.write(String.valueOf(list[i]) + ": unable to open");
                    } else if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.write(String.valueOf(list[i]) + ": wrong dimensions");
                    } else if (imp.getType() != type) {
                        IJ.write(String.valueOf(list[i]) + ": wrong type");
                    } else {
                        ImageProcessor ip = imp.getProcessor();
                        if (grayscale) {
                            ip = ip.convertToByte(true);
                        }
                        if (halfSize) {
                            ip = ip.resize(width / 2, height / 2);
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        stack.addSlice(imp.getTitle(), ip);
                    }
                }
                ++i;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("FolderOpener");
            stack.trim();
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus("Stack", stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.show();
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imp, int fileCount) {
        FolderOpenerDialog gd = new FolderOpenerDialog("Sequence Options", imp, fileCount);
        gd.addCheckbox("Convert to 8-bits", grayscale);
        gd.addCheckbox("Open 1/2 Size", halfSize);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        grayscale = gd.getNextBoolean();
        halfSize = gd.getNextBoolean();
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

