/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Executer;
import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Hotkeys
implements PlugIn {
    private static final String TITLE = "Hotkeys";
    private static String command = "";
    private static String shortcut = "";
    static /* synthetic */ Class class$ij$plugin$Hotkeys;

    public void run(String string) {
        if (string.equals("install")) {
            this.installHotkey();
        } else if (string.equals("remove")) {
            this.removeHotkey();
        } else {
            Executer executer = new Executer(string);
            executer.run();
        }
        IJ.register(class$ij$plugin$Hotkeys != null ? class$ij$plugin$Hotkeys : (class$ij$plugin$Hotkeys = Hotkeys.class$("ij.plugin.Hotkeys")));
    }

    void installHotkey() {
        String[] stringArray = this.getAllCommands();
        GenericDialog genericDialog = new GenericDialog("Create Shortcut");
        genericDialog.addChoice("Command:", stringArray, command);
        genericDialog.addStringField("Shortcut:", shortcut, 3);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        command = genericDialog.getNextChoice();
        shortcut = genericDialog.getNextString();
        if (shortcut.equals("")) {
            IJ.showMessage(TITLE, "Shortcut required");
            return;
        }
        if (shortcut.length() > 1) {
            shortcut = shortcut.replace('f', 'F');
        }
        String string = "ij.plugin.Hotkeys(\"" + command + "\")";
        int n = Menus.installPlugin(string, 'h', "*" + command, shortcut, IJ.getInstance());
        switch (n) {
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or F1-F12.");
                break;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                break;
            }
            default: {
                shortcut = "";
            }
        }
    }

    void removeHotkey() {
        String[] stringArray = this.getInstalledCommands();
        if (stringArray == null) {
            IJ.showMessage("Remove...", "No installed commands found.");
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Remove");
        genericDialog.addChoice("Command:", stringArray, "");
        genericDialog.addMessage("The command is not removed\nuntil ImageJ is restarted.");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        command = genericDialog.getNextChoice();
        int n = Menus.uninstallPlugin(command);
        boolean bl = true;
        if (n == -5) {
            bl = this.deletePlugin(command);
        }
        if (bl) {
            IJ.showStatus("\"" + command + "\" removed; ImageJ restart required");
        } else {
            IJ.showStatus("\"" + command + "\" not removed");
        }
    }

    boolean deletePlugin(String string) {
        String string2 = (String)Menus.getCommands().get(string);
        String string3 = String.valueOf(string2) + ".class";
        File file = new File(Menus.getPlugInsPath(), string3);
        if (file == null || !file.exists()) {
            return false;
        }
        return IJ.showMessageWithCancel("Delete Plugin?", "Permanently delete \"" + string3 + "\"?");
    }

    String[] getAllCommands() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = Menus.getCommands().keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (object.startsWith("*")) continue;
            vector.addElement((Object[])object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        StringSorter.sort(object);
        return object;
    }

    String[] getInstalledCommands() {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        Hashtable hashtable = Menus.getCommands();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.startsWith("*")) {
                vector.addElement(objectArray);
                continue;
            }
            String string = (String)hashtable.get(objectArray);
            if (string.indexOf("_") < 0 || string.startsWith("ij.")) continue;
            vector.addElement(objectArray);
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        StringSorter.sort((String[])objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

