/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;

public class StackWriter
implements PlugIn {
    private static String[] choices = new String[]{"Tiff", "Gif", "Jpeg", "Raw", "Zip", "Text"};
    private static String fileType = "Tiff";
    private static int ndigits = 4;
    private static boolean useLabels;
    static /* synthetic */ Class class$ij$plugin$StackWriter;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus != null && imagePlus.getStackSize() < 2) {
            IJ.error("This command requires a stack.");
            return;
        }
        String string2 = imagePlus.getTitle();
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        GenericDialog genericDialog = new GenericDialog("Save Image Sequence");
        genericDialog.addChoice("Save Slices as:", choices, fileType);
        genericDialog.addStringField("Name:", string2, 12);
        genericDialog.addNumericField("Digits (1-8):", ndigits, 0);
        genericDialog.addCheckbox("Use Slice Labels as File Names", useLabels);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        fileType = genericDialog.getNextChoice();
        string2 = genericDialog.getNextString();
        ndigits = (int)genericDialog.getNextNumber();
        useLabels = genericDialog.getNextBoolean();
        int n2 = 0;
        if (ndigits < 1) {
            ndigits = 1;
        }
        if (ndigits > 8) {
            ndigits = 8;
        }
        if (fileType.equals("Gif") && !FileSaver.okForGif(imagePlus)) {
            return;
        }
        if (fileType.equals("Jpeg") && !FileSaver.okForJpeg(imagePlus)) {
            return;
        }
        String string3 = "";
        if (fileType.equals("Tiff")) {
            string3 = ".tif";
        } else if (fileType.equals("Jpeg")) {
            string3 = ".jpg";
        } else if (fileType.equals("Gif")) {
            string3 = ".gif";
        } else if (fileType.equals("Raw")) {
            string3 = ".raw";
        } else if (fileType.equals("Zip")) {
            string3 = ".zip";
        } else if (fileType.equals("Text")) {
            string3 = ".txt";
        }
        String string4 = this.getDigits(n2);
        SaveDialog saveDialog = new SaveDialog("Save Image Sequence", String.valueOf(string2) + string4 + string3, string3);
        String string5 = saveDialog.getFileName();
        if (string5 == null) {
            return;
        }
        String string6 = saveDialog.getDirectory();
        ImageStack imageStack = imagePlus.getStack();
        ImagePlus imagePlus2 = new ImagePlus();
        imagePlus2.setTitle(imagePlus.getTitle());
        int n3 = imageStack.getSize();
        String string7 = null;
        int n4 = 1;
        while (n4 <= n3) {
            IJ.showStatus("writing: " + n4 + "/" + n3);
            IJ.showProgress((double)n4 / (double)n3);
            imagePlus2.setProcessor(null, imageStack.getProcessor(n4));
            string4 = this.getDigits(n2++);
            if (useLabels) {
                int n5;
                string7 = imageStack.getSliceLabel(n4);
                if (string7 != null && string7.equals("")) {
                    string7 = null;
                }
                if (string7 != null && (n5 = string7.lastIndexOf(".")) >= 0) {
                    string7 = string7.substring(0, n5);
                }
            }
            String string8 = string7 == null ? String.valueOf(string6) + string2 + string4 + string3 : String.valueOf(string6) + string7 + string3;
            if (fileType.equals("Tiff")) {
                if (!new FileSaver(imagePlus2).saveAsTiff(string8)) {
                    break;
                }
            } else if (fileType.equals("Gif")) {
                if (!new FileSaver(imagePlus2).saveAsGif(string8)) {
                    break;
                }
            } else if (fileType.equals("Jpeg")) {
                if (!new FileSaver(imagePlus2).saveAsJpeg(string8)) {
                    break;
                }
            } else if (fileType.equals("Raw")) {
                if (!new FileSaver(imagePlus2).saveAsRaw(string8)) {
                    break;
                }
            } else if (fileType.equals("Zip")) {
                imagePlus2.setTitle(String.valueOf(string2) + string4 + string3);
                if (!new FileSaver(imagePlus2).saveAsZip(string8)) {
                    break;
                }
            } else if (fileType.equals("Text") && !new FileSaver(imagePlus2).saveAsText(string8)) break;
            ++n4;
        }
        IJ.showStatus("");
        IJ.showProgress(1.0);
        IJ.register(class$ij$plugin$StackWriter != null ? class$ij$plugin$StackWriter : (class$ij$plugin$StackWriter = StackWriter.class$("ij.plugin.StackWriter")));
    }

    String getDigits(int n) {
        String string = "00000000" + n;
        return string.substring(string.length() - ndigits, string.length());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

