/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Filler
implements PlugInFilter {
    String arg;
    Roi roi;
    ImagePlus imp;
    int sliceCount;
    int[] mask;
    static /* synthetic */ Class class$ij$plugin$filter$Filler;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.roi = imagePlus.getRoi();
        }
        boolean bl = this.roi != null && this.roi instanceof TextRoi;
        IJ.register(class$ij$plugin$filter$Filler != null ? class$ij$plugin$filter$Filler : (class$ij$plugin$filter$Filler = Filler.class$("ij.plugin.filter.Filler")));
        int n = 1055;
        if (string.equals("clear")) {
            if (bl || this.isLineSelection()) {
                return n;
            }
            return IJ.setupDialog(imagePlus, n + 64);
        }
        if (string.equals("draw")) {
            if (bl) {
                return n + 64;
            }
            return n;
        }
        if (string.equals("outside")) {
            return IJ.setupDialog(imagePlus, n);
        }
        return IJ.setupDialog(imagePlus, n + 64);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.arg.equals("clear")) {
            this.clear(imageProcessor);
        } else if (this.arg.equals("fill") || this.arg.equals("draw") && this.roi instanceof TextRoi) {
            this.fill(imageProcessor);
        } else if (this.arg.equals("draw")) {
            this.draw(imageProcessor);
        } else if (this.arg.equals("outside")) {
            this.clearOutside(imageProcessor);
        }
    }

    boolean isLineSelection() {
        return this.roi != null && this.roi.getType() >= 5 && this.roi.getType() <= 7;
    }

    public void clear(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getBackgroundColor());
        if (this.isLineSelection()) {
            this.roi.drawPixels();
        } else {
            imageProcessor.fill();
        }
        imageProcessor.setColor(Toolbar.getForegroundColor());
    }

    public void fill(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getForegroundColor());
        if (this.isLineSelection()) {
            this.roi.drawPixels();
        } else {
            imageProcessor.fill();
        }
    }

    public void draw(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getForegroundColor());
        this.roi.drawPixels();
    }

    public synchronized void clearOutside(ImageProcessor imageProcessor) {
        if (this.isLineSelection()) {
            IJ.error("\"Clear Outside\" does not work with line selections.");
            return;
        }
        ++this.sliceCount;
        Rectangle rectangle = imageProcessor.getRoi();
        if (this.mask == null) {
            this.makeMask(imageProcessor, rectangle);
        }
        imageProcessor.setColor(Toolbar.getBackgroundColor());
        int n = this.imp.getStackSize();
        if (n > 1) {
            imageProcessor.snapshot();
        }
        imageProcessor.fill();
        imageProcessor.reset(this.mask);
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        imageProcessor.setRoi(0, 0, rectangle.x, n3);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, 0, rectangle.width, rectangle.y);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n3 - (rectangle.y + rectangle.height));
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x + rectangle.width, 0, n2 - (rectangle.x + rectangle.width), n3);
        imageProcessor.fill();
        imageProcessor.setRoi(null);
        if (this.sliceCount == n) {
            imageProcessor.setColor(Toolbar.getForegroundColor());
            Roi roi = this.imp.getRoi();
            this.imp.killRoi();
            this.imp.updateAndDraw();
            this.imp.setRoi(roi);
        }
    }

    public void makeMask(ImageProcessor imageProcessor, Rectangle rectangle) {
        this.mask = this.imp.getMask();
        if (this.mask == null) {
            this.mask = new int[rectangle.width * rectangle.height];
            int n = 0;
            while (n < this.mask.length) {
                this.mask[n] = -16777216;
                ++n;
            }
        } else {
            int[] nArray = new int[this.mask.length];
            int n = 0;
            while (n < this.mask.length) {
                nArray[n] = this.mask[n];
                ++n;
            }
            this.mask = nArray;
        }
        int n = 0;
        while (n < this.mask.length) {
            this.mask[n] = this.mask[n] == -16777216 ? -1 : -16777216;
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

