/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class Info
implements PlugInFilter {
    private ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        String string = (String)this.imp.getProperty("Info");
        String string2 = this.getInfo(imageProcessor);
        if (string != null) {
            this.showInfo(String.valueOf(string) + "\n------------------------\n" + string2, 400, 500);
        } else {
            this.showInfo(string2, 300, 300);
        }
    }

    String getInfo(ImageProcessor imageProcessor) {
        Object object;
        Object object2;
        double d;
        String string = new String("\n");
        string = String.valueOf(string) + "Title: '" + this.imp.getTitle() + "'\n";
        Calibration calibration = this.imp.getCalibration();
        if (calibration.scaled()) {
            String string2 = calibration.getUnit();
            String string3 = calibration.getUnits();
            string = String.valueOf(string) + "Width:  " + IJ.d2s((double)this.imp.getWidth() * calibration.pixelWidth, 2) + " " + string3 + " (" + this.imp.getWidth() + ")\n";
            string = String.valueOf(string) + "Height:  " + IJ.d2s((double)this.imp.getHeight() * calibration.pixelHeight, 2) + " " + string3 + " (" + this.imp.getHeight() + ")\n";
            if (calibration.pixelWidth == calibration.pixelHeight) {
                string = String.valueOf(string) + "Resolution:  " + IJ.d2s(1.0 / calibration.pixelWidth, 1) + " pixels per " + string2 + "\n";
            } else {
                string = String.valueOf(string) + "X Resolution:  " + IJ.d2s(1.0 / calibration.pixelWidth, 1) + " pixels per " + string2 + "\n";
                string = String.valueOf(string) + "Y Resolution:  " + IJ.d2s(1.0 / calibration.pixelHeight, 1) + " pixels per " + string2 + "\n";
            }
        } else {
            string = String.valueOf(string) + "Width:  " + this.imp.getWidth() + " pixels\n";
            string = String.valueOf(string) + "Height:  " + this.imp.getHeight() + " pixels\n";
        }
        int n = this.imp.getType();
        switch (n) {
            case 0: {
                string = String.valueOf(string) + "Bits per pixel: 8 ";
                if (this.imp.isInvertedLut()) {
                    string = String.valueOf(string) + "(inverted LUT)\n";
                    break;
                }
                string = String.valueOf(string) + "(grayscale LUT)\n";
                break;
            }
            case 1: 
            case 2: {
                if (n == 1) {
                    ShortProcessor cfr_ignored_0 = (ShortProcessor)this.imp.getProcessor();
                    string = String.valueOf(string) + "Bits per pixel: 16 (unsigned short)\n";
                } else {
                    string = String.valueOf(string) + "Bits per pixel: 32 (float)\n";
                }
                string = String.valueOf(string) + "Display range: ";
                int n2 = n == 1 ? 0 : 2;
                d = imageProcessor.getMin();
                double d2 = imageProcessor.getMax();
                if (calibration.calibrated()) {
                    d = calibration.getCValue((int)d);
                    d2 = calibration.getCValue((int)d2);
                }
                string = String.valueOf(string) + IJ.d2s(d, n2) + " - " + IJ.d2s(d2, n2) + "\n";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "Bits per pixel: 32 (RGB)\n";
                break;
            }
        }
        int n3 = this.imp.getStackSize();
        if (n3 > 1) {
            d = calibration.frameInterval;
            String string4 = d > 0.0 ? "Frames: " : "Slices: ";
            string = String.valueOf(string) + string4 + n3 + " (" + this.imp.getCurrentSlice() + ")\n";
            if (d > 0.0) {
                if (d < 1.0) {
                    double d3 = 1.0 / d;
                    object2 = Math.abs(d3 - (double)Math.round(d3)) < 1.0E-5 ? IJ.d2s(d3, 0) : IJ.d2s(d3, 5);
                    string = String.valueOf(string) + "Frame rate: " + (String)object2 + " fps\n";
                } else {
                    string = String.valueOf(string) + "Frame interval: " + IJ.d2s(d, 5) + " seconds\n";
                }
            }
        }
        string = imageProcessor.getMinThreshold() == -808080.0 ? String.valueOf(string) + "No Threshold\n" : String.valueOf(string) + "Threshold: " + IJ.d2s(imageProcessor.getMinThreshold(), 0) + "-" + IJ.d2s(imageProcessor.getMaxThreshold(), 0) + "\n";
        ImageCanvas imageCanvas = this.imp.getWindow().getCanvas();
        double d4 = imageCanvas.getMagnification();
        if (d4 != 1.0) {
            string = String.valueOf(string) + "Magnification: " + d4 + "\n";
        }
        if (calibration.calibrated()) {
            string = String.valueOf(string) + " \n";
            int n4 = calibration.getFunction();
            string = String.valueOf(string) + "Calibration Function: ";
            string = n4 == 21 ? String.valueOf(string) + "Uncalibrated OD\n" : String.valueOf(string) + CurveFitter.fList[n4] + "\n";
            object = calibration.getCoefficients();
            if (object != null) {
                string = String.valueOf(string) + "  a: " + IJ.d2s((double)object[0], 6) + "\n";
                string = String.valueOf(string) + "  b: " + IJ.d2s((double)object[1], 6) + "\n";
                if (((Object)object).length >= 3) {
                    string = String.valueOf(string) + "  c: " + IJ.d2s((double)object[2], 6) + "\n";
                }
                if (((Object)object).length >= 4) {
                    string = String.valueOf(string) + "  c: " + IJ.d2s((double)object[3], 6) + "\n";
                }
                if (((Object)object).length >= 5) {
                    string = String.valueOf(string) + "  c: " + IJ.d2s((double)object[4], 6) + "\n";
                }
            }
            string = String.valueOf(string) + "  Unit: \"" + calibration.getValueUnit() + "\"\n";
        } else {
            string = String.valueOf(string) + "Uncalibrated\n";
        }
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            if (calibration.calibrated()) {
                string = String.valueOf(string) + " \n";
            }
            string = String.valueOf(string) + "No ROI\n";
        } else {
            string = String.valueOf(string) + " \n";
            switch (roi.getType()) {
                case 0: {
                    string = String.valueOf(string) + "Rectangular ROI\n";
                    break;
                }
                case 1: {
                    string = String.valueOf(string) + "Oval ROI\n";
                    break;
                }
                case 2: {
                    string = String.valueOf(string) + "Polygon ROI\n";
                    break;
                }
                case 3: {
                    string = String.valueOf(string) + "Freehand ROI\n";
                    break;
                }
                case 4: {
                    string = String.valueOf(string) + "Traced ROI\n";
                    break;
                }
                case 5: {
                    string = String.valueOf(string) + "Line Selection\n";
                    break;
                }
                case 6: {
                    string = String.valueOf(string) + "Polyline Selection\n";
                    break;
                }
                case 7: {
                    string = String.valueOf(string) + "Freehand line Selection\n";
                    break;
                }
            }
            object = roi.getBoundingRect();
            if (roi instanceof Line) {
                object2 = (Line)roi;
                string = String.valueOf(string) + "  X1: " + IJ.d2s((double)((Line)object2).x1 * calibration.pixelWidth) + "\n";
                string = String.valueOf(string) + "  Y1: " + IJ.d2s((double)((Line)object2).y1 * calibration.pixelHeight) + "\n";
                string = String.valueOf(string) + "  X2: " + IJ.d2s((double)((Line)object2).x2 * calibration.pixelWidth) + "\n";
                string = String.valueOf(string) + "  Y2: " + IJ.d2s((double)((Line)object2).y2 * calibration.pixelHeight) + "\n";
            } else if (calibration.scaled()) {
                string = String.valueOf(string) + "  X: " + IJ.d2s((double)((Rectangle)object).x * calibration.pixelWidth) + " (" + ((Rectangle)object).x + ")\n";
                string = String.valueOf(string) + "  Y: " + IJ.d2s((double)((Rectangle)object).y * calibration.pixelHeight) + " (" + ((Rectangle)object).y + ")\n";
                string = String.valueOf(string) + "  Width: " + IJ.d2s((double)((Rectangle)object).width * calibration.pixelWidth) + " (" + ((Rectangle)object).width + ")\n";
                string = String.valueOf(string) + "  Height: " + IJ.d2s((double)((Rectangle)object).height * calibration.pixelHeight) + " (" + ((Rectangle)object).height + ")\n";
            } else {
                string = String.valueOf(string) + "  X: " + ((Rectangle)object).x + "\n";
                string = String.valueOf(string) + "  Y: " + ((Rectangle)object).y + "\n";
                string = String.valueOf(string) + "  Width: " + ((Rectangle)object).width + "\n";
                string = String.valueOf(string) + "  Height: " + ((Rectangle)object).height + "\n";
            }
        }
        return string;
    }

    void showInfo(String string, int n, int n2) {
        new TextWindow("Info for " + this.imp.getTitle(), string, n, n2);
    }
}

