/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class RankFilters
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    static final int MEDIAN = 0;
    static final int MEAN = 1;
    static final int MIN = 2;
    static final int MAX = 3;
    ImagePlus imp;
    static int filterType = 0;
    String title;
    static boolean createSelection = false;
    int kw;
    int kh;
    static float[] kernel;
    static int slice;
    static boolean canceled;
    static ImageWindow win;
    static double radius;
    private static final String[] typeStrings;
    static /* synthetic */ Class class$ij$plugin$filter$RankFilters;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$RankFilters != null ? class$ij$plugin$filter$RankFilters : (class$ij$plugin$filter$RankFilters = RankFilters.class$("ij.plugin.filter.RankFilters")));
        this.imp = imagePlus;
        if (string.equals("min")) {
            filterType = 2;
        } else if (string.equals("max")) {
            filterType = 3;
        } else if (string.equals("mean")) {
            filterType = 1;
        }
        slice = 0;
        canceled = false;
        if (imagePlus != null) {
            win = imagePlus.getWindow();
            RankFilters.win.running = true;
        }
        this.title = typeStrings[filterType];
        IJ.showStatus(String.valueOf(this.title) + ", radius=" + radius + " (esc to abort)");
        if (imagePlus != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, 31);
    }

    public void run(ImageProcessor imageProcessor) {
        if (canceled) {
            return;
        }
        ++slice;
        if (!RankFilters.win.running) {
            canceled = true;
            IJ.beep();
            return;
        }
        this.rank(imageProcessor, radius, filterType);
        if (slice > 1) {
            IJ.showStatus(String.valueOf(this.title) + ": " + slice + "/" + this.imp.getStackSize());
        }
        if (slice == this.imp.getStackSize()) {
            imageProcessor.resetMinAndMax();
        }
    }

    void showMasks() {
        int n = 150;
        int n2 = 150;
        ImageStack imageStack = new ImageStack(n, n2);
        double d = 0.5;
        while (d < 50.0) {
            int n3 = (int)(d + 0.5) * 2 + 1;
            int[] nArray = this.createCircularMask(n3, d);
            FloatProcessor floatProcessor = new FloatProcessor(n, n2, new int[n * n2]);
            floatProcessor.insert(new FloatProcessor(n3, n3, nArray), n / 2 - n3 / 2, n2 / 2 - n3 / 2);
            imageStack.addSlice("radius=" + d + ", size=" + n3, floatProcessor);
            d += 0.5;
        }
        new ImagePlus("Masks", imageStack).show();
    }

    int getType(ImageProcessor imageProcessor) {
        int n = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        return n;
    }

    public void convertBack(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n) {
        switch (n) {
            case 0: {
                imageProcessor = imageProcessor.convertToByte(false);
                byte[] byArray = (byte[])imageProcessor2.getPixels();
                byte[] byArray2 = (byte[])imageProcessor.getPixels();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                imageProcessor = imageProcessor.convertToShort(false);
                short[] sArray = (short[])imageProcessor2.getPixels();
                short[] sArray2 = (short[])imageProcessor.getPixels();
                System.arraycopy(sArray2, 0, sArray, 0, sArray.length);
                break;
            }
        }
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog(String.valueOf(this.title) + "...");
        genericDialog.addNumericField("Radius (pixels):", radius, 1);
        genericDialog.addCheckbox("Show Circular Masks", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            canceled = true;
            return false;
        }
        radius = genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        if (bl) {
            this.showMasks();
            return false;
        }
        if (radius < 0.5) {
            radius = 0.5;
        }
        this.imp.startTiming();
        return true;
    }

    public void rank(ImageProcessor imageProcessor, double d, int n) {
        int n2 = this.getType(imageProcessor);
        if (n2 == 3) {
            this.rankRGB(imageProcessor, d, n);
            return;
        }
        imageProcessor.setCalibrationTable(null);
        ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
        this.rankFloat(imageProcessor2, d, n);
        this.convertBack(imageProcessor2, imageProcessor, n2);
    }

    public void rankRGB(ImageProcessor imageProcessor, double d, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = n2 * n3;
        if (slice == 1) {
            IJ.showStatus(String.valueOf(this.title) + " (red)");
        }
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n2, n3, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n2, n3, byArray3, null);
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        this.rankFloat(imageProcessor2, d, n);
        if (canceled) {
            return;
        }
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        if (slice == 1) {
            IJ.showStatus(String.valueOf(this.title) + " (green)");
        }
        imageProcessor2 = byteProcessor2.convertToFloat();
        this.rankFloat(imageProcessor2, d, n);
        if (canceled) {
            return;
        }
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        if (slice == 1) {
            IJ.showStatus(String.valueOf(this.title) + " (blue)");
        }
        imageProcessor2 = byteProcessor3.convertToFloat();
        this.rankFloat(imageProcessor2, d, n);
        if (canceled) {
            return;
        }
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public void rankFloat(ImageProcessor imageProcessor, double d, int n) {
        int n2;
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n2 = (int)(d + 0.5) * 2 + 1;
        int[] nArray = this.createCircularMask(n2, d);
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2 * n2) {
            if (nArray[n7] != 0) {
                ++n6;
            }
            ++n7;
        }
        float[] fArray = new float[n6];
        int n8 = n2 / 2;
        int n9 = n5 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getPixelsCopy();
        int n10 = 0;
        while (n10 < n3 * n4) {
            fArray2[n10] = 0.0f;
            ++n10;
        }
        int n11 = Math.max(n4 / 50, 1);
        int n12 = 0;
        while (n12 < n4) {
            if (n12 % n11 == 0) {
                IJ.showProgress((double)n12 / (double)n4);
                boolean bl = canceled = win != null && !RankFilters.win.running;
                if (canceled) break;
            }
            boolean bl = n12 < n9 || n12 >= n4 + n9;
            int n13 = 0;
            while (n13 < n3) {
                double d2 = 0.0;
                int n14 = 0;
                int n15 = 0;
                if (n13 < n8 || n13 >= n4 + n8) {
                    bl = true;
                }
                int n16 = -n9;
                while (n16 <= n9) {
                    int n17 = n13 + (n12 + n16) * n3;
                    int n18 = -n8;
                    while (n18 <= n8) {
                        if (nArray[n14++] != 0) {
                            fArray[n15] = bl ? this.getPixel(n13 + n18, n12 + n16, fArray3, n3, n4) : fArray3[n17 + n18];
                            ++n15;
                        }
                        ++n18;
                    }
                    ++n16;
                }
                fArray2[n13 + n12 * n3] = n == 0 ? this.findMedian(fArray) : (n == 1 ? this.findMean(fArray) : (n == 2 ? this.findMin(fArray) : this.findMax(fArray)));
                ++n13;
            }
            ++n12;
        }
        IJ.showProgress(1.0);
        if (canceled) {
            imageProcessor.insert(new FloatProcessor(n3, n4, fArray3, null), 0, 0);
            IJ.beep();
        }
    }

    private float getPixel(int n, int n2, float[] fArray, int n3, int n4) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        return fArray[n + n2 * n3];
    }

    int[] createCircularMask(int n, double d) {
        int[] nArray = new int[n * n];
        int n2 = n / 2;
        int n3 = (int)(d * d) + 1;
        int n4 = -n2;
        while (n4 <= n2) {
            int n5 = -n2;
            while (n5 <= n2) {
                if (n4 * n4 + n5 * n5 <= n3) {
                    nArray[n2 + n4 + (n2 + n5) * n] = 1;
                }
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    private final float findMedian(float[] fArray) {
        int n = fArray.length;
        int n2 = (n - 1) / 2;
        int n3 = 0;
        int n4 = n - 1;
        float f = fArray[n2];
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            while (true) {
                if (fArray[n5] < f) {
                    ++n5;
                    continue;
                }
                while (f < fArray[n6]) {
                    --n6;
                }
                float f2 = fArray[n6];
                fArray[n6] = fArray[n5];
                fArray[n5] = f2;
                if (--n6 < n2 || ++n5 > n2) break;
            }
            if (n6 < n2) {
                n3 = n5;
            }
            if (n2 < n5) {
                n4 = n6;
            }
            f = fArray[n2];
        }
        return f;
    }

    private final float findMin(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] < f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    private final float findMax(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] > f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    private final float findMean(float[] fArray) {
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            f += fArray[n];
            ++n;
        }
        return f / (float)fArray.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        radius = 2.0;
        typeStrings = new String[]{"Median", "Mean", "Minimum", "Maximum"};
    }
}

