/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;
import java.io.Serializable;

public class Resizer
implements PlugInFilter {
    ImagePlus imp;
    private boolean crop;
    private static int newWidth = 100;
    private static int newHeight = 100;
    private static boolean constrain = true;
    private static boolean interpolate = true;
    static /* synthetic */ Class class$ij$plugin$filter$Resizer;

    public int setup(String string, ImagePlus imagePlus) {
        this.crop = string.equals("crop");
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$Resizer != null ? class$ij$plugin$filter$Resizer : (class$ij$plugin$filter$Resizer = Resizer.class$("ij.plugin.filter.Resizer")));
        if (this.crop) {
            return 1183;
        }
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Serializable serializable;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() >= 5 && roi.getType() <= 7) {
            IJ.error("The Crop and Adjust->Size commands\ndo not work with line selections.");
            return;
        }
        boolean bl = false;
        if (this.crop) {
            serializable = roi.getBoundingRect();
            newWidth = ((Rectangle)serializable).width;
            newHeight = ((Rectangle)serializable).height;
        } else {
            serializable = new GenericDialog("Resize", IJ.getInstance());
            ((GenericDialog)serializable).addNumericField("New width (pixels):", newWidth, 0);
            ((GenericDialog)serializable).addNumericField("New Height (pixels):", newHeight, 0);
            ((GenericDialog)serializable).addCheckbox("Constrain Aspect Ratio", constrain);
            ((GenericDialog)serializable).addCheckbox("Interpolate", interpolate);
            ((GenericDialog)serializable).addMessage("NOTE: Undo is not available");
            ((GenericDialog)serializable).showDialog();
            if (((GenericDialog)serializable).wasCanceled()) {
                return;
            }
            newWidth = (int)((GenericDialog)serializable).getNextNumber();
            newHeight = (int)((GenericDialog)serializable).getNextNumber();
            if (((GenericDialog)serializable).invalidNumber()) {
                IJ.error("Width or height are invalid.");
                return;
            }
            constrain = ((GenericDialog)serializable).getNextBoolean();
            interpolate = ((GenericDialog)serializable).getNextBoolean();
            boolean bl2 = bl = constrain && newWidth == 0;
            if ((double)newWidth <= 0.0 && !constrain) {
                newWidth = 50;
            }
            if ((double)newHeight <= 0.0) {
                newHeight = 50;
            }
        }
        serializable = imageProcessor.getRoi();
        double d = ((Rectangle)serializable).width;
        double d2 = ((Rectangle)serializable).height;
        if (!this.crop && constrain) {
            if (bl) {
                newWidth = (int)((double)newHeight * (d / d2));
            } else {
                newHeight = (int)((double)newWidth * (d2 / d));
            }
        }
        imageProcessor.setInterpolate(interpolate);
        int n = this.imp.getStackSize();
        try {
            StackProcessor stackProcessor = new StackProcessor(this.imp.getStack(), imageProcessor);
            ImageStack imageStack = stackProcessor.resize(newWidth, newHeight);
            int n2 = imageStack.getSize();
            if (imageStack.getWidth() > 0 && n2 > 0) {
                boolean bl3;
                boolean bl4 = bl3 = this.crop && roi != null && roi.getType() != 0;
                if (bl3) {
                    this.imp.killRoi();
                }
                this.imp.hide();
                Calibration calibration = this.imp.getCalibration();
                if (calibration.scaled()) {
                    calibration.pixelWidth *= d / (double)newWidth;
                    calibration.pixelHeight *= d2 / (double)newHeight;
                    this.imp.setCalibration(calibration);
                }
                this.imp.setStack(null, imageStack);
                this.imp.show();
                if (bl3) {
                    this.imp.restoreRoi();
                }
            }
            if (n > 1 && n2 < n) {
                IJ.error("ImageJ ran out of memory causing \nthe last " + (n - n2) + " slices to be lost.");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Resize");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

