/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Calibrator;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;
    static /* synthetic */ Class class$ij$plugin$filter$ScaleDialog;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$ScaleDialog != null ? class$ij$plugin$filter$ScaleDialog : (class$ij$plugin$filter$ScaleDialog = ScaleDialog.class$("ij.plugin.filter.ScaleDialog")));
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Roi roi;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string = "cm";
        boolean bl = Calibrator.global;
        Calibration calibration = this.imp.getCalibration();
        boolean bl2 = calibration.scaled();
        String string2 = "<no scale>";
        if (bl2) {
            d = 1.0 / calibration.pixelWidth;
            d2 = 1.0;
            d3 = calibration.pixelHeight / calibration.pixelWidth;
            string = calibration.getUnit();
            string2 = String.valueOf(IJ.d2s(d, 2)) + " pixels per " + string;
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof Line) {
            d = ((Line)roi).getRawLength();
            d2 = 0.0;
        }
        SetScaleDialog setScaleDialog = new SetScaleDialog("Set Scale", string2);
        setScaleDialog.addNumericField("Distance in Pixels:", d, 2);
        setScaleDialog.addNumericField("Known Distance:", d2, 2);
        setScaleDialog.addNumericField("Pixel Aspect Ratio:", d3, 1);
        setScaleDialog.addStringField("Unit of Measurement:", string);
        setScaleDialog.addMessage("Scale: 12345.789 pixels per centimeter");
        setScaleDialog.addCheckbox("Global", Calibrator.global);
        setScaleDialog.showDialog();
        if (setScaleDialog.wasCanceled()) {
            return;
        }
        d = setScaleDialog.getNextNumber();
        d2 = setScaleDialog.getNextNumber();
        d3 = setScaleDialog.getNextNumber();
        string = setScaleDialog.getNextString();
        Calibrator.global = setScaleDialog.getNextBoolean();
        if (d != 0.0 && d2 == 0.0) {
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
            return;
        }
        if (d <= 0.0 || string.startsWith("pixel") || string.startsWith("Pixel") || string.equals("")) {
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
            calibration.setUnit("pixel");
        } else {
            calibration.pixelWidth = d2 / d;
            calibration.pixelHeight = d3 != 0.0 ? calibration.pixelWidth * d3 : calibration.pixelWidth;
            calibration.setUnit(string);
        }
        if (bl && !Calibrator.global) {
            this.imp.setGlobalCalibration(null);
        } else {
            this.imp.setCalibration(calibration);
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
        }
        if (Calibrator.global || Calibrator.global != bl) {
            int[] nArray = WindowManager.getIDList();
            if (nArray == null) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[n]);
                if (imagePlus != null) {
                    imagePlus.getWindow().repaint();
                }
                ++n;
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

