/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.measure.Measurements;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;

public class UnsharpMask
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private int slice;
    private boolean canceled;
    private ImageWindow win;
    private static double radius = 2.0;
    private static double weight = 0.6;
    static /* synthetic */ Class class$ij$plugin$filter$UnsharpMask;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$UnsharpMask != null ? class$ij$plugin$filter$UnsharpMask : (class$ij$plugin$filter$UnsharpMask = UnsharpMask.class$("ij.plugin.filter.UnsharpMask")));
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.win = imagePlus.getWindow();
            this.win.running = true;
        }
        if (imagePlus != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, 31);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        ++this.slice;
        if (this.slice > 1) {
            IJ.showStatus("Unsharp Mask: " + this.slice + "/" + this.imp.getStackSize());
        }
        this.sharpen(imageProcessor, radius, weight);
    }

    public void sharpen(ImageProcessor imageProcessor, double d, double d2) {
        boolean bl;
        imageProcessor.setCalibrationTable(null);
        ImageProcessor imageProcessor2 = imageProcessor;
        boolean bl2 = bl = imageProcessor instanceof ByteProcessor || imageProcessor instanceof ShortProcessor;
        if (bl) {
            imageProcessor2 = imageProcessor.convertToFloat();
        }
        ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor2, 16, null);
        double d3 = imageStatistics.min;
        double d4 = imageStatistics.max;
        ImageProcessor imageProcessor3 = imageProcessor2.duplicate();
        new GaussianBlur().blur(imageProcessor3, d);
        imageProcessor3.multiply(d2);
        imageProcessor2.copyBits(imageProcessor3, 0, 0, 4);
        imageProcessor2.multiply(1.0 / (1.0 - d2));
        if (!(imageProcessor2 instanceof ColorProcessor)) {
            imageProcessor2.min(d3);
            imageProcessor2.max(d4);
        }
        if (bl) {
            boolean bl3 = imageProcessor instanceof ByteProcessor;
            boolean bl4 = bl3 && this.imp.getStackSize() == 1;
            ImageProcessor imageProcessor4 = bl3 ? imageProcessor2.convertToByte(bl4) : imageProcessor2.convertToShort(bl4);
            imageProcessor.insert(imageProcessor4, 0, 0);
        }
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Unsharp Mask...");
        genericDialog.addNumericField("Gaussian Radius (1-15)", radius, 0);
        genericDialog.addNumericField("Mask Weight (0.2-0.9)", weight, 2);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = genericDialog.getNextNumber();
        weight = genericDialog.getNextNumber();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

