/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ColorSelector
extends PlugInFrame
implements ItemListener {
    private static final int ROI = 0;
    private static final int FOREGROUND = 1;
    private static final int BACKGROUND = 2;
    private Choice color;
    private String[] colors = new String[]{"red", "green", "blue", "magenta     ", "cyan", "yellow", "orange", "black", "white"};
    private int mode = 0;

    public ColorSelector() {
        super("ROI Color");
    }

    public void run(String string) {
        String string2;
        Color color;
        if (string.equals("roi")) {
            this.setTitle("ROI Color");
            this.mode = 0;
        } else if (string.equals("back")) {
            this.setTitle("Background Color");
            this.mode = 2;
        } else {
            this.setTitle("Foreground Color");
            this.mode = 1;
        }
        this.setLayout(new FlowLayout(1, 35, 5));
        this.color = new Choice();
        int n = 0;
        while (n < this.colors.length) {
            this.color.addItem(this.colors[n]);
            ++n;
        }
        switch (this.mode) {
            case 0: {
                color = Roi.getColor();
                string2 = "yellow";
                break;
            }
            case 2: {
                color = Toolbar.getBackgroundColor();
                string2 = "white";
                break;
            }
            default: {
                color = Toolbar.getForegroundColor();
                string2 = "black";
            }
        }
        if (color.equals(Color.red)) {
            string2 = this.colors[0];
        } else if (color.equals(Color.green)) {
            string2 = this.colors[1];
        } else if (color.equals(Color.blue)) {
            string2 = this.colors[2];
        } else if (color.equals(Color.magenta)) {
            string2 = this.colors[3];
        } else if (color.equals(Color.cyan)) {
            string2 = this.colors[4];
        } else if (color.equals(Color.yellow)) {
            string2 = this.colors[5];
        } else if (color.equals(Color.orange)) {
            string2 = this.colors[6];
        } else if (color.equals(Color.black)) {
            string2 = this.colors[7];
        } else if (color.equals(Color.white)) {
            string2 = this.colors[8];
        }
        this.color.select(string2);
        this.color.addItemListener(this);
        this.add(this.color);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.width < 180) {
            ((Component)this).setSize(180, dimension.height);
        }
        GUI.center(this);
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.color.getSelectedItem();
        Color color = Color.yellow;
        if (string.equals(this.colors[0])) {
            color = Color.red;
        } else if (string.equals(this.colors[1])) {
            color = Color.green;
        } else if (string.equals(this.colors[2])) {
            color = Color.blue;
        } else if (string.equals(this.colors[3])) {
            color = Color.magenta;
        } else if (string.equals(this.colors[4])) {
            color = Color.cyan;
        } else if (string.equals(this.colors[5])) {
            color = Color.yellow;
        } else if (string.equals(this.colors[6])) {
            color = Color.orange;
        } else if (string.equals(this.colors[7])) {
            color = Color.black;
        } else if (string.equals(this.colors[8])) {
            color = Color.white;
        }
        switch (this.mode) {
            case 0: {
                Roi.setColor(color);
                ImagePlus imagePlus = WindowManager.getCurrentImage();
                if (imagePlus == null) break;
                imagePlus.draw();
                break;
            }
            case 1: {
                Toolbar.setForegroundColor(color);
                if (!Recorder.record) break;
                Recorder.record("setForegroundColor", color.getRed(), color.getGreen(), color.getBlue());
                break;
            }
            case 2: {
                Toolbar.setBackgroundColor(color);
                if (!Recorder.record) break;
                Recorder.record("setBackgroundColor", color.getRed(), color.getGreen(), color.getBlue());
                break;
            }
        }
    }
}

