/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.ColorModel;

public class TypeConverter {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private ImageProcessor ip;
    private int type;
    boolean doScaling = true;
    int width;
    int height;

    public TypeConverter(ImageProcessor imageProcessor, boolean bl) {
        this.ip = imageProcessor;
        this.doScaling = bl;
        this.type = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
    }

    public ImageProcessor convertToByte() {
        switch (this.type) {
            case 0: {
                return this.ip;
            }
            case 1: {
                return this.convertShortToByte();
            }
            case 2: {
                return this.convertFloatToByte();
            }
            case 3: {
                return this.convertRGBToByte();
            }
        }
        return null;
    }

    ByteProcessor convertShortToByte() {
        if (this.doScaling) {
            Image image = this.ip.createImage();
            return new ByteProcessor(image);
        }
        short[] sArray = (short[])this.ip.getPixels();
        byte[] byArray = new byte[this.width * this.height];
        int n = 0;
        while (n < this.width * this.height) {
            int n2 = sArray[n] & 0xFFFF;
            if (n2 > 255) {
                n2 = 255;
            }
            byArray[n] = (byte)n2;
            ++n;
        }
        return new ByteProcessor(this.width, this.height, byArray, this.ip.getColorModel());
    }

    ByteProcessor convertFloatToByte() {
        if (this.doScaling) {
            Image image = this.ip.createImage();
            return new ByteProcessor(image);
        }
        float[] fArray = (float[])this.ip.getPixels();
        byte[] byArray = new byte[this.width * this.height];
        int n = 0;
        while (n < this.width * this.height) {
            float f = fArray[n];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            }
            byArray[n] = (byte)Math.round(f);
            ++n;
        }
        return new ByteProcessor(this.width, this.height, byArray, this.ip.getColorModel());
    }

    ByteProcessor convertRGBToByte() {
        int[] nArray = (int[])this.ip.getPixels();
        byte[] byArray = new byte[this.width * this.height];
        int n = 0;
        while (n < this.width * this.height) {
            int n2 = nArray[n];
            int n3 = (n2 & 0xFF0000) >> 16;
            int n4 = (n2 & 0xFF00) >> 8;
            int n5 = n2 & 0xFF;
            byArray[n] = (byte)((int)((double)n3 * 0.299 + (double)n4 * 0.587 + (double)n5 * 0.114) & 0xFF);
            ++n;
        }
        return new ByteProcessor(this.width, this.height, byArray, null);
    }

    public ImageProcessor convertToShort() {
        switch (this.type) {
            case 0: {
                return this.convertByteToShort();
            }
            case 1: {
                return this.ip;
            }
            case 2: {
                return this.convertFloatToShort();
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    ShortProcessor convertByteToShort() {
        byte[] byArray = (byte[])this.ip.getPixels();
        short[] sArray = new short[this.width * this.height];
        int n = 0;
        while (n < this.width * this.height) {
            sArray[n] = (short)(byArray[n] & 0xFF);
            ++n;
        }
        return new ShortProcessor(this.width, this.height, sArray, this.ip.getColorModel());
    }

    ShortProcessor convertFloatToShort() {
        float[] fArray = (float[])this.ip.getPixels();
        short[] sArray = new short[this.width * this.height];
        double d = this.ip.getMin();
        double d2 = this.ip.getMax();
        double d3 = d2 - d == 0.0 ? 1.0 : 65535.0 / (d2 - d);
        int n = 0;
        while (n < this.width * this.height) {
            double d4 = this.doScaling ? ((double)fArray[n] - d) * d3 : (double)fArray[n];
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (d4 > 65535.0) {
                d4 = 65535.0;
            }
            sArray[n] = (short)d4;
            ++n;
        }
        return new ShortProcessor(this.width, this.height, sArray, this.ip.getColorModel());
    }

    public ImageProcessor convertToFloat(float[] fArray) {
        switch (this.type) {
            case 0: {
                return this.convertByteToFloat(fArray);
            }
            case 1: {
                return this.convertShortToFloat(fArray);
            }
            case 2: {
                return this.ip;
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    FloatProcessor convertByteToFloat(float[] fArray) {
        int n;
        byte[] byArray = (byte[])this.ip.getPixels();
        this.ip.isInvertedLut();
        float[] fArray2 = new float[this.width * this.height];
        if (fArray != null && fArray.length == 256) {
            n = 0;
            while (n < this.width * this.height) {
                fArray2[n] = fArray[byArray[n] & 0xFF];
                ++n;
            }
        } else {
            n = 0;
            while (n < this.width * this.height) {
                fArray2[n] = byArray[n] & 0xFF;
                ++n;
            }
        }
        ColorModel colorModel = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, fArray2, colorModel);
    }

    FloatProcessor convertShortToFloat(float[] fArray) {
        int n;
        short[] sArray = (short[])this.ip.getPixels();
        float[] fArray2 = new float[this.width * this.height];
        if (fArray != null && fArray.length == 65536) {
            n = 0;
            while (n < this.width * this.height) {
                fArray2[n] = fArray[sArray[n] & 0xFFFF];
                ++n;
            }
        } else {
            n = 0;
            while (n < this.width * this.height) {
                fArray2[n] = sArray[n] & 0xFFFF;
                ++n;
            }
        }
        ColorModel colorModel = this.ip.getColorModel();
        return new FloatProcessor(this.width, this.height, fArray2, colorModel);
    }

    public ImageProcessor convertToRGB() {
        if (this.type == 3) {
            return this.ip;
        }
        ImageProcessor imageProcessor = this.ip.convertToByte(this.doScaling);
        return new ColorProcessor(imageProcessor.createImage());
    }
}

