/*
 * Decompiled with CFR 0.152.
 */
package rad.ijplugin.dcm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmInputStream;
import rad.dicom.dcm.DcmValue;
import rad.dicom.ima.GeneralImageIOD;
import rad.dicom.ima.ImageBtnPanel;
import rad.ijplugin.dcm.DumpPanel;
import rad.ijplugin.dcm.FileListPanel;
import rad.ijplugin.dcm.GridBagConstraints2;
import rad.ijplugin.dcm.ImportData;
import rad.ijplugin.util.Util;

public class ImportPanel
extends JPanel {
    private ImportData imda;
    private String workingDir = null;
    private String aktFileName = null;
    JTabbedPane tabbedPane = new JTabbedPane();
    JPanel selectPanel = new JPanel();
    JButton selectBtn = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel fileInfo = new JPanel();
    ImageBtnPanel dcmImageBP = new ImageBtnPanel();
    JPanel imgP = new JPanel();
    JButton dumpBtn = new JButton();
    JPanel patientPanel = new JPanel();
    JPanel studyPanel = new JPanel();
    JPanel seriesPanel = new JPanel();
    JPanel imagePanel = new JPanel();
    JTextArea patientInfo = new JTextArea();
    JTextArea studyInfo = new JTextArea();
    JTextArea seriesInfo = new JTextArea();
    JTextArea imageInfo = new JTextArea();
    JTextArea planePixelInfo = new JTextArea();
    JPanel planePixelPanel = new JPanel();
    JTextArea modalityInfo = new JTextArea();
    JPanel modalityPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    GridBagLayout gridBagLayout9 = new GridBagLayout();
    GridBagLayout gridBagLayout10 = new GridBagLayout();
    GridBagLayout gridBagLayout11 = new GridBagLayout();
    JScrollPane fileScrollP = new JScrollPane();
    JList fileL = new JList();
    JLabel patNameL = new JLabel();
    JLabel patBirthT = new JLabel();
    JLabel patBirthL = new JLabel();
    JLabel patNameT = new JLabel();
    JLabel studyL = new JLabel();
    JLabel studyT = new JLabel();
    JLabel seriesL = new JLabel();
    JLabel seriesT = new JLabel();
    JLabel instanceL = new JLabel();
    JLabel instanceT = new JLabel();
    JPanel infoP = new JPanel();
    FileListPanel fileListP = new FileListPanel();
    JScrollPane modalityScrollPane = new JScrollPane();
    public JLabel copyrightL = new JLabel();

    public ImportPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initWithDataBlock(ImportData id) {
        this.imda = id;
        this.fileListP.intWithDataBlock(this.imda);
    }

    public void updateDataBlock() {
        this.fileListP.updateDataBlock();
    }

    private void selectFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select a DICOM file...");
        if (this.imda.inputDir != null) {
            chooser.setCurrentDirectory(this.imda.inputDir);
        }
        chooser.showOpenDialog(this);
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.imda.inputDir = new File(f.getParent());
        this.workingDir = f.getParent() + File.separator;
        this.aktFileName = f.getName();
        this.openFile();
        String[] fl = new File(this.workingDir).list();
        if (fl != null) {
            Util.bubbleSortStrings(fl);
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < fl.length) {
                try {
                    FileInputStream fis = new FileInputStream(this.workingDir + fl[i]);
                    if (DcmInputStream.isDicomStream((BufferedInputStream)new BufferedInputStream(fis))) {
                        v.addElement(fl[i]);
                    }
                    fis.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
            this.fileL.setListData(v);
            this.fileL.invalidate();
            this.fileScrollP.invalidate();
            this.validate();
        }
    }

    private void openFile() {
        try {
            this.imda.theFile = new File(this.workingDir + this.aktFileName);
            DcmDataObject ddo = DcmInputStream.loadDDO((File)this.imda.theFile);
            this.imda.theGI = new GeneralImageIOD(ddo, this.imda.allowACRNema);
            this.processDcmImageFileObject();
        }
        catch (Exception err) {
            Util.showErrorDialog(err.getMessage());
        }
    }

    private void processDcmImageFileObject() throws Exception {
        String infoStr = "";
        DcmDataObject ddo = this.imda.theGI.headerDDO;
        if (ddo == null) {
            throw new Exception("processDcmImageFileObject: No DcmDataObject specified");
        }
        this.dcmImageBP.setImage(this.imda.theGI);
        infoStr = ddo.getStorage() == 64 ? infoStr + "PLAIN" : infoStr + "META";
        infoStr = ddo.getStructure() == 16 ? infoStr + "-EX" : infoStr + "-IM";
        infoStr = ddo.getEncoding() == 1 ? infoStr + "-LI: " : infoStr + "-BI: ";
        if (this.imda.theFile != null) {
            infoStr = infoStr + this.imda.theFile.getName();
        }
        this.setInfoBorder(infoStr);
        this.fillGeneralInfo(ddo);
        this.fillPatientInfo(ddo);
        this.fillStudyInfo(ddo);
        this.fillSeriesInfo(ddo);
        this.fillImageInfo(ddo);
        this.fillPlanePixelInfo(ddo);
        this.fillModalityInfo(ddo);
    }

    private void fillGeneralInfo(DcmDataObject ddo) {
        this.patNameT.setText(ddo.getString(104));
        this.patBirthT.setText(ddo.getString(107));
        this.studyT.setText(ddo.getString(9) + " / " + ddo.getString(441));
        this.seriesT.setText(ddo.getString(442));
        this.instanceT.setText(ddo.getString(444));
    }

    private void fillPatientInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 104, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 105, 27);
        s = s + this.getDcmValueString(ddo, 107, 27);
        s = s + this.getDcmValueString(ddo, 109, 27);
        s = s + this.getDcmValueString(ddo, 64, 27);
        s = s + this.getDcmValueString(ddo, 108, 27);
        s = s + this.getDcmValueString(ddo, 111, 27);
        s = s + this.getDcmValueString(ddo, 112, 27);
        s = s + this.getDcmValueString(ddo, 127, 27);
        s = s + this.getDcmValueString(ddo, 134, 27);
        this.patientInfo.setText(s);
    }

    private void fillStudyInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 439, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 9, 27);
        s = s + this.getDcmValueString(ddo, 15, 27);
        s = s + this.getDcmValueString(ddo, 34, 27);
        s = s + this.getDcmValueString(ddo, 441, 27);
        s = s + this.getDcmValueString(ddo, 22, 27);
        s = s + this.getDcmValueString(ddo, 49, 27);
        s = s + this.getDcmValueString(ddo, 53, 27);
        s = s + this.getDcmValueString(ddo, 55, 27);
        s = s + this.getDcmValueString(ddo, 61, 27);
        s = s + this.getDcmValueString(ddo, 50, 27);
        this.studyInfo.setText(s);
    }

    private void fillSeriesInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 440, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 442, 27);
        s = s + this.getDcmValueString(ddo, 26, 27);
        s = s + this.getDcmValueString(ddo, 458, 27);
        s = s + this.getDcmValueString(ddo, 10, 27);
        s = s + this.getDcmValueString(ddo, 16, 27);
        s = s + this.getDcmValueString(ddo, 54, 27);
        s = s + this.getDcmValueString(ddo, 200, 27);
        s = s + this.getDcmValueString(ddo, 51, 27);
        s = s + this.getDcmValueString(ddo, 56, 27);
        s = s + this.getDcmValueString(ddo, 62, 27);
        s = s + this.getDcmValueString(ddo, 139, 27);
        s = s + this.getDcmValueString(ddo, 356, 27);
        s = s + this.getDcmValueString(ddo, 497, 27);
        s = s + this.getDcmValueString(ddo, 498, 27);
        s = s + this.getDcmValueString(ddo, 623, 27);
        this.seriesInfo.setText(s);
    }

    private void fillImageInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 444, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 451, 27);
        s = s + this.getDcmValueString(ddo, 12, 27);
        s = s + this.getDcmValueString(ddo, 18, 27);
        s = s + this.getDcmValueString(ddo, 3, 27);
        s = s + this.getDcmValueString(ddo, 443, 27);
        s = s + this.getDcmValueString(ddo, 11, 27);
        s = s + this.getDcmValueString(ddo, 17, 27);
        s = s + this.getDcmValueString(ddo, 67, 27);
        s = s + this.getDcmValueString(ddo, 78, 27);
        s = s + this.getDcmValueString(ddo, 79, 27);
        s = s + this.getDcmValueString(ddo, 464, 27);
        s = s + this.getDcmValueString(ddo, 475, 27);
        s = s + this.getDcmValueString(ddo, 502, 27);
        s = s + this.getDcmValueString(ddo, 503, 27);
        s = s + this.getDcmValueString(ddo, 77, 27);
        s = s + this.getDcmValueString(ddo, 525, 27);
        this.imageInfo.setText(s);
    }

    private void fillPlanePixelInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 486, 27);
        s = s + this.getDcmValueString(ddo, 456, 27);
        s = s + this.getDcmValueString(ddo, 455, 27);
        s = s + this.getDcmValueString(ddo, 162, 27);
        s = s + this.getDcmValueString(ddo, 467, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 477, 27);
        s = s + this.getDcmValueString(ddo, 478, 27);
        s = s + this.getDcmValueString(ddo, 482, 27);
        s = s + this.getDcmValueString(ddo, 483, 27);
        s = s + this.getDcmValueString(ddo, 491, 27);
        s = s + this.getDcmValueString(ddo, 492, 27);
        s = s + this.getDcmValueString(ddo, 493, 27);
        s = s + this.getDcmValueString(ddo, 494, 27);
        s = s + this.getDcmValueString(ddo, 479, 27);
        s = s + this.getDcmValueString(ddo, 489, 27);
        s = s + this.getDcmValueString(ddo, 495, 27);
        s = s + this.getDcmValueString(ddo, 496, 27);
        s = s + "\n";
        s = s + this.getDcmValueString(ddo, 506, 27);
        s = s + this.getDcmValueString(ddo, 507, 27);
        this.planePixelInfo.setText(s);
    }

    private String fillCTInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 3, 27);
        s = s + this.getDcmValueString(ddo, 508, 27);
        s = s + this.getDcmValueString(ddo, 509, 27);
        s = s + this.getDcmValueString(ddo, 163, 27);
        s = s + this.getDcmValueString(ddo, 443, 27);
        s = s + this.getDcmValueString(ddo, 142, 27);
        s = s + this.getDcmValueString(ddo, 180, 27);
        s = s + this.getDcmValueString(ddo, 241, 27);
        s = s + this.getDcmValueString(ddo, 242, 27);
        s = s + this.getDcmValueString(ddo, 243, 27);
        s = s + this.getDcmValueString(ddo, 245, 27);
        s = s + this.getDcmValueString(ddo, 247, 27);
        s = s + this.getDcmValueString(ddo, 255, 27);
        s = s + this.getDcmValueString(ddo, 264, 27);
        s = s + this.getDcmValueString(ddo, 265, 27);
        s = s + this.getDcmValueString(ddo, 266, 27);
        s = s + this.getDcmValueString(ddo, 273, 27);
        s = s + this.getDcmValueString(ddo, 278, 27);
        s = s + this.getDcmValueString(ddo, 284, 27);
        s = s + this.getDcmValueString(ddo, 290, 27);
        return s;
    }

    private String fillMRInfo(DcmDataObject ddo) {
        String s = "";
        s = s + this.getDcmValueString(ddo, 3, 27);
        s = s + this.getDcmValueString(ddo, 140, 27);
        s = s + this.getDcmValueString(ddo, 141, 27);
        s = s + this.getDcmValueString(ddo, 142, 27);
        s = s + this.getDcmValueString(ddo, 143, 27);
        s = s + this.getDcmValueString(ddo, 170, 27);
        s = s + this.getDcmValueString(ddo, 171, 27);
        s = s + this.getDcmValueString(ddo, 181, 27);
        s = s + this.getDcmValueString(ddo, 172, 27);
        s = s + this.getDcmValueString(ddo, 212, 27);
        s = s + this.getDcmValueString(ddo, 144, 27);
        s = s + this.getDcmValueString(ddo, 145, 27);
        s = s + this.getDcmValueString(ddo, 173, 27);
        s = s + this.getDcmValueString(ddo, 174, 27);
        s = s + this.getDcmValueString(ddo, 175, 27);
        s = s + this.getDcmValueString(ddo, 176, 27);
        s = s + this.getDcmValueString(ddo, 177, 27);
        s = s + this.getDcmValueString(ddo, 178, 27);
        s = s + this.getDcmValueString(ddo, 179, 27);
        s = s + this.getDcmValueString(ddo, 182, 27);
        s = s + this.getDcmValueString(ddo, 183, 27);
        s = s + this.getDcmValueString(ddo, 184, 27);
        s = s + this.getDcmValueString(ddo, 214, 27);
        s = s + this.getDcmValueString(ddo, 231, 27);
        s = s + this.getDcmValueString(ddo, 232, 27);
        s = s + this.getDcmValueString(ddo, 233, 27);
        s = s + this.getDcmValueString(ddo, 234, 27);
        s = s + this.getDcmValueString(ddo, 235, 27);
        s = s + this.getDcmValueString(ddo, 236, 27);
        s = s + this.getDcmValueString(ddo, 237, 27);
        s = s + this.getDcmValueString(ddo, 238, 27);
        s = s + this.getDcmValueString(ddo, 239, 27);
        s = s + this.getDcmValueString(ddo, 240, 27);
        s = s + this.getDcmValueString(ddo, 241, 27);
        s = s + this.getDcmValueString(ddo, 294, 27);
        s = s + this.getDcmValueString(ddo, 295, 27);
        s = s + this.getDcmValueString(ddo, 301, 27);
        s = s + this.getDcmValueString(ddo, 302, 27);
        s = s + this.getDcmValueString(ddo, 303, 27);
        s = s + this.getDcmValueString(ddo, 305, 27);
        s = s + this.getDcmValueString(ddo, 304, 27);
        s = s + this.getDcmValueString(ddo, 306, 27);
        s = s + this.getDcmValueString(ddo, 460, 27);
        s = s + this.getDcmValueString(ddo, 461, 27);
        s = s + this.getDcmValueString(ddo, 462, 27);
        return s;
    }

    private void fillModalityInfo(DcmDataObject ddo) {
        String s = "";
        s = ddo.getString(7);
        String classUID = s;
        if (classUID.compareTo("1.2.840.10008.5.1.4.1.1.2") == 0) {
            this.modalityInfo.setText(this.fillCTInfo(ddo));
            return;
        }
        if (classUID.compareTo("1.2.840.10008.5.1.4.1.1.4") == 0) {
            this.modalityInfo.setText(this.fillMRInfo(ddo));
            return;
        }
        this.modalityInfo.setText("");
    }

    private String getDcmValueString(DcmDataObject ddo, int type, int len) {
        DcmValue dv = ddo.getDcmValue(type);
        if (dv == null) {
            return "";
        }
        return dv.toString(true, len, false, 256, false) + "\n";
    }

    private void setInfoBorder(String s) {
        this.fileInfo.setBorder(new TitledBorder(new LineBorder(Color.darkGray), s));
        this.fileInfo.repaint();
    }

    void selectBtn_actionPerformed(ActionEvent e) {
        this.selectFile();
    }

    void fileL_valueChanged(ListSelectionEvent e) {
        int i = this.fileL.getAnchorSelectionIndex();
        if (i < 0) {
            return;
        }
        String s = (String)this.fileL.getModel().getElementAt(i);
        if (s.compareTo(this.aktFileName) == 0) {
            return;
        }
        this.aktFileName = s;
        this.openFile();
    }

    void dumpBtn_actionPerformed(ActionEvent e) {
        if (this.imda.theGI == null) {
            return;
        }
        DumpPanel dp = new DumpPanel(this.imda.outputDir);
        try {
            dp.processDcmDataObject(this.imda.theGI.headerDDO);
        }
        catch (Exception err) {
            // empty catch block
        }
        Object[] options = new Object[]{"OK"};
        int diaRes = JOptionPane.showOptionDialog(null, dp, "DICOM file dump", -1, -1, null, options, options[0]);
        if (diaRes == 0) {
            // empty if block
        }
    }

    private void jbInit() throws Exception {
        DefaultListSelectionModel m = new DefaultListSelectionModel();
        m.setSelectionMode(0);
        this.fileL.setSelectionModel(m);
        this.setMinimumSize(new Dimension(620, 420));
        this.setPreferredSize(new Dimension(620, 420));
        this.fileInfo.setPreferredSize(new Dimension(230, 272));
        this.fileInfo.setBackground(SystemColor.control);
        this.fileInfo.setBorder(new LineBorder(Color.darkGray));
        this.fileInfo.setMinimumSize(new Dimension(230, 222));
        this.fileInfo.setLayout(this.gridBagLayout10);
        this.setInfoBorder("No file selected");
        this.selectPanel.setBackground(SystemColor.control);
        this.selectBtn.setText("Select a DICOM file");
        this.selectBtn.setPreferredSize(new Dimension(150, 25));
        this.selectBtn.setSelected(true);
        this.selectBtn.setMinimumSize(new Dimension(150, 25));
        this.selectBtn.requestDefaultFocus();
        this.dcmImageBP.setPreferredSize(new Dimension(175, 175));
        this.dcmImageBP.setMinimumSize(new Dimension(175, 175));
        this.dcmImageBP.setSize(new Dimension(132, 132));
        this.imgP.setPreferredSize(new Dimension(142, 250));
        this.imgP.setBackground(SystemColor.control);
        this.imgP.setMinimumSize(new Dimension(132, 200));
        this.dumpBtn.setText("Dump");
        this.dumpBtn.setPreferredSize(new Dimension(59, 25));
        this.dumpBtn.setMinimumSize(new Dimension(59, 25));
        this.patientPanel.setBackground(SystemColor.control);
        this.studyPanel.setBackground(SystemColor.control);
        this.seriesPanel.setBackground(SystemColor.control);
        this.imagePanel.setBackground(SystemColor.control);
        this.imagePanel.setLayout(this.gridBagLayout5);
        this.seriesPanel.setLayout(this.gridBagLayout4);
        this.studyPanel.setLayout(this.gridBagLayout2);
        this.patientPanel.setLayout(this.gridBagLayout1);
        this.patientInfo.setBackground(SystemColor.control);
        this.patientInfo.setEditable(false);
        this.patientInfo.setFont(new Font("Monospaced", 0, 12));
        this.modalityPanel.setLayout(this.gridBagLayout7);
        this.modalityInfo.setBackground(SystemColor.control);
        this.modalityInfo.setEditable(false);
        this.modalityInfo.setFont(new Font("Monospaced", 0, 12));
        this.modalityPanel.setBackground(SystemColor.control);
        this.fileScrollP.setPreferredSize(new Dimension(150, 75));
        this.fileScrollP.setMinimumSize(new Dimension(150, 75));
        this.fileL.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ImportPanel.this.fileL_valueChanged(e);
            }
        });
        this.infoP.setLayout(this.gridBagLayout8);
        this.planePixelPanel.setLayout(this.gridBagLayout6);
        this.planePixelInfo.setBackground(SystemColor.control);
        this.planePixelInfo.setEditable(false);
        this.planePixelInfo.setFont(new Font("Monospaced", 0, 12));
        this.planePixelPanel.setBackground(SystemColor.control);
        this.imageInfo.setBackground(SystemColor.control);
        this.imageInfo.setEditable(false);
        this.imageInfo.setFont(new Font("Monospaced", 0, 12));
        this.seriesInfo.setBackground(SystemColor.control);
        this.seriesInfo.setEditable(false);
        this.seriesInfo.setFont(new Font("Monospaced", 0, 12));
        this.studyInfo.setBackground(SystemColor.control);
        this.studyInfo.setEditable(false);
        this.studyInfo.setFont(new Font("Monospaced", 0, 12));
        this.dumpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportPanel.this.dumpBtn_actionPerformed(e);
            }
        });
        this.imgP.setLayout(this.gridBagLayout9);
        this.selectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportPanel.this.selectBtn_actionPerformed(e);
            }
        });
        this.selectPanel.setLayout(this.gridBagLayout11);
        this.setLayout(this.gridBagLayout3);
        this.fileListP.setPreferredSize(new Dimension(200, 10));
        this.patNameL.setText("Patient's Name:");
        this.patNameT.setText("?");
        this.patBirthL.setText("Patient's Birth Date:");
        this.patBirthT.setText("?");
        this.studyL.setText("Study Date / ID:");
        this.studyT.setText("?");
        this.seriesL.setText("Series Number:");
        this.seriesT.setText("?");
        this.instanceL.setText("Instance (Image) ID:");
        this.instanceT.setText("?");
        this.modalityScrollPane.setBorder(null);
        this.copyrightL.setToolTipText("");
        this.copyrightL.setText("(c) 2000 Thomas Hacklaender, see GPL Lizense");
        this.add((Component)this.tabbedPane, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.tabbedPane.addTab("Select File", this.selectPanel);
        this.selectPanel.add((Component)this.selectBtn, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.selectPanel.add((Component)this.fileInfo, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.fileInfo.add((Component)this.imgP, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.imgP.add((Component)this.dcmImageBP, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.imgP.add((Component)this.dumpBtn, new GridBagConstraints2(0, 3, 0, 1, 0.0, 0.0, 10, 1, new Insets(8, 4, 8, 4), 0, 0));
        this.fileInfo.add((Component)this.infoP, new GridBagConstraints2(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.infoP.add((Component)this.fileListP, new GridBagConstraints2(0, 5, 3, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.infoP.add((Component)this.patNameL, new GridBagConstraints2(0, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.infoP.add((Component)this.seriesL, new GridBagConstraints2(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.infoP.add((Component)this.patBirthL, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.infoP.add((Component)this.patNameT, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.infoP.add((Component)this.patBirthT, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.infoP.add((Component)this.seriesT, new GridBagConstraints2(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.infoP.add((Component)this.instanceL, new GridBagConstraints2(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.infoP.add((Component)this.studyL, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 8), 0, 0));
        this.infoP.add((Component)this.studyT, new GridBagConstraints2(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.infoP.add((Component)this.instanceT, new GridBagConstraints2(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.selectPanel.add((Component)this.fileScrollP, new GridBagConstraints2(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        this.fileScrollP.getViewport().add((Component)this.fileL, null);
        this.tabbedPane.addTab("Patient", this.patientPanel);
        this.patientPanel.add((Component)this.patientInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 472, 301));
        this.tabbedPane.addTab("Study", this.studyPanel);
        this.studyPanel.add((Component)this.studyInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 471, 301));
        this.tabbedPane.addTab("Series", this.seriesPanel);
        this.seriesPanel.add((Component)this.seriesInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 472, 301));
        this.tabbedPane.addTab("Image", this.imagePanel);
        this.imagePanel.add((Component)this.imageInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 472, 301));
        this.tabbedPane.addTab("Plane / Pixel", this.planePixelPanel);
        this.planePixelPanel.add((Component)this.planePixelInfo, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 484, 316));
        this.tabbedPane.addTab("Modality", this.modalityPanel);
        this.modalityPanel.add((Component)this.modalityScrollPane, new GridBagConstraints2(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.copyrightL, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.modalityScrollPane.getViewport().add((Component)this.modalityInfo, null);
    }
}

