/*
 * Decompiled with CFR 0.152.
 */
package jm.cepstrum;

public class BicubicInterpolation {
    private int[] image = null;
    private int width = 0;
    private int height = 0;
    private static double a = -0.75;
    private int[] p = null;
    private double tt;

    public BicubicInterpolation(byte[] img, int w, int h) {
        this.width = w;
        this.height = h;
        this.p = new int[16];
        this.image = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            this.image[i] = img[i];
            ++i;
        }
    }

    public BicubicInterpolation(short[] img, int w, int h) {
        this.width = w;
        this.height = h;
        this.p = new int[16];
        this.image = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            this.image[i] = img[i];
            ++i;
        }
    }

    public BicubicInterpolation(int[] img, int w, int h) {
        this.width = w;
        this.height = h;
        this.p = new int[16];
        this.image = new int[this.width * this.height];
        System.arraycopy(img, 0, this.image, 0, this.width * this.height);
    }

    public int getPixel(double x, double y) {
        int result = 0;
        if (x >= (double)this.width || x < 0.0 || y >= (double)this.height || y < 0.0) {
            return result;
        }
        double ix = x - Math.floor(x);
        double iy = y - Math.floor(y);
        int posx = (int)Math.floor(x) - 1;
        int posy = (int)Math.floor(y) - 1;
        int j = 0;
        while (j <= 3) {
            int n = posy + j;
            if (n < 0) {
                n = 1;
            }
            if (n == this.height) {
                n = this.height - 2;
            }
            if (n > this.height) {
                n = this.height - 3;
            }
            int i = 0;
            while (i <= 3) {
                int m = posx + i;
                if (m < 0) {
                    m = 1;
                }
                if (m == this.width) {
                    m = this.width - 2;
                }
                if (m > this.width) {
                    m = this.width - 3;
                }
                this.p[(j << 2) + i] = this.image[n * this.width + m];
                ++i;
            }
            ++j;
        }
        double c3x = this.c3(ix);
        double c2x = this.c2(ix);
        double c1x = this.c1(ix);
        double c0x = this.c0(ix);
        double h3 = (double)this.p[0] * c3x + (double)this.p[1] * c2x + (double)this.p[2] * c1x + (double)this.p[3] * c0x;
        double h2 = (double)this.p[4] * c3x + (double)this.p[5] * c2x + (double)this.p[6] * c1x + (double)this.p[7] * c0x;
        double h1 = (double)this.p[8] * c3x + (double)this.p[9] * c2x + (double)this.p[10] * c1x + (double)this.p[11] * c0x;
        double h0 = (double)this.p[12] * c3x + (double)this.p[13] * c2x + (double)this.p[14] * c1x + (double)this.p[15] * c0x;
        result = (int)(h3 * this.c3(iy) + h2 * this.c2(iy) + h1 * this.c1(iy) + h0 * this.c0(iy));
        return result;
    }

    private double c0(double t) {
        this.tt = t * t;
        return -1.0 * a * t * this.tt + a * this.tt;
    }

    private double c1(double t) {
        this.tt = t * t;
        return -1.0 * (a + 2.0) * t * this.tt + (2.0 * a + 3.0) * this.tt - a * t;
    }

    private double c2(double t) {
        this.tt = t * t;
        return (a + 2.0) * t * this.tt - (a + 3.0) * this.tt + 1.0;
    }

    private double c3(double t) {
        this.tt = t * t;
        return a * t * this.tt - 2.0 * a * this.tt + a * t;
    }
}

