/*
 * Decompiled with CFR 0.152.
 */
package jm.cepstrum;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ShortProcessor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ColorModel;
import jm.cepstrum.ResultLog;
import jm.jigl.ComplexImage;
import jm.jigl.FFT;
import jm.jigl.GrayImage;
import jm.jigl.RealGrayImage;
import jm.jigl.Shift;

public class Cepstrum
extends Frame {
    private int img_width;
    private int img_height;
    private int all_width;
    private int all_height;
    private Point img1_pos;
    private Point img2_pos;
    private boolean destroy_when_ready;
    private boolean imgs_docked;
    private boolean do_windowing;
    private boolean do_sobel;
    private boolean check_result;
    private boolean verbose = true;
    private boolean writeLog = true;
    private int translation_x;
    private int translation_y;
    private ImagePlus orgImage = null;
    private ImagePlus fftImage = null;
    private ImagePlus psImage = null;
    private ImagePlus fft2Image = null;
    private ImagePlus ps2Image = null;
    public ImageStack orgStack = null;
    public ImageStack fftStack = null;
    public ImageStack psStack = null;
    public ImageStack fft2Stack = null;
    public ImageStack ps2Stack = null;
    public boolean showImages = true;
    public double peakQuality = 0.0;
    public double peakAboveAverage = 0.0;
    private GrayImage input1;
    private GrayImage input2;
    private GrayImage img1;
    private RealGrayImage img2;
    private RealGrayImage img3;
    private GrayImage img4;
    FlowLayout flowLayout1 = new FlowLayout();

    public Cepstrum() {
        try {
            this.check_result = true;
            this.destroy_when_ready = true;
            this.do_sobel = true;
            this.do_windowing = true;
            this.imgs_docked = true;
            this.translation_x = -1;
            this.translation_y = -1;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setWriteLog(boolean log) {
        this.writeLog = log;
    }

    public boolean calculateTranslation(Image in1, Image in2, Point shift) {
        boolean result = false;
        try {
            int offset_y;
            shift.x = -1;
            shift.y = -1;
            this.input1 = new GrayImage(in1);
            this.input2 = new GrayImage(in2);
            if (this.input1.X() != this.input2.X() && this.input1.Y() != this.input2.Y()) {
                return result;
            }
            this.img_width = this.input1.X();
            this.img_height = this.input1.Y();
            int offset_x = this.offsetToPowerOf2(this.img_width);
            int xydiff = (this.img_width + offset_x) * 2 - (this.img_height + (offset_y = this.offsetToPowerOf2(this.img_height)));
            if (xydiff != 0) {
                if (xydiff > 0) {
                    offset_y += Math.abs(xydiff);
                } else {
                    offset_x += xydiff / 2;
                }
            }
            this.all_width = (this.img_width + offset_x) * 2 * 2;
            this.all_height = (this.img_height + offset_y) * 2;
            this.img1_pos = new Point(this.all_width / 4 + offset_x / 2, this.all_height / 4 + offset_y / 2);
            this.img2_pos = new Point(this.all_width / 2 + offset_x / 2, this.all_height / 4 + offset_y / 2);
            this.img1 = new GrayImage(this.all_width, this.all_height);
            if (this.verbose) {
                IJ.write((String)"Sobel-Operator...");
            }
            if (this.do_sobel) {
                this.input1 = this.filterSobel(this.input1);
                this.input2 = this.filterSobel(this.input2);
            }
            if (this.verbose) {
                IJ.write((String)"Applying Window...");
            }
            if (this.do_windowing) {
                this.input1 = this.filterKBWindow(this.input1, true);
                this.input2 = this.filterKBWindow(this.input2, true);
            }
            int x = 0;
            while (x < this.img_width) {
                int y = 0;
                while (y < this.img_height) {
                    this.img1.set(this.img1_pos.x + x, this.img1_pos.y + y, this.input1.get(x, y));
                    this.img1.set(this.img2_pos.x + x, this.img2_pos.y + y, this.input2.get(x, y));
                    ++y;
                }
                ++x;
            }
            if (this.orgStack == null && this.showImages) {
                ShortProcessor sp = new ShortProcessor(10, 10, true);
                ColorModel cm = sp.getColorModel();
                this.orgStack = new ImageStack(this.all_width, this.all_height, cm);
                this.fftStack = new ImageStack(this.all_width, this.all_height, cm);
                this.psStack = new ImageStack(this.all_width, this.all_height, cm);
                this.fft2Stack = new ImageStack(this.all_width, this.all_height, cm);
                this.ps2Stack = new ImageStack(this.all_width, this.all_height, cm);
            }
            if (this.showImages) {
                this.orgStack.addSlice(" ", (Object)this.getGrayArray(this.img1));
            }
            if (this.writeLog) {
                ResultLog logFile = new ResultLog("cepstrum.log");
                logFile.append("" + this.do_sobel + "|" + this.do_windowing + "|" + this.all_width + "|" + this.all_height + "|");
            }
            result = this.doCepstrum();
            shift.x = this.translation_x;
            shift.y = this.translation_y;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private int offsetToPowerOf2(int size) {
        int offset = 0;
        int power = 2;
        while (power < size) {
            if ((power *= 2) == size) {
                return 0;
            }
            offset = power - size;
        }
        return offset;
    }

    private boolean doCepstrum() throws Exception {
        boolean result = false;
        try {
            if (this.verbose) {
                IJ.write((String)"Applying Window...");
            }
            if (this.do_windowing) {
                this.applyWindow(this.img1);
            }
            if (this.verbose) {
                IJ.write((String)"Fourier-Transformation...");
            }
            ComplexImage imgcc = FFT.doFFT(this.img1, true);
            if (this.verbose) {
                IJ.write((String)"Centering FFT-Image...");
            }
            Shift shift = new Shift(imgcc.X() / 2, imgcc.Y() / 2, 1);
            RealGrayImage imgr = (RealGrayImage)shift.apply((jm.jigl.Image)imgcc.real());
            RealGrayImage imgi = (RealGrayImage)shift.apply((jm.jigl.Image)imgcc.imag());
            imgcc.setImag(imgi);
            imgcc.setReal(imgr);
            if (this.showImages) {
                this.fftStack.addSlice(" ", (Object)this.getGrayArray(imgcc));
            }
            if (this.verbose) {
                IJ.write((String)"Building Power-Spectrum...");
            }
            this.img2 = this.filterPower(imgcc);
            if (this.verbose) {
                IJ.write((String)"calculating Log[] of Image...");
            }
            this.img2 = this.filterLog(this.img2);
            if (this.verbose) {
                IJ.write((String)"Applying Window...");
            }
            if (this.do_windowing) {
                this.img2 = this.filterKBWindow(this.img2, false);
            }
            if (this.showImages) {
                this.psStack.addSlice(" ", (Object)this.getGrayArray(this.img2));
            }
            if (this.verbose) {
                IJ.write((String)"Fourier-Transformation...");
            }
            ComplexImage imgcc2 = FFT.doFFT(this.img2, true);
            if (this.verbose) {
                IJ.write((String)"Centering FFT-Image...");
            }
            Shift shift2 = new Shift(imgcc2.X() / 2, imgcc2.Y() / 2, 1);
            RealGrayImage imgr2 = (RealGrayImage)shift2.apply((jm.jigl.Image)imgcc2.real());
            RealGrayImage imgi2 = (RealGrayImage)shift2.apply((jm.jigl.Image)imgcc2.imag());
            imgcc2.setImag(imgi2);
            imgcc2.setReal(imgr2);
            if (this.showImages) {
                this.fft2Stack.addSlice(" ", (Object)this.getGrayArray(imgcc2));
            }
            if (this.verbose) {
                IJ.write((String)"Building Power-Spectrum...");
            }
            this.img3 = this.filterPower(imgcc2);
            if (this.showImages) {
                this.ps2Stack.addSlice(" ", (Object)this.getGrayArray(this.img3));
            }
            if (this.verbose) {
                IJ.write((String)"Searching for local maxima...");
            }
            this.img4 = this.findLocalMax(imgcc2);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private GrayImage getFFTImageForDisplay(GrayImage img) {
        ComplexImage imgcc = FFT.doFFT(img, true);
        Shift shift = new Shift(imgcc.X() / 2, imgcc.Y() / 2, 1);
        RealGrayImage imgr = (RealGrayImage)shift.apply((jm.jigl.Image)imgcc.real());
        RealGrayImage imgi = (RealGrayImage)shift.apply((jm.jigl.Image)imgcc.imag());
        imgcc.setImag(imgi);
        imgcc.setReal(imgr);
        return this.getMagScaleFromComplexImage(imgcc);
    }

    private GrayImage filterSobel(GrayImage img) {
        GrayImage imgres = new GrayImage(img.X(), img.Y());
        imgres.byteSize();
        imgres.clear();
        img.byteSize();
        int xxw = img.X();
        int yyw = img.Y();
        int p1 = 0;
        int p2 = 0;
        int p3 = 0;
        int p4 = 0;
        int p5 = 0;
        int p6 = 0;
        int p7 = 0;
        int p8 = 0;
        int p9 = 0;
        int result = 0;
        int result_x = 0;
        int result_y = 0;
        int yy = 1;
        while (yy < yyw - 1) {
            int xx = 1;
            while (xx < xxw - 1) {
                if (xx == 1) {
                    p1 = img.get(xx - 1, yy - 1);
                    p2 = img.get(xx, yy - 1);
                    p3 = img.get(xx + 1, yy - 1);
                    p4 = img.get(xx - 1, yy);
                    p5 = img.get(xx, yy);
                    p6 = img.get(xx + 1, yy);
                    p7 = img.get(xx - 1, yy + 1);
                    p8 = img.get(xx, yy + 1);
                    p9 = img.get(xx + 1, yy + 1);
                } else {
                    p1 = p2;
                    p2 = p3;
                    p3 = img.get(xx + 1, yy - 1);
                    p4 = p5;
                    p5 = p6;
                    p6 = img.get(xx + 1, yy);
                    p7 = p8;
                    p8 = p9;
                    p9 = img.get(xx + 1, yy + 1);
                }
                result_x = p7 + 2 * p8 + p9 - p1 - 2 * p2 - p3;
                result_y = p3 + 2 * p6 + p9 - p1 - 2 * p4 - p7;
                result_x = Math.abs(result_x);
                result_y = Math.abs(result_y);
                result = (result_x + result_y) / 4;
                if (result > 255) {
                    result = 255;
                }
                imgres.set(xx, yy, result);
                ++xx;
            }
            ++yy;
        }
        return imgres;
    }

    public RealGrayImage filterLog(RealGrayImage imgReal) {
        int width = imgReal.X();
        int height = imgReal.Y();
        RealGrayImage imgLog = new RealGrayImage(width, height);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                float a = (float)Math.log(imgReal.get(x, y));
                imgLog.set(x, y, a);
                ++y;
            }
            ++x;
        }
        return imgLog;
    }

    private RealGrayImage filterPower(ComplexImage imgcc) {
        int width = imgcc.X();
        int height = imgcc.Y();
        RealGrayImage imgPower = new RealGrayImage(width, height);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                float a = imgcc.getReal(x, y) * imgcc.getReal(x, y) + imgcc.getImag(x, y) * imgcc.getImag(x, y);
                imgPower.set(x, y, a);
                ++y;
            }
            ++x;
        }
        return imgPower;
    }

    private short[] getGrayArray(ComplexImage imgcc) {
        int y;
        int w = imgcc.X();
        int h = imgcc.Y();
        short[] pix = new short[w * h];
        double a = 0.0;
        double max = Double.MIN_VALUE;
        double c = 1.0;
        int x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = Math.sqrt((double)imgcc.getReal(x, y) * (double)imgcc.getReal(x, y) + (double)imgcc.getImag(x, y) * (double)imgcc.getImag(x, y));
                if ((a = Math.log(1.0 + a)) > max) {
                    max = a;
                }
                ++y;
            }
            ++x;
        }
        c = max / 16380.0;
        x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = Math.sqrt((double)imgcc.getReal(x, y) * (double)imgcc.getReal(x, y) + (double)imgcc.getImag(x, y) * (double)imgcc.getImag(x, y));
                a = Math.log(1.0 + a);
                pix[y * w + x] = (short)(a /= c);
                ++y;
            }
            ++x;
        }
        return pix;
    }

    private short[] getGrayArray(RealGrayImage imgcc) {
        int y;
        int w = imgcc.X();
        int h = imgcc.Y();
        short[] pix = new short[w * h];
        double a = 0.0;
        double max = Double.MIN_VALUE;
        double c = 1.0;
        int x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = imgcc.get(x, y);
                if (a > max && a < 16384.0) {
                    max = a;
                }
                ++y;
            }
            ++x;
        }
        c = max / 16384.0;
        x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = imgcc.get(x, y);
                pix[y * w + x] = (short)(a /= c);
                ++y;
            }
            ++x;
        }
        return pix;
    }

    private short[] getGrayArray(GrayImage imgcc) {
        int y;
        int w = imgcc.X();
        int h = imgcc.Y();
        short[] pix = new short[w * h];
        double a = 0.0;
        double max = Double.MIN_VALUE;
        double c = 1.0;
        int x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = imgcc.get(x, y);
                if (a > max && a < 16384.0) {
                    max = a;
                }
                ++y;
            }
            ++x;
        }
        c = max / 16384.0;
        x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                a = imgcc.get(x, y);
                pix[y * w + x] = (short)(a /= c);
                ++y;
            }
            ++x;
        }
        return pix;
    }

    private GrayImage filterKBWindow(GrayImage img, boolean inverse) {
        double kb;
        double val;
        int x;
        int w = img.X();
        int h = img.Y();
        GrayImage imgWin = new GrayImage(w, h);
        double twoPiDivWidth = Math.PI * 2 / (double)w;
        double twoPiDivHeight = Math.PI * 2 / (double)h;
        int y = 0;
        while (y < h) {
            x = 0;
            while (x < w) {
                val = img.get(x, y);
                kb = 0.40243 - 0.49804 * Math.cos(twoPiDivWidth * (double)x) + 0.09831 * Math.cos(twoPiDivWidth * 2.0 * (double)x) - 0.00122 * Math.cos(twoPiDivWidth * 3.0 * (double)x);
                if (inverse) {
                    kb = 1.0 - kb;
                }
                imgWin.set(x, y, (int)(kb * val));
                ++x;
            }
            ++y;
        }
        x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                val = imgWin.get(x, y);
                kb = 0.40243 - 0.49804 * Math.cos(twoPiDivHeight * (double)y) + 0.09831 * Math.cos(twoPiDivHeight * 2.0 * (double)y) - 0.00122 * Math.cos(twoPiDivHeight * 3.0 * (double)y);
                if (inverse) {
                    kb = 1.0 - kb;
                }
                imgWin.set(x, y, (int)(kb * val));
                ++y;
            }
            ++x;
        }
        return imgWin;
    }

    private RealGrayImage filterKBWindow(RealGrayImage img, boolean inverse) {
        double kb;
        double val;
        int x;
        int w = img.X();
        int h = img.Y();
        RealGrayImage imgWin = new RealGrayImage(w, h);
        double twoPiDivWidth = Math.PI * 2 / (double)w;
        double twoPiDivHeight = Math.PI * 2 / (double)h;
        int y = 0;
        while (y < h) {
            x = 0;
            while (x < w) {
                val = img.get(x, y);
                kb = 0.40243 - 0.49804 * Math.cos(twoPiDivWidth * (double)x) + 0.09831 * Math.cos(twoPiDivWidth * 2.0 * (double)x) - 0.00122 * Math.cos(twoPiDivWidth * 3.0 * (double)x);
                if (inverse) {
                    kb = 1.0 - kb;
                }
                imgWin.set(x, y, (float)(kb * val));
                ++x;
            }
            ++y;
        }
        x = 0;
        while (x < w) {
            y = 0;
            while (y < h) {
                val = imgWin.get(x, y);
                kb = 0.40243 - 0.49804 * Math.cos(twoPiDivHeight * (double)y) + 0.09831 * Math.cos(twoPiDivHeight * 2.0 * (double)y) - 0.00122 * Math.cos(twoPiDivHeight * 3.0 * (double)y);
                if (inverse) {
                    kb = 1.0 - kb;
                }
                imgWin.set(x, y, (int)(kb * val));
                ++y;
            }
            ++x;
        }
        return imgWin;
    }

    private void applyWindow(GrayImage img) {
        int y;
        int bw = 8;
        double a = 3.0;
        double valorg = 0.0;
        double valnew = 0.0;
        double exponent = 0.0;
        int x = this.img1_pos.x;
        while (x < this.img2_pos.x + this.img_width) {
            y = 0;
            while (y < this.img_height / bw) {
                valorg = img.get(x, this.img1_pos.y + y);
                exponent = Math.pow(a * (double)y / (double)(this.img_height / bw), 2.0) * -1.0;
                valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                img.set(x, this.img1_pos.y + y, (int)valnew);
                ++y;
            }
            y = 0;
            while (y < this.img_height / bw) {
                valorg = img.get(x, this.img1_pos.y + this.img_height - 1 - y);
                exponent = Math.pow(a * (double)y / (double)(this.img_height / bw), 2.0) * -1.0;
                valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                img.set(x, this.img1_pos.y + this.img_height - 1 - y, (int)valnew);
                ++y;
            }
            ++x;
        }
        y = this.img1_pos.y;
        while (y < this.img1_pos.y + this.img_height) {
            x = 0;
            while (x < this.img_width / bw) {
                valorg = img.get(this.img1_pos.x + x, y);
                exponent = Math.pow(a * (double)x / (double)(this.img_width / bw), 2.0) * -1.0;
                valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                img.set(this.img1_pos.x + x, y, (int)valnew);
                ++x;
            }
            x = 0;
            while (x < this.img_width / bw) {
                valorg = img.get(this.img2_pos.x + this.img_width - 1 - x, y);
                exponent = Math.pow(a * (double)x / (double)(this.img_width / bw), 2.0) * -1.0;
                valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                img.set(this.img2_pos.x + this.img_width - 1 - x, y, (int)valnew);
                ++x;
            }
            ++y;
        }
        if (this.imgs_docked) {
            y = this.img1_pos.y;
            while (y < this.img1_pos.y + this.img_height) {
                x = 0;
                while (x < this.img_width / bw) {
                    valnew = img.get(this.img2_pos.x - x, y);
                    img.set(this.img2_pos.x - 1 - x, y, (int)(valnew += (double)img.get(this.img2_pos.x - 1 - x, y)) / 2);
                    ++x;
                }
                ++y;
            }
            y = this.img1_pos.y;
            while (y < this.img1_pos.y + this.img_height) {
                x = 0;
                while (x < this.img_width / bw) {
                    valnew = img.get(this.img2_pos.x - 1 + x, y);
                    img.set(this.img2_pos.x + x, y, (int)(valnew += (double)img.get(this.img2_pos.x + x, y)) / 2);
                    ++x;
                }
                ++y;
            }
        } else {
            y = this.img1_pos.y;
            while (y < this.img1_pos.y + this.img_height) {
                x = 0;
                while (x < this.img_width / bw) {
                    valorg = img.get(this.img2_pos.x + x, y);
                    exponent = Math.pow(a * (double)x / (double)(this.img_width / bw), 2.0) * -1.0;
                    valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                    img.set(this.img2_pos.x + x, y, (int)valnew);
                    ++x;
                }
                x = 0;
                while (x < this.img_width / bw) {
                    valorg = img.get(this.img1_pos.x + this.img_width - 1 - x, y);
                    exponent = Math.pow(a * (double)x / (double)(this.img_width / bw), 2.0) * -1.0;
                    valnew = valorg * (1.0 - Math.pow(Math.E, exponent));
                    img.set(this.img1_pos.x + this.img_width - 1 - x, y, (int)valnew);
                    ++x;
                }
                ++y;
            }
        }
    }

    public void setDestroyInputImages(boolean destroy) {
        this.destroy_when_ready = destroy;
    }

    public void setApplyWindow(boolean windowing) {
        this.do_windowing = windowing;
    }

    public void setApplySobel(boolean sobel) {
        this.do_sobel = sobel;
    }

    public boolean getDestroyInputImages() {
        return this.destroy_when_ready;
    }

    public boolean getApplyWindow() {
        return this.do_windowing;
    }

    public boolean getApplySobel() {
        return this.do_sobel;
    }

    private GrayImage getMagScaleFromComplexImage(ComplexImage imgcc) {
        GrayImage result = new GrayImage(imgcc.X(), imgcc.Y());
        int xxw = imgcc.X();
        int yyw = imgcc.Y();
        int yy = 0;
        while (yy < yyw) {
            int xx = 0;
            while (xx < xxw) {
                int i = (int)Math.log(1.0 + Math.sqrt(Math.pow(imgcc.getReal(xx, yy), 2.0) + Math.pow(imgcc.getImag(xx, yy), 2.0)));
                if (i < 0) {
                    i *= -1;
                }
                if (i > 255) {
                    i = 255;
                }
                result.set(xx, yy, i);
                ++xx;
            }
            ++yy;
        }
        return result;
    }

    public GrayImage createTranslation(GrayImage img, int posx, int posy, int shiftx, int shifty) {
        GrayImage result = new GrayImage(256, 256);
        int xxw = result.X();
        int yyw = result.Y();
        int yy = yyw / 4;
        while (yy < yyw / 4 * 3) {
            int xx = xxw / 4;
            while (xx < xxw / 2) {
                result.set(xx, yy, img.get(posx + xx, posy + yy));
                result.set(xx + xxw / 4, yy, img.get(posx + shiftx + xx, posy + shifty + yy));
                ++xx;
            }
            ++yy;
        }
        return result;
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(638, 524));
        this.setLayout(this.flowLayout1);
    }

    public GrayImage findLocalMax(ComplexImage imgcc) {
        int width = imgcc.X();
        int height = imgcc.Y();
        GrayImage result = new GrayImage(width, height);
        int max = 5;
        int[] px = new int[max];
        int[] py = new int[max];
        long[] val = new long[max];
        int x_start_search = width / 8;
        int x_end_search = width / 8 * 3;
        int y_start_search = 0;
        int y_end_search = height;
        double average = 0.0;
        int counter = 0;
        int i = 0;
        while (i < max) {
            px[i] = 0;
            py[i] = 0;
            val[i] = 0L;
            ++i;
        }
        int xx = x_start_search;
        while (xx < x_end_search) {
            int yy = y_start_search;
            while (yy < y_end_search) {
                double a = Math.pow(imgcc.getReal(xx, yy), 2.0) + Math.pow(imgcc.getImag(xx, yy), 2.0);
                long b = (long)a;
                average += a / 1000.0;
                ++counter;
                int pos = 0;
                while (pos < max) {
                    if (b > val[pos]) {
                        i = max - 1;
                        i = max - 1;
                        while (i > pos) {
                            px[i] = px[i - 1];
                            py[i] = py[i - 1];
                            val[i] = val[i - 1];
                            --i;
                        }
                        val[pos] = b;
                        px[pos] = xx;
                        py[pos] = yy;
                        pos = max;
                    }
                    ++pos;
                }
                ++yy;
            }
            ++xx;
        }
        i = 0;
        while (i < max) {
            result.set(px[i], py[i], 255);
            ++i;
        }
        double fuzzy = 0.0;
        i = 1;
        while (i < max) {
            fuzzy += Math.sqrt(Math.pow(Math.abs(px[0] - px[i]), 2.0) + Math.pow(Math.abs(py[0] - py[i]), 2.0));
            ++i;
        }
        if (this.verbose) {
            IJ.write((String)("Quality of Cepstrum-Maximum: " + fuzzy));
        }
        this.peakQuality = fuzzy;
        if (this.writeLog) {
            ResultLog logFile = new ResultLog("cepstrum.log");
            logFile.append("" + fuzzy + "|");
        }
        average /= (double)counter;
        double percentAboveAverage = Math.pow(imgcc.getReal(px[0], py[0]), 2.0) + Math.pow(imgcc.getImag(px[0], py[0]), 2.0);
        percentAboveAverage /= (average *= 1000.0);
        if (this.verbose) {
            IJ.write((String)("Cepstrum-Maximum is above Average (in %): " + percentAboveAverage));
        }
        this.peakAboveAverage = percentAboveAverage;
        if (this.writeLog) {
            ResultLog logFile = new ResultLog("cepstrum.log");
            logFile.append("" + percentAboveAverage + "|");
        }
        int shiftx = 0;
        int shifty = 0;
        int midx = x_start_search + (x_end_search - x_start_search) / 2;
        int midy = y_start_search + (y_end_search - y_start_search) / 2;
        shiftx = (midx - px[0]) * -1;
        shifty = (midy - py[0]) * -1;
        if (this.verbose) {
            IJ.write((String)("Cepstrum calculated Translation: " + shiftx + " / " + shifty));
        }
        this.translation_x = shiftx;
        this.translation_y = shifty;
        return result;
    }
}

