/*
 * Decompiled with CFR 0.152.
 */
package jm.cepstrum;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import jm.cepstrum.BicubicInterpolation;
import jm.cepstrum.Cepstrum;
import jm.cepstrum.ResultLog;
import jm.kidney.AnalysisDialog;

public class CepstrumAnalysis
extends Thread {
    private int maxImage = 0;
    private int startImage = 1;
    private boolean verbose = true;
    private boolean secondChance = true;
    private boolean writeLog = true;
    private boolean newWindow = false;
    private int minDiffSwitch = 1000;
    private Image referenceImage = null;
    private Image lastImage = null;
    private Image actualImage = null;
    private AnalysisDialog analysisDialog = null;
    private ImagePlus imagePlus = null;
    private ImageStack imageStack = null;
    private ImageStack newStack = null;
    private int width = 0;
    private int height = 0;
    private Roi rRoi = null;
    private Roi lRoi = null;
    private Rectangle rRect = null;
    private Rectangle lRect = null;
    private double analysisAccuracy = 1.0;
    private int min_x_left;
    private int min_y_left;
    private int max_x_left;
    private int max_y_left;
    private int min_x_right;
    private int min_y_right;
    private int max_x_right;
    private int max_y_right;
    private int lastChangeLeft = 0;
    private int lastChangeRight = 0;
    private double minImageDiff;
    public String seriesDate = "";
    public String studyDate = "";
    public String patientName = "";
    public String patientBirth = "";
    public String patientWeight = "";
    public boolean stopRunning = false;
    public boolean finished = false;
    public boolean error = false;
    public int[] cepstrumQuality = null;

    public CepstrumAnalysis(AnalysisDialog dlg, Roi rightRoi, Roi leftRoi) {
        this.analysisDialog = dlg;
        this.imagePlus = this.analysisDialog.imagePlus;
        this.imageStack = this.imagePlus.getStack();
        this.maxImage = this.imagePlus.getStackSize();
        this.height = this.imagePlus.getHeight();
        this.width = this.imagePlus.getWidth();
        this.min_y_left = this.height + 1;
        this.min_y_right = this.height + 1;
        this.max_y_left = -1;
        this.max_y_right = -1;
        this.analysisAccuracy = 1.0;
        this.lastChangeLeft = 1;
        this.lastChangeRight = 1;
        this.startImage = this.analysisDialog.startImage;
        this.cepstrumQuality = new int[this.maxImage];
        if (leftRoi != null) {
            this.lRoi = leftRoi;
            this.lRect = this.lRoi.getBoundingRect();
            if (this.verbose) {
                IJ.write((String)("left ROI ---  x:" + this.lRect.x + " y: " + this.lRect.y + " w: " + this.lRect.width + " h: " + this.lRect.height));
            }
        }
        if (rightRoi != null) {
            this.rRoi = rightRoi;
            this.rRect = this.rRoi.getBoundingRect();
            if (this.verbose) {
                IJ.write((String)("right ROI ---  x:" + this.rRect.x + " y: " + this.rRect.y + " w: " + this.rRect.width + " h: " + this.rRect.height));
            }
        }
    }

    public void setAccuracy(double accuracy) {
        this.analysisAccuracy = accuracy;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void newWindow(boolean w) {
        this.newWindow = w;
    }

    public void setSecondChance(boolean sc) {
        this.secondChance = sc;
    }

    public void setWriteLog(boolean log) {
        this.writeLog = log;
    }

    public void setMinDiff(int s) {
        this.minDiffSwitch = s;
    }

    public void run() {
        int i = 0;
        ColorModel cm = this.imageStack.getColorModel();
        this.newStack = new ImageStack(this.width, this.height, cm);
        i = 1;
        while (i <= this.startImage) {
            this.newStack.addSlice(this.imageStack.getSliceLabel(i), this.imageStack.getPixels(i));
            ++i;
        }
        Point shift = new Point(0, 0);
        Point firstShift = new Point(0, 0);
        Point secondShift = new Point(0, 0);
        double firstMinDiff = 4.0;
        double secondMinDiff = 4.0;
        Cepstrum cepstrumFilter = new Cepstrum();
        cepstrumFilter.showImages = false;
        cepstrumFilter.setVerbose(this.verbose);
        cepstrumFilter.setWriteLog(this.writeLog);
        ByteProcessor leftIP_ref = null;
        ByteProcessor leftIP_act = null;
        ByteProcessor rightIP_ref = null;
        ByteProcessor rightIP_act = null;
        this.analysisDialog.setCepstrumResult(0, this.startImage, 0);
        this.analysisDialog.setCepstrumResult(1, this.startImage, 0);
        try {
            if (this.lRect != null) {
                int lrw = (int)Math.ceil((double)this.lRect.width * this.analysisAccuracy);
                int lrh = (int)Math.ceil((double)this.lRect.height * this.analysisAccuracy);
                leftIP_ref = new ByteProcessor(lrw, lrh, new byte[lrw * lrh], cm);
                leftIP_act = new ByteProcessor(lrw, lrh, new byte[lrw * lrh], cm);
            }
            if (this.rRect != null) {
                int rrw = (int)Math.ceil((double)this.rRect.width * this.analysisAccuracy);
                int rrh = (int)Math.ceil((double)this.rRect.height * this.analysisAccuracy);
                rightIP_ref = new ByteProcessor(rrw, rrh, new byte[rrw * rrh], cm);
                rightIP_act = new ByteProcessor(rrw, rrh, new byte[rrw * rrh], cm);
            }
            if (this.lRect == null && this.rRect == null) {
                return;
            }
            IJ.showProgress((double)0.001);
            int maxProgress = 0;
            int counter = 0;
            if (this.lRect != null) {
                ++maxProgress;
            }
            if (this.rRect != null) {
                ++maxProgress;
            }
            counter = (this.startImage - 2) * maxProgress;
            maxProgress = maxProgress * 2 * (this.maxImage - (this.startImage - 1));
            i = this.startImage + 1;
            while (!this.stopRunning && i <= this.maxImage) {
                int half = 0;
                while (half <= 1) {
                    int lastChangeHalf;
                    ByteProcessor halfIP_act;
                    ByteProcessor halfIP_ref;
                    String strHalf;
                    Rectangle rect;
                    if (half == 0) {
                        rect = this.lRect;
                        strHalf = "left";
                        halfIP_ref = leftIP_ref;
                        halfIP_act = leftIP_act;
                        lastChangeHalf = this.lastChangeLeft;
                    } else {
                        rect = this.rRect;
                        strHalf = "right";
                        halfIP_ref = rightIP_ref;
                        halfIP_act = rightIP_act;
                        lastChangeHalf = this.lastChangeRight;
                    }
                    try {
                        CepstrumAnalysis.sleep(5L);
                    }
                    catch (InterruptedException ie) {
                        IJ.write((String)"Interrupted in Ceptrum-Filter !");
                    }
                    if (rect != null) {
                        if (this.writeLog) {
                            ResultLog logFile = new ResultLog("cepstrum.log");
                            logFile.append("" + this.patientName + "|" + this.patientBirth + "|" + this.patientWeight + "|" + this.studyDate + "|" + this.seriesDate + "|" + i + "|" + strHalf + "|" + this.analysisAccuracy + "|");
                        }
                        if (this.verbose) {
                            IJ.write((String)"__________________________________________");
                        }
                        if (this.verbose) {
                            IJ.write((String)("Movement Correction for Image " + i + " - " + strHalf));
                        }
                        boolean firstTry = true;
                        boolean secondTry = false;
                        int tryCounter = 0;
                        while (firstTry || secondTry) {
                            ++tryCounter;
                            int lastGoodResult = i - 1;
                            while (this.cepstrumQuality[lastGoodResult] > 4 && lastGoodResult > 1) {
                                --lastGoodResult;
                            }
                            if (secondTry && lastGoodResult > 1) {
                                --lastGoodResult;
                                while (this.cepstrumQuality[lastGoodResult] > 4 && lastGoodResult > 1) {
                                    --lastGoodResult;
                                }
                            }
                            this.prepareImages(half, halfIP_ref, lastGoodResult, halfIP_act, i);
                            halfIP_act = this.histogramEquilisation((ImageProcessor)halfIP_ref, (ImageProcessor)halfIP_act);
                            firstTry = false;
                            if (i - lastChangeHalf < this.minDiffSwitch) {
                                int range;
                                IJ.showStatus((String)(" Image " + i + " / " + this.maxImage + " - Cepstrum-Filter " + strHalf + " kidney"));
                                this.referenceImage = halfIP_ref.createImage();
                                this.actualImage = halfIP_act.createImage();
                                boolean success = cepstrumFilter.calculateTranslation(this.referenceImage, this.actualImage, shift);
                                if (this.writeLog) {
                                    ResultLog logFile = new ResultLog("cepstrum.log");
                                    logFile.append("" + shift.x + "|" + shift.y + "|" + (double)shift.x / this.analysisAccuracy + "|" + (double)shift.y / this.analysisAccuracy + "|");
                                }
                                if ((range = (int)Math.round(this.analysisAccuracy * 2.0)) > 7) {
                                    range = 7;
                                }
                                this.minImageDiff = this.checkCepstrumResult((ImageProcessor)halfIP_ref, (ImageProcessor)halfIP_act, range, 2, shift);
                            } else {
                                IJ.showStatus((String)(" Image " + i + " / " + this.maxImage + " - Minimum-Difference filter " + strHalf + " kidney"));
                                this.linearTranslationCorrection(halfIP_ref, halfIP_act, half, shift);
                            }
                            try {
                                CepstrumAnalysis.sleep(5L);
                            }
                            catch (InterruptedException ie) {
                                IJ.write((String)"Interrupted in Ceptrum-Filter !");
                            }
                            IJ.showProgress((double)((double)(++counter) / (double)maxProgress));
                            if (secondTry) {
                                secondMinDiff = this.minImageDiff;
                                secondShift.x = shift.x;
                                secondShift.y = shift.y;
                            } else {
                                firstMinDiff = this.minImageDiff;
                                firstShift.x = shift.x;
                                firstShift.y = shift.y;
                            }
                            this.cepstrumQuality[i - 1] = 5;
                            if (cepstrumFilter.peakQuality <= 20.0 && cepstrumFilter.peakAboveAverage >= 150.0 && this.minImageDiff <= 21.0) {
                                this.cepstrumQuality[i - 1] = 4;
                            }
                            if (cepstrumFilter.peakQuality <= 13.0 && cepstrumFilter.peakAboveAverage >= 200.0 && this.minImageDiff <= 14.0) {
                                this.cepstrumQuality[i - 1] = 3;
                            }
                            if (cepstrumFilter.peakQuality <= 10.0 && cepstrumFilter.peakAboveAverage >= 200.0 && this.minImageDiff <= 11.0) {
                                this.cepstrumQuality[i - 1] = 2;
                            }
                            if (cepstrumFilter.peakQuality <= 8.0 && cepstrumFilter.peakAboveAverage >= 300.0 && this.minImageDiff <= 7.0) {
                                this.cepstrumQuality[i - 1] = 1;
                            }
                            this.analysisDialog.setCepstrumResult(half, i, this.cepstrumQuality[i - 1]);
                            secondTry = this.cepstrumQuality[i - 1] == 5 && !secondTry;
                        }
                        if (tryCounter == 2) {
                            IJ.write((String)"DRIN1");
                            Point temp = this.compareShifts(firstShift, firstMinDiff, secondShift, secondMinDiff);
                            shift.x = temp.x;
                            shift.y = temp.y;
                        }
                        this.applyShift(i, half, shift);
                        if (this.writeLog) {
                            ResultLog logFile = new ResultLog("cepstrum.log");
                            logFile.append("" + shift.x + "|" + shift.y + "|" + (double)shift.x / this.analysisAccuracy + "|" + (double)shift.y / this.analysisAccuracy + "\r\n");
                        }
                        IJ.showProgress((double)((double)(++counter) / (double)maxProgress));
                    }
                    ++half;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.error = true;
            e.printStackTrace();
            IJ.write((String)"Error in Movement Correction !");
        }
        if (i > this.maxImage) {
            this.finished = true;
            i = 1;
            while (i <= this.maxImage) {
                this.imageStack.deleteLastSlice();
                ++i;
            }
            i = 1;
            while (i <= this.maxImage) {
                this.imageStack.addSlice(this.newStack.getSliceLabel(i), this.newStack.getPixels(i));
                ++i;
            }
        }
        this.imagePlus.updateAndDraw();
        if (this.verbose) {
            IJ.write((String)"Movement Correction finished");
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
        this.stopRunning = true;
        if (cepstrumFilter.showImages) {
            cepstrumFilter.fftStack.setColorModel(cm);
            cepstrumFilter.fft2Stack.setColorModel(cm);
            cepstrumFilter.psStack.setColorModel(cm);
            cepstrumFilter.ps2Stack.setColorModel(cm);
            cepstrumFilter.orgStack.setColorModel(cm);
            ImagePlus test1 = new ImagePlus("fftImage", cepstrumFilter.fftStack);
            ImagePlus test2 = new ImagePlus("fft2Image", cepstrumFilter.fft2Stack);
            ImagePlus test3 = new ImagePlus("psImage", cepstrumFilter.psStack);
            ImagePlus test4 = new ImagePlus("ps2Image", cepstrumFilter.ps2Stack);
            ImagePlus test5 = new ImagePlus("orgImage", cepstrumFilter.orgStack);
            test1.show();
            IJ.wait((int)500);
            test2.show();
            IJ.wait((int)500);
            test3.show();
            IJ.wait((int)500);
            test4.show();
            IJ.wait((int)500);
            test5.show();
            IJ.wait((int)500);
        }
        this.newStack = null;
        this.analysisDialog.cepstrumFinished();
        this.imagePlus.unlock();
    }

    private Point compareShifts(Point p1, double m1, Point p2, double m2) {
        double tr = 22.0;
        double e1 = Math.abs((double)p1.x / this.analysisAccuracy) + Math.abs((double)p1.y / this.analysisAccuracy);
        double e2 = Math.abs((double)p2.x / this.analysisAccuracy) + Math.abs((double)p2.y / this.analysisAccuracy);
        if (e1 < tr && e2 > tr) {
            return p1;
        }
        if (e1 > tr && e2 < tr) {
            return p2;
        }
        if (e1 < e2) {
            return p1;
        }
        return p2;
    }

    private void applyShift(int slice, int half, Point shift) {
        int stop_half;
        int start_half;
        boolean change;
        short[] pix_org = new short[this.width * this.height];
        pix_org = (short[])this.imageStack.getPixels(slice);
        short[] pix = new short[this.width * this.height];
        System.arraycopy(pix_org, 0, pix, 0, this.width * this.height);
        double shift_x = (double)shift.x / this.analysisAccuracy;
        double shift_y = (double)shift.y / this.analysisAccuracy;
        if (half == 0) {
            change = false;
            if (shift.y < this.min_y_left) {
                this.min_y_left = shift.y;
                this.min_x_left = shift.x;
                change = true;
            }
            if (shift.y > this.max_y_left) {
                this.max_y_left = shift.y;
                this.max_x_left = shift.x;
                change = true;
            }
            if (change) {
                ++this.lastChangeLeft;
            }
        } else {
            change = false;
            if (shift.y < this.min_y_right) {
                this.min_y_right = shift.y;
                this.min_x_right = shift.x;
                change = true;
            }
            if (shift.y > this.max_y_right) {
                this.max_y_right = shift.y;
                this.max_x_right = shift.x;
                change = true;
            }
            if (change) {
                ++this.lastChangeRight;
            }
        }
        if (this.verbose) {
            IJ.write((String)("shifting Images, shift: x=" + shift_x + " y=" + shift_y));
        }
        if (half == 0) {
            start_half = 0;
            stop_half = this.width / 2;
        } else {
            start_half = this.width / 2;
            stop_half = this.width;
        }
        int start_x = start_half;
        int stop_x = stop_half;
        int adder_x = 1;
        int start_y = 0;
        int stop_y = this.height;
        int adder_y = 1;
        if (shift.x > 0) {
            start_x = stop_half - 1;
            stop_x = start_half - 1;
            adder_x = -1;
        }
        if (shift.y > 0) {
            start_y = this.height - 1;
            stop_y = -1;
            adder_y = -1;
        }
        if (!(this.analysisAccuracy > 1.0)) {
            int y = start_y;
            while (y != stop_y) {
                int x = start_x;
                while (x != stop_x) {
                    short val = pix[y * this.width + x];
                    int px = x + (int)Math.round(shift_x);
                    int py = y + (int)Math.round(shift_y);
                    if (px >= start_half && py >= 0 && px < stop_half && py < this.height) {
                        pix[py * this.width + px] = val;
                    }
                    x += adder_x;
                }
                y += adder_y;
            }
        } else {
            BicubicInterpolation bic = new BicubicInterpolation(pix, this.width, this.height);
            int y = start_y;
            while (y != stop_y) {
                int x = start_x;
                while (x != stop_x) {
                    int val = bic.getPixel((double)x - shift_x, (double)y - shift_y);
                    pix[y * this.width + x] = (short)val;
                    x += adder_x;
                }
                y += adder_y;
            }
        }
        if (this.newStack.getSize() == slice) {
            this.newStack.deleteLastSlice();
        }
        this.newStack.addSlice(this.imageStack.getSliceLabel(slice), (Object)pix);
        this.imageStack.setPixels((Object)pix, slice);
    }

    double checkCepstrumResult(ImageProcessor ip_ref, ImageProcessor ip_act, int range, int accuracy, Point shift) {
        int i;
        if (range < 1 || accuracy < 1) {
            return -1.0;
        }
        if (this.verbose) {
            IJ.write((String)"Checking result...");
        }
        short[][] pix = new short[ip_ref.getWidth() * ip_ref.getHeight() * 2][];
        int startx = range;
        int endx = ip_ref.getWidth() - range;
        int starty = range;
        int endy = ip_ref.getHeight() - range;
        if (shift.x < 0) {
            startx += Math.abs(shift.x);
        } else {
            endx -= shift.x;
        }
        if (shift.y < 0) {
            starty += Math.abs(shift.y);
        } else {
            endy -= shift.y;
        }
        double[][] add = new double[range * 2 + 1][range * 2 + 1];
        int j = range * -1;
        while (j <= range) {
            i = range * -1;
            while (i <= range) {
                int counter = 0;
                add[i + range][j + range] = 0.0;
                int y = starty;
                while (y < endy) {
                    int offset = y % accuracy;
                    int x = startx + offset;
                    while (x < endx) {
                        add[i + range][j + range] = add[i + range][j + range] + (double)Math.abs(ip_ref.getPixel(x, y) - ip_act.getPixel(x - shift.x - i, y - shift.y - j));
                        ++counter;
                        x += accuracy;
                    }
                    ++y;
                }
                add[i + range][j + range] = add[i + range][j + range] / (double)counter;
                ++i;
            }
            ++j;
        }
        int min_i = -1;
        int min_j = -1;
        double min_val = Double.MAX_VALUE;
        j = range * -1;
        while (j <= range) {
            i = range * -1;
            while (i <= range) {
                if (add[i + range][j + range] < min_val) {
                    min_val = add[i + range][j + range];
                    min_i = i;
                    min_j = j;
                }
                ++i;
            }
            ++j;
        }
        shift.x += min_i;
        shift.y += min_j;
        if (this.verbose) {
            IJ.write((String)("Found MinDiffValue " + add[min_i + range][min_j + range] + " at i: " + min_i + " j: " + min_j + " -> correcting Shift to x:" + shift.x + " y: " + shift.y));
        }
        ResultLog log07 = new ResultLog("cepstrum.log");
        log07.append("" + add[min_i + range][min_j + range] + "|");
        return add[min_i + range][min_j + range];
    }

    private void getDeformationMatrix(int slice, int half, ImageProcessor ip_act, Point shift) {
        int rect_y;
        int rect_x;
        int rect_height;
        int rect_width;
        short[] pix = new short[this.width * this.height];
        pix = (short[])this.imageStack.getPixels(slice);
        BicubicInterpolation bi_ref = new BicubicInterpolation(pix, this.width, this.height);
        int[] pix_ref = new int[81];
        if (half == 0) {
            rect_width = this.lRect.width;
            rect_height = this.lRect.height;
            rect_x = this.lRect.x;
            rect_y = this.lRect.y;
        } else {
            rect_width = this.rRect.width;
            rect_height = this.rRect.height;
            rect_x = this.rRect.x;
            rect_y = this.rRect.y;
        }
        int matrixX = rect_width / 5;
        int matrixY = rect_height / 5;
        double factor = 1.0 / this.analysisAccuracy;
        int j = 0;
        while (j < matrixY) {
            int i = 0;
            while (i < matrixX) {
                int sy;
                int counterX = 0;
                int sx = -2;
                while (sx < 7) {
                    int counterY = 0;
                    sy = -2;
                    while (sy < 7) {
                        double dx = (double)(rect_x + i * 5) + (double)sx * factor;
                        double dy = (double)(rect_y + j * 5) + (double)sy * factor;
                        pix_ref[counterY * 9 + counterX] = bi_ref.getPixel(dx, dy);
                        ++counterY;
                        ++sy;
                    }
                    ++counterX;
                    ++sx;
                }
                int x = 0;
                while (x < 4) {
                    int y = 0;
                    while (y < 4) {
                        sx = i * 5 + x;
                        sy = j * 5 + y;
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
            ++j;
        }
    }

    private void prepareImages(int half, ByteProcessor ip_ref, int slice_ref, ByteProcessor ip_act, int slice_act) {
        int rect_y;
        int rect_x;
        int rect_height;
        int rect_width;
        if (this.verbose) {
            IJ.write((String)("Preparing Images for Cepstrum Filter. Accuracy is " + this.analysisAccuracy));
        }
        short[][] pix = new short[][]{(short[])this.imageStack.getPixels(slice_ref), (short[])this.imageStack.getPixels(slice_act)};
        if (half == 0) {
            rect_width = this.lRect.width;
            rect_height = this.lRect.height;
            rect_x = this.lRect.x;
            rect_y = this.lRect.y;
        } else {
            rect_width = this.rRect.width;
            rect_height = this.rRect.height;
            rect_x = this.rRect.x;
            rect_y = this.rRect.y;
        }
        if (!(this.analysisAccuracy > 1.0)) {
            int x = 0;
            while (x < rect_width) {
                int y = 0;
                while (y < rect_height) {
                    short val_ref = pix[0][(y + rect_y) * this.width + x + rect_x];
                    short val_act = pix[1][(y + rect_y) * this.width + x + rect_x];
                    ip_ref.putPixel(x, y, (int)val_ref);
                    ip_act.putPixel(x, y, (int)val_act);
                    ++y;
                }
                ++x;
            }
        } else {
            if (rect_x + rect_width >= this.width) {
                rect_width = this.width - rect_x - 1;
            }
            if (rect_y + rect_height >= this.height) {
                rect_height = this.height - rect_y - 1;
            }
            double adder = 1.0 / this.analysisAccuracy;
            BicubicInterpolation bi_ref = new BicubicInterpolation(pix[0], this.width, this.height);
            BicubicInterpolation bi_act = new BicubicInterpolation(pix[1], this.width, this.height);
            int x = 0;
            double dx = 0.0;
            while (dx < (double)rect_width) {
                int y = 0;
                double dy = 0.0;
                while (dy < (double)rect_height) {
                    double px = dx + (double)rect_x;
                    double py = dy + (double)rect_y;
                    short val_ref = (short)bi_ref.getPixel(px, py);
                    short val_act = (short)bi_act.getPixel(px, py);
                    ip_ref.putPixel(x, y, (int)val_ref);
                    ip_act.putPixel(x, y, (int)val_act);
                    ++y;
                    dy += adder;
                }
                ++x;
                dx += adder;
            }
        }
    }

    int linearTranslationCorrection(ByteProcessor ip_ref, ByteProcessor ip_act, int half, Point shift) {
        int vy;
        int dy;
        int vx;
        int dx;
        int yb;
        int xb;
        int ya;
        int xa;
        int result = -1;
        int offsetx = 0;
        int offsety = 0;
        int counter = 0;
        Point actPoint = new Point(0, 0);
        Point bestPoint = new Point(0, 0);
        double minDiffVal = Double.MAX_VALUE;
        double actDiffVal = 0.0;
        if (half == 0) {
            xa = this.min_x_left + offsetx;
            ya = this.min_y_left + offsety;
            xb = this.max_x_left + offsetx;
            yb = this.max_y_left + offsety;
        } else {
            xa = this.min_x_right + offsetx;
            ya = this.min_y_right + offsety;
            xb = this.max_x_right + offsetx;
            yb = this.max_y_right + offsety;
        }
        if (xb > xa) {
            dx = 1;
            vx = yb - ya;
        } else {
            dx = -1;
            vx = ya - yb;
        }
        if (yb > ya) {
            dy = 1;
            vy = xa - xb;
        } else {
            dy = -1;
            vy = xb - xa;
        }
        int fa = 0;
        int x = xa;
        int y = ya;
        while (x != xb || y != yb) {
            if (counter++ % 2 == 0) {
                actPoint.x = x;
                actPoint.y = y;
                actDiffVal = this.findMinDiffValue(ip_ref, ip_act, actPoint);
                if (actDiffVal < minDiffVal) {
                    minDiffVal = actDiffVal;
                    bestPoint.x = actPoint.x;
                    bestPoint.y = actPoint.y;
                }
            }
            int fx = fa + vx;
            int fy = fa + vy;
            int fxy = fx + fy - fa;
            if (Math.abs(fx) <= Math.abs(fy) && Math.abs(fx) <= Math.abs(fxy)) {
                x += dx;
                fa = fx;
                continue;
            }
            if (Math.abs(fy) < Math.abs(fx) && Math.abs(fy) < Math.abs(fxy)) {
                fa = fy;
                y += dy;
                continue;
            }
            fa = fxy;
            x += dx;
            y += dy;
        }
        actPoint.x = x;
        actPoint.y = y;
        actDiffVal = this.findMinDiffValue(ip_ref, ip_act, actPoint);
        if (actDiffVal < minDiffVal) {
            minDiffVal = actDiffVal;
            bestPoint.x = actPoint.x;
            bestPoint.y = actPoint.y;
        }
        shift.x = bestPoint.x;
        shift.y = bestPoint.y;
        return result;
    }

    private double findMinDiffValue(ByteProcessor ip_ref, ByteProcessor ip_act, Point shift) {
        int r = (int)Math.round(this.analysisAccuracy * 2.0);
        if (r > 7) {
            r = 7;
        }
        return this.checkCepstrumResult((ImageProcessor)ip_ref, (ImageProcessor)ip_act, r, 2, shift);
    }

    public ByteProcessor filterSobel(ByteProcessor ip) {
        byte[] pixel = (byte[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] sobel = new byte[width * height];
        byte p1 = 0;
        byte p2 = 0;
        byte p3 = 0;
        byte p4 = 0;
        byte p5 = 0;
        byte p6 = 0;
        byte p7 = 0;
        byte p8 = 0;
        byte p9 = 0;
        int sobelResult = 0;
        int sobelX = 0;
        int sobelY = 0;
        int y = 1;
        while (y < height - 1) {
            int x = 1;
            while (x < width - 1) {
                if (x > 0) {
                    p1 = pixel[(y - 1) * width + (x - 1)];
                    p2 = pixel[(y - 1) * width + x];
                    p3 = pixel[(y - 1) * width + (x + 1)];
                    p4 = pixel[y * width + (x - 1)];
                    p5 = pixel[y * width + x];
                    p6 = pixel[y * width + (x + 1)];
                    p7 = pixel[(y + 1) * width + (x - 1)];
                    p8 = pixel[(y + 1) * width + x];
                    p9 = pixel[(y + 1) * width + (x + 1)];
                } else {
                    p1 = p2;
                    p2 = p3;
                    p3 = pixel[(y - 0) * width + (x - 0)];
                    p4 = p5;
                    p5 = p6;
                    p6 = pixel[(y - 0) * width + (x - 0)];
                    p7 = p8;
                    p8 = p9;
                    p9 = pixel[(y - 0) * width + (x - 0)];
                }
                sobelX = p7 + 2 * p8 + p9 - p1 - 2 * p2 - p3;
                sobelY = p3 + 2 * p6 + p9 - p1 - 2 * p4 - p7;
                sobelX = Math.abs(sobelX);
                sobelY = Math.abs(sobelY);
                sobelResult = (sobelX + sobelY) / 2;
                if (sobelResult > 255) {
                    sobelResult = 255;
                }
                sobel[y * width + x] = (byte)sobelResult;
                ++x;
            }
            ++y;
        }
        ByteProcessor result = new ByteProcessor(width, height, sobel, ip.getColorModel());
        return result;
    }

    private ByteProcessor histogramEquilisation(ImageProcessor refIP, ImageProcessor aktIP) {
        if (refIP == null && aktIP == null) {
            return null;
        }
        byte[] orgPixel = (byte[])aktIP.getPixels();
        int width = refIP.getWidth();
        int height = refIP.getHeight();
        int[] aktPixel = new int[width * height];
        ImagePlus refImp = new ImagePlus("", refIP);
        ImagePlus aktImp = new ImagePlus("", aktIP);
        ImageStatistics refStat = refImp.getStatistics();
        ImageStatistics aktStat = aktImp.getStatistics();
        double refMin = refStat.min;
        double refMax = refStat.max;
        double aktMin = aktStat.min;
        double aktMax = aktStat.max;
        double c0 = refMin - aktMin;
        aktMin += c0;
        aktMax += c0;
        int i = 0;
        while (i < width * height) {
            aktPixel[i] = orgPixel[i] + (int)c0;
            ++i;
        }
        i = 0;
        while (i < width * height) {
            double val = aktPixel[i];
            double d = (val - aktMin) / (aktMax - aktMin);
            double e = refMin + d * (refMax - refMin);
            aktPixel[i] = (int)e;
            ++i;
        }
        i = 0;
        while (i < width * height) {
            orgPixel[i] = (byte)aktPixel[i];
            ++i;
        }
        ByteProcessor result = new ByteProcessor(width, height, orgPixel, refIP.getColorModel());
        return result;
    }
}

