/*
 * Decompiled with CFR 0.152.
 */
package jm.extension;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import jm.extension.AddRoiDialog;
import jm.extension.AwtToolTip;
import jm.extension.AwtToolTipHelper;
import jm.kidney.AnalysisDialog;
import jm.kidney.ManualMover;

public class ExImageCanvas
extends ImageCanvas
implements ComponentListener,
KeyListener {
    private Roi[] leftRoi = null;
    private Roi[] rightRoi = null;
    private Roi[][] leftRoiCortex = null;
    private Roi[][] rightRoiCortex = null;
    private Roi[][] leftRoiMedulla = null;
    private Roi[][] rightRoiMedulla = null;
    private Roi dummy = null;
    private Roi actualSelection = null;
    private Roi storedRoi = null;
    private Color darkgreen = new Color(0, 180, 0);
    private Color darkred = new Color(136, 0, 0);
    private Color[][] buttonBorderColor;
    private Color myYellow = new Color(243, 239, 118);
    private Color myWhite = Color.white;
    private Color myRed = new Color(227, 75, 75);
    private Color myOrange = new Color(251, 196, 77);
    private Point buttonPos = new Point(30, 0);
    private static final int buttonWidth = 18;
    private static final int buttonHeight = 10;
    private ImagePlus imagePlus = null;
    private ImageStack imageStack = null;
    private String[] acquisitionTime = null;
    private String[][] cepstrumEvaluation = null;
    private boolean[][] manualSelector = null;
    private boolean storeNextCanvasSize = false;
    private boolean altKeyDown = false;
    private boolean delKeyDown = false;
    private int maxImage;
    private int slice;
    private int width;
    private int height;
    private int xMouse;
    private int yMouse;
    private Color textColor;
    private int widthDiv2;
    private AnalysisDialog analysisDialog = null;
    public static final int MAXROIS = 100;
    private static final int CANCEL = 0;
    private static final int ALL = 1;
    private static final int CURRENT = 2;
    private static final int BUTTON1LEFT = 1;
    private static final int BUTTON2LEFT = 2;
    private static final int BUTTON3LEFT = 3;
    private static final int BUTTON1RIGHT = 4;
    private static final int BUTTON2RIGHT = 5;
    private static final int BUTTON3RIGHT = 6;
    private static final int SELECTORLEFT = 7;
    private static final int SELECTORRIGHT = 8;
    private static final int MOVELEFT = 9;
    private static final int MOVERIGHT = 10;
    private Rectangle rect = null;
    private Rectangle repaintRect = new Rectangle(0, 0, 1, 1);
    private Rectangle lastRect = new Rectangle(0, 0, 1, 1);
    private boolean repaintDone = true;
    private Font font = new Font("Dialog", 0, 10);
    private boolean dontAskAgain = false;
    private JLabel toolTipLabel = new JLabel("lock right main roi");
    public AwtToolTip awtToolTip = new AwtToolTip();
    private AwtToolTipHelper awtToolTipHelper = new AwtToolTipHelper();
    private Cursor defaultCursor = new Cursor(0);

    public ExImageCanvas(ImagePlus imp) {
        super(imp);
        this.imagePlus = imp;
        this.imageStack = imp.getStack();
        this.maxImage = this.imageStack.getSize();
        this.addMouseMotionListener(this.awtToolTip);
        this.addMouseListener(this.awtToolTipHelper);
        this.awtToolTip.setSourceClass(this);
        this.addComponentListener(this);
        this.addKeyListener(this);
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.widthDiv2 = this.width / 2;
        this.cepstrumEvaluation = new String[2][this.maxImage];
        this.manualSelector = new boolean[2][this.maxImage];
        this.leftRoi = new Roi[this.maxImage];
        this.rightRoi = new Roi[this.maxImage];
        this.leftRoiCortex = new Roi[this.maxImage][100];
        this.rightRoiCortex = new Roi[this.maxImage][100];
        this.leftRoiMedulla = new Roi[this.maxImage][100];
        this.rightRoiMedulla = new Roi[this.maxImage][100];
        this.slice = 0;
        while (this.slice < this.maxImage) {
            this.cepstrumEvaluation[0][this.slice] = "na";
            this.cepstrumEvaluation[1][this.slice] = "na";
            this.manualSelector[0][this.slice] = false;
            this.manualSelector[1][this.slice] = false;
            this.leftRoi[this.slice] = null;
            this.rightRoi[this.slice] = null;
            ++this.slice;
        }
        this.buttonBorderColor = new Color[2][3];
        this.slice = 0;
        while (this.slice < 3) {
            this.buttonBorderColor[0][this.slice] = Color.darkGray;
            this.buttonBorderColor[1][this.slice] = Color.darkGray;
            ++this.slice;
        }
        JToolTip toolTip = new JToolTip();
        this.awtToolTip.setDismissDelay(ToolTipManager.sharedInstance().getDismissDelay());
        this.awtToolTip.setInitialDelay(ToolTipManager.sharedInstance().getInitialDelay());
        this.toolTipLabel.setBackground(toolTip.getBackground());
        this.toolTipLabel.setForeground(toolTip.getForeground());
        this.toolTipLabel.setFont(new Font("Dialog", 0, 9));
    }

    private void setToolTipText(String text) {
        this.toolTipLabel.setText(text);
    }

    public void setManualSelector(int half, boolean selected) {
        this.slice = 0;
        while (this.slice < this.maxImage) {
            this.manualSelector[half][this.slice] = selected;
            ++this.slice;
        }
    }

    public void setParent(AnalysisDialog dlg) {
        this.analysisDialog = dlg;
    }

    public void setRoi(int half, Roi roi) {
        if (roi == null) {
            return;
        }
        int roiPos = roi.getBoundingRect().x + roi.getBoundingRect().width / 2;
        if (roiPos < this.imagePlus.getWidth() / 2 && half == 1) {
            return;
        }
        if (roiPos >= this.imagePlus.getWidth() / 2 && half == 0) {
            return;
        }
        Roi[] roiArray = half == 0 ? this.leftRoi : this.rightRoi;
        this.slice = 0;
        while (this.slice < this.maxImage) {
            Roi nr = (Roi)roi.clone();
            nr.setImage(this.imagePlus);
            roiArray[this.slice] = nr;
            ++this.slice;
        }
        this.imagePlus.killRoi();
        this.repaint();
    }

    public void setRoi(int slice, int half, Roi roi) {
        if (roi == null) {
            return;
        }
        int roiPos = roi.getBoundingRect().x + roi.getBoundingRect().width / 2;
        if (roiPos < this.imagePlus.getWidth() / 2 && half == 1) {
            return;
        }
        if (roiPos >= this.imagePlus.getWidth() / 2 && half == 0) {
            return;
        }
        if (half == 0) {
            this.leftRoi[slice] = roi;
        } else {
            this.rightRoi[slice] = roi;
        }
        this.imagePlus.killRoi();
        this.repaint();
    }

    public void addToRoiArray(int slice, int half, int tissue, Roi roi) {
        if (roi == null) {
            return;
        }
        int roiPos = roi.getBoundingRect().x + roi.getBoundingRect().width / 2;
        if (roiPos < this.imagePlus.getWidth() / 2 && half == 1) {
            return;
        }
        if (roiPos >= this.imagePlus.getWidth() / 2 && half == 0) {
            return;
        }
        Roi[][] roiArray = half == 0 ? (tissue == 2 ? this.leftRoiMedulla : this.leftRoiCortex) : (tissue == 2 ? this.rightRoiMedulla : this.rightRoiCortex);
        int pos = 0;
        boolean success = false;
        while (!success && pos < 100) {
            if (roiArray[slice][pos] == null) {
                roiArray[slice][pos] = roi;
                success = true;
            }
            ++pos;
        }
        if (success) {
            this.compressRoiArray(slice, roiArray);
            this.imagePlus.killRoi();
            this.repaint();
        }
    }

    public void addToRoiArray(int half, int tissue, Roi roi) {
        if (roi == null) {
            return;
        }
        int roiPos = roi.getBoundingRect().x + roi.getBoundingRect().width / 2;
        if (roiPos < this.imagePlus.getWidth() / 2 && half == 1) {
            return;
        }
        if (roiPos >= this.imagePlus.getWidth() / 2 && half == 0) {
            return;
        }
        boolean atLeastOneRoiAdded = false;
        Roi[][] roiArray = half == 0 ? (tissue == 2 ? this.leftRoiMedulla : this.leftRoiCortex) : (tissue == 2 ? this.rightRoiMedulla : this.rightRoiCortex);
        this.slice = 0;
        while (this.slice < this.maxImage) {
            int pos = 0;
            boolean success = false;
            while (!success && pos < 100) {
                if (roiArray[this.slice][pos] == null) {
                    roiArray[this.slice][pos] = roi;
                    success = true;
                }
                ++pos;
            }
            if (success) {
                atLeastOneRoiAdded = true;
                this.compressRoiArray(this.slice, roiArray);
            }
            ++this.slice;
        }
        if (atLeastOneRoiAdded) {
            this.imagePlus.killRoi();
            this.repaint();
        }
    }

    private void compressRoiArray(int slice, Roi[][] roiArray) {
        int i = 0;
        while (i < 100) {
            if (roiArray[slice][i] == null) {
                int j = i + 1;
                while (j < 100 && roiArray[slice][j] == null) {
                    ++j;
                }
                if (j < 100) {
                    roiArray[slice][i] = roiArray[slice][j];
                    roiArray[slice][j] = null;
                } else {
                    i = 100;
                }
            }
            ++i;
        }
    }

    public void deleteRois(int half, int tissue) {
        this.slice = 0;
        while (this.slice < this.maxImage) {
            int i;
            if (tissue == 5) {
                if (half == 0) {
                    this.leftRoi[this.slice] = null;
                }
                if (half == 1) {
                    this.rightRoi[this.slice] = null;
                }
            }
            if (tissue == 2) {
                i = 0;
                while (i < 100) {
                    if (half == 0) {
                        this.leftRoiMedulla[this.slice][i] = null;
                    }
                    if (half == 1) {
                        this.rightRoiMedulla[this.slice][i] = null;
                    }
                    ++i;
                }
            }
            if (tissue == 3) {
                i = 0;
                while (i < 100) {
                    if (half == 0) {
                        this.leftRoiCortex[this.slice][i] = null;
                    }
                    if (half == 1) {
                        this.rightRoiCortex[this.slice][i] = null;
                    }
                    ++i;
                }
            }
            ++this.slice;
        }
    }

    public Roi[] getRoi(int half) {
        Roi[] result = null;
        if (half == 0) {
            result = this.leftRoi;
        }
        if (half == 1) {
            result = this.rightRoi;
        }
        return result;
    }

    public Roi[][] getRoi(int half, int tissue) {
        Roi[][] result = null;
        if (tissue == 2) {
            if (half == 0) {
                result = this.leftRoiMedulla;
            }
            if (half == 1) {
                result = this.rightRoiMedulla;
            }
        }
        if (tissue == 3) {
            if (half == 0) {
                result = this.leftRoiCortex;
            }
            if (half == 1) {
                result = this.rightRoiCortex;
            }
        }
        return result;
    }

    public boolean[][] getEnabledForSIT() {
        return this.manualSelector;
    }

    public void setAcquisitionTime(String[] data) {
        this.acquisitionTime = data;
    }

    public void setCepstrumResult(int half, int slice, String result) {
        if (half < 2 && half >= 0 && slice <= this.maxImage && slice > 0 && result != null) {
            this.cepstrumEvaluation[half][slice - 1] = result;
            if (result != "--") {
                this.manualSelector[half][slice - 1] = true;
            }
            this.manualSelector[0][this.analysisDialog.startImage - 1] = true;
            this.manualSelector[1][this.analysisDialog.startImage - 1] = true;
        }
    }

    public void setTextColor(Color c) {
        if (c != null) {
            this.textColor = c;
        }
    }

    public void paint(Graphics g) {
        Roi roi;
        int pos;
        super.paint(g);
        if (this.storeNextCanvasSize) {
            this.width = g.getClipBounds().width;
            this.height = g.getClipBounds().height;
            this.widthDiv2 = this.width / 2;
            this.storeNextCanvasSize = false;
        }
        g.setColor(this.myWhite);
        g.setFont(this.font);
        this.slice = this.imp.getCurrentSlice() - 1;
        if (this.acquisitionTime != null && this.acquisitionTime[this.slice] != null) {
            g.drawString(this.acquisitionTime[this.slice], 1, this.height - 2);
        }
        g.drawString(this.cepstrumEvaluation[0][this.slice], 1, 7);
        g.drawString(this.cepstrumEvaluation[1][this.slice], this.widthDiv2 + 1, 7);
        if (this.leftRoi != null && this.leftRoi[this.slice] != null) {
            Roi.setColor((Color)this.darkgreen);
            this.leftRoi[this.slice].draw(g);
        }
        if (this.rightRoi != null && this.rightRoi[this.slice] != null) {
            Roi.setColor((Color)this.darkgreen);
            this.rightRoi[this.slice].draw(g);
        }
        if (this.leftRoiCortex != null && this.leftRoiCortex[this.slice] != null) {
            pos = 0;
            while (pos < 100 && this.leftRoiCortex[this.slice][pos] != null) {
                Roi[] cfr_ignored_0 = this.leftRoiCortex[this.slice];
                Roi.setColor((Color)this.myYellow);
                this.leftRoiCortex[this.slice][pos].draw(g);
                ++pos;
            }
        }
        if (this.leftRoiMedulla != null && this.leftRoiMedulla[this.slice] != null) {
            pos = 0;
            while (pos < 100 && this.leftRoiMedulla[this.slice][pos] != null) {
                Roi[] cfr_ignored_1 = this.leftRoiMedulla[this.slice];
                Roi.setColor((Color)this.myRed);
                this.leftRoiMedulla[this.slice][pos].draw(g);
                ++pos;
            }
        }
        if (this.rightRoiCortex != null && this.rightRoiCortex[this.slice] != null) {
            pos = 0;
            while (pos < 100 && this.rightRoiCortex[this.slice][pos] != null) {
                Roi[] cfr_ignored_2 = this.rightRoiCortex[this.slice];
                Roi.setColor((Color)this.myYellow);
                this.rightRoiCortex[this.slice][pos].draw(g);
                ++pos;
            }
        }
        if (this.rightRoiMedulla != null && this.rightRoiMedulla[this.slice] != null) {
            pos = 0;
            while (pos < 100 && this.rightRoiMedulla[this.slice][pos] != null) {
                Roi[] cfr_ignored_3 = this.rightRoiMedulla[this.slice];
                Roi.setColor((Color)this.myRed);
                this.rightRoiMedulla[this.slice][pos].draw(g);
                ++pos;
            }
        }
        if ((roi = this.imp.getRoi()) != null) {
            Roi.setColor((Color)this.myWhite);
            roi.draw(g);
        }
        g.setColor(this.darkgreen);
        g.fillRect(this.buttonPos.x + 1, this.buttonPos.y + 1, 17, 9);
        g.fillRect(this.widthDiv2 + this.buttonPos.x + 1, this.buttonPos.y + 1, 17, 9);
        g.setColor(this.myYellow);
        g.fillRect(this.buttonPos.x + 18 + 1 + 1, this.buttonPos.y + 1, 17, 9);
        g.fillRect(this.widthDiv2 + this.buttonPos.x + 18 + 1 + 1, this.buttonPos.y + 1, 17, 9);
        g.setColor(this.myRed);
        g.fillRect(this.buttonPos.x + 36 + 2 + 1, this.buttonPos.y + 1, 17, 9);
        g.fillRect(this.widthDiv2 + this.buttonPos.x + 36 + 2 + 1, this.buttonPos.y + 1, 17, 9);
        g.setColor(this.buttonBorderColor[0][0]);
        g.draw3DRect(this.buttonPos.x, this.buttonPos.y, 18, 10, true);
        g.setColor(this.buttonBorderColor[1][0]);
        g.draw3DRect(this.widthDiv2 + this.buttonPos.x, this.buttonPos.y, 18, 10, true);
        g.setColor(this.buttonBorderColor[0][1]);
        g.draw3DRect(this.buttonPos.x + 18 + 1, this.buttonPos.y, 18, 10, true);
        g.setColor(this.buttonBorderColor[1][1]);
        g.draw3DRect(this.widthDiv2 + this.buttonPos.x + 18 + 1, this.buttonPos.y, 18, 10, true);
        g.setColor(this.buttonBorderColor[0][2]);
        g.draw3DRect(this.buttonPos.x + 36 + 2, this.buttonPos.y, 18, 10, true);
        g.setColor(this.buttonBorderColor[1][2]);
        g.draw3DRect(this.widthDiv2 + this.buttonPos.x + 36 + 2, this.buttonPos.y, 18, 10, true);
        g.setColor(this.myWhite);
        g.drawRect(16, 0, 9, 9);
        g.drawRect(this.widthDiv2 + 16, 0, 9, 9);
        if (this.manualSelector[0][this.slice]) {
            g.setColor(Color.green);
            g.drawLine(18, 5, 20, 7);
            g.drawLine(20, 7, 23, 2);
        } else {
            g.setColor(Color.red);
            g.drawLine(18, 2, 23, 7);
            g.drawLine(18, 7, 23, 2);
        }
        if (this.manualSelector[1][this.slice]) {
            g.setColor(Color.green);
            g.drawLine(this.widthDiv2 + 18, 5, this.widthDiv2 + 20, 7);
            g.drawLine(this.widthDiv2 + 20, 7, this.widthDiv2 + 23, 2);
        } else {
            g.setColor(Color.red);
            g.drawLine(this.widthDiv2 + 18, 2, this.widthDiv2 + 23, 7);
            g.drawLine(this.widthDiv2 + 18, 7, this.widthDiv2 + 23, 2);
        }
        g.setColor(Color.white);
        int arrowButtonPos = this.buttonPos.x + 54 + 3 + 1;
        g.drawLine(arrowButtonPos, 5, arrowButtonPos + 8, 5);
        g.drawLine(arrowButtonPos + 4, 1, arrowButtonPos + 4, 9);
        g.drawLine(arrowButtonPos + 1, 4, arrowButtonPos + 1, 6);
        g.drawLine(arrowButtonPos + 7, 4, arrowButtonPos + 7, 6);
        g.drawLine(arrowButtonPos + 3, 2, arrowButtonPos + 5, 2);
        g.drawLine(arrowButtonPos + 3, 8, arrowButtonPos + 5, 8);
        g.drawLine(arrowButtonPos += this.widthDiv2, 5, arrowButtonPos + 8, 5);
        g.drawLine(arrowButtonPos + 4, 1, arrowButtonPos + 4, 9);
        g.drawLine(arrowButtonPos + 1, 4, arrowButtonPos + 1, 6);
        g.drawLine(arrowButtonPos + 7, 4, arrowButtonPos + 7, 6);
        g.drawLine(arrowButtonPos + 3, 2, arrowButtonPos + 5, 2);
        g.drawLine(arrowButtonPos + 3, 8, arrowButtonPos + 5, 8);
        if (this.awtToolTip.showToolTip() && this.awtToolTipHelper.isMouseOver() && this.toolTipLabel.getText() != null && this.toolTipLabel.getText().length() != 0) {
            String s = this.toolTipLabel.getText();
            Font f = this.toolTipLabel.getFont();
            g.setColor(this.toolTipLabel.getBackground());
            g.fillRect(this.xMouse, this.yMouse + 20, this.getFontMetrics(f).stringWidth(s) + 3, 12);
            g.setFont(f);
            g.setColor(this.toolTipLabel.getForeground());
            g.drawString(s, this.xMouse + 2, this.yMouse + 29);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.storedRoi = this.imagePlus.getRoi();
        int button = this.mouseOverButton(e.getX(), e.getY());
        if (button < 0) {
            super.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        int button = this.mouseOverButton(e.getX(), e.getY());
        if (button < 0) {
            super.mouseReleased(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int result = 0;
        int button = this.mouseOverButton(x, y);
        if (button >= 0) {
            switch (button) {
                case 1: {
                    if (this.delKeyDown) {
                        this.analysisDialog.lockLeftRoi(this.storedRoi, false, false);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.analysisDialog.lockLeftRoi(this.storedRoi, true, true);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.analysisDialog.lockLeftRoi(this.storedRoi, true, true);
                    }
                    if (result >= 0 && result != 2) break;
                    this.setRoi(this.slice, 0, this.storedRoi);
                    break;
                }
                case 2: {
                    if (this.delKeyDown) {
                        this.deleteRois(0, 3);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.addToRoiArray(0, 3, this.storedRoi);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.addToRoiArray(0, 3, this.storedRoi);
                    }
                    if (result >= 0 && result == 0 || result == 1) break;
                    this.addToRoiArray(this.slice, 0, 3, this.storedRoi);
                    break;
                }
                case 3: {
                    if (this.delKeyDown) {
                        this.deleteRois(0, 2);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.addToRoiArray(0, 2, this.storedRoi);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.addToRoiArray(0, 2, this.storedRoi);
                    }
                    if (result >= 0 && result == 0 || result == 1) break;
                    this.addToRoiArray(this.slice, 0, 2, this.storedRoi);
                    break;
                }
                case 4: {
                    if (this.delKeyDown) {
                        this.analysisDialog.lockRightRoi(this.storedRoi, false, false);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.analysisDialog.lockRightRoi(this.storedRoi, true, true);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.analysisDialog.lockRightRoi(this.storedRoi, true, true);
                    }
                    if (result >= 0 && result == 0 || result == 1) break;
                    this.setRoi(this.slice, 1, this.storedRoi);
                    break;
                }
                case 5: {
                    if (this.delKeyDown) {
                        this.deleteRois(1, 3);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.addToRoiArray(1, 3, this.storedRoi);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.addToRoiArray(1, 3, this.storedRoi);
                    }
                    if (result >= 0 && result == 0 || result == 1) break;
                    this.addToRoiArray(this.slice, 1, 3, this.storedRoi);
                    break;
                }
                case 6: {
                    if (this.delKeyDown) {
                        this.deleteRois(1, 2);
                        break;
                    }
                    if (this.altKeyDown) {
                        this.addToRoiArray(1, 2, this.storedRoi);
                        break;
                    }
                    result = this.showAddRoiMessage();
                    if (result == 1) {
                        this.addToRoiArray(1, 2, this.storedRoi);
                    }
                    if (result >= 0 && result == 0 || result == 1) break;
                    this.addToRoiArray(this.slice, 1, 2, this.storedRoi);
                    break;
                }
                case 7: {
                    if (this.delKeyDown) {
                        this.setManualSelector(0, false);
                    } else if (this.altKeyDown) {
                        this.setManualSelector(0, true);
                    } else {
                        this.manualSelector[0][this.slice] = !this.manualSelector[0][this.slice];
                    }
                    this.repaint();
                    break;
                }
                case 8: {
                    if (this.delKeyDown) {
                        this.setManualSelector(1, false);
                    } else if (this.altKeyDown) {
                        this.setManualSelector(1, true);
                    } else {
                        this.manualSelector[1][this.slice] = !this.manualSelector[1][this.slice];
                    }
                    this.repaint();
                    break;
                }
                case 9: {
                    this.callAdjuster(0);
                    this.repaint();
                    break;
                }
                case 10: {
                    this.callAdjuster(1);
                    this.repaint();
                }
            }
        } else {
            Roi roi;
            super.mouseClicked(e);
            if (e.getClickCount() == 2 && (roi = this.getClickedRoi(e)) != null) {
                this.imagePlus.setRoi(roi);
            }
        }
    }

    private void callAdjuster(int half) {
        ManualMover manualMover = new ManualMover(this.imagePlus, this.slice, half, this.imagePlus.getWindow().getBounds());
    }

    private int showAddRoiMessage() {
        if (!this.dontAskAgain) {
            AddRoiDialog dlg = new AddRoiDialog((Frame)this.imagePlus.getWindow(), "ADD ROI", "Add this roi for all slices or\nonly for the current slice ?\n   \nNote:\nALT-Key + Mouseclick:\n      adds a roi for all slices\nDEL-Key  + Mouseclick:\n      deletes all rois of the selected Type");
            dlg.setVisible(true);
            if (dlg.dontAskAgain) {
                this.dontAskAgain = true;
            }
            if (dlg.result == 1) {
                dlg = null;
                return 1;
            }
            if (dlg.result == 2) {
                dlg = null;
                return 2;
            }
            if (dlg.result == 0) {
                dlg = null;
                return 0;
            }
        }
        return -1;
    }

    private Roi getClickedRoi(MouseEvent e) {
        Roi result = null;
        Roi[] mainRoi = null;
        Roi[][] cortexRoi = null;
        Roi[][] medullaRoi = null;
        int bestPosArray = -1;
        int bestType = -1;
        int x = this.offScreenX(e.getX());
        int y = this.offScreenY(e.getY());
        if (this.imp.sCalibrated) {
            x = (int)((double)x * this.imp.pixelWidth);
            y = (int)((double)y * this.imp.pixelWidth);
        }
        if (x < this.imagePlus.getWidth() / 2) {
            mainRoi = this.leftRoi;
            cortexRoi = this.leftRoiCortex;
            medullaRoi = this.leftRoiMedulla;
        } else {
            mainRoi = this.rightRoi;
            cortexRoi = this.rightRoiCortex;
            medullaRoi = this.rightRoiMedulla;
        }
        if (this.storedRoi == null) {
            double dy;
            double dx;
            double d;
            Rectangle rect;
            boolean roiClicked = false;
            double minDistance = Double.MAX_VALUE;
            Roi roi = mainRoi[this.slice];
            if (roi != null) {
                rect = roi.getBoundingRect();
                if (x >= rect.x && x < rect.x + rect.width && y >= rect.y && y < rect.y + rect.height && (d = Math.sqrt((dx = (double)(rect.x + rect.width / 2 - x)) * dx + (dy = (double)(rect.y + rect.height / 2 - y)) * dy)) < minDistance) {
                    minDistance = d;
                    bestType = 5;
                }
            }
            int j = 0;
            while (j < 100 && cortexRoi[this.slice][j] != null) {
                roi = cortexRoi[this.slice][j];
                if (roi != null) {
                    rect = roi.getBoundingRect();
                    if (x >= rect.x && x < rect.x + rect.width && y >= rect.y && y < rect.y + rect.height && (d = Math.sqrt((dx = (double)(rect.x + rect.width / 2 - x)) * dx + (dy = (double)(rect.y + rect.height / 2 - y)) * dy)) < minDistance) {
                        minDistance = d;
                        bestPosArray = j;
                        bestType = 3;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < 100 && medullaRoi[this.slice][j] != null) {
                roi = medullaRoi[this.slice][j];
                if (roi != null) {
                    rect = roi.getBoundingRect();
                    if (x >= rect.x && x < rect.x + rect.width && y >= rect.y && y < rect.y + rect.height && (d = Math.sqrt((dx = (double)(rect.x + rect.width / 2 - x)) * dx + (dy = (double)(rect.y + rect.height / 2 - y)) * dy)) < minDistance) {
                        minDistance = d;
                        bestPosArray = j;
                        bestType = 2;
                    }
                }
                ++j;
            }
        }
        if (bestType == 5) {
            result = mainRoi[this.slice];
            mainRoi[this.slice] = null;
        }
        if (bestType == 2) {
            result = medullaRoi[this.slice][bestPosArray];
            medullaRoi[this.slice][bestPosArray] = null;
            this.compressRoiArray(this.slice, medullaRoi);
        }
        if (bestType == 3) {
            result = cortexRoi[this.slice][bestPosArray];
            cortexRoi[this.slice][bestPosArray] = null;
            this.compressRoiArray(this.slice, cortexRoi);
        }
        return result;
    }

    public void mouseMoved(MouseEvent e) {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 3) {
                this.buttonBorderColor[i][j] = Color.darkGray;
                ++j;
            }
            ++i;
        }
        this.xMouse = e.getX();
        this.yMouse = e.getY();
        this.lastRect.x = this.repaintRect.x;
        this.lastRect.y = this.repaintRect.y;
        this.lastRect.width = this.repaintRect.width;
        this.lastRect.height = this.repaintRect.height;
        int button = this.mouseOverButton(this.xMouse, this.yMouse);
        if (button >= 0) {
            ImageWindow win = this.imp.getWindow();
            if (win != null) {
                win.setCursor(this.defaultCursor);
            }
            switch (button) {
                case 1: {
                    this.buttonBorderColor[0][0] = Color.lightGray;
                    this.setToolTipText("lock main roi right");
                    break;
                }
                case 2: {
                    this.buttonBorderColor[0][1] = Color.lightGray;
                    this.setToolTipText("lock cortex roi right");
                    break;
                }
                case 3: {
                    this.buttonBorderColor[0][2] = Color.lightGray;
                    this.setToolTipText("lock medulla roi right");
                    break;
                }
                case 4: {
                    this.buttonBorderColor[1][0] = Color.lightGray;
                    this.setToolTipText("lock main roi left");
                    break;
                }
                case 5: {
                    this.buttonBorderColor[1][1] = Color.lightGray;
                    this.setToolTipText("lock cortex roi left");
                    break;
                }
                case 6: {
                    this.buttonBorderColor[1][2] = Color.lightGray;
                    this.setToolTipText("lock medulla roi left");
                    break;
                }
                case 7: {
                    this.setToolTipText("enable for SIT-Curves");
                    break;
                }
                case 8: {
                    this.setToolTipText("enable for SIT-Curves");
                    break;
                }
                case 9: {
                    this.setToolTipText("adjust translation");
                    break;
                }
                case 10: {
                    this.setToolTipText("adjust translation");
                }
            }
            this.repaintDone = false;
            if (this.lastRect.x != this.repaintRect.x) {
                this.repaint(this.lastRect.x, this.lastRect.y, this.lastRect.width, this.lastRect.height);
            }
            this.repaint(this.repaintRect.x, this.repaintRect.y, this.repaintRect.width, this.repaintRect.height);
        } else {
            super.mouseMoved(e);
            this.setToolTipText("");
            if (!this.repaintDone) {
                this.repaint(this.repaintRect.x, this.repaintRect.y, this.repaintRect.width, this.repaintRect.height);
                this.repaintDone = true;
            }
        }
    }

    private int mouseOverButton(int x, int y) {
        if (y <= this.buttonPos.y + 10 && y >= this.buttonPos.y) {
            this.repaintRect.width = 18;
            this.repaintRect.height = 10;
            if (x >= this.buttonPos.x && x <= this.buttonPos.x + 18) {
                this.repaintRect.x = this.buttonPos.x;
                this.repaintRect.y = this.buttonPos.y;
                return 1;
            }
            if (x >= this.buttonPos.x + 18 + 1 && x < this.buttonPos.x + 36 + 2) {
                this.repaintRect.x = this.buttonPos.x + 18 + 1;
                this.repaintRect.y = this.buttonPos.y;
                return 2;
            }
            if (x >= this.buttonPos.x + 36 + 2 && x < this.buttonPos.x + 54 + 3) {
                this.repaintRect.x = this.buttonPos.x + 36 + 2;
                this.repaintRect.y = this.buttonPos.y;
                return 3;
            }
            if (x >= this.widthDiv2 + this.buttonPos.x && x <= this.widthDiv2 + this.buttonPos.x + 18) {
                this.repaintRect.x = this.widthDiv2 + this.buttonPos.x;
                this.repaintRect.y = this.buttonPos.y;
                return 4;
            }
            if (x >= this.widthDiv2 + this.buttonPos.x + 18 + 1 && x < this.widthDiv2 + this.buttonPos.x + 36 + 2) {
                this.repaintRect.x = this.widthDiv2 + this.buttonPos.x + 18 + 1;
                this.repaintRect.y = this.buttonPos.y;
                return 5;
            }
            if (x >= this.widthDiv2 + this.buttonPos.x + 36 + 2 && x < this.widthDiv2 + this.buttonPos.x + 54 + 3) {
                this.repaintRect.x = this.widthDiv2 + this.buttonPos.x + 36 + 2;
                this.repaintRect.y = this.buttonPos.y;
                return 6;
            }
        }
        if (y <= 9) {
            if (x >= 16 && x <= 25) {
                this.repaintRect.x = 16;
                this.repaintRect.y = 0;
                this.repaintRect.width = 10;
                this.repaintRect.height = 10;
                return 7;
            }
            if (x >= this.widthDiv2 + 16 && x <= this.widthDiv2 + 25) {
                this.repaintRect.x = this.widthDiv2 + 16;
                this.repaintRect.y = 0;
                this.repaintRect.width = 10;
                this.repaintRect.height = 10;
                return 8;
            }
            int arrowButtonPos = this.buttonPos.x + 54 + 3 + 1;
            if (x >= arrowButtonPos && x <= arrowButtonPos + 9) {
                this.repaintRect.x = arrowButtonPos;
                this.repaintRect.y = 0;
                this.repaintRect.width = 10;
                this.repaintRect.height = 10;
                return 9;
            }
            if (x >= arrowButtonPos + this.widthDiv2 && x <= arrowButtonPos + this.widthDiv2 + 9) {
                this.repaintRect.x = arrowButtonPos + this.widthDiv2;
                this.repaintRect.y = 0;
                this.repaintRect.width = 10;
                this.repaintRect.height = 10;
                return 10;
            }
        }
        return -1;
    }

    public void componentHidden(ComponentEvent e) {
        this.storeNextCanvasSize = true;
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
        this.storeNextCanvasSize = true;
        this.repaint();
    }

    public void componentMoved(ComponentEvent e) {
        this.storeNextCanvasSize = true;
        this.repaint();
    }

    public void componentResized(ComponentEvent e) {
        this.storeNextCanvasSize = true;
        this.repaint();
    }

    public void keyReleased(KeyEvent evt) {
        this.altKeyDown = false;
        this.delKeyDown = false;
    }

    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        this.altKeyDown = false;
        this.delKeyDown = false;
        if (keyCode == 18) {
            this.altKeyDown = true;
        }
        if (keyCode == 127) {
            this.delKeyDown = true;
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public boolean endThreads() {
        try {
            this.awtToolTip.setSourceClass(null);
            this.awtToolTip = null;
        }
        catch (Exception e) {
            IJ.write((String)e.toString());
            IJ.write((String)"AWTToolTip-Thread laeuft immer noch !");
            return false;
        }
        return true;
    }

    static {
        buttonWidth = 18;
        buttonHeight = 10;
        MAXROIS = 100;
        CANCEL = 0;
        ALL = 1;
        CURRENT = 2;
        BUTTON1LEFT = 1;
        BUTTON2LEFT = 2;
        BUTTON3LEFT = 3;
        BUTTON1RIGHT = 4;
        BUTTON2RIGHT = 5;
        BUTTON3RIGHT = 6;
        SELECTORLEFT = 7;
        SELECTORRIGHT = 8;
        MOVELEFT = 9;
        MOVERIGHT = 10;
    }
}

