/*
 * Decompiled with CFR 0.152.
 */
package jm.extension;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import jm.extension.ExImageCanvas;
import jm.extension.ExStackWindow;

public class ExImageWindow
extends ImageWindow {
    private static final int TEXT_GAP = 0;
    private Font textFont = new Font("Dialog", 1, 11);

    public ExImageWindow(ImagePlus imp) {
        super(imp, (ImageCanvas)new ExImageCanvas(imp));
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.pack();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
    }

    public void paint(Graphics g) {
        this.drawInfo(g);
    }

    public boolean close() {
        return super.close();
    }

    public void drawInfo(Graphics g) {
        String s = "";
        Insets insets = super.getInsets();
        int nSlices = this.imp.getStackSize();
        if (nSlices > 1) {
            String label;
            ImageStack stack = this.imp.getStack();
            s = s + this.imp.getCurrentSlice() + "/" + nSlices;
            boolean isLabel = false;
            if (nSlices <= 4 && (label = stack.getSliceLabel(1)) != null) {
                s = s + " (" + label + ")";
            }
            if (this instanceof ExStackWindow && this.running) {
                g.drawString(s, 5, insets.top + 0);
                return;
            }
            s = s + "; ";
        }
        int type = this.imp.getType();
        s = this.imp.sCalibrated ? s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; " : s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int size = this.imp.getWidth() * this.imp.getHeight() * this.imp.getStackSize() / 1024;
        switch (type) {
            case 0: {
                s = s + "8-bit grayscale";
                break;
            }
            case 1: {
                s = s + "16-bit grayscale";
                size *= 2;
                break;
            }
            case 2: {
                s = s + "32-bit grayscale";
                size *= 4;
                break;
            }
            case 3: {
                s = s + "8-bit color";
                break;
            }
            case 4: {
                s = s + "RGB";
                size *= 4;
            }
        }
        s = s + "; " + size + "K";
        g.drawString(s, 5, insets.top + 0);
    }

    static {
        TEXT_GAP = 0;
    }
}

