/*
 * Decompiled with CFR 0.152.
 */
package jm.extension;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;

public class ExJButton
extends JButton
implements MouseListener {
    private boolean mouseOver = false;
    private boolean mouseButtonDown = false;
    private Color inactiveForeground;

    public ExJButton() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addMouseListener(this);
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        if ((r -= 25) < 0) {
            r = 0;
        }
        if ((g -= 25) < 0) {
            g = 0;
        }
        if ((b -= 25) < 0) {
            b = 0;
        }
        this.inactiveForeground = new Color(r, g, b);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseButtonDown = false;
        this.mouseOver = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseButtonDown = false;
        this.mouseOver = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseButtonDown = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.mouseButtonDown = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        boolean enabled = this.isEnabled();
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        String s = this.getText();
        int textPosX = (width - this.getFontMetrics(this.getFont()).stringWidth(s)) / 2 - 1;
        int textPosY = this.getFont().getSize() + (height - this.getFont().getSize()) / 2 - 1;
        if (this.mouseButtonDown && enabled) {
            ++textPosX;
            ++textPosY;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setFont(this.getFont());
        if (this.mouseOver && enabled) {
            g.setColor(this.getForeground());
            g.drawRect(0, 0, width - 1, height - 1);
            g.drawString(s, textPosX, textPosY);
            if (!this.mouseButtonDown) {
                g.drawLine(textPosX - 1, textPosY + 2, textPosX - 1 + this.getFontMetrics(this.getFont()).stringWidth(s), textPosY + 2);
            }
        } else {
            g.setColor(this.inactiveForeground);
            g.drawRect(0, 0, width - 1, height - 1);
            g.drawString(s, textPosX, textPosY);
        }
    }
}

