/*
 * Decompiled with CFR 0.152.
 */
package jm.extension;

import ij.ImagePlus;
import ij.ImageStack;
import java.awt.Color;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.extension.ExImageWindow;

public class ExStackWindow
extends ExImageWindow
implements Runnable,
AdjustmentListener,
ActionListener {
    protected Scrollbar sliceSelector;
    protected Thread thread;
    protected boolean done;
    protected int slice;

    public ExStackWindow(ImagePlus imp) {
        super(imp);
        ImageStack s = imp.getStack();
        int stackSize = s.getSize();
        this.sliceSelector = new Scrollbar(0, 1, 1, 1, stackSize + 1);
        this.sliceSelector.setBackground(Color.black);
        this.sliceSelector.setForeground(Color.white);
        this.add(this.sliceSelector);
        this.sliceSelector.addAdjustmentListener(this);
        int blockIncrement = stackSize / 10;
        if (blockIncrement < 1) {
            blockIncrement = 1;
        }
        this.sliceSelector.setUnitIncrement(1);
        this.sliceSelector.setBlockIncrement(blockIncrement);
        this.pack();
        this.show();
        imp.setSlice(1);
        this.thread = new Thread((Runnable)this, "SliceSelector");
        this.thread.start();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running) {
            this.slice = this.sliceSelector.getValue();
            this.notify();
        }
    }

    public void lock() {
        this.imp.lock();
        this.ic.setEnabled(false);
        this.sliceSelector.setEnabled(false);
    }

    public void unlock() {
        this.imp.unlock();
        this.ic.setEnabled(true);
        this.sliceSelector.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        super.close();
        ExStackWindow exStackWindow = this;
        synchronized (exStackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int index) {
        ImageStack stack = this.imp.getStack();
        if (index >= 1 && stack != null && index <= stack.getSize()) {
            this.imp.setSlice(index);
            this.sliceSelector.setValue(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ExStackWindow exStackWindow = this;
            synchronized (exStackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int s = this.slice;
            this.slice = 0;
            ImageStack stack = this.imp.getStack();
            this.imp.setSlice(s);
        }
    }
}

