/*
 * Decompiled with CFR 0.152.
 */
package jm.extension;

import java.awt.event.MouseEvent;
import jm.extension.ExImageCanvas;

public class TimerThread
extends Thread {
    public boolean stopped = false;
    public boolean started = false;
    private int latencyTime = 750;
    private int dismissTime = 4000;
    private long actualTime = 0L;
    private long lastMoveTime = Long.MAX_VALUE;
    private ExImageCanvas exImageCanvas = null;
    public boolean showToolTip = false;
    private boolean repaintOnce = true;
    private boolean repaintDismiss = true;
    private MouseEvent mouseEvent = null;

    public TimerThread() {
        this.start();
    }

    public void run() {
        this.setPriority(1);
        this.started = true;
        while (!this.stopped && this.exImageCanvas != null) {
            this.actualTime = System.currentTimeMillis();
            if (this.actualTime - this.lastMoveTime > (long)this.latencyTime) {
                if (this.repaintOnce) {
                    this.repaintOnce = false;
                    this.showToolTip = true;
                    this.exImageCanvas.repaint();
                    this.showToolTip = false;
                }
            } else {
                this.showToolTip = false;
                this.repaintOnce = true;
                this.repaintDismiss = true;
            }
            if (this.actualTime - this.lastMoveTime > (long)this.dismissTime && this.repaintDismiss) {
                this.repaintDismiss = false;
                this.showToolTip = false;
                this.exImageCanvas.repaint();
            }
            if (this.exImageCanvas != null) continue;
            this.interrupt();
        }
    }

    public void setInitialDelay(int ms) {
        if (ms > 0) {
            this.latencyTime = ms;
        }
    }

    public void setDismissDelay(int ms) {
        if (ms > 0) {
            this.dismissTime = ms;
        }
    }

    public void setLastMoveTime(long time) {
        if (time > 0L) {
            this.lastMoveTime = time;
        }
    }

    public void setSourceClass(ExImageCanvas ic) {
        this.exImageCanvas = ic;
    }
}

