/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.DiscreteSignal;
import jm.jigl.LevelOp;
import jm.jigl.RealSignal;
import jm.jigl.Signal;
import jm.jigl.SignalInputStream;
import jm.jigl.SignalNotSupportedException;
import jm.jigl.SignalOutputStream;

public class ByteSize
implements LevelOp {
    public Signal apply(Signal signal) throws SignalNotSupportedException {
        if (signal instanceof DiscreteSignal) {
            return this.apply((DiscreteSignal)signal);
        }
        if (signal instanceof RealSignal) {
            return this.apply((RealSignal)signal);
        }
        throw new SignalNotSupportedException();
    }

    private DiscreteSignal apply(DiscreteSignal signal) {
        float min = signal.min();
        float max = signal.max();
        float range = max - min;
        int value = 0;
        int x = 0;
        while (x < signal.length()) {
            value = (int)(255.0 / (double)range * (double)((float)signal.get(x) - min));
            value = 0xFF & value;
            signal.set(x, (short)value);
            ++x;
        }
        return signal;
    }

    private RealSignal apply(RealSignal signal) {
        float min = signal.min();
        float max = signal.max();
        float range = max - min;
        float value = 0.0f;
        int x = 0;
        while (x < signal.length()) {
            value = (float)(255.0 / (double)range * (double)(signal.get(x) - min));
            value = 0xFF & (int)value;
            signal.set(x, value);
            ++x;
        }
        return signal;
    }

    public static void main(String[] argv) {
        try {
            Signal image = null;
            String inputfile = argv[0];
            Signal image2 = null;
            SignalInputStream is = new SignalInputStream(inputfile);
            image = is.read();
            is.close();
            ByteSize bytesize = new ByteSize();
            image2 = bytesize.apply(image);
            SignalOutputStream os = new SignalOutputStream(argv[1]);
            os.write(image2);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

