/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

public class Complex
extends Number {
    protected float x;
    protected float y;

    public Complex() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Complex(double a, double b) {
        this.x = (float)a;
        this.y = (float)b;
    }

    public Complex(Complex z) {
        this.x = (float)z.real();
        this.y = (float)z.imag();
    }

    public double real() {
        return this.x;
    }

    public double real(double a) {
        double retval = this.x;
        this.x = (float)a;
        return retval;
    }

    public double imag() {
        return this.y;
    }

    public double imag(double a) {
        double retval = this.y;
        this.y = (float)a;
        return retval;
    }

    public double mod() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double arg() {
        return Math.atan2(this.x, this.y);
    }

    public Complex sign() {
        double r = this.mod();
        return new Complex((double)this.x / r, (double)this.y / r);
    }

    public Complex conj() {
        return new Complex(this.x, -this.y);
    }

    public void polar(double r, double t) {
        this.x = (float)(r * Math.cos(t));
        this.y = (float)(r * Math.sin(t));
    }

    public boolean equals(Complex z) {
        return this.x == z.x && this.y == z.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public Complex add(Complex z) {
        this.x += z.x;
        this.y += z.y;
        return this;
    }

    public Complex sub(Complex z) {
        this.x -= z.x;
        this.y -= z.y;
        return this;
    }

    public Complex mult(Complex z) {
        float a = this.x * z.x - this.y * z.y;
        float b = this.x * z.y + this.y * z.x;
        this.x = a;
        this.y = b;
        return this;
    }

    public Complex div(Complex z) {
        float r = z.x * z.x + z.y * z.y;
        float a = (this.x * z.x + this.y * z.y) / r;
        float b = (this.y * z.x - this.x * z.y) / r;
        this.x = a;
        this.y = b;
        return this;
    }

    public Complex add(double a) {
        this.x += (float)a;
        return this;
    }

    public Complex sub(double a) {
        this.x -= (float)a;
        return this;
    }

    public Complex mult(double a) {
        this.x *= (float)a;
        this.y *= (float)a;
        return this;
    }

    public Complex div(double a) {
        this.x /= (float)a;
        this.y /= (float)a;
        return this;
    }

    public Complex sqrt() {
        double r = this.mod();
        double t = Math.atan2(this.x, this.y);
        return new Complex(Math.sqrt(r) * Math.cos(t / 2.0), Math.sqrt(r) * Math.sin(t / 2.0));
    }

    public Complex exp() {
        return new Complex(Math.exp(this.x) * Math.cos(this.y), Math.exp(this.x) * Math.sin(this.y));
    }

    public Complex log() {
        return new Complex(Math.log(this.mod()), Math.atan2(this.x, this.y));
    }

    public Complex pow(double a) {
        double r = this.mod();
        double t = Math.atan2(this.x, this.y);
        return new Complex(Math.pow(r, a) * Math.cos(a * t), Math.pow(r, a) * Math.sin(a * t));
    }

    public Complex cosh() {
        Complex z1 = this.exp();
        Complex z2 = this.mult(-1.0).exp();
        z1.add(z2);
        z1.div(2.0);
        return z1;
    }

    public Complex sinh() {
        Complex z1 = this.exp();
        Complex z2 = this.mult(-1.0).exp();
        z1.sub(z2);
        z1.div(2.0);
        return z1;
    }

    Complex j1mult() {
        return new Complex(-this.y, this.x);
    }

    Complex j2mult() {
        return new Complex(-this.x, -this.y);
    }

    Complex j3mult() {
        return new Complex(this.y, -this.x);
    }

    public Complex cos() {
        Complex z1 = this.j1mult().exp();
        Complex z2 = this.j3mult().exp();
        z1.add(z2);
        z1.div(2.0);
        return z1;
    }

    public Complex sin() {
        Complex z1 = this.j1mult().exp();
        Complex z2 = this.j3mult().exp();
        z1.sub(z2);
        z1.j3mult();
        z1.div(2.0);
        return z1;
    }

    public double doubleValue() {
        return this.mod();
    }

    public float floatValue() {
        return (float)this.mod();
    }

    public int intValue() {
        return (int)this.mod();
    }

    public long longValue() {
        return (long)this.mod();
    }

    public static Complex add(Complex z1, Complex z2) {
        Complex z = new Complex();
        z.x = z1.x + z2.x;
        z.y = z1.y + z2.y;
        return z;
    }

    public static Complex sub(Complex z1, Complex z2) {
        Complex z = new Complex();
        z.x = z1.x - z2.x;
        z.y = z1.y - z2.y;
        return z;
    }

    public static Complex mult(Complex z1, Complex z2) {
        Complex z = new Complex();
        z.x = z1.x * z2.x - z1.y * z2.y;
        z.y = z1.x * z2.y + z1.y * z2.x;
        return z;
    }

    public static Complex div(Complex z1, Complex z2) {
        float r = z2.x * z2.x + z2.y * z2.y;
        Complex z = new Complex();
        z.x = (z1.x * z2.x + z1.y * z2.y) / r;
        z.y = (z1.y * z2.x - z1.x * z2.y) / r;
        return z;
    }
}

