/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.awt.image.ImageProducer;
import jm.jigl.Complex;
import jm.jigl.Image;
import jm.jigl.ROI;
import jm.jigl.RealGrayImage;

public class ComplexImage
implements Image {
    protected RealGrayImage real;
    protected RealGrayImage imag;
    protected int X;
    protected int Y;

    public ComplexImage() {
        this.X = 0;
        this.Y = 0;
        this.real = null;
        this.imag = null;
    }

    public ComplexImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.real = new RealGrayImage(this.X, this.Y);
        this.imag = new RealGrayImage(this.X, this.Y);
    }

    public ComplexImage(ComplexImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.real = img.real();
        this.imag = img.imag();
    }

    public ComplexImage(java.awt.Image img) {
        this.real = new RealGrayImage(img);
        this.X = this.real.X();
        this.Y = this.imag.Y();
        this.imag = new RealGrayImage(this.X, this.Y);
    }

    public ImageProducer getJavaImage() {
        return this.real.getJavaImage();
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public Image copy() {
        ComplexImage c = new ComplexImage(this.X, this.Y);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                c.real.set(x, y, this.real.get(x, y));
                c.imag.set(x, y, this.imag.get(x, y));
                ++x;
            }
            ++y;
        }
        return c;
    }

    public final RealGrayImage real() {
        return this.real;
    }

    public final void setReal(RealGrayImage pl) {
        this.real = pl;
    }

    public final RealGrayImage imag() {
        return this.imag;
    }

    public final void setImag(RealGrayImage pl) {
        this.imag = pl;
    }

    public final float getReal(int x, int y) {
        return this.real.get(x, y);
    }

    public final float getImag(int x, int y) {
        return this.imag.get(x, y);
    }

    public final void setReal(int x, int y, float v) {
        this.real.set(x, y, v);
    }

    public final void setImag(int x, int y, float v) {
        this.imag.set(x, y, v);
    }

    public final void set(int x, int y, float r, float i) {
        this.real.set(x, y, r);
        this.imag.set(x, y, i);
    }

    public final Complex min() {
        Complex p = new Complex();
        Complex min = new Complex(Double.MAX_VALUE, Double.MAX_VALUE);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                p.real(this.getReal(x, y));
                p.imag(this.getImag(x, y));
                if (p.mod() < min.mod()) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final Complex max() {
        Complex p = new Complex();
        Complex max = new Complex(Double.MIN_VALUE, Double.MIN_VALUE);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                p.real(this.getReal(x, y));
                p.imag(this.getImag(x, y));
                if (p.mod() > max.mod()) {
                    // empty if block
                }
                max = p;
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final void add(int x, int y, float r, float i) {
        this.real.add(x, y, r);
        this.imag.add(x, y, i);
    }

    public final void subtract(int x, int y, float r, float i) {
        this.real.subtract(x, y, r);
        this.imag.subtract(x, y, i);
    }

    public final void multiply(int x, int y, float r, float i) {
        float a = this.real.get(x, y) * r - this.imag.get(x, y) * i;
        float b = this.real.get(x, y) * i + this.imag.get(x, y) * r;
        this.real.set(x, y, a);
        this.imag.set(x, y, b);
    }

    public final void divide(int x, int y, float r, float i) {
        float mag2 = r * r + i * i;
        float a = (this.real.get(x, y) * r + this.imag.get(x, y) * i) / mag2;
        float b = (this.imag.get(x, y) * r - this.real.get(x, y) * i) / mag2;
        this.real.set(x, y, a);
        this.imag.set(x, y, b);
    }

    public final void add(ComplexImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.add(x, y, im.getReal(x, y), im.getImag(x, y));
                ++x;
            }
            ++y;
        }
    }

    public final void subtract(ComplexImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.subtract(x, y, im.getReal(x, y), im.getImag(x, y));
                ++x;
            }
            ++y;
        }
    }

    public final ComplexImage diff(ComplexImage im) {
        this.real = this.real.diff(im.real());
        this.imag = this.imag.diff(im.imag());
        return this;
    }

    public final void multiply(ComplexImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.multiply(x, y, im.getReal(x, y), im.getImag(x, y));
                ++x;
            }
            ++y;
        }
    }

    public final void divide(ComplexImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.divide(x, y, im.getReal(x, y), im.getImag(x, y));
                ++x;
            }
            ++y;
        }
    }

    public final ComplexImage add(float r, float i) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.add(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage subtract(float r, float i) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.subtract(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage multiply(float r, float i) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.multiply(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage divide(float r, float i) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.divide(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString() {
        String str = this.real.toString();
        str = str + this.imag.toString();
        return str;
    }

    public Image copy(ROI r) {
        ComplexImage c = new ComplexImage(r.X(), r.Y());
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.uy()) {
                c.real.set(x, y, this.real.get(x, y));
                c.imag.set(x, y, this.imag.get(x, y));
                ++x;
            }
            ++y;
        }
        return c;
    }

    public final float getReal(int x, int y, ROI r) {
        return this.real.get(x + r.ux(), y + r.uy());
    }

    public final float getImag(int x, int y, ROI r) {
        return this.imag.get(x + r.ux(), y + r.uy());
    }

    public final void setReal(int x, int y, float v, ROI r) {
        this.real.set(x + r.ux(), y + r.uy(), v);
    }

    public final void setImag(int x, int y, float v, ROI r) {
        this.imag.set(x + r.ux(), y + r.uy(), v);
    }

    public final void set(int x, int y, float r, float i, ROI r2) {
        this.real.set(x, y, r, r2);
        this.imag.set(x, y, i, r2);
    }

    public final Complex min(ROI r) {
        Complex p = new Complex();
        Complex min = new Complex(Double.MAX_VALUE, Double.MAX_VALUE);
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.ux()) {
                p.real(this.getReal(x, y));
                p.imag(this.getImag(x, y));
                if (p.mod() < min.mod()) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final Complex max(ROI r) {
        Complex p = new Complex();
        Complex max = new Complex(Double.MIN_VALUE, Double.MIN_VALUE);
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.ux()) {
                p.real(this.getReal(x, y));
                p.imag(this.getImag(x, y));
                if (p.mod() > max.mod()) {
                    // empty if block
                }
                max = p;
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final void add(int x, int y, float r, float i, ROI r2) {
        this.real.add(x, y, r, r2);
        this.imag.add(x, y, i, r2);
    }

    public final void subtract(int x, int y, float r, float i, ROI r2) {
        this.real.subtract(x, y, r, r2);
        this.imag.subtract(x, y, i, r2);
    }

    public final void multiply(int x, int y, float r, float i, ROI r2) {
        float a = this.real.get(x, y) * r - this.imag.get(x, y) * i;
        float b = this.real.get(x, y) * i + this.imag.get(x, y) * r;
        this.real.set(x, y, a, r2);
        this.imag.set(x, y, b, r2);
    }

    public final void divide(int x, int y, float r, float i, ROI r2) {
        float mag2 = r * r + i * i;
        float a = (this.real.get(x, y) * r + this.imag.get(x, y) * i) / mag2;
        float b = (this.imag.get(x, y) * r - this.real.get(x, y) * i) / mag2;
        this.real.set(x, y, a, r2);
        this.imag.set(x, y, b, r2);
    }

    public final ComplexImage add(float r, float i, ROI r2) {
        int y = r2.uy();
        while (y < r2.ly()) {
            int x = r2.ux();
            while (x < r2.lx()) {
                this.add(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage subtract(float r, float i, ROI r2) {
        int y = r2.uy();
        while (y < r2.ly()) {
            int x = r2.ux();
            while (x < r2.lx()) {
                this.subtract(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage multiply(float r, float i, ROI r2) {
        int y = r2.uy();
        while (y < r2.ly()) {
            int x = r2.ux();
            while (x < r2.lx()) {
                this.multiply(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final ComplexImage divide(float r, float i, ROI r2) {
        int y = r2.uy();
        while (y < r2.ly()) {
            int x = r2.ux();
            while (x < r2.lx()) {
                this.divide(x, y, r, i);
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.real.toString(r);
        str = str + this.imag.toString(r);
        return str;
    }

    public final void add(ComplexImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                this.add(x, y, im.getReal(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()), im.getImag(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
    }

    public final void subtract(ComplexImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                this.subtract(x, y, im.getReal(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()), im.getImag(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
    }

    public final void multiply(ComplexImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                this.multiply(x, y, im.getReal(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()), im.getImag(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
    }

    public final void divide(ComplexImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                this.divide(x, y, im.getReal(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()), im.getImag(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
    }

    public final RealGrayImage getMagnitudeImage() {
        RealGrayImage im = new RealGrayImage(this.X, this.Y);
        float value = 0.0f;
        int x = 0;
        while (x < this.X) {
            int y = 0;
            while (y < this.Y) {
                value = (float)Math.sqrt(Math.pow(this.getReal(x, y), 2.0) + Math.pow(this.getImag(x, y), 2.0));
                im.set(x, y, value);
                ++y;
            }
            ++x;
        }
        return im;
    }
}

