/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.Complex;
import jm.jigl.ROI;
import jm.jigl.RealSignal;
import jm.jigl.Signal;

public class ComplexSignal
implements Signal {
    protected RealSignal real;
    protected RealSignal imag;
    protected int length;

    public ComplexSignal() {
        this.length = 0;
        this.real = null;
        this.imag = null;
    }

    public ComplexSignal(int x) {
        this.length = x;
        this.real = new RealSignal(this.length);
        this.imag = new RealSignal(this.length);
    }

    public ComplexSignal(ComplexSignal s) {
        this.length = s.length();
        this.real = s.real();
        this.imag = s.imag();
    }

    public final int length() {
        return this.length;
    }

    public final RealSignal real() {
        return this.real;
    }

    public final RealSignal imag() {
        return this.imag;
    }

    public Signal copy() {
        ComplexSignal c = new ComplexSignal(this.length);
        int x = 0;
        while (x < this.length) {
            c.real.set(x, this.real.get(x));
            c.imag.set(x, this.imag.get(x));
            ++x;
        }
        return c;
    }

    public final void setReal(RealSignal pl) {
        this.real = pl;
    }

    public final void setImag(RealSignal pl) {
        this.imag = pl;
    }

    public final float getReal(int x) {
        return this.real.get(x);
    }

    public final float getImag(int x) {
        return this.imag.get(x);
    }

    public final void setReal(int x, float v) {
        this.real.set(x, v);
    }

    public final void setImag(int x, float v) {
        this.imag.set(x, v);
    }

    public final void set(int x, float r, float i) {
        this.real.set(x, r);
        this.imag.set(x, i);
    }

    public final Complex min() {
        Complex p = new Complex();
        Complex min = new Complex(Double.MAX_VALUE, Double.MAX_VALUE);
        int x = 0;
        while (x < this.length) {
            p.imag(this.getImag(x));
            p.real(this.getReal(x));
            if (p.mod() < min.mod()) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final Complex max() {
        Complex p = new Complex();
        Complex max = new Complex(Double.MIN_VALUE, Double.MIN_VALUE);
        int x = 0;
        while (x < this.length) {
            p.imag(this.getImag(x));
            p.real(this.getReal(x));
            if (p.mod() > max.mod()) {
                // empty if block
            }
            max = p;
            ++x;
        }
        return max;
    }

    public final void add(int x, float r, float i) {
        this.real.add(x, r);
        this.imag.add(x, i);
    }

    public final void subtract(int x, float r, float i) {
        this.real.subtract(x, r);
        this.imag.subtract(x, i);
    }

    public final void multiply(int x, float r, float i) {
        float a = this.real.get(x) * r - this.imag.get(x) * i;
        float b = this.real.get(x) * i + this.imag.get(x) * r;
        this.real.set(x, a);
        this.imag.set(x, b);
    }

    public final void divide(int x, float r, float i) {
        float mag2 = r * r + i * i;
        float a = (this.real.get(x) * r + this.imag.get(x) * i) / mag2;
        float b = (this.imag.get(x) * r - this.real.get(x) * i) / mag2;
        this.real.set(x, a);
        System.out.println(x + "  " + a);
        this.imag.set(x, b);
    }

    public final void add(ComplexSignal im) {
        int x = 0;
        while (x < this.length) {
            this.add(x, im.getReal(x), im.getImag(x));
            ++x;
        }
    }

    public final void subtract(ComplexSignal im) {
        int x = 0;
        while (x < this.length) {
            this.subtract(x, im.getReal(x), im.getImag(x));
            ++x;
        }
    }

    public final ComplexSignal diff(ComplexSignal s) {
        this.real.diff(s.real());
        this.imag.diff(s.real());
        return this;
    }

    public final void multiply(ComplexSignal im) {
        int x = 0;
        while (x < this.length) {
            this.multiply(x, im.getReal(x), im.getImag(x));
            ++x;
        }
    }

    public final void divide(ComplexSignal im) {
        int x = 0;
        while (x < this.length) {
            this.divide(x, im.getReal(x), im.getImag(x));
            ++x;
        }
    }

    public final ComplexSignal add(float r, float i) {
        int x = 0;
        while (x < this.length) {
            this.add(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal subtract(float r, float i) {
        int x = 0;
        while (x < this.length) {
            this.subtract(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal multiply(float r, float i) {
        int x = 0;
        while (x < this.length) {
            this.multiply(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal divide(float r, float i) {
        int x = 0;
        while (x < this.length) {
            this.divide(x, r, i);
            ++x;
        }
        return this;
    }

    public String toString() {
        String str = this.real.toString();
        str = str + this.imag.toString();
        return str;
    }

    public Signal copy(ROI r) {
        ComplexSignal c = new ComplexSignal(r.X());
        int x = r.ux();
        while (x < r.uy()) {
            c.real.set(x, this.real.get(x));
            c.imag.set(x, this.imag.get(x));
            ++x;
        }
        return c;
    }

    public final float getReal(int x, ROI r) {
        return this.real.get(x + r.ux() + r.uy());
    }

    public final float getImag(int x, ROI r) {
        return this.imag.get(x + r.ux() + r.uy());
    }

    public final void setReal(int x, float v, ROI r) {
        this.real.set(x + r.ux() + r.uy(), v);
    }

    public final void setImag(int x, float v, ROI r) {
        this.imag.set(x + r.ux() + r.uy(), v);
    }

    public final void set(int x, float r, float i, ROI r2) {
        this.real.set(x, r, r2);
        this.imag.set(x, i, r2);
    }

    public final Complex min(ROI r) {
        Complex p = new Complex();
        Complex min = new Complex(Double.MAX_VALUE, Double.MAX_VALUE);
        int x = r.ux();
        while (x < r.lx()) {
            p.imag(this.getImag(x));
            p.real(this.getReal(x));
            if (p.mod() < min.mod()) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final Complex max(ROI r) {
        Complex p = new Complex();
        Complex max = new Complex(Double.MIN_VALUE, Double.MIN_VALUE);
        int x = r.ux();
        while (x < r.lx()) {
            p.imag(this.getImag(x));
            p.real(this.getReal(x));
            if (p.mod() > max.mod()) {
                // empty if block
            }
            max = p;
            ++x;
        }
        return max;
    }

    public final void add(int x, float r, float i, ROI r2) {
        this.real.add(x, r, r2);
        this.imag.add(x, i, r2);
    }

    public final void subtract(int x, float r, float i, ROI r2) {
        this.real.subtract(x, r, r2);
        this.imag.subtract(x, i, r2);
    }

    public final void multiply(int x, float r, float i, ROI r2) {
        float a = this.real.get(x) * r - this.imag.get(x) * i;
        float b = this.real.get(x) * i + this.imag.get(x) * r;
        this.real.set(x, a, r2);
        this.imag.set(x, b, r2);
    }

    public final void divide(int x, float r, float i, ROI r2) {
        float mag2 = r * r + i * i;
        float a = (this.real.get(x) * r + this.imag.get(x) * i) / mag2;
        float b = (this.imag.get(x) * r - this.real.get(x) * i) / mag2;
        this.real.set(x, a, r2);
        this.imag.set(x, b, r2);
    }

    public final ComplexSignal add(float r, float i, ROI r2) {
        int x = r2.ux();
        while (x < r2.lx()) {
            this.add(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal subtract(float r, float i, ROI r2) {
        int x = r2.ux();
        while (x < r2.lx()) {
            this.subtract(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal multiply(float r, float i, ROI r2) {
        int x = r2.ux();
        while (x < r2.lx()) {
            this.multiply(x, r, i);
            ++x;
        }
        return this;
    }

    public final ComplexSignal divide(float r, float i, ROI r2) {
        int x = r2.ux();
        while (x < r2.lx()) {
            this.divide(x, r, i);
            ++x;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.real.toString(r);
        str = str + this.imag.toString(r);
        return str;
    }

    public final void add(ComplexSignal im, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            this.add(x, im.getReal(x - sourceSignal.ux() + destSignal.ux()), im.getImag(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
    }

    public final void subtract(ComplexSignal im, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            this.subtract(x, im.getReal(x - sourceSignal.ux() + destSignal.ux()), im.getImag(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
    }

    public final void multiply(ComplexSignal im, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            this.multiply(x, im.getReal(x - sourceSignal.ux() + destSignal.ux()), im.getImag(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
    }

    public final void divide(ComplexSignal im, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            this.divide(x, im.getReal(x - sourceSignal.ux() + destSignal.ux()), im.getImag(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
    }
}

