/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.Complex;
import jm.jigl.ComplexSignal;
import jm.jigl.DiscreteSignal;
import jm.jigl.RealSignal;
import jm.jigl.Signal;

public class ConvertSignal {
    public static DiscreteSignal toDiscrete(Signal signal) {
        if (signal instanceof DiscreteSignal) {
            return ConvertSignal.toDiscrete((DiscreteSignal)signal);
        }
        if (signal instanceof RealSignal) {
            return ConvertSignal.toDiscrete((RealSignal)signal);
        }
        return ConvertSignal.toDiscrete((ComplexSignal)signal);
    }

    public static RealSignal toRealDiscrete(Signal signal) {
        if (signal instanceof DiscreteSignal) {
            return ConvertSignal.toRealDiscrete((DiscreteSignal)signal);
        }
        if (signal instanceof RealSignal) {
            return ConvertSignal.toRealDiscrete((RealSignal)signal);
        }
        return ConvertSignal.toRealDiscrete((ComplexSignal)signal);
    }

    public static ComplexSignal toComplex(Signal signal) {
        if (signal instanceof DiscreteSignal) {
            return ConvertSignal.toComplex((DiscreteSignal)signal);
        }
        if (signal instanceof RealSignal) {
            return ConvertSignal.toComplex((RealSignal)signal);
        }
        return ConvertSignal.toComplex((ComplexSignal)signal);
    }

    public static DiscreteSignal toDiscrete(DiscreteSignal signal) {
        int length = signal.length();
        DiscreteSignal newsignal = new DiscreteSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, signal.get(x));
            ++x;
        }
        return newsignal;
    }

    public static DiscreteSignal toDiscrete(RealSignal signal) {
        int length = signal.length();
        DiscreteSignal newsignal = new DiscreteSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, (short)signal.get(x));
            ++x;
        }
        return newsignal;
    }

    public static DiscreteSignal toDiscrete(ComplexSignal signal) {
        int length = signal.length();
        DiscreteSignal newsignal = null;
        newsignal = new DiscreteSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, (int)signal.getReal(x));
            ++x;
        }
        return newsignal;
    }

    public static RealSignal toRealDiscrete(DiscreteSignal signal) {
        int length = signal.length();
        RealSignal newsignal = new RealSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, signal.get(x));
            ++x;
        }
        return newsignal;
    }

    public static RealSignal toRealDiscrete(RealSignal signal) {
        int length = signal.length();
        RealSignal newsignal = new RealSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, signal.get(x));
            ++x;
        }
        return newsignal;
    }

    public static RealSignal toRealDiscrete(ComplexSignal signal) {
        int length = signal.length();
        RealSignal newsignal = null;
        newsignal = new RealSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.set(x, signal.getReal(x));
            ++x;
        }
        return newsignal;
    }

    public static ComplexSignal toComplex(DiscreteSignal signal) {
        int length = signal.length();
        Complex complex = new Complex();
        ComplexSignal newsignal = new ComplexSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.setReal(x, signal.get(x));
            newsignal.setImag(x, 0.0f);
            ++x;
        }
        return newsignal;
    }

    public static ComplexSignal toComplex(RealSignal signal) {
        int length = signal.length();
        Complex complex = new Complex();
        ComplexSignal newsignal = new ComplexSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.setReal(x, signal.get(x));
            newsignal.setImag(x, 0.0f);
            ++x;
        }
        return newsignal;
    }

    public static ComplexSignal toComplex(ComplexSignal signal) {
        int length = signal.length();
        ComplexSignal newsignal = null;
        newsignal = new ComplexSignal(length);
        int x = 0;
        while (x < length) {
            newsignal.setReal(x, signal.getReal(x));
            newsignal.setImag(x, signal.getImag(x));
            ++x;
        }
        return newsignal;
    }
}

