/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.ConvertSignal;
import jm.jigl.ROI;
import jm.jigl.Signal;

public class DiscreteSignal
implements Signal {
    protected short[] data;
    protected int length;

    public DiscreteSignal() {
        this.length = 0;
        this.data = null;
    }

    public DiscreteSignal(int x) {
        this.length = x;
        this.data = new short[this.length];
    }

    public DiscreteSignal(DiscreteSignal s) {
        this.length = s.length();
        this.data = s.data();
    }

    public Signal copy() {
        DiscreteSignal s = new DiscreteSignal(this.length);
        s.length = this.length;
        int x = 0;
        while (x < this.length) {
            s.data[x] = this.data[x];
            ++x;
        }
        return s;
    }

    public final int length() {
        return this.length;
    }

    public final short[] data() {
        return this.data;
    }

    public final int get(int x) {
        return this.data[x];
    }

    public final void set(int x, int value) {
        this.data[x] = (short)value;
    }

    public final DiscreteSignal clear() {
        this.clear(0);
        return this;
    }

    public final DiscreteSignal clear(int val) {
        int x = 0;
        while (x < this.length) {
            this.data[x] = (short)val;
            ++x;
        }
        return this;
    }

    public final void add(int x, int value) {
        int n = x;
        this.data[n] = (short)(this.data[n] + (short)value);
    }

    public final void subtract(int x, int value) {
        int n = x;
        this.data[n] = (short)(this.data[n] - (short)value);
    }

    public final void multiply(int x, int value) {
        int n = x;
        this.data[n] = (short)(this.data[n] * (short)value);
    }

    public final void divide(int x, int value) {
        int n = x;
        this.data[n] = (short)(this.data[n] / (short)value);
    }

    public final int min() {
        short min = Short.MAX_VALUE;
        int x = 0;
        while (x < this.length) {
            short p = this.data[x];
            if (p < min) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final int max() {
        short max = Short.MIN_VALUE;
        int x = 0;
        while (x < this.length) {
            short p = this.data[x];
            if (p > max) {
                max = p;
            }
            ++x;
        }
        return max;
    }

    public final DiscreteSignal add(int v) {
        short sv = (short)v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = (short)(this.data[n] + sv);
        }
        return this;
    }

    public final DiscreteSignal subtract(int v) {
        short sv = (short)v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = (short)(this.data[n] - sv);
        }
        return this;
    }

    public final DiscreteSignal multiply(int v) {
        short sv = (short)v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = (short)(this.data[n] * sv);
        }
        return this;
    }

    public final DiscreteSignal divide(int v) {
        short sv = (short)v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = (short)(this.data[n] / sv);
        }
        return this;
    }

    public final DiscreteSignal add(DiscreteSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = (short)(this.data[n] + s.get(x));
            ++x;
        }
        return this;
    }

    public DiscreteSignal addbuffer(int w, int color) {
        int Y = this.length;
        DiscreteSignal g = new DiscreteSignal(w);
        int y = 0;
        while (y < Y) {
            g.data[y] = y < Y ? this.data[y] : (short)color;
            ++y;
        }
        return g;
    }

    public final DiscreteSignal subtract(DiscreteSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = (short)(this.data[n] - s.get(x));
            ++x;
        }
        return this;
    }

    public final DiscreteSignal diff(DiscreteSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = (short)(this.data[n] - s.get(x));
            if (this.data[x] < 0) {
                this.data[x] = -this.data[x];
            }
            ++x;
        }
        return this;
    }

    public final DiscreteSignal multiply(DiscreteSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = (short)(this.data[n] * s.get(x));
            ++x;
        }
        return this;
    }

    public final DiscreteSignal divide(DiscreteSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = (short)(this.data[n] / s.get(x));
            ++x;
        }
        return this;
    }

    public String toString() {
        String str = this.length + "\n";
        int x = 0;
        while (x < this.length) {
            str = str + this.data[x] + " ";
            ++x;
        }
        str = str + "\n";
        return str;
    }

    public void byteSize() {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int value = 0;
        int x = 0;
        while (x < this.length) {
            value = (int)(255.0 / range * ((double)this.data[x] - min));
            value = 0xFF & value;
            this.data[x] = (short)value;
            ++x;
        }
    }

    public final void clip(int min, int max) {
        int value = 0;
        int x = 0;
        while (x < this.length) {
            value = this.data[x];
            value = value > max ? max : value;
            value = value < min ? min : value;
            this.data[x] = (short)value;
            ++x;
        }
    }

    public void convolve(DiscreteSignal kernel) {
        int x;
        int Num = kernel.length();
        int mid = Num / 2;
        double sum = 0.0;
        short[] value = new short[this.length];
        float[] kern = ConvertSignal.toRealDiscrete((DiscreteSignal)kernel).data;
        int x2 = 0;
        while (x2 < Num) {
            sum += (double)kern[x2];
            ++x2;
        }
        if (sum != 0.0) {
            x = 0;
            while (x < Num) {
                int n = x++;
                kern[n] = (float)((double)kern[n] / sum);
            }
        }
        x = 0;
        while (x < this.length) {
            sum = 0.0;
            int i = -mid;
            while (i <= mid) {
                try {
                    sum += (double)((float)this.data[x + i] * kern[mid + i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value[x] = (short)sum;
            ++x;
        }
        this.data = value;
    }

    private double[] sort(double[] vals, int size) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        double temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size) {
        int Num = size > this.length ? this.length : size;
        int mid = Num / 2;
        double[] value = new double[Num * Num];
        int x = 0;
        while (x < this.length) {
            int count = 0;
            int i = -mid;
            while (i <= mid) {
                try {
                    value[count++] = this.data[x + i];
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value = this.sort(value, count);
            this.data[x] = (short)value[count / 2];
            ++x;
        }
    }

    public Signal copy(ROI r) {
        DiscreteSignal s = new DiscreteSignal(r.lx() - r.ux());
        s.length = this.length;
        int x = r.ux();
        while (x < r.lx()) {
            s.data[x] = this.data[x];
            ++x;
        }
        return s;
    }

    public final int get(int x, ROI r) {
        return this.data[x + r.ux()];
    }

    public final void set(int x, int value, ROI r) {
        this.data[x + r.ux()] = (short)value;
    }

    public final DiscreteSignal clear(ROI r) {
        this.clear(0);
        return this;
    }

    public final DiscreteSignal clear(int val, ROI r) {
        int x = r.ux();
        while (x < r.lx()) {
            this.data[x] = (short)val;
            ++x;
        }
        return this;
    }

    public final void add(int x, int value, ROI r) {
        int n = x + r.ux();
        this.data[n] = (short)(this.data[n] + (short)value);
    }

    public final void subtract(int x, int value, ROI r) {
        int n = x + r.ux();
        this.data[n] = (short)(this.data[n] - (short)value);
    }

    public final void multiply(int x, int value, ROI r) {
        int n = x + r.ux();
        this.data[n] = (short)(this.data[n] * (short)value);
    }

    public final void divide(int x, int value, ROI r) {
        int n = x + r.ux();
        this.data[n] = (short)(this.data[n] / (short)value);
    }

    public final int min(ROI r) {
        short min = Short.MAX_VALUE;
        int x = r.ux();
        while (x < r.lx()) {
            short p = this.data[x];
            if (p < min) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final int max(ROI r) {
        short max = Short.MIN_VALUE;
        int x = r.ux();
        while (x < r.lx()) {
            short p = this.data[x];
            if (p > max) {
                max = p;
            }
            ++x;
        }
        return max;
    }

    public final DiscreteSignal add(int v, ROI r) {
        short sv = (short)v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = (short)(this.data[n] + sv);
        }
        return this;
    }

    public final DiscreteSignal subtract(int v, ROI r) {
        short sv = (short)v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = (short)(this.data[n] - sv);
        }
        return this;
    }

    public final DiscreteSignal multiply(int v, ROI r) {
        short sv = (short)v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = (short)(this.data[n] * sv);
        }
        return this;
    }

    public final DiscreteSignal divide(int v, ROI r) {
        short sv = (short)v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = (short)(this.data[n] / sv);
        }
        return this;
    }

    public final DiscreteSignal subtract(DiscreteSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = (short)(this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
        return this;
    }

    public final DiscreteSignal multiply(DiscreteSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = (short)(this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
        return this;
    }

    public final DiscreteSignal divide(DiscreteSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = (short)(this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
        return this;
    }

    public final DiscreteSignal add(DiscreteSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = (short)(this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux()));
            ++x;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.length + "\n";
        int x = r.ux();
        while (x < r.lx()) {
            str = str + this.data[x] + " ";
            ++x;
        }
        str = str + "\n";
        return str;
    }

    public void byteSize(ROI r) {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int value = 0;
        int x = r.ux();
        while (x < r.lx()) {
            value = (int)(255.0 / range * ((double)this.data[x] - min));
            value = 0xFF & value;
            this.data[x] = (short)value;
            ++x;
        }
    }

    public final void clip(int min, int max, ROI r) {
        int value = 0;
        int x = r.ux();
        while (x < r.lx()) {
            value = this.data[x];
            value = value > max ? max : value;
            value = value < min ? min : value;
            this.data[x] = (short)value;
            ++x;
        }
    }

    public void convolve(DiscreteSignal kernel, ROI r) {
        int x;
        int Num = kernel.length();
        int mid = Num / 2;
        double sum = 0.0;
        short[] value = new short[this.length];
        float[] kern = ConvertSignal.toRealDiscrete((DiscreteSignal)kernel).data;
        int x2 = r.ux();
        while (x2 < Num) {
            sum += (double)kern[x2];
            ++x2;
        }
        if (sum != 0.0) {
            x = r.ux();
            while (x < Num) {
                int n = x++;
                kern[n] = (float)((double)kern[n] / sum);
            }
        }
        x = r.ux();
        while (x < r.lx()) {
            sum = 0.0;
            int i = -mid;
            while (i <= mid) {
                try {
                    sum += (double)((float)this.data[x + i] * kern[mid + i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value[x] = (short)sum;
            ++x;
        }
        this.data = value;
    }

    private double[] sort(double[] vals, int size, ROI r) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        double temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size, ROI r) {
        int Num = size > this.length ? this.length : size;
        int mid = Num / 2;
        double[] value = new double[Num * Num];
        int x = r.ux();
        while (x < r.lx()) {
            int count = 0;
            int i = -mid;
            while (i <= mid) {
                try {
                    value[count++] = this.data[x + i];
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value = this.sort(value, count);
            this.data[x] = (short)value[count / 2];
            ++x;
        }
    }
}

