/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.ComplexImage;
import jm.jigl.GrayImage;
import jm.jigl.Image;
import jm.jigl.RealGrayImage;

public class FFT {
    static final int MAX_POW = 31;
    static final int[] pow2;

    static int BitReverse(int i, int k) {
        int rev = 0;
        int j = 0;
        while (j < k) {
            if ((i & pow2[k - j - 1]) > 0) {
                rev |= pow2[j];
            }
            ++j;
        }
        return rev;
    }

    static void bitDump(int d) {
        System.out.println(d + ":");
        int i = 31;
        while (i >= 0) {
            if ((d & pow2[i]) != 0) {
                System.out.print("1");
            } else {
                System.out.print("0");
            }
            --i;
        }
        System.out.println();
    }

    public static ComplexImage forward(Image im) {
        return FFT.doFFT(im, true);
    }

    public static ComplexImage inverse(Image im) {
        return FFT.doFFT(im, false);
    }

    public static ComplexImage doFFT(Image im, boolean forward) {
        int x = 0;
        int lgn = 0;
        int n = 0;
        int rev = 0;
        int size = im.X() * im.Y();
        float[][] a = null;
        while (x <= 31) {
            if (pow2[x] >= size) {
                lgn = x;
                n = pow2[lgn];
                a = new float[2][n];
                int y = 0;
                while (y < n) {
                    rev = FFT.BitReverse(y, lgn);
                    try {
                        ComplexImage ci;
                        Image ub;
                        if (forward) {
                            if (im instanceof GrayImage) {
                                ub = (GrayImage)im;
                                if (y < ((GrayImage)ub).X() * ((GrayImage)ub).Y()) {
                                    a[0][rev] = ((GrayImage)ub).get(y % ((GrayImage)ub).X(), y / ((GrayImage)ub).X());
                                    a[1][rev] = 0.0f;
                                } else {
                                    a[0][rev] = 0.0f;
                                }
                                a[1][rev] = 0.0f;
                            } else if (im instanceof ComplexImage) {
                                ci = (ComplexImage)im;
                                if (y < ci.X() * ci.Y()) {
                                    a[0][rev] = ci.getReal(y % im.X(), y / im.X());
                                    a[1][rev] = ci.getImag(y % im.X(), y / im.X());
                                } else {
                                    a[0][rev] = 0.0f;
                                    a[1][rev] = 0.0f;
                                }
                            } else if (im instanceof RealGrayImage) {
                                ub = (RealGrayImage)im;
                                if (y < ((RealGrayImage)ub).X() * ((RealGrayImage)ub).Y()) {
                                    a[0][rev] = ((RealGrayImage)ub).get(y % ((RealGrayImage)ub).X(), y / ((RealGrayImage)ub).X());
                                    a[1][rev] = 0.0f;
                                } else {
                                    a[0][rev] = 0.0f;
                                    a[1][rev] = 0.0f;
                                }
                            }
                        } else if (im instanceof GrayImage) {
                            ub = (GrayImage)im;
                            if (y < ((GrayImage)ub).X() * ((GrayImage)ub).Y()) {
                                a[0][y] = (float)((GrayImage)ub).get(y % ((GrayImage)ub).X(), y / ((GrayImage)ub).X()) / (float)n;
                            } else {
                                a[0][rev] = 0.0f;
                            }
                            a[1][rev] = 0.0f;
                        } else if (im instanceof ComplexImage) {
                            ci = (ComplexImage)im;
                            if (y < ci.X() * ci.Y()) {
                                a[0][rev] = ci.getReal(y % ci.X(), y / ci.X()) / (float)n;
                                a[1][rev] = ci.getImag(y % ci.X(), y / ci.X()) / (float)n;
                            } else {
                                a[0][rev] = 0.0f;
                                a[1][rev] = 0.0f;
                            }
                        } else if (im instanceof RealGrayImage) {
                            ub = (RealGrayImage)im;
                            if (y < ((RealGrayImage)ub).X() * ((RealGrayImage)ub).Y()) {
                                a[0][y] = ((RealGrayImage)ub).get(y % ((RealGrayImage)ub).X(), y / ((RealGrayImage)ub).X()) / (float)n;
                            } else {
                                a[0][rev] = 0.0f;
                            }
                            a[1][rev] = 0.0f;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        a[0][rev] = 0.0f;
                        a[1][rev] = 0.0f;
                    }
                    catch (Exception e) {
                        System.out.println("FFT Error:  " + e.toString());
                    }
                    ++y;
                }
                break;
            }
            ++x;
        }
        int m = 0;
        int mdiv2 = 0;
        float omega_m0 = 0.0f;
        float omega_m1 = 0.0f;
        float[][] b = new float[2][n];
        int w = im.X();
        int h = im.Y();
        double minustwotimesPI = Math.PI * -2;
        double twotimesPI = Math.PI * 2;
        int s = 1;
        while (s <= lgn) {
            m = pow2[s];
            mdiv2 = m >> 1;
            if (forward) {
                double minustwotimesPIdivm = minustwotimesPI / (double)m;
                omega_m0 = (float)Math.cos(minustwotimesPIdivm);
                omega_m1 = (float)Math.sin(minustwotimesPIdivm);
            } else {
                double twotimesPIdivm = twotimesPI / (double)m;
                omega_m0 = (float)Math.cos(twotimesPIdivm);
                omega_m1 = (float)Math.sin(twotimesPIdivm);
            }
            float omega0 = 1.0f;
            float omega1 = 0.0f;
            int j = 0;
            while (j < mdiv2) {
                int k = j;
                while (k < n) {
                    int kplusmdiv2 = k + mdiv2;
                    float t0 = omega0;
                    float t1 = omega1;
                    float u0 = a[0][k];
                    float u1 = a[1][k];
                    float temp = t0 * a[0][kplusmdiv2] - t1 * a[1][kplusmdiv2];
                    t1 = t0 * a[1][kplusmdiv2] + t1 * a[0][kplusmdiv2];
                    t0 = temp;
                    a[0][k] = u0 + t0;
                    a[1][k] = u1 + t1;
                    a[0][kplusmdiv2] = u0 - t0;
                    a[1][kplusmdiv2] = u1 - t1;
                    k += m;
                }
                float t2 = omega0 * omega_m0 - omega1 * omega_m1;
                omega1 = omega0 * omega_m1 + omega1 * omega_m0;
                omega0 = t2;
                ++j;
            }
            ++s;
        }
        ComplexImage ar = new ComplexImage(w, h);
        int i = 0;
        while (i < n) {
            ar.set(i % w, i / w, a[0][i], a[1][i]);
            ++i;
        }
        return ar;
    }

    static {
        MAX_POW = 31;
        pow2 = new int[32];
        FFT.pow2[0] = 1;
        int i = 1;
        while (i <= 31) {
            FFT.pow2[i] = 2 * pow2[i - 1];
            ++i;
        }
    }
}

