/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jm.jigl.DummyObserver;
import jm.jigl.Image;
import jm.jigl.ROI;

public class GrayImage
implements Image {
    protected short[][] data;
    protected int X;
    protected int Y;

    public GrayImage() {
        this.X = 0;
        this.Y = 0;
        this.data = null;
    }

    public GrayImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.data = new short[this.Y][this.X];
    }

    public GrayImage(int x, int y, short[] dat) {
        this.X = x;
        this.Y = y;
        this.data = new short[this.Y][this.X];
        int a = 0;
        while (a < y) {
            int b = 0;
            while (b < x) {
                this.data[a][b] = dat[a * this.Y + b];
                ++b;
            }
            ++a;
        }
    }

    public GrayImage(short[][] dat) {
        int max = 0;
        this.Y = dat.length;
        int y = 0;
        while (y < this.X) {
            if (dat[y].length > max) {
                max = dat[y].length;
            }
            ++y;
        }
        this.X = max;
        int a = 0;
        while (a < this.Y) {
            int b = 0;
            while (b < this.X) {
                this.data[a][b] = b < this.data[a].length ? dat[a][b] : (short)0;
                ++b;
            }
            ++a;
        }
        this.data = dat;
    }

    public GrayImage(GrayImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = img.data;
    }

    public GrayImage(java.awt.Image img) {
        int w = img.getWidth(DummyObserver.dummy);
        int h = img.getHeight(DummyObserver.dummy);
        this.X = w;
        this.Y = h;
        this.data = new short[this.Y][this.X];
        this.InitFromImage(img, 0, 0, w, h);
    }

    public Image copy() {
        GrayImage g = new GrayImage(this.X, this.Y);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                g.data[y][x] = this.data[y][x];
                ++x;
            }
            ++y;
        }
        return g;
    }

    public GrayImage addbuffer(int w, int h, int color) {
        GrayImage g = new GrayImage(w, h);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                g.data[y][x] = x < this.X && y < this.Y ? this.data[y][x] : (short)color;
                ++x;
            }
            ++y;
        }
        return g;
    }

    public GrayImage addbuffer(int w, int h, int xoff, int yoff, int color) {
        GrayImage g = new GrayImage(w, h);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                g.data[y][x] = x < xoff || y < yoff ? (short)color : (x > xoff + this.X || y > yoff + this.Y ? (short)color : this.data[y - yoff][x - xoff]);
                ++x;
            }
            ++y;
        }
        return g;
    }

    private void InitFromImage(java.awt.Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        int index = 0;
        int iy = 0;
        while (iy < this.Y) {
            int ix = 0;
            while (ix < this.X) {
                red = 0xFF & pixels[index] >> 16;
                green = 0xFF & pixels[index] >> 8;
                blue = 0xFF & pixels[index];
                this.data[iy][ix] = (short)((double)red * 0.299 + (double)green * 0.587 + (double)blue * 0.114);
                ++index;
                ++ix;
            }
            ++iy;
        }
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public final int get(int x, int y) {
        return this.data[y][x];
    }

    public final void set(int x, int y, int value) {
        this.data[y][x] = (short)value;
    }

    public final GrayImage clear() {
        this.clear(0);
        return this;
    }

    public final GrayImage clear(int val) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.data[y][x] = (short)val;
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final void add(int x, int y, int value) {
        short[] sArray = this.data[y];
        int n = x;
        sArray[n] = (short)(sArray[n] + (short)value);
    }

    public final void subtract(int x, int y, int value) {
        short[] sArray = this.data[y];
        int n = x;
        sArray[n] = (short)(sArray[n] - (short)value);
    }

    public final void multiply(int x, int y, int value) {
        short[] sArray = this.data[y];
        int n = x;
        sArray[n] = (short)(sArray[n] * (short)value);
    }

    public final void divide(int x, int y, int value) {
        short[] sArray = this.data[y];
        int n = x;
        sArray[n] = (short)(sArray[n] / (short)value);
    }

    public final int min() {
        short min = Short.MAX_VALUE;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short p = this.data[y][x];
                if (p < min) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final int max() {
        short max = Short.MIN_VALUE;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short p = this.data[y][x];
                if (p > max) {
                    max = p;
                }
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final GrayImage add(int v) {
        short sv = (short)v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] + sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage subtract(int v) {
        short sv = (short)v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] - sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage multiply(int v) {
        short sv = (short)v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] * sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage divide(int v) {
        short sv = (short)v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] / sv);
            }
            ++y;
        }
        return this;
    }

    public final int addSum() {
        int sum = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum += this.data[y][x];
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final int absSum() {
        int sum = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum = this.data[y][x] < 0 ? (sum += -this.data[y][x]) : (sum += this.data[y][x]);
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final long sqrSum() {
        long sum = 0L;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum += (long)(this.data[y][x] * this.data[y][x]);
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final GrayImage add(GrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    short[] sArray = this.data[y];
                    int n = x;
                    sArray[n] = (short)(sArray[n] + im.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage subtract(GrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    short[] sArray = this.data[y];
                    int n = x;
                    sArray[n] = (short)(sArray[n] - im.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage diff(GrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                short[] sArray = this.data[y];
                int n = x;
                sArray[n] = (short)(sArray[n] - im.get(x, y));
                if (this.data[y][x] < 0) {
                    this.data[y][x] = -this.data[y][x];
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage multiply(GrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    short[] sArray = this.data[y];
                    int n = x;
                    sArray[n] = (short)(sArray[n] * im.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage divide(GrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    short[] sArray = this.data[y];
                    int n = x;
                    sArray[n] = (short)(sArray[n] / im.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString() {
        String str = this.X + ":" + this.Y + "\n";
        int x = 0;
        while (x < this.X) {
            int y = 0;
            while (y < this.Y) {
                str = str + this.data[y][x] + " ";
                ++y;
            }
            str = str + "\n";
            ++x;
        }
        return str;
    }

    public ImageProducer getJavaImage() {
        int min = this.min();
        int max = this.max();
        if (min >= 0 && max <= 255) {
            min = 0;
            max = 255;
        }
        int range = max - min;
        int[] pix = new int[this.X * this.Y];
        int index = 0;
        int value = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = (int)(255.0 / (double)range * (double)((float)this.data[y][x] - (float)min));
                value = 0xFF & value;
                pix[index] = 0xFF000000 | value << 16 | value << 8 | value;
                ++index;
                ++x;
            }
            ++y;
        }
        return new MemoryImageSource(this.X, this.Y, pix, 0, this.X);
    }

    public void byteSize() {
        float min = this.min();
        float max = this.max();
        float range = max - min;
        int value = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = (int)(255.0 / (double)range * (double)((float)this.data[y][x] - min));
                value = 0xFF & value;
                this.data[y][x] = (short)value;
                ++x;
            }
            ++y;
        }
    }

    public void clip(int min, int max) {
        int value = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = this.data[y][x];
                value = value > max ? max : value;
                value = value < min ? min : value;
                this.data[y][x] = (short)value;
                ++x;
            }
            ++y;
        }
    }

    private double[] sort(double[] vals, int size) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        double temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        double[] value = new double[NumX * NumY];
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                int count = 0;
                int j = -midY;
                while (j <= midY) {
                    int i = -midX;
                    while (i <= midX) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    ++j;
                }
                value = this.sort(value, count);
                this.data[y][x] = (short)value[count / 2];
                ++x;
            }
            ++y;
        }
    }

    public Image copy(ROI r) {
        GrayImage g = new GrayImage(r.lx() - r.ux(), r.ly() - r.uy());
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                g.data[y][x] = this.data[y][x];
                ++x;
            }
            ++y;
        }
        return g;
    }

    public final void set(int x, int y, int value, ROI r) {
        this.data[r.uy() + y][r.ux() + x] = (short)value;
    }

    public final void add(int x, int y, int value, ROI r) {
        short[] sArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        sArray[n] = (short)(sArray[n] + (short)value);
    }

    public final void subtract(int x, int y, int value, ROI r) {
        short[] sArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        sArray[n] = (short)(sArray[n] - (short)value);
    }

    public final void multiply(int x, int y, int value, ROI r) {
        short[] sArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        sArray[n] = (short)(sArray[n] * (short)value);
    }

    public final void divide(int x, int y, int value, ROI r) {
        short[] sArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        sArray[n] = (short)(sArray[n] / (short)value);
    }

    public final int min(ROI r) {
        short min = Short.MAX_VALUE;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short p = this.data[y][x];
                if (p < min) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final int max(ROI r) {
        short max = Short.MIN_VALUE;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short p = this.data[y][x];
                if (p > max) {
                    max = p;
                }
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final GrayImage add(int v, ROI r) {
        short sv = (short)v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] + sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage subtract(int v, ROI r) {
        short sv = (short)v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] - sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage multiply(int v, ROI r) {
        short sv = (short)v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] * sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage divide(int v, ROI r) {
        short sv = (short)v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                short[] sArray = this.data[y];
                int n = x++;
                sArray[n] = (short)(sArray[n] / sv);
            }
            ++y;
        }
        return this;
    }

    public final GrayImage add(GrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                short[] sArray = this.data[x];
                int n = y;
                sArray[n] = (short)(sArray[n] + im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage subtract(GrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                short[] sArray = this.data[x];
                int n = y;
                sArray[n] = (short)(sArray[n] - im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage multiply(GrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                short[] sArray = this.data[x];
                int n = y;
                sArray[n] = (short)(sArray[n] * im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final GrayImage divide(GrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                short[] sArray = this.data[x];
                int n = y;
                sArray[n] = (short)(sArray[n] / im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy()));
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.X + ":" + this.Y + "\n";
        int x = r.ux();
        while (x < r.lx()) {
            int y = r.uy();
            while (y < r.ly()) {
                str = str + this.data[y][x] + " ";
                ++y;
            }
            str = str + "\n";
            ++x;
        }
        return str;
    }

    public void clip(int min, int max, ROI r) {
        int value = 0;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                value = this.data[y][x];
                value = value > max ? max : value;
                value = value < min ? min : value;
                this.data[y][x] = (short)value;
                ++x;
            }
            ++y;
        }
    }

    public void median(int size, ROI r) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        double[] value = new double[NumX * NumY];
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                int count = 0;
                int j = -midY;
                while (j <= midY) {
                    int i = -midX;
                    while (i <= midX) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    ++j;
                }
                value = this.sort(value, count);
                this.data[y][x] = (short)value[count / 2];
                ++x;
            }
            ++y;
        }
    }

    public static void main(String[] args) {
        int[][] array = new int[][]{{1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 6}};
        System.out.println(array[0].length);
        System.out.println(array[6][0]);
    }
}

