/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.io.IOException;
import jm.jigl.BadImageException;
import jm.jigl.ComplexImage;
import jm.jigl.FileExtensionNotSupportedException;
import jm.jigl.GrayImage;
import jm.jigl.IllegalPBMFormatException;
import jm.jigl.Image;
import jm.jigl.ImageInputStream;
import jm.jigl.ImageNotSupportedException;
import jm.jigl.RealGrayImage;

public class ImageCanvas
extends Canvas {
    MediaTracker m_tracker = null;
    protected java.awt.Image image;
    protected Image jimage;
    public int mouseux = 0;
    public int mouseuy = 0;
    public int mouselx = 0;
    public int mousely = 0;
    public boolean mouse_clicked = false;
    public boolean box_draw = true;
    private boolean db = true;

    public ImageCanvas() {
    }

    public ImageCanvas(String fname) throws FileExtensionNotSupportedException, BadImageException, IllegalPBMFormatException, InterruptedException, ImageNotSupportedException, FileNotFoundException, IOException {
        this.image = this.getImageFromFile(fname);
    }

    public ImageCanvas(GrayImage img) throws BadImageException {
        this.image = this.getJavaImage(img);
        this.jimage = img;
    }

    public ImageCanvas(RealGrayImage img) throws BadImageException {
        this.image = this.getJavaImage(img);
        this.jimage = img;
    }

    public ImageCanvas(ComplexImage img) throws BadImageException {
        this.image = this.getJavaImage(img);
        this.jimage = img;
    }

    public ImageCanvas(Image img) throws BadImageException {
        this.image = this.getJavaImage(img);
        this.jimage = img;
    }

    public void setDrawBox(boolean value) {
        this.db = value;
    }

    public void setImage(java.awt.Image img) {
        this.image = img;
        this.jimage = null;
    }

    public void setImage(Image img) throws BadImageException {
        this.image = this.getJavaImage(img);
        this.jimage = img;
    }

    public Image getImage() {
        return this.jimage;
    }

    public java.awt.Image getJavaImage() {
        return this.image;
    }

    public Graphics setOffScreen() {
        java.awt.Image tempImage = this.image;
        this.image = this.createImage(this.image.getWidth(this), this.image.getHeight(this));
        Graphics g = this.image.getGraphics();
        g.drawImage(tempImage, 0, 0, this);
        return g;
    }

    public Graphics setOffScreen(double xfactor, double yfactor) {
        java.awt.Image tempImage = this.image;
        this.image = this.createImage((int)((double)this.image.getWidth(this) * xfactor), (int)((double)this.image.getHeight(this) * yfactor));
        Graphics g = this.image.getGraphics();
        g.drawImage(tempImage, 0, 0, (int)((double)tempImage.getWidth(this) * xfactor), (int)((double)tempImage.getHeight(this) * yfactor), this);
        return g;
    }

    public void setVisible(boolean b) {
        this.setSize(this.imWidth(), this.imHeight());
        super.setVisible(b);
    }

    public int imHeight() {
        return this.image.getHeight(this);
    }

    public int imWidth() {
        return this.image.getWidth(this);
    }

    public java.awt.Image getJavaImage(Image img) throws BadImageException, RuntimeException {
        Image im;
        int w = 0;
        int h = 0;
        java.awt.Image jimg = null;
        int max = Short.MIN_VALUE;
        int min = Short.MAX_VALUE;
        if (img instanceof GrayImage) {
            im = (GrayImage)img;
            w = ((GrayImage)im).X();
            h = ((GrayImage)im).Y();
            jimg = this.createImage(((GrayImage)im).getJavaImage());
        } else if (img instanceof RealGrayImage) {
            im = (RealGrayImage)img;
            w = ((RealGrayImage)im).X();
            h = ((RealGrayImage)im).Y();
            jimg = this.createImage(((RealGrayImage)im).getJavaImage());
        } else if (img instanceof ComplexImage) {
            im = (ComplexImage)img;
            w = ((ComplexImage)im).X();
            h = ((ComplexImage)im).Y();
            jimg = this.createImage(((ComplexImage)im).getJavaImage());
        } else {
            throw new BadImageException();
        }
        h += 0;
        if ((w += 0) > this.getSize().width) {
            this.setSize(w, h);
        }
        if (h > this.getSize().height) {
            this.setSize(w, h);
        }
        return jimg;
    }

    public java.awt.Image getImageFromFile(String fname) throws FileExtensionNotSupportedException, BadImageException, IllegalPBMFormatException, InterruptedException, ImageNotSupportedException, IOException, FileNotFoundException {
        java.awt.Image img = null;
        if (fname.endsWith(".gif") || fname.endsWith(".jpg") || fname.endsWith(".jpeg")) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            img = toolkit.getImage(fname);
            this.m_tracker = new MediaTracker(this);
            this.m_tracker.addImage(img, 0);
            try {
                this.m_tracker.waitForAll();
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted image load.");
            }
            this.jimage = null;
            return img;
        }
        if (fname.endsWith(".ppm") || fname.endsWith(".pgm") || fname.endsWith(".pbm")) {
            ImageInputStream is = new ImageInputStream(fname);
            this.jimage = is.read();
            return this.getJavaImage(this.jimage);
        }
        return img;
    }

    public void update(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        g.setXORMode(Color.white);
        if (this.db) {
            g.drawLine(this.mouseux, this.mouseuy, this.mouselx, this.mouseuy);
            g.drawLine(this.mouseux, this.mousely, this.mouselx, this.mousely);
            g.drawLine(this.mouseux, this.mouseuy, this.mouseux, this.mousely);
            g.drawLine(this.mouselx, this.mouseuy, this.mouselx, this.mousely);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }
}

