/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.awt.Canvas;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jm.jigl.GrayImage;
import jm.jigl.IllegalPBMFormatException;
import jm.jigl.Image;
import jm.jigl.ImageNotSupportedException;
import jm.jigl.RealGrayImage;

public class ImageInputStream
extends Canvas {
    protected BufferedInputStream data;
    protected int ndims;
    protected int X;
    protected int Y;
    protected java.awt.Image img = null;
    private int type;
    private static final int UNKNOWN = 0;
    private static final int PBM_ASCII = 1;
    private static final int PGM_ASCII = 2;
    private static final int PPM_ASCII = 3;
    private static final int PBM_RAW = 4;
    private static final int PGM_RAW = 5;
    private static final int PPM_RAW = 6;
    private static final int PRGM_RAW = 7;
    private static final int PRCM_RAW = 8;
    private static final int TIFF = 9;
    private static final int JIGL_GRAY = 10;
    private static final int JIGL_COLOR = 11;
    protected int maxval;
    protected float maxvalf;
    private int bitshift = -1;
    private int bits;

    public ImageInputStream(String fn) throws InterruptedException, FileNotFoundException, ImageNotSupportedException, IOException {
        if (fn.endsWith(".gif") || fn.endsWith(".jpg") || fn.endsWith(".jpeg")) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.img = toolkit.getImage(fn);
            MediaTracker m_tracker = new MediaTracker(this);
            m_tracker.addImage(this.img, 0);
            m_tracker.waitForAll();
        } else {
            this.ndims = 2;
            this.data = new BufferedInputStream(new FileInputStream(fn));
            this.type = this.readMagic();
            this.readHeader();
        }
    }

    public ImageInputStream(String url, int i) throws InterruptedException, IOException, ImageNotSupportedException, MalformedURLException {
        URL ur = new URL(url);
        if (url.endsWith(".gif") || url.endsWith(".jpg") || url.endsWith(".jpeg")) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.img = toolkit.getImage(ur);
            MediaTracker m_tracker = new MediaTracker(this);
            m_tracker.addImage(this.img, 0);
            m_tracker.waitForAll();
        } else {
            this.ndims = 2;
            this.data = new BufferedInputStream(ur.openStream());
            this.type = this.readMagic();
            this.readHeader();
        }
    }

    public ImageInputStream(ImageInputStream stream) {
        this.data = stream.data;
        this.ndims = stream.ndims;
        this.X = stream.X;
        this.Y = stream.Y;
        this.type = stream.type;
    }

    public int ndims() {
        return this.ndims;
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public int type() {
        return this.type;
    }

    public void close() throws IOException {
        if (this.data != null) {
            this.data.close();
        }
    }

    public int readMagic() throws ImageNotSupportedException, IOException {
        int t2;
        char[] c = new char[]{(char)this.readByte(this.data), (char)this.readByte(this.data)};
        String str = new String(c);
        if (str.equals("P1")) {
            t2 = 1;
        } else if (str.equals("P2")) {
            t2 = 2;
        } else if (str.equals("P3")) {
            t2 = 3;
        } else if (str.equals("P4")) {
            t2 = 4;
        } else if (str.equals("P5")) {
            t2 = 5;
        } else if (str.equals("P6")) {
            t2 = 6;
        } else if (str.equals("P7")) {
            t2 = 7;
        } else if (str.equals("P8")) {
            t2 = 8;
        } else {
            boolean t2 = false;
            throw new ImageNotSupportedException();
        }
        return t2;
    }

    public void readHeader() throws ImageNotSupportedException, IOException {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.X = this.readInt(this.data);
                this.Y = this.readInt(this.data);
                this.ndims = 2;
                if (this.type != 1 && this.type != 4 && this.type != 7 && this.type != 8) {
                    this.maxval = this.readInt(this.data);
                    break;
                }
                if (this.type != 1 && this.type != 4) {
                    this.maxvalf = this.readFloat(this.data);
                    break;
                }
                this.maxval = 1;
                break;
            }
            default: {
                throw new ImageNotSupportedException();
            }
        }
    }

    public Image read() throws ImageNotSupportedException, IllegalPBMFormatException, IOException {
        if (this.img == null) {
            GrayImage g_im = null;
            RealGrayImage rg_im = null;
            Object cx_im = null;
            switch (this.type) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    g_im = new GrayImage(this.X, this.Y);
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 7: {
                    rg_im = new RealGrayImage(this.X, this.Y);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    throw new ImageNotSupportedException();
                }
            }
            int[] color = new int[3];
            float[] colorf = new float[3];
            int y = 0;
            while (y < this.Y) {
                int x = 0;
                while (x < this.X) {
                    switch (this.type) {
                        case 1: {
                            int value;
                            char c = this.readChar(this.data);
                            if (c == '1') {
                                value = 0;
                            } else if (c == '0') {
                                value = 255;
                            } else {
                                throw new IllegalPBMFormatException();
                            }
                            g_im.set(x, y, value);
                            break;
                        }
                        case 2: {
                            int g = this.readInt(this.data);
                            g_im.set(x, y, g);
                            break;
                        }
                        case 3: {
                            int r = this.readInt(this.data);
                            int g = this.readInt(this.data);
                            int b = this.readInt(this.data);
                            color[0] = r;
                            color[1] = g;
                            color[2] = b;
                            break;
                        }
                        case 4: {
                            int value = this.readBit(this.data) ? 0 : 255;
                            g_im.set(x, y, value);
                            break;
                        }
                        case 5: {
                            int g = this.readByte(this.data);
                            if (this.maxval != 255) {
                                g = this.fixDepth(g);
                            }
                            g_im.set(x, y, g);
                            break;
                        }
                        case 7: {
                            float gf = this.readBytef(this.data);
                            if (this.maxvalf != 255.0f) {
                                gf = this.fixDepth(gf);
                            }
                            rg_im.set(x, y, gf);
                            break;
                        }
                        case 6: {
                            int r = this.readByte(this.data);
                            int g = this.readByte(this.data);
                            int b = this.readByte(this.data);
                            if (this.maxval != 255) {
                                r = this.fixDepth(r);
                                g = this.fixDepth(g);
                                b = this.fixDepth(b);
                            }
                            color[0] = r;
                            color[1] = g;
                            color[2] = b;
                            break;
                        }
                        case 8: {
                            float rf = this.readBytef(this.data);
                            float gf = this.readBytef(this.data);
                            float bf = this.readBytef(this.data);
                            if (this.maxvalf != 255.0f) {
                                rf = this.fixDepth(rf);
                                gf = this.fixDepth(gf);
                                bf = this.fixDepth(bf);
                            }
                            colorf[0] = rf;
                            colorf[1] = gf;
                            colorf[2] = bf;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            switch (this.type) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return g_im;
                }
                case 3: 
                case 6: 
                case 7: {
                    return rg_im;
                }
            }
            throw new ImageNotSupportedException();
        }
        GrayImage image = new GrayImage(this.img);
        return image;
    }

    private int readByte(InputStream data) throws IOException {
        int b = data.read();
        return b;
    }

    private float readBytef(InputStream data) throws IOException {
        float b = data.read();
        return b;
    }

    private int readInt(InputStream data) throws IOException {
        char c = this.readNonwhiteChar(data);
        if ((c < '0' || c > '9') && c != '-') {
            throw new IOException("junk in file where integer should be");
        }
        int i = 0;
        if (c == '-') {
            c = this.readChar(data);
            do {
                i = i * 10 + c - 48;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
            i = -i;
        } else {
            do {
                i = i * 10 + c - 48;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
        }
        return i;
    }

    private float readFloat(InputStream data) throws IOException {
        boolean flag = true;
        float cons = 0.1f;
        char c = this.readNonwhiteChar(data);
        if ((c < '0' || c > '9') && c != '-') {
            throw new IOException("junk in file where integer should be");
        }
        float i = 0.0f;
        if (c == '-') {
            c = this.readChar(data);
            do {
                i = i * 10.0f + (float)c - 48.0f;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
            i = -i;
            flag = false;
        } else {
            do {
                i = i * 10.0f + (float)c - 48.0f;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
        }
        c = this.readChar(data);
        if (c == '.') {
            this.readChar(data);
            do {
                i = flag ? (i += cons * (float)(c - 48)) : (i += -(cons * (float)(c - 48)));
                c = this.readChar(data);
                cons *= 0.1f;
            } while (c >= '0' && c <= '9');
        }
        return i;
    }

    private char readChar(InputStream data) throws IOException {
        char c = (char)this.readByte(data);
        if (c == '#') {
            while ((c = (char)this.readByte(data)) != '\n' && c != '\r') {
            }
        }
        return c;
    }

    private char readNonwhiteChar(InputStream data) throws IOException {
        char c;
        while ((c = this.readChar(data)) == ' ' || c == '\t' || c == '\n' || c == '\r') {
        }
        return c;
    }

    private int fixDepth(int p) {
        return (p * 255 + this.maxval / 2) / this.maxval;
    }

    private float fixDepth(float p) {
        return (p * 255.0f + this.maxvalf / 2.0f) / (float)this.maxval;
    }

    private boolean readBit(InputStream in) throws IOException {
        if (this.bitshift == -1) {
            this.bits = this.readByte(in);
            this.bitshift = 7;
        }
        boolean bit = (this.bits >> this.bitshift & 1) != 0;
        --this.bitshift;
        return bit;
    }

    static {
        UNKNOWN = 0;
        PBM_ASCII = 1;
        PGM_ASCII = 2;
        PPM_ASCII = 3;
        PBM_RAW = 4;
        PGM_RAW = 5;
        PPM_RAW = 6;
        PRGM_RAW = 7;
        PRCM_RAW = 8;
        TIFF = 9;
        JIGL_GRAY = 10;
        JIGL_COLOR = 11;
    }
}

