/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jm.jigl.DummyObserver;
import jm.jigl.Image;
import jm.jigl.ROI;

public class RealGrayImage
implements Image {
    protected float[][] data;
    protected int X;
    protected int Y;

    public RealGrayImage() {
        this.X = 0;
        this.Y = 0;
        this.data = null;
    }

    public RealGrayImage(int x, int y) {
        this.X = x;
        this.Y = y;
        this.data = new float[this.Y][this.X];
    }

    public RealGrayImage(int x, int y, float[] dat) {
        this.X = x;
        this.Y = y;
        this.data = new float[this.Y][this.X];
        int a = 0;
        while (a < y) {
            int b = 0;
            while (b < x) {
                this.data[a][b] = dat[a * this.Y + b];
                ++b;
            }
            ++a;
        }
    }

    public RealGrayImage(float[][] dat) {
        int max = 0;
        this.Y = dat.length;
        int y = 0;
        while (y < this.X) {
            if (dat[y].length > max) {
                max = dat[y].length;
            }
            ++y;
        }
        this.X = max;
        int a = 0;
        while (a < this.Y) {
            int b = 0;
            while (b < this.X) {
                this.data[a][b] = b < this.data[a].length ? dat[a][b] : 0.0f;
                ++b;
            }
            ++a;
        }
        this.data = dat;
    }

    public RealGrayImage(RealGrayImage img) {
        this.X = img.X();
        this.Y = img.Y();
        this.data = img.data;
    }

    public RealGrayImage(java.awt.Image img) {
        int w = img.getWidth(DummyObserver.dummy);
        int h = img.getHeight(DummyObserver.dummy);
        this.X = w;
        this.Y = h;
        this.data = new float[this.Y][this.X];
        this.InitFromImage(img, 0, 0, w, h);
    }

    public Image copy() {
        RealGrayImage g = new RealGrayImage(this.X, this.Y);
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                g.data[y][x] = this.data[y][x];
                ++x;
            }
            ++y;
        }
        return g;
    }

    private void InitFromImage(java.awt.Image img, int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        int index = 0;
        int iy = 0;
        while (iy < this.Y) {
            int ix = 0;
            while (ix < this.X) {
                red = 0xFF & pixels[index] >> 16;
                green = 0xFF & pixels[index] >> 8;
                blue = 0xFF & pixels[index];
                this.data[iy][ix] = (float)((double)red * 0.299 + (double)green * 0.587 + (double)blue * 0.114);
                ++index;
                ++ix;
            }
            ++iy;
        }
    }

    public final int X() {
        return this.X;
    }

    public final int Y() {
        return this.Y;
    }

    public final float get(int x, int y) {
        return this.data[y][x];
    }

    public final void set(int x, int y, float value) {
        this.data[y][x] = value;
    }

    public final RealGrayImage clear() {
        this.clear(0.0f);
        return this;
    }

    public final RealGrayImage clear(float val) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                this.data[y][x] = val;
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final void add(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] + value;
    }

    public final void subtract(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] - value;
    }

    public final void multiply(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] * value;
    }

    public final void divide(int x, int y, float value) {
        float[] fArray = this.data[y];
        int n = x;
        fArray[n] = fArray[n] / value;
    }

    public final float min() {
        float min = 32767.0f;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float p = this.data[y][x];
                if (p < min) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final float max() {
        float max = -32768.0f;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float p = this.data[y][x];
                if (p > max) {
                    max = p;
                }
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final float addSum() {
        float sum = 0.0f;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum += this.data[y][x];
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final float absSum() {
        float sum = 0.0f;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum = this.data[y][x] < 0.0f ? (sum += -this.data[y][x]) : (sum += this.data[y][x]);
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final double sqrSum() {
        double sum = 0.0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                sum += (double)(this.data[y][x] * this.data[y][x]);
                ++x;
            }
            ++y;
        }
        return sum;
    }

    public final RealGrayImage add(float v) {
        float sv = v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] + sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage subtract(float v) {
        float sv = v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] - sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage multiply(float v) {
        float sv = v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] * sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage divide(float v) {
        float sv = v;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] / sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage add(RealGrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    float[] fArray = this.data[y];
                    int n = x;
                    fArray[n] = fArray[n] + im.get(x, y);
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage subtract(RealGrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    float[] fArray = this.data[y];
                    int n = x;
                    fArray[n] = fArray[n] - im.get(x, y);
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage diff(RealGrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                float[] fArray = this.data[y];
                int n = x;
                fArray[n] = fArray[n] - im.get(x, y);
                if (this.data[y][x] < 0.0f) {
                    this.data[y][x] = (short)(-this.data[y][x]);
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage multiply(RealGrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    float[] fArray = this.data[y];
                    int n = x;
                    fArray[n] = fArray[n] * im.get(x, y);
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage divide(RealGrayImage im) {
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                if (y < im.Y() && x < im.X()) {
                    float[] fArray = this.data[y];
                    int n = x;
                    fArray[n] = fArray[n] / im.get(x, y);
                }
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString() {
        String str = this.X + ":" + this.Y + "\n";
        int x = 0;
        while (x < this.X) {
            int y = 0;
            while (y < this.Y) {
                str = str + this.data[y][x] + " ";
                ++y;
            }
            str = str + "\n";
            ++x;
        }
        return str;
    }

    public ImageProducer getJavaImage() {
        float min = this.min();
        float max = this.max();
        if (min >= 0.0f && max <= 255.0f) {
            min = 0.0f;
            max = 255.0f;
        }
        float range = max - min;
        int[] pix = new int[this.X * this.Y];
        int index = 0;
        int value = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = (int)(255.0 / (double)range * (double)((float)((int)this.data[y][x]) - min));
                value = 0xFF & value;
                pix[index] = 0xFF000000 | value << 16 | value << 8 | value;
                ++index;
                ++x;
            }
            ++y;
        }
        return new MemoryImageSource(this.X, this.Y, pix, 0, this.X);
    }

    public void byteSize() {
        float min = this.min();
        float max = this.max();
        float range = max - min;
        int value = 0;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = (int)(255.0 / (double)range * (double)(this.data[y][x] - min));
                value = 0xFF & value;
                this.data[y][x] = value;
                ++x;
            }
            ++y;
        }
    }

    public void clip(int min, int max) {
        float value = 0.0f;
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                value = this.data[y][x];
                value = value > (float)max ? (float)max : value;
                this.data[y][x] = value = value < (float)min ? (float)min : value;
                ++x;
            }
            ++y;
        }
    }

    private float[] sort(float[] vals, int size) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        float temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        float[] value = new float[NumX * NumY];
        int y = 0;
        while (y < this.Y) {
            int x = 0;
            while (x < this.X) {
                int count = 0;
                int j = -midY;
                while (j <= midY) {
                    int i = -midX;
                    while (i <= midX) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    ++j;
                }
                value = this.sort(value, count);
                this.data[y][x] = value[count / 2];
                ++x;
            }
            ++y;
        }
    }

    public Image copy(ROI r) {
        RealGrayImage g = new RealGrayImage(r.lx() - r.ux(), r.ly() - r.uy());
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                g.data[y][x] = this.data[y][x];
                ++x;
            }
            ++y;
        }
        return g;
    }

    public final void set(int x, int y, float value, ROI r) {
        this.data[r.uy() + y][r.ux() + x] = value;
    }

    public final void add(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] + value;
    }

    public final void subtract(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] - value;
    }

    public final void multiply(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] * value;
    }

    public final void divide(int x, int y, float value, ROI r) {
        float[] fArray = this.data[r.uy() + y];
        int n = r.ux() + x;
        fArray[n] = fArray[n] / value;
    }

    public final float min(ROI r) {
        float min = 32767.0f;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float p = this.data[y][x];
                if (p < min) {
                    min = p;
                }
                ++x;
            }
            ++y;
        }
        return min;
    }

    public final float max(ROI r) {
        float max = -32768.0f;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float p = this.data[y][x];
                if (p > max) {
                    max = p;
                }
                ++x;
            }
            ++y;
        }
        return max;
    }

    public final RealGrayImage add(float v, ROI r) {
        float sv = v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] + sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage subtract(float v, ROI r) {
        float sv = v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] - sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage multiply(float v, ROI r) {
        float sv = v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] * sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage divide(float v, ROI r) {
        float sv = v;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                float[] fArray = this.data[y];
                int n = x++;
                fArray[n] = fArray[n] / sv;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage add(RealGrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] + im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage subtract(RealGrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] - im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage multiply(RealGrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] * im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
                ++x;
            }
            ++y;
        }
        return this;
    }

    public final RealGrayImage divide(RealGrayImage im, ROI sourceImage, ROI destImage) {
        int y = sourceImage.uy();
        while (y < sourceImage.ly()) {
            int x = sourceImage.ux();
            while (x < sourceImage.lx()) {
                float[] fArray = this.data[x];
                int n = y;
                fArray[n] = fArray[n] / im.get(x - sourceImage.ux() + destImage.ux(), y - sourceImage.uy() + destImage.uy());
                ++x;
            }
            ++y;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.X + ":" + this.Y + "\n";
        int x = r.ux();
        while (x < r.lx()) {
            int y = r.uy();
            while (y < r.ly()) {
                str = str + this.data[y][x] + " ";
                ++y;
            }
            str = str + "\n";
            ++x;
        }
        return str;
    }

    public void clip(int min, int max, ROI r) {
        float value = 0.0f;
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                value = this.data[y][x];
                value = value > (float)max ? (float)max : value;
                this.data[y][x] = value = value < (float)min ? (float)min : value;
                ++x;
            }
            ++y;
        }
    }

    public void median(int size, ROI r) {
        int NumX = size > this.X ? this.X : size;
        int NumY = size > this.Y ? this.Y : size;
        int midX = NumX / 2;
        int midY = NumY / 2;
        float[] value = new float[NumX * NumY];
        int y = r.uy();
        while (y < r.ly()) {
            int x = r.ux();
            while (x < r.lx()) {
                int count = 0;
                int j = -midY;
                while (j <= midY) {
                    int i = -midX;
                    while (i <= midX) {
                        try {
                            value[count++] = this.data[y + j][x + i];
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++i;
                    }
                    ++j;
                }
                value = this.sort(value, count);
                this.data[y][x] = value[count / 2];
                ++x;
            }
            ++y;
        }
    }
}

