/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.ConvertSignal;
import jm.jigl.ROI;
import jm.jigl.Signal;

public class RealSignal
implements Signal {
    protected float[] data;
    protected int length;

    public RealSignal() {
        this.length = 0;
        this.data = null;
    }

    public RealSignal(int x) {
        this.length = x;
        this.data = new float[this.length];
    }

    public RealSignal(RealSignal s) {
        this.length = s.length();
        this.data = s.data();
    }

    public Signal copy() {
        RealSignal s = new RealSignal(this.length);
        s.length = this.length;
        int x = 0;
        while (x < this.length) {
            s.data[x] = this.data[x];
            ++x;
        }
        return s;
    }

    public final int length() {
        return this.length;
    }

    public final float[] data() {
        return this.data;
    }

    public final float get(int x) {
        return this.data[x];
    }

    public final void set(int x, float value) {
        this.data[x] = value;
    }

    public final RealSignal clear() {
        this.clear(0.0f);
        return this;
    }

    public final RealSignal clear(float val) {
        int x = 0;
        while (x < this.length) {
            this.data[x] = val;
            ++x;
        }
        return this;
    }

    public final void add(int x, float value) {
        int n = x;
        this.data[n] = this.data[n] + value;
    }

    public final void subtract(int x, float value) {
        int n = x;
        this.data[n] = this.data[n] - value;
    }

    public final void multiply(int x, float value) {
        int n = x;
        this.data[n] = this.data[n] * value;
    }

    public final void divide(int x, float value) {
        int n = x;
        this.data[n] = this.data[n] / value;
    }

    public final float min() {
        float min = 32767.0f;
        int x = 0;
        while (x < this.length) {
            float p = this.data[x];
            if (p < min) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final float max() {
        float max = -32768.0f;
        int x = 0;
        while (x < this.length) {
            float p = this.data[x];
            if (p > max) {
                max = p;
            }
            ++x;
        }
        return max;
    }

    public final RealSignal add(float v) {
        float sv = v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = this.data[n] + sv;
        }
        return this;
    }

    public RealSignal addbuffer(int w, int color) {
        int Y = this.length;
        RealSignal g = new RealSignal(w);
        int y = 0;
        while (y < Y) {
            g.data[y] = y < Y ? this.data[y] : (float)((short)color);
            ++y;
        }
        return g;
    }

    public final RealSignal subtract(float v) {
        float sv = v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = this.data[n] - sv;
        }
        return this;
    }

    public final RealSignal multiply(float v) {
        float sv = v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = this.data[n] * sv;
        }
        return this;
    }

    public final RealSignal divide(float v) {
        float sv = v;
        int x = 0;
        while (x < this.length) {
            int n = x++;
            this.data[n] = this.data[n] / sv;
        }
        return this;
    }

    public final RealSignal add(RealSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = this.data[n] + s.get(x);
            ++x;
        }
        return this;
    }

    public final RealSignal subtract(RealSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = this.data[n] - s.get(x);
            ++x;
        }
        return this;
    }

    public final RealSignal diff(RealSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = this.data[n] - s.get(x);
            if (this.data[x] < 0.0f) {
                this.data[x] = (short)(-this.data[x]);
            }
            ++x;
        }
        return this;
    }

    public final RealSignal multiply(RealSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = this.data[n] * s.get(x);
            ++x;
        }
        return this;
    }

    public final RealSignal divide(RealSignal s) {
        int x = 0;
        while (x < this.length) {
            int n = x;
            this.data[n] = this.data[n] / s.get(x);
            ++x;
        }
        return this;
    }

    public String toString() {
        String str = this.length + "\n";
        int x = 0;
        while (x < this.length) {
            str = str + this.data[x] + " ";
            ++x;
        }
        str = str + "\n";
        return str;
    }

    public void byteSize() {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int value = 0;
        int x = 0;
        while (x < this.length) {
            value = (int)(255.0 / range * ((double)this.data[x] - min));
            value = 0xFF & value;
            this.data[x] = value;
            ++x;
        }
    }

    public final void clip(int min, int max) {
        float value = 0.0f;
        int x = 0;
        while (x < this.length) {
            value = this.data[x];
            value = value > (float)max ? (float)max : value;
            this.data[x] = value = value < (float)min ? (float)min : value;
            ++x;
        }
    }

    public void convolve(RealSignal kernel) {
        int x;
        int Num = kernel.length();
        int mid = Num / 2;
        double sum = 0.0;
        float[] value = new float[this.length];
        float[] kern = ConvertSignal.toRealDiscrete((RealSignal)kernel).data;
        int x2 = 0;
        while (x2 < Num) {
            sum += (double)kern[x2];
            ++x2;
        }
        if (sum != 0.0) {
            x = 0;
            while (x < Num) {
                int n = x++;
                kern[n] = (float)((double)kern[n] / sum);
            }
        }
        x = 0;
        while (x < this.length) {
            sum = 0.0;
            int i = -mid;
            while (i <= mid) {
                try {
                    sum += (double)(this.data[x + i] * kern[mid + i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value[x] = (float)sum;
            ++x;
        }
        this.data = value;
    }

    private double[] sort(double[] vals, int size) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        double temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size) {
        int Num = size > this.length ? this.length : size;
        int mid = Num / 2;
        double[] value = new double[Num * Num];
        int x = 0;
        while (x < this.length) {
            int count = 0;
            int i = -mid;
            while (i <= mid) {
                try {
                    value[count++] = this.data[x + i];
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value = this.sort(value, count);
            this.data[x] = (float)value[count / 2];
            ++x;
        }
    }

    public Signal copy(ROI r) {
        RealSignal s = new RealSignal(r.lx() - r.ux());
        s.length = this.length;
        int x = r.ux();
        while (x < r.lx()) {
            s.data[x] = this.data[x];
            ++x;
        }
        return s;
    }

    public final float get(int x, ROI r) {
        return this.data[x + r.ux()];
    }

    public final void set(int x, float value, ROI r) {
        this.data[x + r.ux()] = value;
    }

    public final RealSignal clear(ROI r) {
        this.clear(0.0f);
        return this;
    }

    public final RealSignal clear(float val, ROI r) {
        int x = r.ux();
        while (x < r.lx()) {
            this.data[x] = val;
            ++x;
        }
        return this;
    }

    public final void add(int x, float value, ROI r) {
        int n = x + r.ux();
        this.data[n] = this.data[n] + value;
    }

    public final void subtract(int x, float value, ROI r) {
        int n = x + r.ux();
        this.data[n] = this.data[n] - value;
    }

    public final void multiply(int x, float value, ROI r) {
        int n = x + r.ux();
        this.data[n] = this.data[n] * value;
    }

    public final void divide(int x, float value, ROI r) {
        int n = x + r.ux();
        this.data[n] = this.data[n] / value;
    }

    public final float min(ROI r) {
        float min = 32767.0f;
        int x = r.ux();
        while (x < r.lx()) {
            float p = this.data[x];
            if (p < min) {
                min = p;
            }
            ++x;
        }
        return min;
    }

    public final float max(ROI r) {
        float max = -32768.0f;
        int x = r.ux();
        while (x < r.lx()) {
            float p = this.data[x];
            if (p > max) {
                max = p;
            }
            ++x;
        }
        return max;
    }

    public final RealSignal add(float v, ROI r) {
        float sv = v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = this.data[n] + sv;
        }
        return this;
    }

    public final RealSignal subtract(float v, ROI r) {
        float sv = v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = this.data[n] - sv;
        }
        return this;
    }

    public final RealSignal multiply(float v, ROI r) {
        float sv = v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = this.data[n] * sv;
        }
        return this;
    }

    public final RealSignal divide(float v, ROI r) {
        float sv = v;
        int x = r.ux();
        while (x < r.lx()) {
            int n = x++;
            this.data[n] = this.data[n] / sv;
        }
        return this;
    }

    public final RealSignal subtract(RealSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux());
            ++x;
        }
        return this;
    }

    public final RealSignal multiply(RealSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux());
            ++x;
        }
        return this;
    }

    public final RealSignal divide(RealSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux());
            ++x;
        }
        return this;
    }

    public final RealSignal add(RealSignal s, ROI sourceSignal, ROI destSignal) {
        int x = sourceSignal.ux();
        while (x < sourceSignal.lx()) {
            int n = x;
            this.data[n] = this.data[n] + s.get(x - sourceSignal.ux() + destSignal.ux());
            ++x;
        }
        return this;
    }

    public String toString(ROI r) {
        String str = this.length + "\n";
        int x = r.ux();
        while (x < r.lx()) {
            str = str + this.data[x] + " ";
            ++x;
        }
        str = str + "\n";
        return str;
    }

    public void byteSize(ROI r) {
        double min = this.min();
        double max = this.max();
        double range = max - min;
        int value = 0;
        int x = r.ux();
        while (x < r.lx()) {
            value = (int)(255.0 / range * ((double)this.data[x] - min));
            value = 0xFF & value;
            this.data[x] = value;
            ++x;
        }
    }

    public final void clip(int min, int max, ROI r) {
        float value = 0.0f;
        int x = r.ux();
        while (x < r.lx()) {
            value = this.data[x];
            value = value > (float)max ? (float)max : value;
            this.data[x] = value = value < (float)min ? (float)min : value;
            ++x;
        }
    }

    public void convolve(RealSignal kernel, ROI r) {
        int x;
        int Num = kernel.length();
        int mid = Num / 2;
        double sum = 0.0;
        float[] value = new float[this.length];
        float[] kern = ConvertSignal.toRealDiscrete((RealSignal)kernel).data;
        int x2 = r.ux();
        while (x2 < Num) {
            sum += (double)kern[x2];
            ++x2;
        }
        if (sum != 0.0) {
            x = r.ux();
            while (x < Num) {
                int n = x++;
                kern[n] = (float)((double)kern[n] / sum);
            }
        }
        x = r.ux();
        while (x < r.lx()) {
            sum = 0.0;
            int i = -mid;
            while (i <= mid) {
                try {
                    sum += (double)(this.data[x + i] * kern[mid + i]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value[x] = (float)sum;
            ++x;
        }
        this.data = value;
    }

    private double[] sort(double[] vals, int size, ROI r) {
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size - 1) {
                try {
                    if (vals[j] > vals[j + 1]) {
                        double temp = vals[j];
                        vals[j] = vals[j + 1];
                        vals[j + 1] = temp;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public void median(int size, ROI r) {
        int Num = size > this.length ? this.length : size;
        int mid = Num / 2;
        double[] value = new double[Num * Num];
        int x = r.ux();
        while (x < r.lx()) {
            int count = 0;
            int i = -mid;
            while (i <= mid) {
                try {
                    value[count++] = this.data[x + i];
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            value = this.sort(value, count);
            this.data[x] = (float)value[count / 2];
            ++x;
        }
    }
}

