/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import jm.jigl.GrayImage;
import jm.jigl.Image;
import jm.jigl.RealGrayImage;

public class Shift {
    private final int NOWRAP = 0;
    private final int WRAP = 1;
    private int xoffset = 0;
    private int yoffset = 0;
    private boolean wrap = false;

    public Shift(int x, int y, int wrapp) {
        this.xoffset = x;
        this.yoffset = y;
        if (wrapp == 1) {
            this.wrap = true;
        }
    }

    private GrayImage apply(GrayImage image) {
        int X = image.X();
        int Y = image.Y();
        GrayImage temp = new GrayImage(X, Y);
        int y = 0;
        while (y < Y) {
            int x = 0;
            while (x < X) {
                if (this.xoffset > 0 && this.yoffset > 0) {
                    temp.set((x + this.xoffset) % X, (y + this.yoffset) % Y, image.get(x, y));
                } else if (this.xoffset > 0) {
                    temp.set((x + this.xoffset) % X, (Y + this.yoffset + y) % Y, image.get(x, y));
                } else if (this.yoffset > 0) {
                    temp.set((X + this.xoffset + x) % X, (y + this.yoffset) % Y, image.get(x, y));
                } else {
                    temp.set((X + this.xoffset + x) % X, (y + this.yoffset + Y) % Y, image.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return temp;
    }

    private GrayImage applynw(GrayImage image) {
        int X = image.X();
        int Y = image.Y();
        GrayImage temp = new GrayImage(X, Y);
        int y = 0;
        while (y < Y) {
            int x = 0;
            while (x < X) {
                if (x + this.xoffset >= 0 && x + this.xoffset < X && y + this.yoffset >= 0 && y + this.yoffset < Y) {
                    temp.set(x, y, image.get(x + this.xoffset, y + this.yoffset));
                } else {
                    temp.set(x, y, 0);
                }
                ++x;
            }
            ++y;
        }
        return temp;
    }

    private RealGrayImage apply(RealGrayImage image) {
        int X = image.X();
        int Y = image.Y();
        RealGrayImage temp = new RealGrayImage(X, Y);
        int y = 0;
        while (y < Y) {
            int x = 0;
            while (x < X) {
                if (this.xoffset > 0 && this.yoffset > 0) {
                    temp.set((x + this.xoffset) % X, (y + this.yoffset) % Y, image.get(x, y));
                } else if (this.xoffset > 0) {
                    temp.set((x + this.xoffset) % X, (Y + this.yoffset + y) % Y, image.get(x, y));
                } else if (this.yoffset > 0) {
                    temp.set((X + this.xoffset + x) % X, (y + this.yoffset) % Y, image.get(x, y));
                } else {
                    temp.set((X + this.xoffset + x) % X, (y + this.yoffset + Y) % Y, image.get(x, y));
                }
                ++x;
            }
            ++y;
        }
        return temp;
    }

    private RealGrayImage applynw(RealGrayImage image) {
        int X = image.X();
        int Y = image.Y();
        RealGrayImage temp = new RealGrayImage(X, Y);
        int y = 0;
        while (y < Y) {
            int x = 0;
            while (x < X) {
                if (x + this.xoffset >= 0 && x + this.xoffset < X && y + this.yoffset >= 0 && y + this.yoffset < Y) {
                    temp.set(x, y, image.get(x + this.xoffset, y + this.yoffset));
                } else {
                    temp.set(x, y, 0.0f);
                }
                ++x;
            }
            ++y;
        }
        return temp;
    }

    public Image apply(Image image) {
        if (this.wrap) {
            if (image instanceof GrayImage) {
                return this.apply((GrayImage)image);
            }
            if (image instanceof RealGrayImage) {
                return this.apply((RealGrayImage)image);
            }
        } else {
            if (image instanceof GrayImage) {
                return this.applynw((GrayImage)image);
            }
            if (image instanceof RealGrayImage) {
                return this.applynw((RealGrayImage)image);
            }
        }
        return null;
    }
}

