/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import jm.jigl.DiscreteSignal;
import jm.jigl.IllegalPBMFormatException;
import jm.jigl.RealSignal;
import jm.jigl.Signal;
import jm.jigl.SignalNotSupportedException;

public class SignalInputStream {
    protected BufferedInputStream data;
    protected int ndims;
    protected int X;
    private int type;
    private static final int UNKNOWN = 0;
    private static final int PDS_ASCII = 1;
    private static final int PRS_ASCII = 2;
    private static final int PDS_RAW = 3;
    private static final int PRS_RAW = 4;
    private static final int DAT_FILE = 5;
    protected int maxval;
    protected float maxvalf;
    private int bitshift = -1;
    private int bits;

    public SignalInputStream(String fn) throws FileNotFoundException, SignalNotSupportedException, IOException {
        if (fn.endsWith(".dat")) {
            char c;
            this.ndims = 1;
            this.data = new BufferedInputStream(new FileInputStream(fn));
            this.type = 5;
            this.X = 0;
            do {
                if ((c = this.readChar(this.data)) != '\n') continue;
                ++this.X;
            } while (c != '|');
            this.data = new BufferedInputStream(new FileInputStream(fn));
            this.maxvalf = 1.0f;
        } else {
            this.ndims = 1;
            this.data = new BufferedInputStream(new FileInputStream(fn));
            this.type = this.readMagic();
            this.readHeader();
        }
    }

    public SignalInputStream(String url, int i) throws IOException, SignalNotSupportedException, MalformedURLException {
        URL ur = new URL(url);
        this.ndims = 1;
        this.data = new BufferedInputStream(ur.openStream());
        this.type = this.readMagic();
        this.readHeader();
    }

    public SignalInputStream(SignalInputStream stream) {
        this.data = stream.data;
        this.ndims = stream.ndims;
        this.X = stream.X;
        this.type = stream.type;
    }

    public int ndims() {
        return this.ndims;
    }

    public int X() {
        return this.X;
    }

    public int type() {
        return this.type;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public int readMagic() throws SignalNotSupportedException, IOException {
        int t2;
        char[] c = new char[]{(char)this.readByte(this.data), (char)this.readByte(this.data)};
        String str = new String(c);
        if (str.equals("S1")) {
            t2 = 1;
        } else if (str.equals("S2")) {
            t2 = 2;
        } else if (str.equals("S3")) {
            t2 = 3;
        } else if (str.equals("S4")) {
            t2 = 4;
        } else {
            boolean t2 = false;
            throw new SignalNotSupportedException();
        }
        return t2;
    }

    public void readHeader() throws SignalNotSupportedException, IOException {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.X = this.readInt(this.data);
                this.ndims = 1;
                if (this.type == 3) {
                    this.maxval = this.readInt(this.data);
                    break;
                }
                if (this.type == 4) {
                    this.maxvalf = this.readFloat(this.data);
                    break;
                }
                this.maxval = 1;
                break;
            }
            default: {
                throw new SignalNotSupportedException();
            }
        }
    }

    public Signal read() throws SignalNotSupportedException, IllegalPBMFormatException, IOException {
        DiscreteSignal ds = null;
        RealSignal rs = null;
        switch (this.type) {
            case 3: {
                ds = new DiscreteSignal(this.X);
                break;
            }
            case 4: {
                rs = new RealSignal(this.X);
                break;
            }
            case 5: {
                rs = new RealSignal(this.X);
                break;
            }
            default: {
                throw new SignalNotSupportedException();
            }
        }
        int x = 0;
        while (x < this.X) {
            switch (this.type) {
                case 3: {
                    int s = this.readByte(this.data);
                    if (this.maxval != 255) {
                        s = this.fixDepth(s);
                    }
                    ds.set(x, s);
                    break;
                }
                case 4: {
                    float sr = this.readBytef(this.data);
                    if (this.maxvalf != 255.0f) {
                        sr = this.fixDepth(sr);
                    }
                    rs.set(x, sr);
                    break;
                }
                case 5: {
                    double t = this.readFloat(this.data);
                    float sr = (float)t;
                    rs.set(x, sr);
                    break;
                }
                default: {
                    throw new SignalNotSupportedException();
                }
            }
            ++x;
        }
        switch (this.type) {
            case 3: {
                return ds;
            }
            case 4: {
                return rs;
            }
            case 5: {
                return rs;
            }
        }
        throw new SignalNotSupportedException();
    }

    private int readByte(InputStream data) throws IOException {
        int b = data.read();
        return b;
    }

    private float readBytef(InputStream data) throws IOException {
        float b = data.read();
        return b;
    }

    private int readInt(InputStream data) throws IOException {
        char c = this.readNonwhiteChar(data);
        if ((c < '0' || c > '9') && c != '-') {
            throw new IOException("junk in file where integer should be");
        }
        int i = 0;
        if (c == '-') {
            c = this.readChar(data);
            do {
                i = i * 10 + c - 48;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
            i = -i;
        } else {
            do {
                i = i * 10 + c - 48;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
        }
        return i;
    }

    private float readFloat(InputStream data) throws IOException {
        boolean flag = true;
        double cons = 0.1f;
        char c = this.readNonwhiteChar(data);
        if ((c < '0' || c > '9') && c != '-') {
            throw new IOException("junk in file where integer should be: " + c);
        }
        double i = 0.0;
        if (c == '-') {
            c = this.readChar(data);
            do {
                i = i * 10.0 + (double)c - 48.0;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
            i = -i;
            flag = false;
        } else {
            do {
                i = i * 10.0 + (double)c - 48.0;
            } while ((c = this.readChar(data)) >= '0' && c <= '9');
        }
        if (c == '.') {
            c = this.readChar(data);
            do {
                i = flag ? (i += cons * (double)(c - 48)) : (i += -(cons * (double)(c - 48)));
                c = this.readChar(data);
                cons *= 0.1;
            } while (c >= '0' && c <= '9');
        }
        return (float)i;
    }

    private char readChar(InputStream data) throws IOException {
        int num = this.readByte(data);
        if (num == -1) {
            return '|';
        }
        char c = (char)num;
        if (c == '#') {
            while ((c = (char)this.readByte(data)) != '\n' && c != '\r') {
            }
        }
        return c;
    }

    private char readNonwhiteChar(InputStream data) throws IOException {
        char c;
        while ((c = this.readChar(data)) == ' ' || c == '\t' || c == '\n' || c == '\r') {
        }
        return c;
    }

    private int fixDepth(int p) {
        return (p * 255 + this.maxval / 2) / this.maxval;
    }

    private float fixDepth(float p) {
        return (p * 255.0f + this.maxvalf / 2.0f) / (float)this.maxval;
    }

    private boolean readBit(InputStream in) throws IOException {
        if (this.bitshift == -1) {
            this.bits = this.readByte(in);
            this.bitshift = 7;
        }
        boolean bit = (this.bits >> this.bitshift & 1) != 0;
        --this.bitshift;
        return bit;
    }

    static {
        UNKNOWN = 0;
        PDS_ASCII = 1;
        PRS_ASCII = 2;
        PDS_RAW = 3;
        PRS_RAW = 4;
        DAT_FILE = 5;
    }
}

