/*
 * Decompiled with CFR 0.152.
 */
package jm.jigl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jm.jigl.ColorModelNotSupportedException;
import jm.jigl.ColorModelUnknownException;
import jm.jigl.DiscreteSignal;
import jm.jigl.RealSignal;
import jm.jigl.Signal;
import jm.jigl.UnknownSignalTypeException;

public class SignalOutputStream {
    protected BufferedOutputStream data;
    protected int ndims;
    protected int X;
    private boolean toDat = false;

    public SignalOutputStream() {
    }

    public SignalOutputStream(String fn) throws IOException {
        FileOutputStream f = new FileOutputStream(fn);
        this.data = new BufferedOutputStream(f);
        if (fn.endsWith(".dat")) {
            this.toDat = true;
        }
    }

    public SignalOutputStream(SignalOutputStream stream) {
        this.data = stream.data;
        this.ndims = stream.ndims;
        this.X = stream.X;
    }

    public int ndims() {
        return this.ndims;
    }

    public int X() {
        return this.X;
    }

    public boolean open(String fn) throws IOException {
        FileOutputStream f = new FileOutputStream(fn);
        this.data = new BufferedOutputStream(f);
        return true;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public void write(Signal im) throws UnknownSignalTypeException, ColorModelNotSupportedException, ColorModelUnknownException, IOException {
        if (im instanceof DiscreteSignal) {
            this.write((DiscreteSignal)im);
        } else if (im instanceof RealSignal) {
            this.write((RealSignal)im);
        } else {
            throw new UnknownSignalTypeException();
        }
    }

    public void write(DiscreteSignal s) throws IOException {
        if (!this.toDat) {
            this.X = s.length();
            DiscreteSignal tmps = (DiscreteSignal)s.copy();
            tmps.byteSize();
            this.writeRawPDSHeader(this.X);
            int x = 0;
            while (x < this.X) {
                this.data.write((byte)tmps.get(x));
                ++x;
            }
        } else {
            Integer f = null;
            int x = 0;
            while (x < s.length()) {
                f = new Integer(s.get(x));
                SignalOutputStream.writeString(this.data, f.toString() + "\n");
                ++x;
            }
        }
    }

    public void write(RealSignal s) throws IOException {
        if (!this.toDat) {
            this.X = s.length();
            RealSignal tmps = (RealSignal)s.copy();
            tmps.byteSize();
            this.writeRawPRSMHeader(this.X);
            int x = 0;
            while (x < this.X) {
                this.data.write((byte)tmps.get(x));
                ++x;
            }
        } else {
            Float f = null;
            int x = 0;
            while (x < s.length()) {
                f = new Float(s.get(x));
                SignalOutputStream.writeString(this.data, f.toString() + "\n");
                ++x;
            }
        }
    }

    void writeRawPDSHeader(int width) throws IOException {
        SignalOutputStream.writeString(this.data, "S3\n");
        SignalOutputStream.writeString(this.data, width + "\n");
        SignalOutputStream.writeString(this.data, "255\n");
    }

    void writeRawPRSMHeader(int width) throws IOException {
        SignalOutputStream.writeString(this.data, "S4\n");
        SignalOutputStream.writeString(this.data, width + "\n");
        SignalOutputStream.writeString(this.data, "255\n");
    }

    static void writeString(OutputStream out, String str) throws IOException {
        out.write(str.getBytes());
    }
}

