/*
 * Decompiled with CFR 0.152.
 */
package jm.kidney;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jm.cepstrum.CepstrumAnalysis;
import jm.extension.ExImageCanvas;
import jm.extension.ExJButton;
import jm.extension.ExStackWindow;
import jm.kidney.AboutDialog;
import jm.kidney.JSplashScreen;
import jm.kidney.PresetsDialog;
import jm.segmentation.KidneyExtraction;
import jm.sit.SITAnalysis;
import jm.util.GridBagConstraints2;

public class AnalysisDialog
extends JFrame
implements ActionListener,
ChangeListener,
WindowListener {
    private PresetsDialog presetsDialog = null;
    public boolean test = false;
    private boolean cepstrumSuccess = false;
    public boolean isCancelPressed = false;
    public boolean isStartAnalysisPressed = false;
    public boolean propertiesOk = false;
    public boolean newResultWindow = false;
    public boolean interpolateNullValues = true;
    public boolean showNullValues = false;
    public boolean verboseResults = false;
    public boolean secondChance = true;
    public boolean rasterTransformation = false;
    public boolean writeLog = true;
    public boolean enableMinDiff = true;
    public boolean verboseSIT = true;
    public boolean splashScreen = true;
    public int startImage = 1;
    public int switchToMinDiff = 1000;
    public int threadPriority = 10;
    public int[] acquisitionTime = null;
    public int[][] cepstrumResult = null;
    private boolean fetchStartParameters = false;
    private boolean leftRoiLocked = false;
    private boolean rightRoiLocked = false;
    private int actualImage = 0;
    private int maxImage = 0;
    public double analysisAccuracy = 2.0;
    public double classificationRange = 0.5;
    private String dialogTitle = " RENAL FUNCTION Analysis";
    private Color darkblue = new Color(0, 0, 100);
    private Color darkred = new Color(136, 0, 0);
    private Font MenuInactive = new Font("Dialog", 0, 11);
    private Font MenuActive = new Font("Dialog", 1, 11);
    private Image image;
    public ImagePlus imagePlus = null;
    public ImageStack imageStack = null;
    public ImageWindow imageWindow = null;
    public ExImageCanvas imageCanvas = null;
    public ExStackWindow stackWindow = null;
    private StackWindow oldStackWindow = null;
    private Roi leftRoi = null;
    private Roi rightRoi = null;
    private Roi dummyRoi = null;
    private Rectangle originalCancelSize = null;
    private CepstrumAnalysis cepstrumAnalysis = null;
    private SITAnalysis sitAnalysis = null;
    JPanel jPanelMain = new JPanel();
    GridBagLayout gridBagLayoutMainPanel = new GridBagLayout();
    ExJButton jButtonStartAnalysis = new ExJButton();
    ExJButton jButtonPresets = new ExJButton();
    ExJButton jButtonSegmentation = new ExJButton();
    ExJButton jButtonExit = new ExJButton();
    JLabel jLabelStatusBar = new JLabel();
    JLabel jLabelImage = new JLabel();
    JTextArea jTextAreaPatienInfo = new JTextArea();
    JPanel jPanelRois = new JPanel();
    ExJButton jButtonLeftRoi = new ExJButton();
    ExJButton jButtonRightRoi = new ExJButton();
    GridBagLayout gridBagLayoutPanelRois = new GridBagLayout();
    JLabel jLabelAccuracy = new JLabel();
    JSlider jSliderAccuracy = new JSlider();
    ExJButton jButtonCancel = new ExJButton();
    ExJButton jButtonSIT = new ExJButton();
    JPanel jPanelMenue = new JPanel();
    JLabel jLabelPatientHeadline = new JLabel();
    JLabel jLabelAnalysisHeadline = new JLabel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    ExJButton jButtonAbout = new ExJButton();
    JTextArea jLabelInfo = new JTextArea();
    public String seriesDate = "";
    public String studyDate = "";
    public String patientName = "";
    public String patientID = "";
    public String patientBirth = "";
    public int patientWeight = 0;
    public int patientAge = 0;
    public double timeTR = 0.0;
    public double timeTE = 0.0;
    public String patientSex = "";
    public String institutionName = "";
    public String matrix = "";
    public int fovX = 0;
    public int fovY = 0;
    public int matrixX = 0;
    public int matrixY = 0;
    public double pixelSpacingX = 1.0;
    public double pixelSpacingY = 1.0;
    public boolean hasPatientInfo = false;
    public boolean seriesLoaded = false;
    static /* synthetic */ Class class$jm$kidney$AnalysisDialog;

    public AnalysisDialog(ImageWindow win) {
        try {
            this.imageWindow = win;
            this.presetsDialog = new PresetsDialog(this);
            this.transferPresetValues();
            this.guiPreparation();
            JSplashScreen splash = new JSplashScreen(this, (class$jm$kidney$AnalysisDialog == null ? (class$jm$kidney$AnalysisDialog = AnalysisDialog.class$("jm.kidney.AnalysisDialog")) : class$jm$kidney$AnalysisDialog).getResource("Splash.gif"), 3900);
            splash.setVisible(this.splashScreen);
            this.jbInit();
            this.guiInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void transferPresetValues() {
        this.startImage = this.presetsDialog.ignoreFirst + 1;
        this.switchToMinDiff = this.presetsDialog.minDiffSwitch;
        this.enableMinDiff = this.presetsDialog.minDiff;
        this.newResultWindow = this.presetsDialog.newWindow;
        this.interpolateNullValues = this.presetsDialog.interpolateMissing;
        this.showNullValues = this.presetsDialog.showNullValues;
        this.verboseResults = this.presetsDialog.verboseText;
        this.secondChance = this.presetsDialog.secondChance;
        this.rasterTransformation = this.presetsDialog.rasterTransformation;
        this.threadPriority = this.presetsDialog.threadPriority;
        this.writeLog = this.presetsDialog.writeLog;
        this.classificationRange = this.presetsDialog.classificationRange;
        this.verboseSIT = this.presetsDialog.verboseSIT;
        this.splashScreen = this.presetsDialog.splashScreen;
    }

    private void jbInit() throws Exception {
        this.jPanelMain.setForeground(Color.lightGray);
        this.jPanelMain.setBackground(Color.black);
        this.jButtonStartAnalysis.setText("Start Analysis");
        this.jButtonPresets.setText("Presets");
        this.jButtonSegmentation.setText("Try Segmentation");
        this.jButtonExit.setText("Exit");
        this.jLabelStatusBar.setText(" Ready");
        this.jPanelMain.setLayout(this.gridBagLayoutMainPanel);
        this.jLabelStatusBar.setForeground(Color.orange);
        this.jTextAreaPatienInfo.setRequestFocusEnabled(false);
        this.jTextAreaPatienInfo.setEnabled(false);
        this.jTextAreaPatienInfo.setForeground(Color.white);
        this.jTextAreaPatienInfo.setBackground(Color.darkGray);
        this.jTextAreaPatienInfo.setFont(new Font("Monospaced", 0, 11));
        this.jTextAreaPatienInfo.setBorder(new LineBorder(Color.gray));
        this.setPatientInfoText();
        this.jButtonRightRoi.setText(" lock left ROI");
        this.jButtonRightRoi.setMargin(new Insets(0, 4, 0, 4));
        this.jButtonRightRoi.setFont(new Font("Dialog", 1, 11));
        this.jButtonLeftRoi.setText("lock right ROI");
        this.jButtonLeftRoi.setMargin(new Insets(0, 4, 0, 4));
        this.jButtonLeftRoi.setFont(new Font("Dialog", 1, 11));
        this.jButtonRightRoi.setText("lock left Roi");
        this.jButtonRightRoi.setForeground(Color.lightGray);
        this.jButtonLeftRoi.setText("lock right Roi");
        this.jButtonLeftRoi.setForeground(Color.lightGray);
        this.jPanelRois.setLayout(this.gridBagLayoutPanelRois);
        this.jPanelRois.setForeground(Color.lightGray);
        this.jPanelRois.setBackground(Color.black);
        this.jPanelRois.setBorder(new LineBorder(Color.gray));
        this.jButtonStartAnalysis.setText("Movement Correction");
        this.jButtonStartAnalysis.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonPresets.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonSegmentation.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonExit.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonSIT.setText("Calculate SIT");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setForeground(Color.orange);
        this.jButtonCancel.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSIT.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonCancel.setFont(new Font("Dialog", 1, 11));
        this.jSliderAccuracy.setMinimum(10);
        this.jSliderAccuracy.setMaximum(40);
        this.jSliderAccuracy.setMajorTickSpacing(10);
        this.jSliderAccuracy.setMinorTickSpacing(1);
        this.jSliderAccuracy.setSnapToTicks(true);
        this.jSliderAccuracy.setValue((int)(this.analysisAccuracy * 10.0));
        this.jLabelAccuracy.setText("-    Analysis accuracy: 1.0    +");
        this.jLabelAccuracy.setForeground(Color.lightGray);
        this.jLabelAccuracy.setFont(new Font("Dialog", 1, 11));
        this.jLabelAnalysisHeadline.setText("Settings Movement Correction");
        this.jLabelPatientHeadline.setText("Series Data");
        this.jPanelMenue.setLayout(this.gridBagLayout3);
        this.jPanelMenue.setForeground(Color.lightGray);
        this.jPanelMenue.setBackground(Color.black);
        this.jLabelStatusBar.setBackground(Color.darkGray);
        this.jLabelStatusBar.setOpaque(true);
        this.jLabelStatusBar.setFont(new Font("Dialog", 1, 11));
        this.jButtonStartAnalysis.setForeground(Color.lightGray);
        this.jButtonStartAnalysis.setBackground(Color.black);
        this.jButtonPresets.setForeground(Color.lightGray);
        this.jButtonPresets.setBackground(Color.black);
        this.jButtonSegmentation.setForeground(Color.lightGray);
        this.jButtonSegmentation.setBackground(Color.black);
        this.jButtonSIT.setForeground(Color.lightGray);
        this.jButtonSIT.setBackground(Color.black);
        this.jButtonExit.setForeground(Color.lightGray);
        this.jButtonExit.setBackground(Color.black);
        this.jButtonSIT.setFont(this.MenuActive);
        this.jButtonExit.setFont(this.MenuActive);
        this.jButtonSegmentation.setFont(this.MenuActive);
        this.jButtonPresets.setFont(this.MenuActive);
        this.jButtonStartAnalysis.setFont(this.MenuActive);
        this.jButtonSIT.setFocusPainted(false);
        this.jButtonExit.setFocusPainted(false);
        this.jButtonSegmentation.setFocusPainted(false);
        this.jButtonPresets.setFocusPainted(false);
        this.jButtonStartAnalysis.setFocusPainted(false);
        this.jButtonStartAnalysis.setToolTipText("Start Cepstrum Movement Correction");
        this.jButtonExit.setToolTipText("Exit Renal Analysis Plugin");
        this.dummyRoi = new Roi(0, 0, this.imagePlus);
        this.jTextAreaPatienInfo.setSelectionColor(Color.darkGray);
        this.jTextAreaPatienInfo.setSelectedTextColor(Color.white);
        this.jLabelStatusBar.setToolTipText("actual Status");
        this.jButtonAbout.setText("About");
        this.jButtonAbout.setMargin(new Insets(0, 0, 0, 8));
        this.jButtonAbout.setForeground(Color.lightGray);
        this.jLabelInfo.setRequestFocusEnabled(false);
        this.jLabelInfo.setEnabled(false);
        this.jLabelInfo.setText("\n Renal Function Analysis\n     Plugin for ImageJ\n(C)1999/2000 Jens Martin");
        this.jLabelInfo.setSelectedTextColor(Color.orange);
        this.jLabelInfo.setForeground(Color.orange);
        this.jLabelInfo.setBackground(Color.black);
        this.jLabelInfo.setSelectionColor(Color.black);
        this.jLabelInfo.setFont(new Font("Dialog", 0, 9));
        this.jLabelInfo.setDisabledTextColor(Color.orange);
        this.jLabelInfo.setToolTipText("Press \"About\" for more Information");
        this.jLabelInfo.setEditable(false);
        this.jButtonAbout.setBackground(Color.black);
        this.jButtonAbout.setFont(this.MenuActive);
        this.jButtonAbout.setFocusPainted(false);
        this.jButtonAbout.setToolTipText("About Renal Analysis Plugin");
        this.jButtonAbout.setFont(new Font("Dialog", 1, 11));
        this.jButtonAbout.setOpaque(true);
        this.jButtonCancel.setOpaque(true);
        this.jButtonCancel.setToolTipText("stop the current process");
        this.jButtonCancel.setBackground(Color.gray);
        this.jSliderAccuracy.setForeground(Color.lightGray);
        this.jSliderAccuracy.setBackground(Color.black);
        this.jSliderAccuracy.setToolTipText("adjust analysis accuracy");
        this.jSliderAccuracy.setRequestFocusEnabled(false);
        this.jLabelAccuracy.setOpaque(true);
        this.jLabelAccuracy.setBackground(Color.black);
        this.jButtonLeftRoi.setOpaque(true);
        this.jButtonLeftRoi.setToolTipText("locks the ROI for the right kidney");
        this.jButtonRightRoi.setOpaque(true);
        this.jButtonRightRoi.setToolTipText("locks the ROI for the left kidney");
        this.jButtonRightRoi.setBackground(Color.darkGray);
        this.jButtonLeftRoi.setBackground(Color.darkGray);
        this.jLabelAnalysisHeadline.setForeground(Color.lightGray);
        this.jLabelAnalysisHeadline.setBackground(Color.black);
        this.jLabelAnalysisHeadline.setFont(new Font("Dialog", 1, 11));
        this.jLabelAnalysisHeadline.setOpaque(true);
        this.jLabelPatientHeadline.setForeground(Color.lightGray);
        this.jLabelPatientHeadline.setBackground(Color.black);
        this.jLabelPatientHeadline.setFont(new Font("Dialog", 1, 11));
        this.jLabelPatientHeadline.setOpaque(true);
        this.jButtonSIT.setFont(new Font("Dialog", 1, 11));
        this.jButtonSIT.setOpaque(true);
        this.jButtonSIT.setToolTipText("Calculate Signal-Intensity-Time Curves");
        this.jButtonExit.setFont(new Font("Dialog", 1, 11));
        this.jButtonExit.setOpaque(true);
        this.jButtonSegmentation.setFont(new Font("Dialog", 1, 11));
        this.jButtonSegmentation.setOpaque(true);
        this.jButtonSegmentation.setToolTipText("detect the kidney's contour");
        this.jButtonPresets.setFont(new Font("Dialog", 1, 11));
        this.jButtonPresets.setOpaque(true);
        this.jButtonPresets.setToolTipText("Show / Edit Presets");
        this.jButtonStartAnalysis.setFont(new Font("Dialog", 1, 11));
        this.jButtonStartAnalysis.setOpaque(true);
        this.jButtonExit.setBorderPainted(false);
        this.jButtonAbout.setBorderPainted(false);
        this.jButtonSegmentation.setBorderPainted(false);
        this.jButtonPresets.setBorderPainted(false);
        this.jButtonSIT.setBorderPainted(false);
        this.jButtonRightRoi.setBorderPainted(false);
        this.jButtonLeftRoi.setBorderPainted(false);
        this.jTextAreaPatienInfo.setDisabledTextColor(Color.white);
        this.jTextAreaPatienInfo.setToolTipText("Information about imported Sequence");
        this.jTextAreaPatienInfo.setEditable(false);
        this.jTextAreaPatienInfo.setCaretColor(Color.darkGray);
        this.getContentPane().add((Component)this.jPanelMain, "Center");
        this.jPanelMain.add((Component)this.jLabelStatusBar, new GridBagConstraints2(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(7, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jTextAreaPatienInfo, new GridBagConstraints2(0, 2, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 12, 0, 15), 0, 0));
        this.jPanelMain.add((Component)this.jPanelRois, new GridBagConstraints2(1, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanelRois.add((Component)this.jButtonLeftRoi, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanelRois.add((Component)this.jButtonRightRoi, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanelRois.add((Component)this.jLabelAccuracy, new GridBagConstraints2(1, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelRois.add((Component)this.jSliderAccuracy, new GridBagConstraints2(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanelMain.add((Component)this.jButtonCancel, new GridBagConstraints2(1, 4, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.jPanelMain.add((Component)this.jPanelMenue, new GridBagConstraints2(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonStartAnalysis, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonPresets, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonSegmentation, new GridBagConstraints2(3, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonSIT, new GridBagConstraints2(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonAbout, new GridBagConstraints2(4, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMenue.add((Component)this.jButtonExit, new GridBagConstraints2(5, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelPatientHeadline, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 16, 2, new Insets(10, 15, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelAnalysisHeadline, new GridBagConstraints2(1, 1, 1, 1, 0.0, 0.0, 16, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanelMain.add((Component)this.jLabelInfo, new GridBagConstraints2(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton) {
            int type;
            Roi roi;
            if (src == this.jButtonExit) {
                this.exitPlugin();
            }
            if (src == this.jButtonAbout) {
                AboutDialog ad = new AboutDialog((class$jm$kidney$AnalysisDialog == null ? (class$jm$kidney$AnalysisDialog = AnalysisDialog.class$("jm.kidney.AnalysisDialog")) : class$jm$kidney$AnalysisDialog).getResource("Splash.gif"));
                ad.setVisible(true);
            }
            if (src == this.jButtonSIT) {
                this.startImage = this.presetsDialog.ignoreFirst + 1;
                this.switchToMinDiff = this.presetsDialog.minDiffSwitch;
                this.startSIT();
            }
            if (src == this.jButtonStartAnalysis) {
                this.startCepstrum();
            }
            if (src == this.jButtonSegmentation) {
                this.startSegmentation();
            }
            if (src == this.jButtonPresets) {
                this.presetsDialog.setVisible(true);
                this.presetsDialog.repaint();
            }
            if (src == this.jButtonCancel) {
                if (this.cepstrumAnalysis != null) {
                    this.cepstrumAnalysis.stopRunning = true;
                }
                if (this.sitAnalysis != null) {
                    this.sitAnalysis.stopRunning = true;
                }
                IJ.showProgress((double)1.0);
                IJ.showStatus((String)"");
            }
            if (src == this.jButtonLeftRoi) {
                roi = this.imagePlus.getRoi();
                if (roi != null) {
                    type = roi.getType();
                    if (type != 0 && type != 2 && type != 3) {
                        JOptionPane.showMessageDialog(null, "Please lock a ROI for both Kidneys !\n\nUse a Rectangle, Polygon or Freehand ROI.", " Wrong type of ROI", 0);
                        roi = null;
                    } else {
                        this.toggleLeftRoi(roi);
                    }
                } else {
                    this.toggleLeftRoi(roi);
                }
            }
            if (src == this.jButtonRightRoi) {
                roi = this.imagePlus.getRoi();
                if (roi != null) {
                    type = roi.getType();
                    if (type != 0 && type != 2 && type != 3) {
                        JOptionPane.showMessageDialog(null, "Please lock a ROI for both Kidneys !\n\nUse a Rectangle, Polygon or Freehand ROI.", " Wrong type of ROI", 0);
                        roi = null;
                    } else {
                        this.toggleRightRoi(roi);
                    }
                } else {
                    this.toggleRightRoi(roi);
                }
            }
        }
    }

    private void toggleLeftRoi(Roi roi) {
        try {
            if (roi != null && !this.leftRoiLocked) {
                this.lockLeftRoi(roi, true, true);
            } else {
                this.lockLeftRoi(null, false, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void lockLeftRoi(Roi roi, boolean lockIt, boolean keepIt) {
        if (lockIt && roi != null) {
            Rectangle rec = roi.getBoundingRect();
            if (rec.x + rec.width / 2 < this.imagePlus.getWidth() / 2) {
                this.leftRoi = roi;
                this.imagePlus.killRoi();
                this.leftRoiLocked = true;
                this.imageCanvas.setRoi(0, this.leftRoi);
                this.jButtonLeftRoi.setText("unlock right");
                this.jButtonLeftRoi.setForeground(Color.orange);
                this.imagePlus.updateAndDraw();
            }
        } else {
            this.leftRoiLocked = false;
            if (this.leftRoi != null && this.imagePlus.getRoi() == null) {
                this.imagePlus.setRoi(this.leftRoi);
            }
            this.leftRoi = null;
            if (!keepIt) {
                this.imageCanvas.deleteRois(0, 5);
            }
            this.jButtonLeftRoi.setText("lock right Roi");
            this.jButtonLeftRoi.setForeground(Color.lightGray);
            this.imagePlus.updateAndDraw();
        }
    }

    private void toggleRightRoi(Roi roi) {
        try {
            if (roi != null && !this.rightRoiLocked) {
                this.lockRightRoi(roi, true, true);
            } else {
                this.lockRightRoi(null, false, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void lockRightRoi(Roi roi, boolean lockIt, boolean keepIt) {
        if (lockIt && roi != null) {
            Rectangle rec = roi.getBoundingRect();
            if (rec.x + rec.width / 2 > this.imagePlus.getWidth() / 2) {
                this.rightRoi = roi;
                this.imagePlus.killRoi();
                this.rightRoiLocked = true;
                this.imageCanvas.setRoi(1, this.rightRoi);
                this.jButtonRightRoi.setText("unlock left");
                this.jButtonRightRoi.setForeground(Color.orange);
                this.imagePlus.updateAndDraw();
            }
        } else {
            this.rightRoiLocked = false;
            if (this.rightRoi != null && this.imagePlus.getRoi() == null) {
                this.imagePlus.setRoi(this.rightRoi);
            }
            this.rightRoi = null;
            if (!keepIt) {
                this.imageCanvas.deleteRois(1, 5);
            }
            this.jButtonRightRoi.setText(" lock left Roi");
            this.jButtonRightRoi.setForeground(Color.lightGray);
            this.imagePlus.updateAndDraw();
        }
    }

    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.jSliderAccuracy) {
            this.analysisAccuracy = (double)this.jSliderAccuracy.getValue() / 10.0;
            String text = "-    Analysis accuracy: ";
            text = text + this.d2s(this.analysisAccuracy, 1);
            text = text + "    +";
            this.jLabelAccuracy.setText(text);
        }
    }

    private void exitPlugin() {
        IJ.write((String)"Ende!");
        this.isCancelPressed = true;
        if (this.imagePlus != null && this.stackWindow != null && this.imagePlus.getWindow() != null) {
            this.imagePlus.unlock();
            this.stackWindow.unlock();
            this.stackWindow.setVisible(false);
            this.imagePlus.setWindow(null);
            if (this.imageCanvas != null) {
                this.imageCanvas.endThreads();
            }
            IJ.wait((int)100);
            this.imagePlus.show();
        }
        this.setVisible(false);
        this.dispose();
        System.runFinalization();
    }

    private void guiPreparation() {
        try {
            String msg;
            String title;
            boolean questionResult;
            this.imagePlus = this.imageWindow.getImagePlus();
            this.imageStack = this.imagePlus.getStack();
            this.maxImage = this.imageStack.getSize();
            this.acquisitionTime = new int[this.maxImage];
            this.hasPatientInfo = this.getPatientInfo();
            if (!(this.hasPatientInfo && this.acquisitionTime[1] != 0 || (questionResult = IJ.showMessageWithCancel((String)(title = " Warning: missing Series Information"), (String)(msg = "This series either contains no patient information or is a secondary-capture !\n \nExport of analysis result will contain no patient or time informations !\n \nContinue anyway ?"))))) {
                this.imagePlus.unlock();
                this.dispose();
                return;
            }
            this.stackWindow = new ExStackWindow(this.imagePlus);
            this.imageCanvas = (ExImageCanvas)this.stackWindow.getCanvas();
            if (this.hasPatientInfo) {
                this.setPatientInfoText();
                String[] acTimeText = new String[this.maxImage];
                int i = 0;
                while (i < this.maxImage) {
                    double t = (double)this.acquisitionTime[i] / 1000.0;
                    acTimeText[i] = "acquisition time +" + IJ.d2s((double)t, (int)2) + " sec.";
                    ++i;
                }
                this.imageCanvas.setAcquisitionTime(acTimeText);
            }
            this.imageCanvas.setParent(this);
            this.cepstrumResult = new int[2][this.maxImage];
            this.imagePlus.updateAndDraw();
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.write((String)("Error in Window Init !" + e));
        }
    }

    private void guiInit() {
        this.jButtonStartAnalysis.addActionListener(this);
        this.jButtonPresets.addActionListener(this);
        this.jButtonSegmentation.addActionListener(this);
        this.jButtonExit.addActionListener(this);
        this.jButtonRightRoi.addActionListener(this);
        this.jButtonLeftRoi.addActionListener(this);
        this.jButtonSIT.addActionListener(this);
        this.jButtonCancel.addActionListener(this);
        this.jButtonAbout.addActionListener(this);
        this.jSliderAccuracy.addChangeListener(this);
        this.addWindowListener(this);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Can't set GUI to look and feel: " + e);
        }
        this.setTitle(this.dialogTitle);
        this.pack();
        this.setBackground(Color.black);
        this.setForeground(Color.lightGray);
        this.setResizable(false);
        IJ.wait((int)150);
        Rectangle rec = this.getBounds();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screensize.width - rec.width) / 2, (screensize.height - rec.height) / 2);
        this.setVisible(true);
        this.toggleCancelButton();
        this.analysisAccuracy = this.presetsDialog.cepstrumAccuracy;
        String text = "-    Analysis accuracy: ";
        text = text + this.d2s(this.analysisAccuracy, 1);
        text = text + "    +";
        this.jLabelAccuracy.setText(text);
    }

    private void startCepstrum() {
        if (this.leftRoiLocked || this.rightRoiLocked) {
            this.cepstrumAnalysis = new CepstrumAnalysis(this, this.rightRoi, this.leftRoi);
            this.cepstrumAnalysis.seriesDate = this.seriesDate;
            this.cepstrumAnalysis.studyDate = this.studyDate;
            this.cepstrumAnalysis.patientName = this.patientName;
            this.cepstrumAnalysis.patientBirth = this.patientBirth;
            this.cepstrumAnalysis.patientWeight = this.d2s(this.patientWeight, 1);
            this.cepstrumAnalysis.setAccuracy(this.analysisAccuracy);
            this.setStatusText(" Movement Correction...      (Press CANCEL to stop)");
            this.toggleCancelButton();
            this.enableButtons(false);
            this.cepstrumAnalysis.setPriority(this.threadPriority);
            this.cepstrumAnalysis.setVerbose(this.verboseResults);
            this.cepstrumAnalysis.setSecondChance(this.secondChance);
            if (this.enableMinDiff) {
                this.cepstrumAnalysis.setMinDiff(this.switchToMinDiff);
            } else {
                this.cepstrumAnalysis.setMinDiff(1000);
            }
            this.stackWindow.showSlice(1);
            this.imagePlus.updateAndDraw();
            this.stackWindow.lock();
            this.cepstrumAnalysis.start();
        } else {
            JOptionPane.showMessageDialog(null, "No ROI locked !\nPlease lock at least one ROI.", " No ROI locked", 0);
            this.setStatusText(" Ready");
        }
    }

    private void startSIT() {
        this.sitAnalysis = new SITAnalysis(this);
        this.setStatusText(" calculating Signal-Intensity-Time-Curves...    (Press CANCEL to stop)");
        this.toggleCancelButton();
        this.enableButtons(false);
        this.sitAnalysis.setPriority(10);
        if (this.sitAnalysis.noRois[0] && this.sitAnalysis.noRois[1]) {
            JOptionPane.showMessageDialog(null, "No ROI locked !\nPlease lock at least one ROI.", " No ROI locked", 0);
            this.setStatusText("Ready");
            this.sitFinished();
        } else {
            this.sitAnalysis.setAdjustmentRange(1.0 - this.classificationRange, 1.0 + this.classificationRange);
            this.sitAnalysis.setVerbose(this.verboseSIT);
            this.sitAnalysis.start();
        }
    }

    private void startSegmentation() {
        Roi roi = this.imagePlus.getRoi();
        if (roi == null) {
            JOptionPane.showMessageDialog(null, "No active ROI !\nPlease mark a rectangle ROI around one kidney.", " No active ROI", 0);
            return;
        }
        if (roi.getType() != 0) {
            JOptionPane.showMessageDialog(null, "Wrong type of ROI !\nPlease mark a RECTANGLE ROI around one kidney.", " Wrong ROI type", 0);
            return;
        }
        KidneyExtraction kidneyExtraction = new KidneyExtraction(this.imagePlus);
        this.setStatusText(" Segmentation of kidney contour...    (Press CANCEL to stop)");
        this.enableButtons(false);
        this.repaint();
        this.validate();
        IJ.wait((int)100);
        try {
            kidneyExtraction.doSegmentation(this.imagePlus.getProcessor());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error in kidney Segmentation!", " Error", 0);
        }
        kidneyExtraction = null;
        this.enableButtons(true);
        this.setStatusText("Ready.");
        this.repaint();
    }

    private void setPatientInfoText() {
        int w = this.jTextAreaPatienInfo.getColumns();
        int lineCounter = 0;
        String text = "Name:   " + this.patientName + "\n";
        ++lineCounter;
        text = text + "Sex:    " + this.patientSex + "\n";
        ++lineCounter;
        text = text + "Birth:  " + this.patientBirth + "\n";
        ++lineCounter;
        text = text + "Age:    " + this.patientAge + "\n";
        ++lineCounter;
        text = text + "Weight: " + this.patientWeight + "\n";
        ++lineCounter;
        text = text + "-------------\n";
        ++lineCounter;
        text = text + "Study Date:  " + this.studyDate + "\n";
        ++lineCounter;
        text = text + "Series Date: " + this.seriesDate + "\n";
        ++lineCounter;
        text = text + "TR Time:     " + this.d2s(this.timeTR, 3) + "\n";
        ++lineCounter;
        text = text + "TE Time:     " + this.d2s(this.timeTE, 3) + "\n";
        ++lineCounter;
        text = text + "PixSpacingX: " + this.d2s(this.pixelSpacingX, 6) + "\n";
        ++lineCounter;
        text = text + "PixSpacingY: " + this.d2s(this.pixelSpacingY, 6) + "\n";
        ++lineCounter;
        text = text + "Matrix:      " + this.matrixX + " x " + this.matrixY + "\n";
        ++lineCounter;
        text = text + "FOV (mm):    " + this.fovX + " x " + this.fovY + "\n";
        ++lineCounter;
        text = text + "-------------\n";
        ++lineCounter;
        text = text + this.institutionName;
        ++lineCounter;
        this.jTextAreaPatienInfo.setText(text);
        if (("Name:   " + this.patientName).length() > w) {
            w = ("Name:   " + this.patientName).length();
        }
        if (this.institutionName.length() > w) {
            w = this.institutionName.length();
        }
        this.jTextAreaPatienInfo.setColumns(w);
        this.jTextAreaPatienInfo.setRows(lineCounter);
        this.jTextAreaPatienInfo.revalidate();
        this.jTextAreaPatienInfo.repaint();
    }

    private boolean getPatientInfo() {
        this.propertiesOk = false;
        Properties prop = null;
        String[] sl = null;
        int index = -1;
        String temp = "";
        prop = this.imagePlus.getProperties();
        if (prop != null && prop.containsKey("1.2.3.4711.5.1")) {
            sl = (String[])prop.get("1.2.3.4711.5.1");
        }
        if (sl != null) {
            try {
                index = sl[0].indexOf("[0x0010, 0x0010, 0x0000000c");
                if (index > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.patientName = temp.substring(0, index);
                }
                if ((index = sl[0].indexOf("[0x0010, 0x0020, 0x0000000c")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.patientID = temp.substring(0, index);
                }
                if ((index = sl[0].indexOf("[0x0008, 0x0080, 0x00000010")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.institutionName = temp.substring(0, index);
                }
                if ((index = sl[0].indexOf("[0x0010, 0x0040, 0x00000002")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.patientSex = temp.substring(0, index);
                }
                if ((index = sl[0].indexOf("[0x0010, 0x1030, 0x00000006")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    String weight = temp.substring(0, index);
                    this.patientWeight = this.s2i(weight);
                }
                if ((index = sl[0].indexOf("[0x0008, 0x0020, 0x00000008")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.studyDate = temp.substring(0, index);
                    if (this.studyDate.length() == 8) {
                        this.studyDate = this.studyDate.substring(6) + "." + this.studyDate.substring(4, 6) + "." + this.studyDate.substring(0, 4);
                    }
                }
                if ((index = sl[0].indexOf("[0x0008, 0x0021, 0x00000008")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.seriesDate = temp.substring(0, index);
                    if (this.seriesDate.length() == 8) {
                        this.seriesDate = this.seriesDate.substring(6) + "." + this.seriesDate.substring(4, 6) + "." + this.seriesDate.substring(0, 4);
                    }
                }
                if ((index = sl[0].indexOf("[0x0010, 0x0030, 0x00000008")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    this.patientBirth = temp.substring(0, index);
                    if (this.patientBirth.length() == 8) {
                        this.patientBirth = this.patientBirth.substring(6) + "." + this.patientBirth.substring(4, 6) + "." + this.patientBirth.substring(0, 4);
                    }
                }
                if ((index = sl[0].indexOf("[0x0010, 0x1010, 0x00000004")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    String age = temp.substring(0, index);
                    this.patientAge = this.s2i(age);
                }
                if ((index = sl[0].indexOf("[0x0018, 0x0080, 0x0000000e")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    String tr = temp.substring(0, index);
                    this.timeTR = Double.valueOf(tr);
                }
                if ((index = sl[0].indexOf("[0x0018, 0x0081, 0x0000000e")) > 0) {
                    temp = sl[0].substring(index + 35);
                    index = temp.indexOf("\n");
                    String te = temp.substring(0, index);
                    this.timeTE = Double.valueOf(te);
                }
                if ((index = sl[0].indexOf("[0x0028, 0x0030, 0x0000001c")) > 0) {
                    try {
                        temp = sl[0].substring(index + 35);
                        index = temp.indexOf("\n");
                        String s = temp.substring(0, index);
                        index = s.indexOf(92);
                        String x = s.substring(0, index);
                        String y = s.substring(index + 1);
                        this.pixelSpacingX = Double.valueOf(x);
                        this.pixelSpacingY = Double.valueOf(y);
                        this.matrixX = this.imagePlus.getWidth();
                        this.matrixY = this.imagePlus.getHeight();
                        this.fovX = (int)((double)this.matrixX * this.pixelSpacingX);
                        this.fovY = (int)((double)this.matrixY * this.pixelSpacingY);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int i = 0;
                while (i < this.maxImage) {
                    index = sl[i].indexOf("[0x0008, 0x0032, 0x0000000e");
                    if (index > 0) {
                        temp = sl[i].substring(index + 35);
                        index = temp.indexOf("\n");
                        String ImageTime = temp.substring(0, index);
                        index = ImageTime.indexOf(".");
                        String hours = ImageTime.substring(0, 2);
                        String minutes = ImageTime.substring(2, 4);
                        String seconds = ImageTime.substring(4, 6);
                        String milliseconds = ImageTime.substring(7, 10);
                        this.acquisitionTime[i] = Integer.valueOf(hours) * 60 * 60 * 1000;
                        this.acquisitionTime[i] = this.acquisitionTime[i] + Integer.valueOf(minutes) * 60 * 1000;
                        this.acquisitionTime[i] = this.acquisitionTime[i] + Integer.valueOf(seconds) * 1000;
                        this.acquisitionTime[i] = this.acquisitionTime[i] + Integer.valueOf(milliseconds);
                    }
                    ++i;
                }
                i = this.maxImage - 1;
                while (i > 0) {
                    this.acquisitionTime[i] = this.acquisitionTime[i] - this.acquisitionTime[0];
                    --i;
                }
                this.acquisitionTime[0] = 0;
            }
            catch (Exception e) {
                IJ.error((String)"Error while reading patient info!\nExport of analysis results\nwill not be possible.");
                e.printStackTrace();
                return false;
            }
            this.propertiesOk = true;
            return true;
        }
        return false;
    }

    private String d2s(double d, int l) {
        String result = IJ.d2s((double)d, (int)l);
        result = result.replace(',', '.');
        while (result.length() > 1 && result.charAt(0) == '0' && result.charAt(1) != '.') {
            result = result.substring(1);
        }
        return result;
    }

    private int s2i(String input) {
        int result = -1;
        String filter = "";
        int i = 0;
        while (i < input.length()) {
            if (Character.isDigit(input.charAt(i))) {
                filter = filter + input.charAt(i);
            }
            ++i;
        }
        while (filter.length() > 0 && filter.charAt(0) == '0') {
            filter = filter.substring(1);
        }
        IJ.wait((int)5);
        if (filter.length() == 0) {
            return 0;
        }
        result = Integer.valueOf(filter);
        return result;
    }

    private void setStatusText(String status) {
        this.jLabelStatusBar.setText(" " + status);
    }

    private void toggleCancelButton() {
        if (this.jButtonCancel.isEnabled()) {
            this.jButtonCancel.setEnabled(false);
            this.jButtonCancel.setOpaque(false);
            this.jButtonCancel.setForeground(Color.black);
            this.jButtonCancel.setBackground(Color.black);
            this.jButtonCancel.repaint();
        } else {
            this.jButtonCancel.setEnabled(true);
            this.jButtonCancel.setOpaque(true);
            this.jButtonCancel.setForeground(Color.orange);
            this.jButtonCancel.setBackground(Color.gray);
            this.jButtonCancel.repaint();
        }
        IJ.wait((int)100);
    }

    public void cepstrumFinished() {
        this.setStatusText(" Ready");
        if (this.cepstrumAnalysis != null && !this.cepstrumAnalysis.finished && !this.cepstrumAnalysis.error) {
            JOptionPane.showMessageDialog(null, "Movement Correction aborded !\nWarning: User Break.", " User Break", 2);
            this.cepstrumSuccess = false;
        } else if (this.cepstrumAnalysis != null && !this.cepstrumAnalysis.finished && this.cepstrumAnalysis.error) {
            JOptionPane.showMessageDialog(null, "Error in Movement Correction !\nWarning: Abnormal Termination.", " Error", 0);
            this.cepstrumSuccess = false;
        } else {
            int badImageCounter = 0;
            String ListLeft = "";
            String ListRight = "";
            String msg = "\nNo Errors.";
            boolean[][] results = this.imageCanvas.getEnabledForSIT();
            int i = this.startImage - 1;
            while (i < this.maxImage) {
                if (!results[0][i]) {
                    ListLeft = ListLeft + (i + 1) + ", ";
                    ++badImageCounter;
                }
                if (!results[1][i]) {
                    ListRight = ListRight + (i + 1) + ", ";
                    ++badImageCounter;
                }
                ++i;
            }
            if (badImageCounter > 0) {
                msg = "\nPossible Errors:";
            }
            if (ListLeft.length() > 0) {
                ListLeft = ListLeft.substring(0, ListLeft.lastIndexOf(", "));
                msg = msg + "\nRight Kidney - images " + ListLeft;
            }
            if (ListRight.length() > 0) {
                ListRight = ListRight.substring(0, ListRight.lastIndexOf(", "));
                msg = msg + "\nLeft Kidney - images " + ListRight;
            }
            JOptionPane.showMessageDialog(null, "Movement Correction Finished !" + msg, " Information", 1);
            this.cepstrumSuccess = true;
        }
        this.stackWindow.unlock();
        this.toggleCancelButton();
        this.enableButtons(true);
        this.cepstrumAnalysis = null;
    }

    public void sitFinished() {
        this.setStatusText(" Ready");
        if (this.sitAnalysis != null && !this.sitAnalysis.finished && !this.sitAnalysis.error) {
            JOptionPane.showMessageDialog(null, "Calculation of SIT-Graphs aborded !\nWarning: User Break.", " User Break", 2);
        } else if (this.sitAnalysis != null && !this.sitAnalysis.finished && this.sitAnalysis.error) {
            JOptionPane.showMessageDialog(null, "Error in calculation of SIT-Graphs !\nWarning: Abnormal Termination.", " Error", 0);
        }
        this.toggleCancelButton();
        this.enableButtons(true);
        this.sitAnalysis = null;
    }

    public void presetsDialogClosed() {
        this.transferPresetValues();
    }

    public void setCepstrumResult(int half, int slice, int result) {
        this.cepstrumResult[half][slice - 1] = result;
        if (result == 1) {
            this.imageCanvas.setCepstrumResult(half, slice, "++");
        }
        if (result == 2) {
            this.imageCanvas.setCepstrumResult(half, slice, "+");
        }
        if (result == 3) {
            this.imageCanvas.setCepstrumResult(half, slice, "o");
        }
        if (result == 4) {
            this.imageCanvas.setCepstrumResult(half, slice, "-");
        }
        if (result == 5) {
            this.imageCanvas.setCepstrumResult(half, slice, "--");
        }
        if (result == 0) {
            this.imageCanvas.setCepstrumResult(half, slice, "**");
        }
    }

    private void enableButtons(boolean active) {
        this.jButtonStartAnalysis.setEnabled(active);
        this.jButtonPresets.setEnabled(active);
        this.jButtonSegmentation.setEnabled(active);
        this.jButtonExit.setEnabled(active);
        this.jButtonRightRoi.setEnabled(active);
        this.jButtonLeftRoi.setEnabled(active);
        this.jButtonSIT.setEnabled(active);
        this.jButtonAbout.setEnabled(active);
        this.jSliderAccuracy.setEnabled(active);
        this.repaint();
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        this.exitPlugin();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

